<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Online_logs_model extends CI_Model
{

	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';
	var $customers = 'customers c';
	var $terminals = 'terminals te';
	var $branches = 'branches b';
	var $users = 'users u';
	var $prices = 'prices p';
	var $sections = 'sections s';
	var $events = 'events e';

	var $arrTListStat = array(); // status filter for TRANSACTION LISTING
	var $arrEventTListStat = array('reserved','unselected'); // status filter for EVENT TRANSACTION LISTING
	// using constructor function, get value of $arrEventTlistStat to make filter for transaction listing the same
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('payment_types_model', 'payment_types_model');
		$this->load->model('branches_model', 'branches_model');
		
		// same filter array. no reserve for display of TRANSACTION LISTING
		$this->arrTListStat = $this->arrEventTListStat;
	}

	function get_log_details($transaction_id = false){
	
		$this->db->where('olog_transaction_id',$transaction_id);
		$query = $this->db->get('logs_online');
		return $query->result();
		
	}
	function get_transaction_status() {
		// show columns from transactions like 'transaction_status';
		$fields = $this->db->query("show columns from transactions like 'transaction_status'")->result();
		// $fields = $this->db->field_data("transactions");
		$arrayinfo = array();

		foreach ($fields as $field) {
			$str = $field->Type;
		}
		$enum_pre = "enum('";
		$enum_post = "')";
		$str = substr($str,6,strlen($str)-strlen($enum_pre)-strlen($enum_post));
		$arrayinfo[] = "--ALL STATUS--";
		foreach(explode("','",$str) as $k=>$v) {
			$arrayinfo[$v] = "$v";
		}
		// print_r($arrayinfo);
		return $arrayinfo;
	}
	
	function get_all_online_transactions($transdate = "1970-01-01", $transtat = 0, $transid, $name, $mobno, $offset = 0, $limit = 0)
	{
		$defdate = "1970-01-01";
		// $transdate = date("Y-m-d", strtotime($transdate));
		if(!empty($transid) || !empty($name) || !empty($mobno) || !empty($transdate))
		{
			if(!empty($transid))
			{
				$this->db->where('t.transaction_id', $transid);
			}
			if (!empty($name))
			{
				$this->db->where("(concat(c.customer_firstname,' ', c.customer_lastname) LIKE '%$name%')");

			}
			if (!empty($mobno))
			{
				$this->db->like('c.customer_mobile', $mobno);
			}
		}
		if (empty($transdate))
		{
			$transdate = $defdate;
		}
		
		//$this->db->where('lower(transaction_status)', strtolower('done'));
		$this->db->select('
				t.transaction_id
				, t.transaction_date
				, t.transaction_branch_id
				, t.transaction_status
				, ti.ticket_branch_id
				, c.customer_lastname
				, c.customer_firstname
				, c.customer_mobile
				, GROUP_CONCAT(DISTINCT ti.ticket_status) concat_tixstatus
				, COUNT(ti.ticket_id) count_ticket_id
 				, s.section_name
				, p.price_name
			');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->events, 'e.event_id = ti.ticket_event_id', 'left');
		// $this->db->join('module_types mt', 'mt.module_type_transaction_id = t.transaction_id', 'left');
		
		$this->db->where("t.transaction_date >= '$transdate 00:00:00'");
		if ($transtat <> "0") {
			$this->db->where("t.transaction_status", $transtat);
		}
		if ($transdate <> $defdate) {
			$this->db->where("t.transaction_date <= '$transdate 23:59:59'");
		}
		$this->db->where("t.transaction_user_id",1);
		$this->db->where("e.event_internet_sales_charge !=", "");
		$this->db->where("t.transaction_status", "unselected");
		
		$this->db->group_by('t.transaction_id');
		$this->db->order_by('t.transaction_id', 'desc');
		// $this->db->where_not_in('t.transaction_status', $this->arrTListStat);
		// $this->db->where_in('ti.ticket_status', $this->arrTicketStat);
/* 
		if ($transdate == $defdate) {
			$limit = 50;
			$offset = 0;
		}
		 */
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$query = $this->db->get($this->transactions);
			// echo $this->db->last_query();
		return $query->result();
	}
	
	function get_terminal_transactions_allcount_alt($customer, $transid, $name, $mobno)
	{
		if(!empty($transid) || !empty($name) || !empty($mobno))
		{
			if(!empty($transid))
			{
				$this->db->where('transaction_id', $transid);
			}
			if (!empty($name))
			{
				$this->db->like('CONCAT(customer_lastname,customer_firstname)', $name);
			}
			if (!empty($mobno))
			{
				$this->db->where('customer_mobile', $mobno);
			}
		}
		else
		{	
			// if ($this->session->userdata('user_branch_id') != 1)
			// {	
				// $this->db->where('transaction_branch_id', $this->session->userdata('user_branch_id'));
			// }
		}

		$this->db->select('count(DISTINCT t.transaction_id) AS count_id');
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join($this->events, 'e.event_id = ti.ticket_event_id', 'left');
		// $this->db->group_by('ti.ticket_transaction_id');
		// $this->db->order_by('t.transaction_id', 'desc');
		// $this->db->where('', $this->arrTListStat);
		$this->db->where_not_in('t.transaction_status', $this->arrTListStat);
		
		if($customer!='')$this->db->where('t.transaction_customer_id', $customer);
		$this->db->where('customer_username !=', '');
		$this->db->where("e.event_internet_sales_charge !=", "");
		$this->db->where("t.transaction_status", "unselected");

		
		$query = $this->db->get($this->transactions);
		$counter = 0;
		foreach($query->result() as $row) {
			$counter = $row->count_id;
		}
		return $counter;

	}

}

