<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class News_model extends CI_Model
{
	var $news = 'news nw';
	var $users = 'users u';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_all
	 *
	 * @access	public
	 */
	function get_all()
	{
		$this->db->order_by('news_status ASC, news_dateposted DESC');
		$this->db->join($this->users, 'user_id=news_user_id');
		$query = $this->db->get($this->news);
			
		return $query->result();
	}
	
	
	/**
	 * get_active_news
	 *
	 * @access	public
	 */
	function get_active_news()
	{
		$this->db->order_by('news_status ASC, news_dateposted DESC');
		$this->db->join($this->users, 'user_id=news_user_id');
		$this->db->where('news_status','active');
		$query = $this->db->get($this->news);
			
		return $query->result();
	}
	


	// --------------------------------------------------------------------
	
	/**
	 * get_news
	 *
	 * @access	public
	 */
	function get_news($type = false)
	{
		$this->db->order_by('news_name');
		$this->db->join($this->users, 'user_id=news_user_id');
		$query = $this->db->get($this->news);
			
		return $query->result();
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_news
	 *
	 * @access	public
	 */
	function get($news_id)
	{
		$this->db->where('news_id', $news_id);
		$this->db->join($this->users, 'user_id=news_user_id');
		$query = $this->db->get($this->news);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add($title=false, $content=false, $dateposted=false, $isactive=false)
	{
		
		if (!$dateposted)
		{
		  $dateposted = $this->input->post('news_dateposted') ?  $this->input->post('news_dateposted') : 'now';
		}
	
		$fields = array(
		    'news_title'		=> issetVal($title, $this->input->post('news_title') ),
			'news_content'      => issetVal($content, $this->input->post('news_content') ),
			'news_dateposted'	=> input_date( $dateposted ),
            'news_user_id'		=> $this->session->userdata('user_id'),
			'news_status'		=> 'active' 
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('news');
		
		return $this->db->insert_id();;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * is_newsname_exist
	 *
	 * @access	public
	 */
	function is_newsname_exist($newsname = FALSE)
	{
		// check if newsname exists
		$this->db->where('lower(news_name)', strtolower($newsname));
		$query = $this->db->get($this->news);
		
		return ($query->num_rows() > 0) ? true : false;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($news_id, $title=false, $content=false, $dateposted=false, $isactive=false)
	{		
		$dateposted = $this->input->post('news_dateposted') ?  $this->input->post('news_dateposted') : 'now';
		$fields = array(
		    'news_title'		=> issetVal($title, $this->input->post('news_title') ),
			'news_content'      => issetVal($content, $this->input->post('news_content') ),
			'news_dateposted'	=> input_date( $dateposted ),
            'news_user_id'		=> $this->session->userdata('user_id'),
			'news_status'		=> issetVal($isactive, issetVal($this->input->post('news_status'), 'inactive') ) 
		);		
		// update db
		$this->db->where('news_id', $news_id);
		$this->db->update($this->news, $fields);
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($news_id)
	{
		$this->db->delete('news', array('news_id' => $news_id));
		return true;
	}
	
	function activate($news_id)
	{
		$this->db->where('news_id', $news_id);
		$this->db->update($this->news, array('news_status'=>'active') );
		
		return true;
	}
	
	function deactivate($news_id)
	{
		$this->db->where('news_id', $news_id);
		$this->db->update($this->news, array('news_status'=>'inactive') );
		
		return true;	
	}
	
}
// END news_model.php
/* Location: ./application/models/news_model.php */	