<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Logos_model extends CI_Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $branches = 'branches o';
	var $logos = 'logos o';
		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_logos
	 *
	 * @access	public
	 */
	function get_logos()
	{
		$query = $this->db->get($this->logos);
		
		return $query->result();
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * get_logos_dropdown
	 *
	 * @access	public
	 */
	function get_logos_dropdown()
	{
		$query = $this->db->get($this->logos);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			$array[0] = 'None';
			foreach($result as $r)
			{
				$array[$r->logo_id] = $r->logo_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * upload
	 *
	 */
	function upload($filename, $image_path)
	{
		$fields = array(
			'logo_path'			=> $image_path,
			'logo_filename'		=> $filename,
			'logo_name'			=> $this->input->post('logo_name'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('logos');
		
		return true;
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($logo_id)
	{
		$this->db->delete('logos', array('logo_id' => $logo_id));
		
		return true;
	}	
}

// END logos_model.php
/* Location: ./application/models/logos_model.php */	