<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class image_model extends CI_Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $branches = 'branches o';
	var $poster = 'poster pr';
	var $image = 'images';
		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_logos
	 *
	 * @access	public
	 */
	function get_image_active()
	{
		$this->db->where('image_active','yes');
		$this->db->join('events e','e.event_id = images.image_event_id');
		$query = $this->db->get($this->image);
		
		return $query->result();
	}
	
	function get_image_inactive()
	{
		$this->db->where('image_active','no');
		$this->db->join('events e','e.event_id = images.image_event_id');
		$query = $this->db->get($this->image);
		
		return $query->result();
	}
	
	function get_image()
	{
		$this->db->join('events e','e.event_id = images.image_event_id');
		$query = $this->db->get($this->image);
		
		return $query->result();
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * get_logos_dropdown
	 *
	 * @access	public
	 */
	
	/* function get_image_dropdown()
	{
		$query = $this->db->get($this->image);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			$array[0] = 'None';
			foreach($result as $r)
			{
				$array[$r->image_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	} */
	
	// --------------------------------------------------------------------
	
	/**
	 * upload
	 *
	 */
	function upload($filename, $image_path, $filewh, $filesize)
	{
		$fields = array(
			'image_path'		=> $image_path,
			'image_filename'	=> $filename,
			'image_title'	=> $this->input->post('image_title'),
			'image_wh'			=> $filewh,
			'image_filesize'	=> $filesize,
			'image_event_id'	=> $this->input->post('event_id'),	
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('images');
		
		
		
		
		
		return true;
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($image_id)
	{
		$this->db->where('image_id', $image_id);
      	$this->db->select('image_path');
      	$query = $this->db->get('images');
      	foreach($query->result() as $item)  
      	{
      		$old_image_path =$item->image_path;
      	}
      	unlink('./uploads/'.$old_image_path);
      	$this->db->where('image_id', $image_id);
		$this->db->delete('images', array('image_id' => $image_id));
		return true;
	}	
	
	/**
	 * recommend
	 *
	 */
	function active($image_id)
	{
		$this->db->where('image_id', $image_id);
		$this->db->update($this->image, array('image_active'=>'yes') );
		
		return true;
	}
	
	/**
	 * recommend
	 *
	 */
	function inactive($image_id)
	{
		$this->db->where('image_id', $image_id);
		$this->db->update($this->image, array('image_active'=>'no') );
		
		return true;
	}
	

	
	
	
	
	
}

// END logos_model.php
/* Location: ./application/models/logos_model.php */	
