<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Events_model2 extends CI_Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $events = 'events e';
	var $events_config = 'events_config ec';
	var $event_types = 'event_types et';
	var $seatplans = 'seatplans sp';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}


	// --------------------------------------------------------------------
	
	/**
	 * get_event
	 *
	 * @access	public
	 */
	function get($event_id=false)
	{
		if($event_id){
		$this->db->where('event_id', $event_id);
		}
		
		$this->db->join($this->events_config, 'ec.events_config_eventid = e.event_id', 'left');
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->join($this->promoters, 'e.event_promoter_id = p.promoter_id', 'left');
		$this->db->join($this->seatplans, 'e.event_seatplan_id = sp.seatplan_id', 'left');
		$query = $this->db->get($this->events);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	/**
	 * get_event
	 *
	 * @access	public
	 */
	function get_by_transaction_id($transaction_id)
	{
		$this->db->where('transaction_id', $transaction_id);
		$this->db->join('tickets', 'ticket_event_id=event_id','left');
		$this->db->join('transactions','ticket_transaction_id=transaction_id','left');
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->join($this->promoters, 'e.event_promoter_id = p.promoter_id', 'left');
		$this->db->join($this->seatplans, 'e.event_seatplan_id = sp.seatplan_id', 'left');
		$this->db->limit(1);
		$query = $this->db->get($this->events);
		
		return $query->row();
	}
	// --------------------------------------------------------------------
	
	/**
	 * get_events
	 *
	 * @access	public
	 */
	function get_events()
	{
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->order_by('e.event_date_time', 'asc'); 
		$query = $this->db->get($this->events);
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_events
	 *
	 * @access	public
	 */
	function get_current_events($searchkey=array())
	{
		//hide event 
		if(in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
			
			$this->db->where('event_id !=', '10');

			// $ignore = array(3808,3822 );
			// $this->db->where_not_in('event_id', $ignore);
		}
		
		
		if(in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2')))
		{
			$this->db->where('event_active', '1');
		}
		
		if(in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2')))
		{
			$this->db->where('event_date_time >=', date("Y-m-d"));
		}
		
		$is_key_exists = false;
		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				{
					if ($key == 'event_date_time')
					{
						$value = input_date($value);
					}
					
					$this->db->like($key, $value);
					$is_key_exists = true;
				}
			}
		}
		
		if (! $is_key_exists)
		{
			$this->db->where('event_date_time >=', date("Y-m-d"));
		}
		
		/*if ($this->session->userdata('user_type') != 'Admin' and !$is_key_exists)
		{
			$this->db->where('event_date_time >=', date("Y-m-d"));
		}*/


		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->where('event_cod', 1);
		}
		
		
		
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->order_by('e.event_date_time', 'asc'); 
		$query = $this->db->get($this->events);
		
		return $query->result();
	}
	
	function get_active_events($searchkey=array())
	{
		$is_key_exists = false;
		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				{
					if ($key == 'event_date_time')
					{
						$value = input_date($value);
					}
					
					$this->db->like($key, $value);
					$is_key_exists = true;
				}
			}
		}

		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->where('event_cod', 1);
		}
		
		
		$this->db->where('event_active', '1');
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->order_by('e.event_date_time', 'asc'); 
		$query = $this->db->get($this->events);
		
		return $query->result();
	}
	
	function get_inactive_events($searchkey=array())
	{
		$is_key_exists = false;
		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				{
					if ($key == 'event_date_time')
					{
						$value = input_date($value);
					}
					
					$this->db->like($key, $value);
					$is_key_exists = true;
				}
			}
		}
		
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->where('event_cod', 1);
		}
		

		$this->db->where('event_active <> ', '1');
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->order_by('e.event_date_time', 'asc'); 
		$query = $this->db->get($this->events);
		
		return $query->result();
	}
	
	function get_all_events($searchkey=array())
	{		
		$is_key_exists = false;
		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				{
					if ($key == 'event_date_time')
					{
						$value = input_date($value);
					}
					
					$this->db->like($key, $value);
					$is_key_exists = true;
				}
			}
		}

		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){ 
			$this->db->where('event_cod', 1);
		}
			
		
		$this->db->join($this->venues, 'e.event_venue_id = v.venue_id', 'left');
		$this->db->order_by('e.event_date_time', 'asc'); 
		$query = $this->db->get($this->events);
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_receipt_number
	 *
	 * @access	public
	 */
	function get_receipt_number($event_id)
	{
		// get last receipt number
		$this->db->select('event_last_receipt_number');
		$this->db->where('event_id', $event_id);
		$query = $this->db->get($this->events);
		$row = $query->row();
		
		$next_receipt_number = $row->event_last_receipt_number += 1;
		
		// update last receipt number
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, array('event_last_receipt_number' => $next_receipt_number));
		
		return $next_receipt_number;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_events_dropdown
	 *
	 * @access	public
	 */
	function get_events_dropdown()
	{
		$query = $this->db->get($this->events);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
		
	/**
	 * get_events_dropdown
	 *
	 * @access	public
	 */
	function get_active_events_dropdown()
	{
		$this->db->where('event_active',1);
		$query = $this->db->get($this->events);
		
		
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_reservation_expiry
	 *
	 */
	function reservation_expiry($event_id)
	{
		$this->db->where('event_id', $event_id);
		$query = $this->db->get($this->events);
		
		return $query->row();
		
	}	

	// --------------------------------------------------------------------
	
	/**
	 * _copy_seatplan
	 *
	 */
	function _copy_seatplan($seatplan_id)
	{
		// copy the seat plan from the template
		$sql = "insert into seatplans(seatplan_name, seatplan_venue_id, seatplan_image, seatplan_template, seatplan_active) select seatplan_name, seatplan_venue_id, seatplan_image, '0', '1' from seatplans where seatplan_id = ?"; 
		$this->db->query($sql, $seatplan_id);
		$new_seatplan_id = $this->db->insert_id();
	
		// copy the sections as well
		$sql = "insert into sections(section_code, section_name, section_type, section_stage_location, section_seat_config, section_seat_heads, section_row_from, section_row_to, section_row_increment, section_col_from, section_col_to, section_col_increment, section_row_aisles, section_col_aisles, section_capacity, section_available, section_seatplan_id) select section_code, section_name, section_type, section_stage_location, section_seat_config,section_seat_heads, section_row_from, section_row_to, section_row_increment, section_col_from, section_col_to, section_col_increment, section_row_aisles, section_col_aisles, section_capacity, section_capacity, ? from sections where section_seatplan_id = ?"; 
		$this->db->query($sql, array($new_seatplan_id,  $seatplan_id)); 
		
		return $new_seatplan_id;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _copy_event
	 *
	 */
	function _copy_event($event_id)
	{
		// get event info
		$event = $this->get($event_id);
		
		// copy the seatplan first
		$new_seatplan_id = $this->_copy_seatplan($event->event_seatplan_id);

 
	
		

		// copy the event
		$sql = "insert into events(
 				event_title,
				event_long_title,
				event_type,
				event_performers,
				event_performers_website,
				event_description,
				event_venue_id,
				event_date_time,
				event_image,
				event_image_1,
				event_ticket_logo_1,
				event_ticket_logo_2,
				event_promoter_id,
				event_seatplan_id,
				event_ticket_types,
				event_venue_amusement_tax,
				event_venue_withholding_tax,
				event_venue_tax,
				event_venue_charge_1,
				event_venue_charge_2,
				event_venue_charge_3,
				event_venue_charge_4,
				event_venue_charge_5,
				event_venue_commission,
				event_service_charge,
				event_ticket_charge,
				event_vat,
				event_withholding_tax,
				event_bank_charge_internet,
				event_bank_charge_outlet,
				event_administrative_fee,
				event_minimum_guarantee,
				event_internet_sales_charge,
				event_delivery_charge,
				event_revenue_pullout,
				event_complimentary_pullout,
				event_interest_fee,
				event_reservation_fee,
				event_charge_01,
				event_charge_02,
				event_charge_03,
				event_charge_04,
				event_charge_05,
				event_charge_06,
				event_charge_07,
				event_charge_08,
				event_charge_09,
				event_charge_10,
				event_last_receipt_number,
				event_reservation_expire,
				event_active,
				event_disable_reservation,
				event_recommended
			) 




			select
 				event_title,
				event_long_title,
				event_type,
				event_performers,
				event_performers_website,
				event_description,
				event_venue_id,
				event_date_time,
				event_image,
				event_image_1,
				event_ticket_logo_1,
				event_ticket_logo_2,
				event_promoter_id,
				?,
				event_ticket_types,
				event_venue_amusement_tax,
				event_venue_withholding_tax,
				event_venue_tax,
				event_venue_charge_1,
				event_venue_charge_2,
				event_venue_charge_3,
				event_venue_charge_4,
				event_venue_charge_5,
				event_venue_commission,
				event_service_charge,
				event_ticket_charge,
				event_vat,
				event_withholding_tax,
				event_bank_charge_internet,
				event_bank_charge_outlet,
				event_administrative_fee,
				event_minimum_guarantee,
				event_internet_sales_charge,
				event_delivery_charge,
				event_revenue_pullout,
				event_complimentary_pullout,
				event_interest_fee,
				event_reservation_fee,
				event_charge_01,
				event_charge_02,
				event_charge_03,
				event_charge_04,
				event_charge_05,
				event_charge_06,
				event_charge_07,
				event_charge_08,
				event_charge_09,
				event_charge_10,
				event_last_receipt_number,
				event_reservation_expire,
				event_active,
				event_disable_reservation,
				event_recommended

			from events where event_id = ?"; 
			
		$this->db->query($sql, array($new_seatplan_id, $event_id));
		
		$new_event_id = $this->db->insert_id();
		
		return $new_event_id;
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * _copy_prices
	 *
	 */
	function _copy_prices($new_event_id, $event_id)
	{
		$sql = "insert into prices(
				price_event_id,
				price_name,
				price_price,
				price_sections
			) 
			
			select
			 	?,
				price_name,
				price_price,
				price_sections
				
			from prices where price_event_id = ?"; 
			
		$this->db->query($sql, array($new_event_id, $event_id));
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _copy_ticket_layout
	 *
	 */
	function _copy_ticket_layout($new_event_id, $event_id)
	{
		$sql = "insert into ticket_layouts(
				ticket_layout_event_id,
				ticket_logo_id_1,
				ticket_logo_id_2,
				ticket_logo_id_3,
				ticket_logo_id_4,
				ticket_logo_id_5,
				ticket_text_1,
				ticket_font_size_1,
				ticket_font_face_1,
				ticket_text_2,
				ticket_font_size_2,
				ticket_font_face_2,
				ticket_text_3,
				ticket_font_size_3,
				ticket_font_face_3,
				ticket_text_4,
				ticket_font_size_4,
				ticket_font_face_4,
				ticket_text_5,
				ticket_font_size_5,
				ticket_font_face_5,
				ticket_text_6,
				ticket_font_size_6,
				ticket_font_face_6,
				ticket_text_7,
				ticket_font_size_7,
				ticket_font_face_7
			) 
			
			select
			 	?,
				ticket_logo_id_1,
				ticket_logo_id_2,
				ticket_logo_id_3,
				ticket_logo_id_4,
				ticket_logo_id_5,
				ticket_text_1,
				ticket_font_size_1,
				ticket_font_face_1,
				ticket_text_2,
				ticket_font_size_2,
				ticket_font_face_2,
				ticket_text_3,
				ticket_font_size_3,
				ticket_font_face_3,
				ticket_text_4,
				ticket_font_size_4,
				ticket_font_face_4,
				ticket_text_5,
				ticket_font_size_5,
				ticket_font_face_5,
				ticket_text_6,
				ticket_font_size_6,
				ticket_font_face_6,
				ticket_text_7,
				ticket_font_size_7,
				ticket_font_face_7
				
			from ticket_layouts where ticket_layout_event_id = ?"; 
			
		$this->db->query($sql, array($new_event_id, $event_id));
		
		return true;
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * copy
	 *
	 */
	function copy($event_id)
	{
		// copy the event, seatplan and sections
		$new_event_id = $this->_copy_event($event_id);
		
		// copy the prices
		$this->_copy_prices($new_event_id, $event_id);
		
		// copy the ticket layout
		$this->_copy_ticket_layout($new_event_id, $event_id);

		return $new_event_id;
	}

	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add($event_image)
	{
		// copy the seat plan first
		$seatplan_id = $this->_copy_seatplan($this->input->post('seatplan_id'));
		
		// add the event
		$fields = array(
			'event_code'				=> $this->input->post('event_code'),
			'event_title'				=> $this->input->post('event_title'),
			'event_long_title'			=> $this->input->post('event_long_title'),
			'event_type'				=> $this->input->post('event_type'),
			'event_performers'			=> $this->input->post('event_performers'),
			'event_performers_website'	=> $this->input->post('event_performers_website'),
			'event_description'			=> $this->input->post('event_description'),
			'event_venue_id'			=> $this->input->post('venue_id'),
			'event_date_time'			=> $this->input->post('date_time'),		
			'event_promoter_id'			=> $this->input->post('promoter_id'),
			'event_seatplan_id'			=> $seatplan_id,	
			'event_image'				=> $event_image,	
			'event_expiration'			=> $this->input->post('event_expiration'),	 
			'event_active'				=> '0', 
			'event_hotel'				=> 0,	
			'event_always_show'			=> 0,	
			'event_reservation_expire'	=> $this->input->post('event_reservation_expire'),
			'event_internet_sales_charge'	=> $this->input->post('event_internet_sales_charge'),
			'event_tags'				=> $this->input->post('event_tags'),
			'event_announcement_date'	=> $this->input->post('event_announcement_date'),	
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('events');
		
		return $this->db->insert_id();
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($event_id, $event_image = false, $event_image_1 = false, $event_image_2 = false, $event_image_3 = false,$event_images,$image_descriptions)
	{
		$seatplan_id = $this->input->post('seatplan_id');
		if ($seatplan_id != $this->input->post('current_seatplan_id'))
		{
			// copy the seat plan first
			$seatplan_id = $this->_copy_seatplan($this->input->post('seatplan_id'));
		}
		

		// save to database
		$fields = array(
			'event_code'				=> $this->input->post('event_code'),
			'event_title'				=> $this->input->post('event_title'),
			'event_long_title'			=> $this->input->post('event_long_title'),
			'event_type'				=> $this->input->post('event_type'),
			'event_performers'			=> $this->input->post('event_performers'),
			'event_performers_website'	=> $this->input->post('event_performers_website'),
			'event_description'			=> $this->input->post('event_description'),
			'event_venue_id'			=> $this->input->post('venue_id'),
			'event_date_time'			=> $this->input->post('date_time'),
			'event_expiration'			=> $this->input->post('event_expiration'),
			'event_promoter_id'			=> $this->input->post('promoter_id'),
			'event_seatplan_id'			=> $seatplan_id,
			'event_active'				=> $this->input->post('event_active'),		
			'event_hotel'				=> $this->input->post('event_hotel'),	
			'event_always_show'			=> $this->input->post('event_always_show'),	
			'event_disable_reservation'	=> $this->input->post('event_disable_reservation'),	
			'event_reservation_expire'	=> $this->input->post('event_reservation_expire'),		
			'event_online_registration'	=> $this->input->post('event_online_registration'),		
			'event_promo'			 	=> $this->input->post('event_promo'),
			'event_max_ticket'			=> $this->input->post('event_max_ticket'),				
			'event_cod'					=> $this->input->post('event_cod'),	
			'event_tags'				=> $this->input->post('event_tags'),	
			'event_announcement_date'	=> $this->input->post('event_announcement_date'),	
			
	
		);
		
		
		if ($event_image)
		{
			$fields['event_image'] = $event_image;
		}		
		if ($event_image_1)
		{
			$fields['event_image_1'] = $event_image_1;
		}
		if ($event_image_2)
		{
			$fields['event_image_2'] = $event_image_2;
		}
		if ($event_image_3)
		{
			$fields['event_image_3'] = $event_image_3;
		}
		// update db
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, $fields);
		
		
		// for extended event configuration
		$tablename = 'events_config';
		$fields = array(
			'events_config_eventid'				=> $event_id,
			'events_config_guestlist_active'	=> $this->input->post('event_guestlist'),
			'events_config_ekbarcode_active'	=> $this->input->post('event_ekbarcode'),
			'events_config_bcode_active'		=> $this->input->post('event_bcode'),
			'events_config_qrcode_active'		=> $this->input->post('event_qrcode'),
		);
		// 'events_config_eklisting_active'	=> $this->input->post('event_eklisting'),
		$where = "events_config_eventid = $event_id";
		
		$do_update = true;
		$test = trim($this->input->post('events_config_id'));
		if (empty($test)) {
			$__isql = $this->db->insert_string('events_config', $fields);
			if($this->db->simple_query($__isql)) {
				$do_update = false;
			}
		} 
		
		if ($do_update) {
			$__usql = $this->db->update_string($tablename, $fields, $where);
			$this->db->simple_query($__usql);
			// echo $__usql;
		}
		
		if($event_images!=""){
		$path = explode("/", $event_images);
		$image_event_path = $path[1].'/'.$path[2];

		$event_image_temp = substr($event_images, 0, -1);	
		$event_image = explode(',',$event_image_temp);
		$image_description_temp = substr($image_descriptions, 0, -1);
		$image_description = explode(',',$image_description_temp);

		

		foreach($event_image as $e_image) {
			$temp = array(
				'image_id' => '',
				'image_event_id' => $event_id,
				'image_path' => $image_event_path,
				'image_filename' => substr($e_image, strrpos($e_image, '/') + 1),
				'image_title' => reset(explode('/', $e_image)),
				'image_type' => 'gallery'
			);
		$__isql = $this->db->insert_string('images',$temp);
			if($this->db->simple_query($__isql)) {
				$do_update = false;
			}
		}
			
		}
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_charges
	 *
	 */
	function edit_charges($event_id)
	{		
		$fields = array(
			'event_venue_amusement_tax'		=> $this->input->post('venue_amusement_tax'),
			'event_venue_withholding_tax'	=> $this->input->post('venue_withholding_tax'),
			'event_venue_tax'				=> $this->input->post('venue_tax'),
			'event_venue_charge_1'			=> $this->input->post('venue_charge_1'),
			'event_venue_charge_2'			=> $this->input->post('venue_charge_2'),
			'event_venue_charge_3'			=> $this->input->post('venue_charge_3'),
			'event_venue_charge_4'			=> $this->input->post('venue_charge_4'),
			'event_venue_charge_5'			=> $this->input->post('venue_charge_5'),
			'event_venue_commission'		=> $this->input->post('venue_commission'),
			'event_service_charge'			=> $this->input->post('event_service_charge'),
			'event_ticket_charge'			=> $this->input->post('event_ticket_charge'),
			'event_vat'						=> $this->input->post('event_vat'),
			'event_withholding_tax'			=> $this->input->post('event_withholding_tax'),
			'event_bank_charge_internet'	=> $this->input->post('event_bank_charge_internet'),
			'event_bank_charge_branch'		=> $this->input->post('event_bank_charge_branch'),
			'event_administrative_fee'		=> $this->input->post('event_administrative_fee'),
			'event_minimum_guarantee'		=> $this->input->post('event_minimum_guarantee'),
			'event_internet_sales_charge'	=> $this->input->post('event_internet_sales_charge'),
			'event_delivery_charge'			=> $this->input->post('event_delivery_charge'),
			'event_revenue_pullout'			=> $this->input->post('event_revenue_pullout'),
			'event_complimentary_pullout'	=> $this->input->post('event_complimentary_pullout'),
			'event_interest_fee'			=> $this->input->post('event_interest_fee'),
			'event_reservation_fee'			=> $this->input->post('event_reservation_fee'),
	
		);
		
		// update db
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, $fields);
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_ticket_types
	 *
	 */
	function edit_ticket_types($event_id)
	{
		$fields = array(
			'event_ticket_types' => serialize($this->input->post('ticket_types')),
		);
		
		// update db
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, $fields);
		
		return true;
	}
	// --------------------------------------------------------------------
	
	/**
	 * edit charges
	 *
	 */
	function edit_charge($event_id)
	{
		$fields = array(
			'event_venue_amusement_tax'		=> $this->input->post('event_venue_amusement_tax'),
			'event_venue_withholding_tax'	=> $this->input->post('event_venue_withholding_tax'),
			'event_venue_tax'				=> $this->input->post('event_venue_tax'),
			'event_venue_charge_1'			=> $this->input->post('event_venue_charge_1'),
			'event_venue_charge_2'			=> $this->input->post('event_venue_charge_2'),	
			'event_venue_charge_3'			=> $this->input->post('event_venue_charge_3'),					
			'event_venue_charge_4'			=> $this->input->post('event_venue_charge_4'),
			'event_venue_charge_5'			=> $this->input->post('event_venue_charge_5'),
			'event_venue_commission'		=> $this->input->post('event_venue_commission'),
			'event_service_charge'			=> $this->input->post('event_service_charge'),
			'event_ticket_charge'			=> $this->input->post('event_ticket_charge'),
			'event_vat'						=> $this->input->post('event_vat'),
			'event_withholding_tax'			=> $this->input->post('event_withholding_tax'),
			'event_bank_charge_internet'	=> $this->input->post('event_bank_charge_internet'),
			'event_bank_charge_outlet'		=> $this->input->post('event_bank_charge_outlet'),
			'event_administrative_fee'		=> $this->input->post('event_administrative_fee'),
			'event_minimum_guarantee'		=> $this->input->post('event_minimum_guarantee'),
			'event_internet_sales_charge'	=> $this->input->post('event_internet_sales_charge'),
			'event_delivery_charge'			=> $this->input->post('event_delivery_charge'),
			'event_revenue_pullout'			=> $this->input->post('event_revenue_pullout'),
			'event_complimentary_pullout'	=> $this->input->post('event_complimentary_pullout'),
			'event_interest_fee'			=> $this->input->post('event_interest_fee'),
			'event_reservation_fee'			=> $this->input->post('event_reservation_fee'),
			'event_charge_01'				=> $this->input->post('event_charge_01'),
			'event_charge_02'				=> $this->input->post('event_charge_02'),
			'event_charge_03'				=> $this->input->post('event_charge_03'),
			'event_charge_04'				=> $this->input->post('event_charge_04'),
			'event_charge_05'				=> $this->input->post('event_charge_05'),
			'event_charge_06'				=> $this->input->post('event_charge_06'),
			'event_charge_07'				=> $this->input->post('event_charge_07'),
			'event_charge_08'				=> $this->input->post('event_charge_08'),
			'event_charge_09'				=> $this->input->post('event_charge_09'),
			'event_charge_10'				=> $this->input->post('event_charge_10'),
		);
		
		// update db
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, $fields);
		
		return true;
	}	

	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($event_id)
	{
		$this->db->delete('events', array('event_id' => $event_id));
		$this->db->delete('videos', array('video_event_id' => $event_id));
		
		return true;
	}
	
		function delete_image_gallery($image_id)
	{
		
		$this->db->delete('images', array('image_id' => $image_id));
		// $this->db->delete('videos', array('video_event_id' => $event_id));
		
		return true;
	}
	
	/**
	 * recommend
	 *
	 */
	function recommend($event_id)
	{
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, array('event_recommended'=>'yes') );
		
		return true;
	}
	
	/**
	 * recommend
	 *
	 */
	function unrecommend($event_id)
	{
		$this->db->where('event_id', $event_id);
		$this->db->update($this->events, array('event_recommended'=>'no') );
		
		return true;
	}
	
  
	function get_amusement_tax($event_id=false){
	
 
	$this->db->select('event_venue_amusement_tax as tax');
	$this->db->where('event_id', $event_id);
	return $this->db->get('events')->row()->tax;
	 
	}
	
	function get_event_details($event_id=false){
	
 
	$this->db->select('event_id,event_venue_amusement_tax as tax, event_expiration as expiry');
	$this->db->where('event_id', $event_id);
	return $this->db->get('events')->row();
	 
	}
	
	
	function get_event_status($evs_list){
	
		// $reports_date = strtotime($reports['reports_date']);
		// $strReportDate = date('Y-m-d',$reports_date);
		$today = date('Y-m-d');
		
		// $evs_list = array();
		$withstatus = array("done", "reserved");
	 
		$this->db->select("
							ti.ticket_id
 							, ti.ticket_event_id
							, ti.ticket_type_id
							, ti.ticket_price_id
							, ti.ticket_status
							, pr.price_price
							, tt.ticket_type_discount_type
							, tt.ticket_type_discount
							, tt.ticket_type_group
							, ti.ticket_reservation_expiry
 							, ti.ticket_branch_id
						");
		$this->db->from('tickets ti');
 		$this->db->join('prices pr', 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join('ticket_types tt', 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->where_in('ti.ticket_status', $withstatus);
		$this->db->where_in('ti.ticket_event_id', $evs_list); 
		$query = $this->db->get();
		 
		
		//data arrays
		$event_array = array();
		
	  
		//build data
		foreach($query->result() as $row)
		{
			
			
			
			$ticket_amt = 0;
			if ($row->ticket_type_discount_type == 'Percentage')
			{
				$ticket_amt = ceil($row->price_price - ($row->price_price * $row->ticket_type_discount / 100));
			}
			else
			{
				$ticket_amt = $row->price_price - $row->ticket_type_discount;
			}
			
			
			if (!isset($event_array[$row->ticket_event_id]['event_id']))
			{
				$event_array[$row->ticket_event_id]['event_id'] = $row->ticket_event_id;
				if ($row->ticket_status == 'done' || $row->ticket_status == 'paid_online')
				{
					
				 
					$event_array[$row->ticket_event_id]['event_tix_qty']['reg'] = 0;
 					 
					 
					if($row->ticket_type_group == 0){ 
						$event_array[$row->ticket_event_id]['event_tix_qty']['reg'] = 1;
 					}
					 
					
				}
				else 
				{
				
				
			 
					$event_array[$row->ticket_event_id]['event_tix_qty']['reg'] = 0;
 					 
					
				 
				 
				}
			}else{
			
				if ($row->ticket_status == 'done' || $row->ticket_status == 'paid_online')
				{
				
				 
					if($row->ticket_type_group == 0){ 
						$event_array[$row->ticket_event_id]['event_tix_qty']['reg'] += 1;
 					}
				 
				
				}
			
			
			
			}
			 
			
			
			if(isset($event_array[$row->ticket_event_id]['event_tix_qty']['cap'])){
			}else{
				 
				//seat cap
				$this->db->where('price_event_id', $row->ticket_event_id);
				$query = $this->db->get('prices');
				$prices = $query->result();
				$sectionsArray = array();
 				foreach ($prices as $price)
				{
					$sections = unserialize($price->price_sections);
					$sectionsArray[] = $sections;
					 
					$this->db->select('sum(section_capacity) as cap');
					$this->db->where_in('section_id',$sections);
					$queryy = $this->db->get('sections')->row(); 
					 
					 
				}

				$sectionsArray = call_user_func_array('array_merge', $sectionsArray); 
				$this->db->select('sum(section_capacity) as cap');
				$this->db->where_in('section_id',$sectionsArray);
				$query = $this->db->get('sections')->row(); 
				$event_array[$row->ticket_event_id]['event_tix_qty']['cap'] = $query->cap;
 				 
			}
			
			
			
			
			
		}
	
		// echo '<pre>';
		// print_r($event_array);
		// echo '</pre>';
		// die();
		
		return $event_array;
	
	
	
	}
		
	function is_event_code_exist($event_code = FALSE , $id = false)
	{
		// check if username exists
		$this->db->where('event_code', $event_code);
		$query = $this->db->get('events');
		
		if($query->num_rows() > 0){
		
			if($query->row()->event_id == $id){
			
				return false;
			
			}else{
			
				return true;
			}
		
		
		}else{
		
		
		return false;
		}
	}	
	
	function get_event_gallery($event_id)
	{
		$this->db->where('image_event_id', $event_id);
		$query = $this->db->get('images');
		$gallery = $query->result();
		return $gallery;
		
	}
	
	function edit_image_gallery($image_id){
		$this->db->where('image_id', $image_id);
		$query = $this->db->get('images');
		$gallery = $query->result();
		return $gallery;
	}
	
	function edit_image($image_info, $image_description,$image_id){
		
		if($image_info!=""){
		$path = explode("/", $image_info);
		$image_path = $path[0].'/'.$path[1];
		$filename = $path[2];
			$fields = array(
			'image_filename'		=> $filename,
			'image_path'			=> $image_path,
			'image_title'			=> $image_description,	
		);
		}
		else{
		$fields = array(
			'image_title'			=> $image_description,	
		);
			
		}

		
		// update db
		$this->db->where('image_id', $image_id);
		$this->db->update('images', $fields);
		
		return true;
	}
	
	
	
}

// END events_model.php
/* Location: ./application/models/events_model.php */	


