<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class EKBarcode_model extends CI_Model
{

	var $events = 'events e';
	var $events_config = "events_config ec";
	var $guestlist = "guestlist gl";
	var $guestlist_config = "guestlist_config gc";
	var $guestlist_config_ext = "guestlist_config_ext gce";
	var $guestlist_transactions = "guestlist_transactions glt";
	var $venues = "venues v";
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('sections_model', 'sections');
		// $this->load->model('events_model', 'events');
	}

	function add_entry($event_id, $csvdata, $days_valid, $ticket_type)
	{
		/*
			Access Code = first 6-digits of barcode
			Range = 311100 to 322222

			Barcode length = 16
			
			Example: 
					311100 1234567890 Regular Day Pass
					311101 1234567890 Promo 1
		*/
		$valid = false;
		if (count($csvdata) > 0) {
			$barcode = $csvdata[0];
			$access_code = substr($barcode,0,6);
			$fields = array(
				'ek_event_id'		=> $event_id,
				'ek_access_code'	=> $access_code,
				'ek_barcode'		=> $barcode,
				'ek_days_valid'		=> $days_valid,
				'ek_ticket_type'	=> $ticket_type,
			);
			
			// build insert SQL
			$__isql = $this->db->insert_string('ek_barcode', $fields);
			$valid = $this->db->simple_query($__isql);
		}
		return $valid;

	}

	function add_entry_for_price($event_id, $csvdata, $days_valid, $price_id)
	{
		/*
			Access Code = first 6-digits of barcode
			Range = 311100 to 322222

			Barcode length = 16
			
			Example: 
					311100 1234567890 Regular Day Pass
					311101 1234567890 Promo 1
		*/
		$valid = false;
		if (count($csvdata) > 0) {
			$barcode = $csvdata[0];
			$access_code = substr($barcode,0,6);
			$fields = array(
				'ek_event_id'		=> $event_id,
				'ek_access_code'	=> $access_code,
				'ek_barcode'		=> $barcode,
				'ek_days_valid'		=> $days_valid,
				'ek_price_id'		=> $price_id,
			);
			
			// build insert SQL
			$__isql = $this->db->insert_string('ek_barcode', $fields);
			$valid = $this->db->simple_query($__isql);
		}
		return $valid;

	}
 
	function listing($active = false) {
		$this->db->query('set transaction isolation level read uncommitted');
		if ($active) {
			$this->db->where("events_config_eklisting_active", 1);
		}
		$this->db->join($this->events_config, 'ec.events_config_eventid = e.event_id', 'left');
		$this->db->join($this->venues, 'v.venue_id = e.event_venue_id', 'left');
		$this->db->where("events_config_ekbarcode_active", 1);
		return $this->db->get($this->events)->result();
	}
	
	function listing_active() {
		return $this->listing(true);
	}

/* 
	function namelist($glc_id = 0, $last_row = 0, $row_count = 0) {
		$this->db->where("gl.guest_config_id", $glc_id);
		$this->db->order_by("gl.guest_id");
		if ($row_count > 0) {
			$start_row = $last_row;
			return array($this->db->count_all($this->guestlist), $this->db->get($this->guestlist, $row_count, $start_row)->result());
		} else {
			// echo $this->db->last_query();
			return $this->db->get($this->guestlist)->result();
		}
	}
 */	

/* 	function guest_details($guest_id) {
		$this->db->where("guest_id",$guest_id);
		return $this->db->get($this->guestlist)->row();
	}
 */	
 
/* 	function guest_details_by_transaction($transaction_id) {
		$this->db->where("glt_transaction_id",$transaction_id);
		$this->db->join($this->guestlist, "gl.guest_id = glt.glt_guest_id", "left");
		return $this->db->get($this->guestlist_transactions)->row();
	}
 */	

/* 	function basic_details($glc_id = 0) {
		$this->db->where("gc.glc_id", $glc_id);
		return $this->db->get($this->guestlist_config)->result();
	}
 */	
 
/* 	function extended_details($glc_id = 0) {
		$this->db->select("gce.*, e.event_title, e.event_seatplan_id");
		// $this->db->join($this->guestlist_config_ext,"gc.glc_id = gce.glce_glc_id", "LEFT");
		$this->db->join($this->events, "e.event_id = gce.glce_event_id", "LEFT");
		$this->db->where("gce.glce_glc_id", $glc_id);
		
		// return $this->db->get($this->guestlist_config)->result();
		return $this->db->get($this->guestlist_config_ext)->result();
	}
 */	
 
/* 	function full_config_details($glc_id = 0) {
		return array(
			$this->basic_details($glc_id),
			$this->extended_details($glc_id),
		);
	}
 */
	
/* 	function events_exclusive() {
	
		$this->db->select('ec.*, e.event_title');
		$this->db->join($this->events, 'ec.events_config_eventid = e.event_id', 'left');	
		$this->db->where('events_config_guestlist_active', 1);
		$this->db->order_by('e.event_long_title, e.event_title');
		return $this->db->get($this->events_config)->result();
	}
 */
	
/* 	function create($guestlist_configname = "", $guestlist_eventids = array())
	{
		// build insert SQL for GLC
		$fields = array(
			'glc_name'	=> $guestlist_configname,
		);
		$__isql = $this->db->insert_string('guestlist_config', $fields);

		$this->db->simple_query($__isql);
		// return $this->db->simple_query($__isql);
		$glc_id = $this->db->insert_id();


		// build insert SQL for GLC_EXTENDED
		// $x = count($guestlist_eventids);
		
		foreach($guestlist_eventids as $eventid) {
		
			$fields = array(
				'glce_glc_id'	=> $glc_id,
				'glce_event_id'	=> $eventid,
			);
			$__isql = $this->db->insert_string('guestlist_config_ext', $fields);
			$this->db->simple_query($__isql);
		}
		
	}
 */
	
/* 	function add_tickets($event_id, $prices_sections, $ticket_per_section = 1)
	{
	
		// for free-seating and standing
		$ticket_count = 0;
		if ($ticket_per_section > 0)
		{

			foreach ($prices_sections as $price_id => $section_id)
			{
				$section_info = $this->sections->get_ticket_availability($section_id, false, false); 
				// print_r($section_info);
				$fields = array(
					'ticket_date_entered'		=> date('Y-m-d H:i:s'),
					'ticket_session_id'			=> $this->session->userdata('customer_session_id'),
					'ticket_event_id'			=> $event_id,
					'ticket_section_id'			=> $section_id,
					'ticket_price_id'			=> $price_id,
					'ticket_seat'				=> $section_info["type"],
					'ticket_user_id'			=> $this->session->userdata('user_id'),
					'ticket_branch_id'			=> $this->session->userdata('user_branch_id'),
					'ticket_terminal_id'		=> $this->session->userdata('user_terminal_id'),
					'ticket_status'				=> 'selected'
				);
				
				//print_array($fields);
				
				// insert to db
				$this->db->set($fields);
				$this->db->insert('tickets');

				$ticket_count++;
			}
			if ($ticket_per_section > 0) {
				$this->sections->update_available($section_id, 'decrease', $ticket_count);
			}
	
		}

		return $ticket_count;
	}
 */
	
/* 	function rsvp_transaction_add_connection($transaction_id, $guest_id) {
		// build insert SQL for GLC
		$fields = array(
			'glt_transaction_id'	=> $transaction_id,
			'glt_guest_id'	=> $guest_id,
		);
		$__isql = $this->db->insert_string("guestlist_transactions", $fields);
		$this->db->simple_query($__isql);

		$glt_id = $this->db->insert_id();
		return $glt_id;
	}
*/	

	function ticket_types_with_barcodes($event_id = 0, $allowed_ticket_type, $ticket_count) {
		$arraydata = array();
		
		$this->db->select('ek_ticket_type, count(*) AS barcode_count');
		// $this->db->where('ek_transaction_id IS NULL');
		$this->db->where('ek_ticket_id IS NULL');
		$this->db->where('ek_event_id', $event_id);
		$this->db->where_in('ek_ticket_type', $allowed_ticket_type);
		$this->db->group_by('ek_ticket_type');
		$query = $this->db->get('ek_barcode');
		foreach($query->result() as $row) {
			if ($row->barcode_count >= $ticket_count) {
				$arraydata[] = $row->ek_ticket_type;
			}
		}
		

		return $arraydata;
	}
	
	function edit_ticket_type($event_id)
	{
		$ticket = $this->input->post('ticket');
		$ticket_type = $this->input->post('ticket_type');
		$count = count($ticket);
		
		for ($i = 0; $i < $count; $i++)
		{
			$fields['ticket_type_id'] = $ticket_type[$i];
			
			// update db
			$this->db->where('ticket_id', $ticket[$i]);
			$this->db->update('tickets', $fields);
			
			$this->mark_barcode_for_ticket($event_id, $ticket[$i], $ticket_type[$i]);
		}
	
		return true;
	}

	function mark_barcode_for_ticket($event_id, $ticket_id, $ticket_type) {
			$fields['ek_ticket_id'] = $ticket_id;
			
			// $this->db->where('ek_transaction_id IS NULL');
			$this->db->where('ek_ticket_id IS NULL');
			$this->db->where('ek_event_id', $event_id);
			$this->db->where('ek_ticket_type', $ticket_type);
			$this->db->limit(1);
			$this->db->update('ek_barcode', $fields);
	}
	
	function mark_barcode_for_ticket_per_price($event_id, $ticket_id, $price_id) {
			$fields['ek_ticket_id'] = $ticket_id;
			
			// $this->db->where('ek_transaction_id IS NULL');
			$this->db->where('ek_ticket_id IS NULL');
			$this->db->where('ek_event_id', $event_id);
			$this->db->where('ek_price_id', $price_id);
			$this->db->limit(1);
			$this->db->update('ek_barcode', $fields);
	}
	
	function count_available_barcodes($event_id, $price_id) {
		
		$this->db->select('ek_id');
		// $this->db->where('ek_transaction_id IS NULL');
		$this->db->where('ek_ticket_id IS NULL');
		$this->db->where('ek_event_id', $event_id);
		$this->db->where('ek_price_id', $price_id);
		$this->db->from('ek_barcode');
		$barcode_count = $this->db->count_all_results();
		return $barcode_count;
	}
	
	function available_barcodes($event_id) {
		
		$this->db->select('ekb.ek_price_id, pr.price_name, pr.price_price, count(*) AS barcode_count');
		$this->db->where('ekb.ek_ticket_id IS NULL');
		$this->db->where('ekb.ek_event_id', $event_id);
		$this->db->join('prices pr', 'pr.price_id = ekb.ek_price_id', 'LEFT');
		$this->db->group_by('ek_price_id');
		$query=$this->db->get('ek_barcode ekb');
		
		return $query->result();
	}
	
	function available_barcode_array($event_id) {
		$return_array = array();
		
		$res = $this->available_barcodes($event_id);
		foreach($res as $row) {
			$return_array[$row->ek_price_id] = $row->barcode_count;
		}
		
		return $return_array;
	}
	
	
	function create_tickets($event_id, $section, $price_id)
	{
		$ticket_count = 0;
	
		// for free-seating and standing
		$input_qty = $this->input->post('ticket_quantity');
		if (is_numeric($input_qty))
		{
			$available_barcodes = $this->count_available_barcodes($event_id, $price_id);
			if ($available_barcodes >= $input_qty) {
				foreach (range(1, $input_qty) as $count)
				{
					$fields = array(
						'ticket_date_entered'		=> date('Y-m-d H:i:s'),
						'ticket_session_id'			=> $this->session->userdata('customer_session_id'),
						'ticket_event_id'			=> $event_id,
						'ticket_section_id'			=> $section->section_id,
						'ticket_price_id'			=> $this->session->userdata('cpi'),
						'ticket_seat'				=> $section->section_type,
						'ticket_user_id'			=> $this->session->userdata('user_id'),
						'ticket_branch_id'			=> $this->session->userdata('user_branch_id'),
						'ticket_terminal_id'		=> $this->session->userdata('user_terminal_id'),
						'ticket_status'				=> 'selected'
					);
					
					//print_array($fields);
					
					// insert to db
					$this->db->set($fields);
					$this->db->insert('tickets');
					
					$ticket_id = $this->db->insert_id();

					$this->mark_barcode_for_ticket_per_price($event_id, $ticket_id, $price_id);
					
					$ticket_count++;
				}
			}

			if ($ticket_count > 1) {
				$this->sections->update_available($section->section_id, 'decrease', $ticket_count);
			}
		}
		
		// for reserved seats
		else
		{
			foreach ($this->input->post('seat') as $seat_row => $seat_cols)
			{
				foreach ($seat_cols as $seat_col => $seat)
				{
		
					list($system_col, $row, $seat) = explode('|', $seat);
								
					$fields = array(
						'ticket_date_entered'		=> date('Y-m-d H:i:s'),
						'ticket_session_id'			=> $this->session->userdata('customer_session_id'),
						'ticket_event_id'			=> $event_id,
						'ticket_section_id'			=> $section->section_id,
						'ticket_price_id'			=> $this->session->userdata('cpi'),
						'ticket_system_row'			=> str_replace('R', '', $seat_row),
						'ticket_system_col'			=> str_replace('C', '', $system_col),
						'ticket_row'				=> $row,
						'ticket_seat'				=> $seat,
						'ticket_status'				=> 'selected'
					);
					
					//print_array($fields);
					
					// insert to db
					$this->db->set($fields);
					$this->db->insert('tickets');
					
					$ticket_count++;
			
				}
			}
		}
		
		return $ticket_count;
	}
	
	function free_stagnant_barcodes() {
		$stagnant = "('unselected')";
		
		$query = $this->db->query("
			UPDATE ek_barcode ekb 
				LEFT JOIN tickets tix
					ON tix.ticket_id = ekb.ek_ticket_id
				SET ek_ticket_id = null
			WHERE tix.ticket_status IN $stagnant
		");
	}
	
	function barcodelist($event_id = 0, $show_all = false, $view_usedbarcode = false) {

		$retval = false;
		
		if ($event_id > 0) {
			$this->db->join('prices pr', 'pr.price_id = ekb.ek_price_id', 'left');
			$this->db->join('tickets tix', 'tix.ticket_id = ekb.ek_ticket_id', 'left');
			$this->db->where("ek_event_id", $event_id);
			if ($show_all) {} 
			else {
				if ($view_usedbarcode) {
					$this->db->where("ek_ticket_id IS NULL");
				} else {
					$this->db->where("ek_ticket_id IS NOT NULL");
				}
			}
			$this->db->order_by("ek_id", "DESC");
			$retval = $this->db->get('ek_barcode ekb')->result();
		}
		
		return $retval;
	}
	
	function set_eksale_listing_config($event_id = 0,$status = 0)
	{
		$retval = false;
		if ($event_id > 0) {
			$tablename = 'events_config';
			$where = "events_config_eventid = $event_id";

			$fields = array(
				'events_config_eklisting_active' => $status, 
			);
			// build insert SQL
			$__usql = $this->db->update_string($tablename, $fields, $where);
			$retval = $this->db->simple_query($__usql);
		}
		
		return $retval;
	}
	

	function _check_tix_stat($session_id = false, $event_id = false, $stat = false, $tix_qty = false)
	{
		$this->db->select("ti.ticket_status");
		$this->db->join("ek_barcode ekb", "ekb.ek_ticket_id = ti.ticket_id");
		$this->db->where('ti.ticket_session_id', $session_id);
		$this->db->where_in('ti.ticket_status', $stat);
		
		$get_tix_stat = $this->db->get('tickets ti');
		
		if ($get_tix_stat->num_rows() == $tix_qty)
		{
			return true;
		}
		else 
		{
			return false;
		}
	}
	
	function listing_active_array() {
		$tmp = array();
		foreach($this->listing(true) as $row) {
			$tmp[$row->events_config_eventid] = 0;
		}
		return $tmp;
	}

	
}
