<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Ds_model extends CI_Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';
	var $customers = 'customers c';
	var $terminals = 'terminals te';
	var $prices = 'prices pr';

	var $ticket_types = 'ticket_types tt';
	var $events = 'events ev';
	var $venues = 'venues ve';
	var $promoters = 'promoters pro';
	var $users	=	'users u';
	var $branches = 'branches br';
	var $payments = 'payments pay';
	var $payment_types = 'payment_types pt';

	// added for consolidated reports  BY JAIZON
	var $sections = 'sections sec';
	var $seatplans = 'seatplans sea';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * Daily Sales File
	 *
	 * @access	public
	 */
	
	function dsf($date)
	{
							// , pt.payment_type_code
		$this->db->select("t.transaction_id
							, ev.event_code
							, t.transaction_branch_id
							, t.transaction_date as tdate
							, count(ti.ticket_id) as qty
							, pr.price_id
							, tt.ticket_type_id
							, tt.ticket_type_code
							, ev.event_bank_charge_outlet
							, ev.event_internet_sales_charge
							, ev.event_service_charge
							, ev.event_reservation_fee
							, ti.ticket_reservation_expiry
							, tt.ticket_type_discount_type
							, tt.ticket_type_discount
							, pr.price_price
							");
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		//$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->group_by('ti.ticket_id');
		$this->db->where('date(t.transaction_date)', $date);
		$this->db->where('ti.ticket_status', 'done');
		$query = $this->db->get('tickets ti');
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * Daily Shows Update
	 *
	 * @access	public
	 */
	
	function dsu()
	{
		// , t.transaction_date as tdate, t.transaction_id, tt.ticket_type_id, ev.event_title, ev.event_date_time, pro.promoter_name, pro.promoter_id, ve.venue_name, ev.event_reservation_expire
		$this->db->select("ev.event_id
							, ev.event_code
							, pr.price_id
							, pr.price_price
							, ev.event_bank_charge_outlet
							, ev.event_vat
							, ev.event_ticket_types
							");
		//$this->db->join($this->venues, 've.venue_id = ev.event_venue_id');
		//$this->db->join($this->promoters, 'pro.promoter_id = ev.event_promoter_id');
		$this->db->join($this->prices, 'pr.price_event_id = ev.event_id');
		//$this->db->where('ev.event_active', 1);
		//$this->db->group_by('ev.event_id');
		$query = $this->db->get('events ev');
		
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * Dept Store Events
	 *
	 * @access	public
	 */
	
	function dse()
	{
		// , t.transaction_date as tdate, t.transaction_id, tt.ticket_type_id
		$this->db->select("ev.event_id
							, ev.event_code
							, ev.event_date_time
							, ev.event_title
							, pro.promoter_id
							, pro.promoter_name
							, ve.venue_name
							, ev.event_reservation_expire
							, pr.price_id
							, pr.price_price
							, ev.event_bank_charge_outlet
							, ev.event_vat
							, ev.event_ticket_types
							");
		$this->db->join($this->venues, 've.venue_id = ev.event_venue_id');
		$this->db->join($this->promoters, 'pro.promoter_id = ev.event_promoter_id');
		$this->db->join($this->prices, 'pr.price_event_id = ev.event_id');
		//$this->db->where('ev.event_active', 1);
		//$this->db->group_by('ev.event_id');
		$query = $this->db->get('events ev');
		
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * Dept Store Pricecodes
	 *
	 * @access	public
	 */
	
	function dsp()
	{
		// , t.transaction_date as tdate, t.transaction_id, tt.ticket_type_id
		$this->db->select("pr.price_id
							, pr.price_event_id
							, pr.price_name
							, pr.price_price
							, pr.price_sections
							");
		$this->db->order_by('pr.price_id');
		$query = $this->db->get('prices pr');
		
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * Dept Store Payment Types
	 *
	 * @access	public
	 */
	
	function dspt()
	{
		$this->db->order_by('pt.payment_type_id');
		$query = $this->db->get('payment_types pt');
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * Dept Store Ticket Types
	 *
	 * @access	public
	 */
	
	function dstt()
	{
		$this->db->order_by('tt.ticket_type_id');
		$query = $this->db->get('ticket_types tt');
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * Dept Store Ticket Types
	 *
	 * @access	public
	 */
	
	function dsb()
	{
		$this->db->select('br.branch_id, br.branch_name, br.branch_category');
		$this->db->order_by('br.branch_id');
		$query = $this->db->get('branches br');
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get branches dropdown with empty option
	 *
	 * @access	public
	 */
	
	function get_branches_dropdown()
	{
		//$this->db->where('branch_id !=', 40);
		if($this->session->userdata('user_branch_id') == 142){ 
			$this->db->where('branch_category','SM Dept. Store');
 		}
		
		$this->db->order_by('branch_name');
		$query = $this->db->get($this->branches);
			
		$result = $query->result();

		if ($result)
		{
			// add an empty array 
			$array[''] = '';
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->branch_id] = $r->branch_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get sellers dropdown with empty option
	 *
	 * @access	public
	 */
	
	function get_sellers_dropdown()
	{
		if ($this->session->userdata('user_branch_id') != 1)
		{
			$this->db->where('user_branch_id', $this->session->userdata('user_branch_id'));
		}
		$this->db->order_by('user_lastname');
		$query = $this->db->get($this->users);
			
		$result = $query->result();

		if ($result)
		{
			// add an empty array 
			$array[''] = '';
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->user_id] = $r->user_lastname . ", " . $r->user_firstname;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get events dropdown with empty option
	 *
	 * @access	public
	 */
	
	function get_events_dropdown()
	{
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->where('event_cod', 1);
		}
		$this->db->order_by('event_title');
		$query = $this->db->get($this->events);
			
		$result = $query->result();

		if ($result)
		{
			// add an empty array 
			$array[''] = '';
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * reports filter
	 *
	 * @access	public
	 */
	
	function reports_filter($eventgroup)
	{
		switch ($eventgroup)
		{
			case 'bssr' :
				{
					$date_from = $this->input->post('date_from');
					$date_to = $this->input->post('date_to');
					$branch_id = $this->input->post('branch_id');
					$user_id = $this->input->post('user_id');
					$event_id = $this->input->post('event_id');
					
					return array('date_from' => $date_from, 'date_to' => $date_to, 'branch_id' => $branch_id, 'user_id' => $user_id, 'event_id' => $event_id);
					break;
				}
			case 'dsf' :
				{
					$date_from = $this->input->post('date_file');
					//$date_to = $this->input->post('date_to');
					//$branch_id = $this->input->post('branch_id');
					//$user_id = $this->input->post('user_id');
					//$event_id = $this->input->post('event_id');
					
					return array('date_file' => $date_from);
					break;
				}
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_branch_details
	 *
	 * @access	public
	 */
 	function get_branch_details($branch_id)
	{
		$this->db->select('br.branch_name');
		$this->db->where('branch_id', $branch_id);
		$query = $this->db->get('branches br');
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_user_details
	 *
	 * @access	public
	 */
 	function get_user_details($user_id)
	{
		$this->db->select('u.user_lastname, u.user_firstname, te.terminal_code, te.terminal_name');
		$this->db->join($this->terminals, 'te.terminal_id = u.user_terminal_id', 'left outer');
		$this->db->where('user_id', $user_id);
		$query = $this->db->get('users u');
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * bssr
	 *
	 * @access	public
	 */
	function bssr($branch_id = false, $event_id = false, $user_id = false, $date_from, $date_to, $payment_type = false)
	{
		$this->db->select('
							pay.payment_transaction_id
							, count(pay.payment_transaction_id) as pt_qty
							');
		//$this->db->join($this->transactions, 't.transaction_id = pay.payment_transaction_id', 'left outer');
		/*$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');*/
		/*$this->db->where('date(t.transaction_date) >=', $date_from);
		$this->db->where('date(t.transaction_date) <=', $date_to);*/
		$this->db->where('pay.payment_amount_type', 'tickets');
		/*if ($branch_id)
		{
			$this->db->where('br.branch_id', $branch_id);
		}
		if ($event_id)
		{
			$this->db->where('ev.event_id', $event_id);
		}
		if ($user_id)
		{
			$this->db->where('u.user_id', $user_id);
		}*/
		$this->db->group_by('pay.payment_transaction_id');
		$query = $this->db->get('payments pay');
		
		$ptid_pqty = $query->result();
		
		$mult_array = array();
		
		foreach ($ptid_pqty as $row)
		{
			if ($row->pt_qty > 1)
			{
				$mult_array['trans_id'] = $row->payment_transaction_id;
			}
		}
		//--------------------------------------------------------------------------------------------------------------
		$this->db->select('ti.ticket_id
							, ti.ticket_price_id
							, ti.ticket_section_id
							, ti.ticket_reservation_expiry
							, t.transaction_id
							, ev.event_id
							, u.user_id
							, t.transaction_user_id
							, t.transaction_branch_id
							, br.branch_id
							, ev.event_title
							, ev.event_code
							, tt.ticket_type_id
							, tt.ticket_type_name
							, tt.ticket_type_discount_type
							, tt.ticket_type_discount
							, pr.price_price
							, ev.event_service_charge
							, ev.event_reservation_fee
							, sec.section_id
							, sec.section_code
							, sec.section_name
							');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		
		
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			$this->db->where('event_cod', 1);
		}
		
		if ($branch_id)
		{
			$this->db->where('br.branch_id', $branch_id);
		}
		if ($event_id)
		{
			$this->db->where('ev.event_id', $event_id);
		}
		if ($user_id)
		{
			$this->db->where('u.user_id', $user_id);
		}
		
		if ($payment_type == 'cash')
		{
			$this->db->where('pay.payment_payment_type_id', 1);
		}
		else 
		{
			$this->db->where('pay.payment_payment_type_id !=', 1);
		}
		
		if (!empty($mult_array))
		{
			if ($payment_type != 'mult')
			{
				$this->db->where_not_in('t.transaction_id', $mult_array);
			}
			else 
			{
				$this->db->where_in('t.transaction_id', $mult_array);
			}
		}
		
		$this->db->where('date(t.transaction_date) >=', $date_from);
		$this->db->where('date(t.transaction_date) <=', $date_to);
		$this->db->where('pay.payment_amount_type', 'tickets');
		$this->db->where('ti.ticket_status', 'done');
		$this->db->order_by('ev.event_id, ti.ticket_section_id, tt.ticket_type_id, ti.ticket_price_id');
		$query = $this->db->get('transactions t');
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * gatwmpt
	 *
	 * @access	public
	 */
	
	function gatwmpt($date_from, $date_to, $event_id = false, $branch_id = false, $user_id = false)
	{
		$this->db->select('
							pay.payment_transaction_id
							, count(pay.payment_transaction_id) as pt_qty
							');
		$this->db->join($this->transactions, 't.transaction_id = pay.payment_transaction_id', 'left outer');
		$this->db->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db->join($this->branches, 'br.branch_id = ti.ticket_branch_id', 'left outer');
		$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db->join($this->users, 'u.user_id = ti.ticket_user_id', 'left outer');
		$this->db->where('date(t.transaction_date) >=', $date_from);
		$this->db->where('date(t.transaction_date) <=', $date_to);
		$this->db->where('pay.payment_amount_type', 'tickets');
		if ($branch_id)
		{
			$this->db->where('br.branch_id', $branch_id);
		}
		if ($event_id)
		{
			$this->db->where('ev.event_id', $event_id);
		}
		if ($user_id)
		{
			$this->db->where('u.user_id', $user_id);
		}
		$this->db->group_by('pay.payment_transaction_id');
		$query = $this->db->get('payments pay');
		
		$ptid_pqty = $query->result();
		
		$mult_array = array();
		
		foreach ($ptid_pqty as $row)
		{
			if ($row->pt_qty > 1)
			{
				$mult_array['trans_id'] = $row->payment_transaction_id;
			}
		}
		
		return $mult_array;
	}
}
 		
// END reports_model.php
/* Location: ./application/models/reports_model.php */		