<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Contacts_model extends CI_Model
{
	var $contacts = 'contacts c';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_contact
	 *
	 * @access	public
	 */
	function get($contact_id)
	{
		$this->db->where('contact_id', $contact_id);
		$query = $this->db->get($this->contacts);
		//echo $this->db->last_query();
		
		return $query->row();
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * get_contacts
	 *
	 * @access	public
	 */
	function get_contacts($type = false, $id = false)
	{
		switch($type)
		{
			case 'promoters': $this->db->where('contact_promoter_id', $id); break;
			case 'venues': $this->db->where('contact_venue_id', $id); break;
			case 'branches': $this->db->where('contact_branch_id', $id); break;
		}
		
		$query = $this->db->get($this->contacts);
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------	
	
	/**
	 * get_contacts_dropdown
	 *
	 * @access	public
	 */
	function get_contacts_dropdown()
	{
		$query = $this->db->get($this->contacts);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->contact_id] = $r->contact_firstname.' '.$r->contact_lastname;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}

	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add($type = false , $id = false)
	{
		$fields = array(
			'contact_firstname'			=> $this->input->post('contact_firstname'),
			'contact_lastname'			=> $this->input->post('contact_lastname'),
			'contact_position'			=> $this->input->post('contact_position'),
			'contact_department'		=> $this->input->post('contact_department'),
			'contact_phone'				=> $this->input->post('contact_phone'),
			'contact_fax'				=> $this->input->post('contact_fax'),
			'contact_mobile'			=> $this->input->post('contact_mobile'),
			'contact_email'				=> $this->input->post('contact_email'),
			'contact_active'			=> '1',
		);
			
		switch($type)
		{
			case 'promoters': $fields['contact_promoter_id'] = $id; break;
			case 'venues': $fields['contact_venue_id'] = $id; break;
			case 'branches': $fields['contact_branch_id'] = $id; break;
		}
			
		// insert to db
		$this->db->set($fields);
		$this->db->insert('contacts');
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($contact_id, $type = false , $id = false)
	{
		$fields = array(
			'contact_firstname'		=> $this->input->post('contact_firstname'),
			'contact_lastname'		=> $this->input->post('contact_lastname'),
			'contact_position'		=> $this->input->post('contact_position'),
			'contact_department'	=> $this->input->post('contact_department'),
			'contact_phone'			=> $this->input->post('contact_phone'),
			'contact_fax'			=> $this->input->post('contact_fax'),
			'contact_mobile'		=> $this->input->post('contact_mobile'),
			'contact_email'			=> $this->input->post('contact_email'),
		);
		
		switch($type)
		{
			case 'promoters': $fields['contact_promoter_id'] = $id; break;
			case 'venues': $fields['contact_venue_id'] = $id; break;
			case 'branches': $fields['contact_branch_id'] = $id; break;
		}		
			
		// update db
		$this->db->where('contact_id', $contact_id);
		$this->db->update($this->contacts, $fields);
		
		return true;
	}	

	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($contact_id)
	{
		$this->db->delete('contacts', array('contact_id' => $contact_id));
		
		return true;
	}
		
}
// END contacts_model.php
/* Location: ./application/models/contacts_model.php */	