<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Claims_model extends CI_Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';
	var $customers = 'customers c';
	var $terminals = 'terminals te';
	var $branches = 'branches b';
	var $users = 'users u';
	var $events = 'events e';
	var $sections = 'sections s';
	var $prices = 'prices p';	
	var $ticket_types = 'ticket_types tt';
	var $venues = 'venues v';
	var $ticket_layouts = 'ticket_layouts tl';
	var $logos = 'logos l';
	var $ticket_logos = 'ticket_logos tk';
	
	var $paid_status = array('done','paid_online');

	var $arrTListStat = array(); // status filter for TRANSACTION LISTING
	var $arrEventTListStat = array('reserved','unselected'); // status filter for EVENT TRANSACTION LISTING
	var $arrTicketStat = array('done','paid','selected','paid_online');
	// using constructor function, get value of $arrEventTlistStat to make filter for transaction listing the same

	public function __construct()
	{
		parent::__construct();
		$this->load->model('payment_types_model', 'payment_types_model');
		$this->load->model('branches_model', 'branches_model');
		
		// same filter array. no reserve for display of TRANSACTION LISTING
		$this->arrTListStat = $this->arrEventTListStat;
	}
	
	// --------------------------------------------------------------------
	
	function get_by_transaction($transID)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('t.*, cu.customer_firstname, cu.customer_lastname, cu.customer_mobile, us.user_firstname, us.user_lastname, br.branch_name, trm.terminal_name, count(tix.ticket_id) as ticket_count, max(tix.ticket_event_id) as ticket_event_id , cu.customer_block as blocked, card_number_value as card_num, card_number_expiration as expiration');
		$this->db->join('tickets tix', 't.transaction_id = tix.ticket_transaction_id', 'LEFT');
		$this->db->join('customers cu', 'cu.customer_id = t.transaction_customer_id', 'LEFT');
		$this->db->join('branches br', 'br.branch_id = t.transaction_branch_id', 'LEFT');
		$this->db->join('terminals trm', 'trm.terminal_id = t.transaction_terminal_id', 'LEFT');
		$this->db->join('users us', 'us.user_id = t.transaction_user_id', 'LEFT');
		$this->db->join('card_numbers cn', 'cn.card_number_transaction_id = t.transaction_id', 'LEFT');
		$this->db->where_in('ticket_status', array('done','paid_online'));
		$this->db->where('t.transaction_id', $transID);
		$this->db->where('ticket_event_id', 5803);
		// $this->db->where('ticket_date_entered <', '2018-04-01');
		$this->db->group_by('t.transaction_id');
		$query = $this->db->get($this->transactions);

		return $query->row();
	}
	
	function get_by_transaction_ticket_breakdown($transID)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('cl.*, us.user_firstname, us.user_lastname, br.branch_name, trm.terminal_name');
		$this->db->join('branches br', 'br.branch_id = cl.claim_branch_id', 'LEFT');
		$this->db->join('terminals trm', 'trm.terminal_id = cl.claim_terminal_id', 'LEFT');
		$this->db->join('users us', 'us.user_id = cl.claim_user_id', 'LEFT');
		$this->db->join('tickets', 'claim_transaction_id = ticket_transaction_id', 'LEFT');
		$this->db->where('cl.claim_transaction_id', $transID);
		$this->db->where('ticket_event_id', 5803);
		// $this->db->where('ticket_date_entered <', '2018-04-01');
		$query = $this->db->get('claims cl');

		return $query->result();
	}
	
	function get_trans_details($transaction_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->join($this->terminals, 't.transaction_terminal_id = te.terminal_id');
		$this->db->join($this->branches, 't.transaction_branch_id = b.branch_id');
		$this->db->join($this->users, 't.transaction_user_id = u.user_id');
		$this->db->join($this->customers, 't.transaction_customer_id = c.customer_id', 'left');
 		//$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		//$this->db->join($this->events, 'ti.ticket_event_id = e.event_id', 'left');
		$this->db->where('transaction_id', $transaction_id);
		$query = $this->db->get($this->transactions);
	
		return $query->row();		
	}
	
	function get_tickets_details($transaction_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('ti.*, t.*, p.*, e.event_reservation_fee, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where_in('ti.ticket_status', array('paid_online','done','paid'));
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join($this->events, 'ti.ticket_event_id = e.event_id', 'left');
		$this->db->orderby('ti.ticket_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		// echo $this->db->last_query();
		
		return $query->result();
	}
	
	function mark_for_ticket_claim($transaction_id)
	{
		$fields = array(
			'claim_transaction_id'				=> $transaction_id,
			'claim_date_time'					=> date('Y-m-d H:i:s'),
			'claim_branch_id'					=> $this->session->userdata('user_branch_id'),
			'claim_terminal_id'					=> $this->session->userdata('user_terminal_id'),
			'claim_user_id'						=> $this->session->userdata('user_id')
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('claims');
		
		return true;
	}
	
	function validatePaidTransactionWithXML($yearmonth = false, $id = false, $trans_id = false) {
		$retval = false;
		
		if (($trans_id > 0) && ($yearmonth > 0) && ($id > 0)){
			$this->db->select('t.transaction_id, g.xml_yearmonth, g.xml_id');
			$this->db->join('generator g', 'g.xml_trans_id = t.transaction_id');
			$this->db->where('t.transaction_id', $trans_id);
			$this->db->where('g.xml_yearmonth', $yearmonth);
			$this->db->where('g.xml_id', $id);
			$query = $this->db->get($this->transactions);
			
			if ($query->num_rows() > 0) {
				$retval = true;
			}
		}
		
		return $retval;
	}
	
	function get_otc_tickets($transaction_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('ti.*, t.*, p.*, e.event_reservation_fee, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('ti.ticket_status', 'done');		
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join($this->events, 'ti.ticket_event_id = e.event_id', 'left');
		$this->db->orderby('ti.ticket_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	function get_paid_tickets_for_printing($transaction_id, $cpi = false)
	{
		
		$this->db->select('ti.*, t.*, p.*, tt.ticket_type_discount_type
				, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code
				, s.section_id, s.section_name, s.section_type, s.section_code
				, ekb.ek_barcode, ekb.ek_days_valid, u.username
				, e.event_code, e.event_id, ec.*
				, smb.*
				, te.terminal_code
				, b.branch_city, b.branch_tin, b.branch_address
			');
			
		$this->db->where('ti.ticket_transaction_id', $transaction_id);
		$this->db->where('t.transaction_id IS NOT NULL');
		$this->db->where('smb.sm_prefix IS NOT NULL');
		$this->db->where('smb.sm_code IS NOT NULL');
		$this->db->where_in('ti.ticket_status', $this->paid_status);
		$this->db->where_in('t.transaction_status', $this->paid_status);

		$this->db->join('sm_barcode smb', '(smb.sm_ticket_id = ti.ticket_id AND smb.sm_transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join('ek_barcode ekb', 'ekb.ek_ticket_id = ti.ticket_id', 'left');
		$this->db->join($this->branches, 'b.branch_id = ti.ticket_branch_id', 'left');
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->users, 'u.user_id = ti.ticket_user_id', 'left');
		$this->db->join($this->events, 'e.event_id = ti.ticket_event_id', 'LEFT');
		$this->db->join('events_config ec', 'e.event_id = ec.events_config_eventid', 'LEFT');
		$this->db->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id', 'left');
		$this->db->orderby('ti.ticket_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$this->db->group_by('ti.ticket_id');
		$query = $this->db->get($this->tickets);
		
		
		return $query->result();
	}
	
}
// END transactions_model.php
/* Location: ./application/models/transactions_model.php */		