<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Archive_b_model extends CI_Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';
	var $customers = 'customers c';
	var $terminals = 'terminals te';
	var $prices = 'prices pr';

	var $ticket_types = 'ticket_types tt';
	var $events = 'events ev';
	var $venues = 'venues ve';
	var $promoters = 'promoters pro';
	var $users	=	'users u';
	var $branches = 'branches br';
	var $payments = 'payments pay';
	var $payment_types = 'payment_types pt';

	// added for consolidated reports  BY JAIZON
	var $sections = 'sections sec';
	var $seatplans = 'seatplans sea';
	
	//added for convenience charge report BY KOREWA
	var $charges = 'charges ch';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	
	
	}
	
	
	function get_branch_details($branch_id)
	{
		$this->db_archive_b->select('br.branch_name, te.terminal_code, te.terminal_name');
		$this->db_archive_b->where('branch_id', $branch_id);
		$this->db_archive_b->join($this->users, 'u.user_branch_id = br.branch_id');
		$this->db_archive_b->join($this->terminals, 'te.terminal_id = u.user_terminal_id');
		$query = $this->db_archive_b->get('branches br');
		
		return $query->result();
	}
	
	function get_branches_dropdown_for_cc()
	{
		//$this->db->where('branch_id !=', 40);
		if ($this->session->userdata('user_branch_id') != 1)
		{
			$this->db_archive_b->where('branch_id', $this->session->userdata('user_branch_id'));
		}
		$this->db_archive_b->order_by('branch_name');
		$query = $this->db_archive_b->get($this->branches);
			
		$result = $query->result();
		
		if ($result)
		{
			// add an empty array 
			if ($this->session->userdata('user_branch_id') == 1)
			{
				$array[''] = '';
			}
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->branch_id] = $r->branch_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}

	}
	
	function gbiddos()
	{
		//print_r($this->config->item('online_seller_id'));
		$online_seller_id = $this->config->item('online_seller_id');
		//$branch_id = $this->db->query('select user_branch_id from users where user_id = "$online_seller_id"');
		
		$this->db_archive_b->select('user_branch_id');
		$this->db_archive_b->where('user_id', $online_seller_id);
		$branch_query = $this->db_archive_b->get('users');
					
		return $branch_query->row();	
	}
	
	function new_audit_trail_all($date_to, $date_from, $action = false)
	{
		$get_online_branch_id = $this->archive_b->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db_archive_b->select('date(t.transaction_date) as trans_date, u.user_id, u.user_firstname, u.user_lastname, ev.event_id, ev.event_title, ev.event_reservation_fee, t.transaction_id, t.transaction_date, sec.section_code, tt.ticket_type_name, pr.price_price, ev.event_internet_sales_charge, c.customer_firstname, c.customer_lastname, ti.ticket_id, ti.ticket_user_id, ti.ticket_branch_id, ti.ticket_acknowledgment_receipt, t.transaction_branch_id, t.transaction_receipt_number, t.transaction_status, ti.ticket_status, ti.ticket_reservation_expiry, ti.ticket_date_printed, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_group, br.branch_id, br.branch_name');
		$this->db_archive_b->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db_archive_b->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db_archive_b->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db_archive_b->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db_archive_b->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db_archive_b->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		if ($action == 'online' || $action == 'online_void')
		{
			$this->db_archive_b->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		}
		else 
		{
			$this->db_archive_b->join($this->branches, 'br.branch_id = ti.ticket_branch_id', 'left outer');
		}
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db_archive_b->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db_archive_b->where('(((date(t.transaction_date) >= "' . $date_from . '") AND (date(t.transaction_date) <= "' . $date_to . '")) OR ((date(ti.ticket_date_printed) >="' . $date_from . '") AND (date(ti.ticket_date_printed) <= "' . $date_to . '")))');
		//$this->db->where('pay.payment_amount_type', 'tickets');
		if ($action == false || $action == 'online_void' || $action == 'void')
		{
			//$this->db->where('t.transaction_branch_id !=', $online_branch_id);
			//$this->db->where('ti.ticket_branch_id !=', $online_branch_id);
		}
		else 
		{
			$this->db_archive_b->where('t.transaction_branch_id', $online_branch_id);
		}
		if ($action == 'online_void' || $action == 'void')
		{
			$this->db_archive_b->where('ti.ticket_status in("voided", "cancelled", "reservation_cancelled", "expired")');
		}
		else
		{
			$this->db_archive_b->where('ti.ticket_status in("done", "paid_online", "paid")');
		}
		$this->db_archive_b->order_by('br.branch_id, date(t.transaction_date), t.transaction_user_id, ev.event_id, t.transaction_id, ti.ticket_acknowledgment_receipt, tt.ticket_type_id');
		
		$query = $this->db_archive_b->get('tickets ti');
		
		return $query->result();
	}
		
	function new_audit_trail_per_branch($date_to, $date_from, $branch_id = false)
	{
		$get_online_branch_id = $this->archive_b->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		$this->db_archive_b->select('date(t.transaction_date) as trans_date, u.user_id, u.user_firstname, u.user_lastname, ev.event_id, ev.event_title, ev.event_reservation_fee, t.transaction_id, t.transaction_date, sec.section_code, tt.ticket_type_name, pr.price_price, ev.event_internet_sales_charge, c.customer_firstname, c.customer_lastname, ti.ticket_id, ti.ticket_user_id, ti.ticket_branch_id, ti.ticket_acknowledgment_receipt, t.transaction_branch_id, t.transaction_receipt_number, t.transaction_status, ti.ticket_status, ti.ticket_reservation_expiry, ti.ticket_date_printed, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_group, br.branch_id, br.branch_name');
		$this->db_archive_b->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db_archive_b->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db_archive_b->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db_archive_b->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db_archive_b->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db_archive_b->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db_archive_b->join($this->branches, 'br.branch_id = ti.ticket_branch_id', 'left outer');
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db_archive_b->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db_archive_b->where('(((date(t.transaction_date) >= "' . $date_from . '") AND (date(t.transaction_date) <= "' . $date_to . '")) OR ((date(ti.ticket_date_printed) >="' . $date_from . '") AND (date(ti.ticket_date_printed) <= "' . $date_to . '")))');
		//$this->db->where('pay.payment_amount_type', 'tickets');

		// $this->db->where('t.transaction_branch_id', $online_branch_id);

		$this->db_archive_b->where('ti.ticket_status in("done", "paid_online", "paid")');
		$this->db_archive_b->where('ti.ticket_branch_id', $branch_id);
		

		$this->db_archive_b->order_by('br.branch_id, date(t.transaction_date), t.transaction_user_id, ev.event_id, t.transaction_id, ti.ticket_acknowledgment_receipt, tt.ticket_type_id');
		
		$query = $this->db_archive_b->get('tickets ti');
		
		// echo '<pre>';
		// print_r($query->result());
		// echo '</pre>';
		
		return $query->result();
	}
	
	function con_charge_report($branch_id = false, $date_from = false, $date_to = false)
	{
		$get_online_branch_id = $this->archive_b->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db_archive_b->select('ch.charge_amount, t.transaction_id as temp_ar, COUNT(ti.ticket_id) AS tqty, ev.event_service_charge AS temp_con_charge, ev.event_internet_sales_charge AS total_con_charge, group_concat(ti.ticket_acknowledgment_receipt) as ar_no, t.transaction_receipt_number, t.transaction_status');
		$this->db_archive_b->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db_archive_b->join($this->charges, 'ti.ticket_transaction_id = ch.charge_transaction_id', 'left outer');
		$this->db_archive_b->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db_archive_b->join($this->branches, 't.transaction_branch_id = br.branch_id', 'left outer');
		$this->db_archive_b->where('date(t.transaction_date) >=', $date_from);
		$this->db_archive_b->where('date(t.transaction_date) <=', $date_to);
		if ($branch_id != $online_branch_id)
		{
			$this->db_archive_b->where('ti.ticket_branch_id', $branch_id);
		}
		else 
		{
			$this->db_archive_b->where('t.transaction_branch_id', $branch_id);
		}
		//$this->db->where("(t.transaction_status = 'done' or t.transaction_status = 'paid_online')");
		$this->db_archive_b->where_in('t.transaction_status', array('done','paid_online'));
		$this->db_archive_b->group_by('t.transaction_id');
		$query = $this->db_archive_b->get('transactions t');
		return $query->result();
	}
	
	function ticket_reservation_report($date_from = false, $date_to = false)
	{
		$get_online_branch_id = $this->archive_b->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db_archive_b->select("t.transaction_id as temp_reservation_id, date(t.transaction_date) as temp_reservation_date, c.customer_firstname, c.customer_lastname, c.customer_phone, c.customer_mobile, c.customer_email, u.user_firstname, u.user_lastname, ev.event_title as event_name, sec.section_code as ticket_type_daw, ev.event_date_time, ti.ticket_status as temp_reservation_status, ti.ticket_row, ti.ticket_seat, ev.event_reservation_fee as temp_con_charge, pr.price_price as ti_amt, tt.ticket_type_discount_type, tt.ticket_type_discount, ti.ticket_user_id, t.transaction_user_id, t.transaction_status, t.transaction_branch_id, ti.ticket_branch_id");
		$this->db_archive_b->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db_archive_b->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db_archive_b->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db_archive_b->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db_archive_b->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db_archive_b->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db_archive_b->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		// $this->db->where("(date(t.transaction_date) between '".$date_from."' and '".$date_to."') and (t.transaction_status = 'paid_online')");
		$this->db_archive_b->where("(date(t.transaction_date) between '".$date_from."' and '".$date_to."')");
		$this->db_archive_b->where("date(ti.ticket_reservation_expiry) > '0000-00-00'");
		$this->db_archive_b->group_by('ti.ticket_id');
		$this->db_archive_b->order_by('t.transaction_id, ti.ticket_row, ti.ticket_seat');
		$query = $this->db_archive_b->get('transactions t');
		return $query->result();
	}
	
	// function get_user_details_by_ti_user_id($ticket_user_id = false)
	// {
		// $this->db->select('u.user_firstname, u.user_lastname');
		// $this->db->where('u.user_id', $ticket_user_id);
		// $query = $this->db->get('users u');
		
		// return $query->row();
	// }
	
	function detailed_sales_summary($date_to, $date_from, $branch_id = false)
	{
		$online_seller = 1;
		
		$this->db_archive_b->select('if((date(t.transaction_date) < ti.ticket_date_printed)
							, ti.ticket_date_printed, date(t.transaction_date)) as testdate
							, date(t.transaction_date) as trans_date
							, t.transaction_user_id
							, ti.ticket_event_id
							, t.transaction_id
							, ti.ticket_id
							, t.transaction_date
							, ti.ticket_section_id
							, ti.ticket_price_id
							, t.transaction_customer_id
							, ti.ticket_user_id
							, ti.ticket_branch_id
							, ti.ticket_acknowledgment_receipt
							, t.transaction_branch_id
							, t.transaction_receipt_number
							, t.transaction_status
							, ti.ticket_status
							, ti.ticket_reservation_expiry
							, ti.ticket_date_printed
							, ti.ticket_type_id
							
						');
		$this->db_archive_b->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db_archive_b->where("t.transaction_date >= '$date_from 00:00:00'");
		$this->db_archive_b->where("t.transaction_date <= '$date_to 23:59:59'");
		$this->db_archive_b->where('t.transaction_user_id ', $online_seller);
		$this->db_archive_b->where_in('t.transaction_status', array("done", "paid_online"));
		$this->db_archive_b->where_in('ti.ticket_status', array("done", "paid_online"));
		$query = $this->db_archive_b->get('tickets ti');
		return $query->result();
	}
	
	 function online_transactions($date_from, $date_to, $action = false)
	 {
	 	$online_branch_id = $this->archive_b->gbiddos();
	 	//$this->db->join($this->branches, 'br.branch_id = t.transaction_branch_id', 'left outer');
		if ($action == 'recap')
		{
			$this->db_archive_b->select('t.transaction_id, pt.payment_type_id, pt.payment_type_name, c.customer_firstname, c.customer_lastname, pay.payment_amount, ev.event_internet_sales_charge, ev.event_reservation_fee');
		}
	 	$this->db_archive_b->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db_archive_b->join($this->terminals, 'te.terminal_id = t.transaction_terminal_id', 'left outer');
		$this->db_archive_b->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db_archive_b->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db_archive_b->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db_archive_b->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db_archive_b->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db_archive_b->join($this->sections, 'sec.section_id = pr.price_sections', 'left outer');
		$this->db_archive_b->join($this->payments, 't.transaction_id = pay.payment_transaction_id', 'left outer');
		$this->db_archive_b->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id');
		$this->db_archive_b->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db_archive_b->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db_archive_b->where('t.transaction_branch_id', $online_branch_id->user_branch_id);
		$this->db_archive_b->group_by('t.transaction_id');
		if ($action == 'recap')
		{
			$this->db_archive_b->order_by('pt.payment_type_id', 'asc');
		}
		else
		{
			$this->db_archive_b->order_by('t.transaction_date', 'asc');
		}
		
		
		$query = $this->db_archive_b->get('transactions t');
		return $query->result();		
	}
	
	function count_online_transaction($transaction_id, $transaction_date = false)
	{
		$this->db_archive_b->select('COUNT(ti.ticket_id) as qty');
		$this->db_archive_b->join($this->transactions, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db_archive_b->where('ti.ticket_transaction_id =', $transaction_id);
		if ($transaction_date != '')
		{
			$this->db_archive_b->where('t.transaction_date like', $transaction_date);
		}
		$query = $this->db_archive_b->get('tickets ti');
		return $query->result();
	}
	
	function new_audit_trail($date_to, $date_from, $branch_id = false, $action = false)
	{
		$get_online_branch_id = $this->archive_b->gbiddos();
		$online_branch_id = $get_online_branch_id->user_branch_id;
		
		$this->db_archive_b->select('if((date(t.transaction_date) < ti.ticket_date_printed)
							, ti.ticket_date_printed, date(t.transaction_date)) as testdate
							, date(t.transaction_date) as trans_date
							, t.transaction_user_id
							, ti.ticket_event_id
							, t.transaction_id
							, ti.ticket_id
							, t.transaction_date
							, ti.ticket_section_id
							, ti.ticket_price_id
							, t.transaction_customer_id
							, ti.ticket_user_id
							, ti.ticket_branch_id
							, ti.ticket_acknowledgment_receipt
							, t.transaction_branch_id
							, t.transaction_receipt_number
							, t.transaction_status
							, ti.ticket_status
							, ti.ticket_reservation_expiry
							, ti.ticket_date_printed
							, ch.charge_amount
							, ti.ticket_type_id
							
						');
		$this->db_archive_b->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id', 'left outer');
		$this->db_archive_b->join($this->charges, 'ti.ticket_transaction_id = ch.charge_transaction_id', 'left outer');
		//$this->db->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		//$this->db->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		//$this->db->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		//$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		//$this->db->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		//$this->db->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		//$this->db->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		//$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db_archive_b->where('((date(t.transaction_date) >= "' . $date_from . '"');
		$this->db_archive_b->where('date(t.transaction_date) <= "' . $date_to . '")');
		$this->db_archive_b->or_where('(date(ti.ticket_date_printed) >="' . $date_from . '"');
		$this->db_archive_b->where('date(ti.ticket_date_printed) <= "' . $date_to . '"))');
		//$this->db->where('pay.payment_amount_type', 'tickets');
		if ($action == 'svspb')
		{
			$this->db_archive_b->where('ti.ticket_status in("voided", "cancelled", "expired")');
		}
		elseif ($action == 'dsso')
		{
			$this->db_archive_b->where('ti.ticket_status in("done", "paid_online")');
		}
		else
		{
			$this->db_archive_b->where('ti.ticket_status in("done", "paid_online", "paid")');
		}
		if($branch_id == $online_branch_id)
		{
			$this->db_archive_b->where("((t.transaction_branch_id = $branch_id) OR (ti.ticket_branch_id = $branch_id))");
			$this->db_archive_b->order_by('date(t.transaction_date), t.transaction_user_id, t.transaction_id, ti.ticket_acknowledgment_receipt');
		}
		else
		{
			$this->db_archive_b->where('ti.ticket_branch_id', $branch_id);
			$this->db_archive_b->order_by('date(t.transaction_date), ti.ticket_user_id, t.transaction_id, ti.ticket_acknowledgment_receipt');
		}
		$query = $this->db_archive_b->get('tickets ti');
		
		return $query->result();
	}
		
	function get_branches_dropdown()
	{
		//$this->db->where('branch_id !=', 40);
		$this->db_archive_b->order_by('branch_name');
		$query = $this->db_archive_b->get($this->branches);
			
		$result = $query->result();

		if ($result)
		{
			// add an empty array 
			$array[''] = '';
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->branch_id] = $r->branch_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_events_dropdown()
	{
		$this->db_archive_b->order_by('event_title');
		$query = $this->db_archive_b->get($this->events);
			
		$result = $query->result();

		if ($result)
		{
			// add an empty array 
			$array[''] = '';
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_sellers_dropdown()
	{
		if ($this->session->userdata('user_branch_id') != 1)
		{
			$this->db_archive_b->where('user_branch_id', $this->session->userdata('user_branch_id'));
		}
		$this->db_archive_b->order_by('user_lastname');
		$query = $this->db_archive_b->get($this->users);
			
		$result = $query->result();

		if ($result)
		{
			// add an empty array 
			$array[''] = '';
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->user_id] = $r->user_lastname . ", " . $r->user_firstname;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_events($event_id)
	{
		$this->db_archive_b->where('ev.event_id', $event_id);
		$this->db_archive_b->join($this->venues, 've.venue_id = ev.event_venue_id', 'left');
		$this->db_archive_b->join($this->promoters, 'pro.promoter_id = ev.event_promoter_id', 'left');
		$query = $this->db_archive_b->get($this->events);
		
		return $query->row();
	}	
	 
	function get_users($user_id = false)
	{
		if($user_id)
		{
		$this->db_archive_b->where('u.user_id', $user_id);
		}
		$this->db_archive_b->join($this->branches, 'br.branch_id = u.user_branch_id');
		$this->db_archive_b->join($this->terminals, 'te.terminal_id = u.user_terminal_id');
		$query = $this->db_archive_b->get($this->users);
		
		return $query->row();
	}
	
	function get_branch($branch_id)
	{
		$this->db_archive_b->where('branch_id', $branch_id);
		$this->db_archive_b->join($this->users, 'u.user_branch_id = br.branch_id');
		$this->db_archive_b->join($this->terminals, 'te.terminal_id = u.user_terminal_id');
		$query = $this->db_archive_b->get($this->branches);
		
		return $query->row();
	}
	
	function get_terminal_details($branch_id, $termid)
	{
		$this->db_archive_b->where('terminal_id', $termid);
		$query = $this->db_archive_b->get($this->terminals);
		
		return $query->row();
	}

	function onlineclaimed_transactions($date_from, $date_to, $eventid, $branchid, $seller)
	{
		//$online_branch_id = $this->reports->gbiddos();
		$this->db_archive_b->select('ev.event_title, ev.event_code, ev.event_internet_sales_charge, t.transaction_id, ti.ticket_transaction_id, c.customer_firstname, c.customer_lastname, tt.ticket_type_name');
		$this->db_archive_b->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db_archive_b->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db_archive_b->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db_archive_b->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db_archive_b->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db_archive_b->where('ti.ticket_date_printed >=', $date_from);
		$this->db_archive_b->where('ti.ticket_date_printed <=', $date_to);
		$this->db_archive_b->where('t.transaction_user_id', '1');
		$this->db_archive_b->where('t.transaction_status', 'done');
		if (!empty($eventid))
		{
			$this->db_archive_b->where('ev.event_id', $eventid);
		}
		if ($this->session->userdata('user_branch_id') == 1)
		{
			if (!empty($branchid))
			{
				$this->db_archive_b->where('ti.ticket_branch_id', $branchid);
			}
		}
		else
		{
			$this->db_archive_b->where('ti.ticket_branch_id', $this->session->userdata('user_branch_id'));
		}
		if (!empty($seller))
		{
			$this->db_archive_b->where('ti.ticket_user_id', $seller);
		}
		
		$this->db_archive_b->group_by('t.transaction_id'); 
		
		$query = $this->db_archive_b->get('transactions t');
		return $query->result();
	}
	
	function total_transaction($date_from, $date_to, $eventid, $branchid, $seller)
	{
		$this->db_archive_b->select('COUNT(t.transaction_id) as total_trasaction');
		$this->db_archive_b->join($this->users, 'u.user_id = t.transaction_user_id', 'left');
		$this->db_archive_b->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left');
		$this->db_archive_b->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left');
		$this->db_archive_b->where('t.transaction_date >=', $date_from.' 00:00:01');
		$this->db_archive_b->where('t.transaction_date <=', $date_to.' 23:59:59');
		$this->db_archive_b->where('t.transaction_user_id', '1');
		$this->db_archive_b->where('t.transaction_status', 'done');
		if (!empty($eventid))
		{
			$this->db_archive_b->where('ev.event_id', $eventid);
		}
		if ($this->session->userdata('user_branch_id') == 1)
		{
			if (!empty($branchid))
			{
				$this->db_archive_b->where('ti.ticket_branch_id', $branchid);
			}
		}
		else
		{
			$this->db_archive_b->where('ti.ticket_branch_id', $this->session->userdata('user_branch_id'));
		}
		if (!empty($seller))
		{
			$this->db_archive_b->where('ti.ticket_user_id', $seller);
		}	
		$this->db_archive_b->group_by('t.transaction_id'); 
		
		$query = $this->db_archive_b->get('transactions t');
		return $query->num_rows();
	}
	
	
	function get_users_by_branch_otc($branch_id)
	{
		$this->db_archive_b->where('user_branch_id', $branch_id);
		$this->db_archive_b->order_by('user_firstname');
		$query = $this->db_archive_b->get($this->users);
		$result = $query->result();
		if ($result)
		{
			$array[''] = '';
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->user_id] = $r->user_firstname.' '.$r->user_lastname;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_events_dropdown_for_otc()
	{
		//$this->db->where('branch_id !=', 40);
		$this->db_archive_b->order_by('event_title');
		$query = $this->db_archive_b->get($this->events);
			
		$result = $query->result();

		if ($result)
		{
			// add an empty array 
			$array[''] = '';
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_event_title()
	{
		$this->db_archive_b->order_by('event_date_time', 'desc');
		$query = $this->db_archive_b->get($this->events);
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_users_by_branch()
	{
		if ($this->session->userdata('user_branch_id') != 1)
		{
			$this->db_archive_b->where('user_branch_id', $this->session->userdata('user_branch_id'));
		}
		
		$this->db_archive_b->order_by('user_firstname');
		$query = $this->db_archive_b->get($this->users);
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->user_id] = $r->user_firstname.' '.$r->user_lastname;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}

	function no_of_tickets2($event_id, $seller_id = false, $status, $seller_id = false, $reports_date)
	{
		switch($status)
		{
			case 'ALL':	{	$this->db_archive_b->select('count(distinct(t.transaction_id)) as no_of_tickets');	break;}
			case 'VOID':	{	$this->db_archive_b->select('count(ti.ticket_id) as no_of_tickets');	break;}
		}
	 	
		$this->db_archive_b->join($this->events, 'ev.event_id = ti.ticket_event_id');
		$this->db_archive_b->join($this->transactions, 't.transaction_id = ti.ticket_transaction_id');
		$this->db_archive_b->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id');
		$this->db_archive_b->where_in('ev.event_id ', $event_id);
		if($seller_id)
		{
			$this->db_archive_b->where('t.transaction_user_id ', $seller_id);
			$this->db_archive_b->where('t.transaction_date >=', $reports_date.' 00:00:01');
		}
		else if(!$seller_id)
		{
			$this->db_archive_b->where('tt.ticket_type_group < 1');
		}
		$this->db_archive_b->where('t.transaction_date <=', $reports_date.' 23:59:59');
		
		switch($status)
		{
			case 'ALL': {
					 $this->db_archive_b->where('t.transaction_status', 'done');
					 break;}
			case 'VOID': { $this->db_archive_b->where('ti.ticket_status', 'voided'); break;}
			//case 'CANCEL': { $this->db->where('t.transaction_status', 'cancelled'); break;}
		}
		
		$query = $this->db_archive_b->get('tickets ti');
		return $query->row();		
	}

	function sales_transactions($date_from, $date_to)
	 {
		$this->db_archive_b->select("t.transaction_id as temp_reservation_id, date(t.transaction_date) as temp_reservation_date
							, ti.ticket_acknowledgment_receipt, ti.ticket_status, c.customer_firstname
							, c.customer_lastname, c.customer_phone, c.customer_mobile, te.terminal_id, u.user_firstname
							, u.user_lastname, ev.event_title as event_name, sec.section_code as ticket_type_daw
							, ev.event_date_time, ti.ticket_status as temp_reservation_status, ti.ticket_row, ti.ticket_seat
							, ti.ticket_id, ev.event_service_charge as temp_con_charge, pr.price_price as ti_amt
							, tt.ticket_type_discount_type, tt.ticket_type_discount, ti.ticket_user_id
							, t.transaction_user_id, t.transaction_branch_id, pt.payment_type_type, ev.event_reservation_fee
							, ev.event_internet_sales_charge, ev.event_reservation_fee, ev.event_service_charge
							, ti.ticket_reservation_expiry, t.transaction_date");
		$this->db_archive_b->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left outer');
		$this->db_archive_b->join($this->users, 'u.user_id = t.transaction_user_id', 'left outer');
		$this->db_archive_b->join($this->tickets, 'ti.ticket_transaction_id = t.transaction_id', 'left outer');
		$this->db_archive_b->join($this->events, 'ev.event_id = ti.ticket_event_id', 'left outer');
		$this->db_archive_b->join($this->sections, 'sec.section_id = ti.ticket_section_id', 'left outer');
		$this->db_archive_b->join($this->prices, 'pr.price_id = ti.ticket_price_id', 'left outer');
		$this->db_archive_b->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left outer');
		$this->db_archive_b->join($this->terminals, 'te.terminal_id = ti.ticket_terminal_id', 'left outer');
		$this->db_archive_b->join($this->payments, 'pay.payment_transaction_id = t.transaction_id', 'left outer');
		$this->db_archive_b->join($this->payment_types, 'pt.payment_type_id = pay.payment_payment_type_id', 'left outer');
		$this->db_archive_b->where('date(t.transaction_date) >=', $date_from);
		$this->db_archive_b->where('date(t.transaction_date) <=', $date_to);
		$statuslist = array('selected', 'voided', 'expired', 'reservation_cancelled', 'unselected', 'reserved');
		$this->db_archive_b->where_not_in('t.transaction_status', $statuslist );
		$this->db_archive_b->where_not_in('ti.ticket_status', $statuslist );
		//$this->db->where('date(t.transaction_date) <=', $date_to);
		$this->db_archive_b->group_by('ti.ticket_id');
		$this->db_archive_b->order_by('t.transaction_date, t.transaction_id, ti.ticket_acknowledgment_receipt', 'asc');
		$query = $this->db_archive_b->get('transactions t');
		return $query->result();
	}
	
	function count_sales_transaction($ticket_id)
	{
		$this->db_archive_b->select('COUNT(ticket_id) as qty');
		$this->db_archive_b->where('ticket_id =', $ticket_id);

		$query = $this->db_archive_b->get('tickets');
		return $query->result();
	}
	
	function get_report_details(){
	
		$event_id = $this->input->post('event_id');
		$this->db_archive_b->select('event_id,event_long_title as event_name');
		$this->db_archive_b->where('event_id', $event_id);
		$query = $this->db_archive_b->get('events');
		
		return $query->row();
	
	}
	
	
	function get_unredeemed_list(){
	
		$event_id = $this->input->post('event_id');	
		$query = $this->db_archive_b->query("
		
		SELECT 
		tr.transaction_id
		,CONCAT(cu.customer_firstname, ' ', cu.customer_lastname) AS customer
		,cu.customer_email
		,cu.customer_mobile
		,CONCAT(se.section_name,' ',GROUP_CONCAT( DISTINCT(ti.ticket_row), '', ti.ticket_seat,' ' SEPARATOR ' / ' )) as sec_row_seat
		,COUNT(ti.ticket_id) AS ticket_quantity
		,SUM(pr.price_price) as total_amount
		,tr.transaction_date
	
	
		FROM transactions tr
		INNER JOIN tickets ti ON ti.ticket_transaction_id = tr.transaction_id
		INNER JOIN customers cu ON cu.customer_id = tr.transaction_customer_id
		INNER JOIN sections se ON se.section_id = ti.ticket_section_id 
		INNER JOIN prices pr ON pr.price_id = ti.ticket_price_id
			
		WHERE ti.ticket_event_id = ". $event_id ."
		AND ti.ticket_transaction_id != 0 
		AND tr.transaction_status in('paid_online')
		GROUP BY tr.transaction_id
		
		");
		
		return $query->result();
	
	
	}
	 
 
	
	
}	
// END reports_model.php
/* Location: ./application/models/reports_model.php */		
