<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Archive_a_model extends CI_Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';
	var $customers = 'customers c';
	var $terminals = 'terminals te';
	var $prices = 'prices pr';

	var $ticket_types = 'ticket_types tt';
	var $events = 'events ev';
	var $venues = 'venues ve';
	var $promoters = 'promoters pro';
	var $users	=	'users u';
	var $branches = 'branches br';
	var $payments = 'payments pay';
	var $payment_types = 'payment_types pt';

	// added for consolidated reports  BY JAIZON
	var $sections = 'sections sec';
	var $seatplans = 'seatplans sea';
	
	//added for convenience charge report BY KOREWA
	var $charges = 'charges ch';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
		
	}
	
	function get_event_title()
	{
		$this->db_archive_a->order_by('event_date_time', 'desc');
		$query = $this->db_archive_a->get($this->events);
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->event_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}

	function get_users_by_branch()
	{
		if ($this->session->userdata('user_branch_id') != 1)
		{
			$this->db_archive_a->where('user_branch_id', $this->session->userdata('user_branch_id'));
		}
		
		$this->db_archive_a->order_by('user_firstname');
		$query = $this->db_archive_a->get($this->users);
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->user_id] = $r->user_firstname.' '.$r->user_lastname;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}

	function get_users($user_id = false)
	{
		if($user_id)
		{
		$this->db->where('u.user_id', $user_id);
		}
		$this->db->join($this->branches, 'br.branch_id = u.user_branch_id');
		$this->db->join($this->terminals, 'te.terminal_id = u.user_terminal_id');
		$query = $this->db->get($this->users);
		
		return $query->row();
	}
		
		
	
	
	
}	
// END reports_model.php
/* Location: ./application/models/reports_model.php */		