<?php

class Video extends CI_Controller
 {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('poster_model', 'poster');
		$this->load->model('ad_model', 'ad');
		$this->load->model('files_model', 'files');
		$this->load->model('logs_model', 'logs');
		$this->load->model('video_model', 'video');
		$this->load->model('events_model', 'events');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('video/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// prepare data for the template
		$data['page_title'] = 'Event Video';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['video'] = $this->video->get_video();
		
		$this->load->view('video_listing', $data);
	}
	
	function video_active()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// prepare data for the template
		$data['page_title'] = 'Event Video';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['video'] = $this->video->get_video_active();
		
		$this->load->view('video_listing', $data);
	}
	
	function video_inactive()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// prepare data for the template
		$data['page_title'] = 'Video';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['video'] = $this->video->get_video_inactive();
		
		$this->load->view('video_listing', $data);
	}
	// --------------------------------------------------------------------
	
	/**
	 * upload
	 *
	 * @access	public
	 */
	function embed()
	{
		// prepare data for the template
		$data['page_title'] = 'Embed Video';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'video_name',
				'label'   => 'Video Name',
				'rules'   => 'trim|required|strip_tags|callback__video_name_check'
			),
			array(
				'field'   => 'event_id',
				'label'   => 'Event Name',
				'rules'   => 'trim|required|strip_tags|min_length[1]|max_length[10]'
			),
			array(
				'field'   => 'video_url',
				'label'   => 'Video URL',
				'rules'   => 'trim|required|max_length[500]'
			),	
		);

		$data['event_names'] = $this->events->get_active_events_dropdown();	
		// $data['event'] = $this->events->get_active_events_dropdown();	
		$data['event'] = $this->events->get();
		
		$data['video'] = $this->video->get_video();
			
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('video_embed', $data);
		}
		else
		{
		$this->video->embed();
		$this->session->set_flashdata('message', assemble_message('Video link has been successfully added'));
		redirect('video/video_active');
		}
			
		
	}
		
		
		
	function _video_name_check($str)
	{	
		$video_name_exists = $this->video->check_existing_video_name($str);
		if ($video_name_exists)
		{
			$this->form_validation->set_message('_video_name_check', "Video name $str already exist");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
		
		
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($video_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Video');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->video->delete($video_id);
		$this->session->set_flashdata('message', assemble_message('Video has been successfully deleted'));
		redirect('events/edit/');
	}	
	
	function active($video_id = FALSE)
	{
		// log this
		$this->logs->add('Video Active');
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->video->active($video_id);
		$this->session->set_flashdata('message', assemble_message('Video has been successfully activated'));
		redirect('events/edit/');
	}
	
	/**
	 * inactive
	 *
	 * @access	public
	 */
	function inactive($video_id = FALSE)
	{
		// log this
		$this->logs->add('Video Inactive');
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->video->inactive($video_id);
		$this->session->set_flashdata('message', assemble_message('Video has been successfully deactivated'));
		redirect('events/edit/');
	}
	
}

/* End of file logos.php */
/* Location: ./application/controllers/logos.php */	



