<?php

class Tickets extends CI_Controller {

    public function __construct()
	{
		parent::__construct();
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('events_model', 'events');
		$this->load->model('ticket_layouts_model', 'ticket_layouts');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('prices_model', 'prices');
		$this->load->model('configurations_model', 'configurations');
		$this->load->model('branches_model', 'branches');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payments_model', 'payments');
		$this->load->model('sections_model', 'sections');
		$this->load->model('extension_model', 'extension');
		$this->load->model('printout_model', 'printout');
		$this->load->database('default');
    }

	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('tickets/listing');
	}
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		$this->load->library('pagination');
		
		// constants
		$limit = $this->pagination->per_page;
		$limit = 20;
		$offset = $this->uri->segment(3);
		
		// prepare data for the template
		$data = $_POST;
		$data['page_title'] = 'Tickets';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance','Manager'));
		
		$searchItems = array();
		$hasSearch = false;
		if (@issetNE($_POST['search_item']))
		{
			$searchItems[$_POST['search_item']] = @issetVal($_POST['search_value'],false);
			$data['has_search'] = $hasSearch = true;
		}
		
		$data['tickets'] = $this->tickets->get_all_tickets($offset, $limit, $searchItems);
		
		// pagination
		$config['base_url'] = site_url('tickets/listing');
		// $config['total_rows'] = $this->tickets->get_ticket_count();//sizeof( $this->tickets->get_all_tickets(false, false, $searchItems) ); 	
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		// if ($hasSearch)
		// {
			// $data['total_search_results'] = $config['total_rows'];			
		// }
		
		$this->benchmark->mark('query_end');
		$this->load->view('tickets_listing', $data);
		$this->benchmark->mark('page_end');

		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);	
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * select_seat
	 *
	 * @access	public
	 */
	function select_seat($event_id = false, $section_id = false, $row = false, $seat = false)
	{
		// check parameters
		if (!$section_id or !$event_id or !$row or !$seat) show_404();
		
		// log this
		$this->logs->add('Select Seat');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager', 'Promoter','Reservation','Reservation-Admin'));
		
		// get row
		preg_match("/^(seat\[R)(.*)(\]\[\])$/", $row, $matches);
		$system_row = $matches[2];
		
		$this->tickets->select_ticket($event_id, $section_id, $system_row, $seat);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * unselect_seat
	 *
	 * @access	public
	 */
	function unselect_seat($event_id = false, $section_id = false, $row = false, $seat = false)
	{
		// check parameters
		if (!$section_id or !$event_id or !$row or !$seat) show_404();
		
		// log this
		$this->logs->add('Unselect Seat');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager', 'Promoter','Reservation','Reservation-Admin'));
		
		// get row
		preg_match("/^(seat\[R)(.*)(\]\[\])$/", $row, $matches);
		$system_row = $matches[2];
		
		$this->tickets->unselect_ticket($event_id, $section_id, $system_row, $seat);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * void
	 *
	 * @access	public
	 */
	function void($ticket_id = false, $offset = false)
	{	
		// check parameters
		if (!$ticket_id or !$offset) show_404();
		
		// log this
		$this->logs->add('Void Ticket');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));

		// void the ticket		
		list($section_id, $ticket_count) = $this->tickets->void_ticket($ticket_id);
		
		// update available tickets
		if ($section_id != 0)
		{
			$this->sections->update_available($section_id, 'increase', $ticket_count);
		}
		
		// redirect
		$this->session->set_flashdata('message', assemble_message('Ticket has been voided and ticket count has been adjusted.'));
		redirect('tickets/listing/' . $offset);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * desktop_printer
	 *
	 * @access	public
	 */
	function desktop_printer()
	{
		$data['page_title'] = 'New Ticket Printer';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		$this->load->view('tickets_desktop_printer', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * output
	 *
	 * @access	public
	 */
    function output($transaction_id = false)
    {
		$this->logs->add('Print Ticket');
		
		if ($transaction_id and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/'.md5($transaction_id).'.pdf'))
		{
			// mark transaction and tickets as done
			$this->transactions->transaction_done($transaction_id);
		
			// call the desktop application
			header('Location: smtickets:'.$_SERVER["HTTP_HOST"].'/uploads/'.md5($transaction_id));
		}
		exit;
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * output
	 *
	 * @access	public
	 */
    function output_single($ticket_id = false, $barcode = false)
    {
		if (!$ticket_id and !$barcode) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'Print Ticket';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$ticket = $this->tickets->get($ticket_id);
		
		if ($ticket->ticket_barcode != $barcode) show_404();
		
		// check if ticket has not been printed
		if ($ticket->ticket_status != 'done')
		{
			// generate the ticket then save it to the server
			$this->tickets->generate_single($ticket_id);
			
			// fetch the ticket from the server then print
			if ($ticket_id and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/'.md5($ticket_id).'.pdf'))
			{
				// mark the ticket as done
				$this->tickets->ticket_done($ticket_id);
	
				// body onload
				$data['onload'] =  'onLoad="window.location=\'smtickets:'.$_SERVER["HTTP_HOST"].'/uploads/'.md5($ticket_id).'\'"';
				
				// display the page
				$this->load->view('tickets_output_single', $data);
			
				// call the desktop application
				//header('Location: smtickets:'.$_SERVER["HTTP_HOST"].'/uploads/'.md5($ticket_id));
			}
		}
		else
		{
			redirect('');
		}
		//exit;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * output_all
	 *
	 * @access	public
	 */
    function output_all($transaction_id = false, $barcode = false)
    {
		if (!$transaction_id and !$barcode) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'Print Ticket';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		$transaction = $this->transactions->get($transaction_id);
		
		if ($transaction->transaction_barcode != $barcode) show_404();
		
		// check if tickets have not been printed
		if ($transaction->transaction_status != 'done')
		{
			// generate the tickets then save them to the server
			$this->tickets->generate($transaction_id, 'paid_online');
			
			// fetch the tickets from the server then print
			if ($transaction_id and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/'.md5($transaction_id).'.pdf'))
			{
				// mark transaction and tickets as done
				$this->transactions->transaction_done($transaction_id);
				$postrequest = @$this->extension->post2mci($transaction_id);

				// body onload
				$data['onload'] =  'onLoad="window.location=\'smtickets:'.$_SERVER["HTTP_HOST"].'/uploads/'.md5($transaction_id).'\'"';
				
				// display the page
				$this->load->view('tickets_output_all', $data);
				
				// call the desktop application
				//header('Location: smtickets:'.$_SERVER["HTTP_HOST"].'/uploads/'.md5($transaction_id));
			}
		}
		else
		{
			redirect('');
		}
		//exit;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete_pdf
	 *
	 * @access	public
	 */
    function delete_pdf($id = false)
    {
		$this->logs->add('Delete PDF');
		if ($id) {
			if (file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/'.$id.'.pdf'))
			{
				unlink($_SERVER["DOCUMENT_ROOT"] . '/uploads/'.$id.'.pdf');
			} else {
				// mark the transaction and tickets as Done
				$uid = $this->printout->transaction_done($id);
				
				if ($uid == $this->config->item('online_seller_id')) {
					// check if this is an online transaction
					$postrequest = @$this->extension->post2mci(id);
				}
			}
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * generate
	 *
	 * @access	public
	 */
    function generate($transaction_id, $type = false, $event_id = false)
    {
		// log this
		$this->logs->add('Print Ticket');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager', 'Promoter','Reservation','Reservation-Admin'));
		
		$in = 72; // inch
		$right_panel_width = 2.5 * $in;
		$right_text_height = 80;
		$left_panel_width = 1.5 * $in;
		$line_top_margin = 29; // start of lines
		$line_text_margin = 0;
		$logo_height = 20;
		$logo_width = 0;
		$logo_count = 0;
		$logo_margin = 5;
		$text_margin = 2;
		$left_container_width = 88;
		$left_text_margin = 1;
		
		if ($transaction_id == '') show_404();
		
		if ($type == 'preview')
		{
			// get ticket layout
			$ticket_layout = $this->ticket_layouts->get($event_id);
			
			// sample ticket info
			$preview_prices = $this->prices->get_prices($event_id);
			// print_r($preview_prices);
			$preview_events = $this->events->get($event_id);

			$preview_priceprice = 5000;
			$preview_sectionname = 'PATRON VIP';
			$preview_row = "R";
			$preview_seat = "8";

				if (is_array($preview_prices)) {
				$preview_sectionname = $preview_prices[0]->price_name;
				$preview_priceprice = $preview_prices[0]->price_price;
				$preview_pricesections = $preview_prices[0]->price_sections;
				
				if(is_object($preview_events)) {
					$preview_sections = $this->sections->get_sections($preview_events->event_seatplan_id);
					// echo $preview_pricesections; print_r($preview_sections);
					foreach($preview_sections as $ps) {
						if(strpos($preview_pricesections,"\"$ps->section_id\"")>0) {
							$preview_sectionname = $ps->section_name;
							$preview_sectiontype = $ps->section_type;
							$preview_sectionseatconfig = $ps->section_seat_config;
							break;
						}
					}
					if ($preview_sectionseatconfig == "") {
						$preview_row = "";
						$preview_seat = $preview_sectiontype;
					} else {
						/*
						$preview_seatconfig = array_search("|",unserialize($preview_sectionseatconfig));
						print_r($preview_seatconfig);
						*/
						$preview_row = "R";
						$preview_seat = "8";
					}
					// print_r(unserialize($preview_sections[0]->section_seat_config));
					
				}
				
			}
			$tickets = array(
				array(
					'ticket_id' => 1,
					'section_name' => $preview_sectionname,
					'ticket_row' => $preview_row,
					'ticket_seat' => $preview_seat,
					'ticket_type_code' => 'RP/CASH',
					'ticket_type_discount_type' => 'Percentage',
					// 'price_price' => 5000,
					'price_price' => $preview_priceprice,
					'ticket_type_discount' => 0,
					'transaction_date' => date("Y-m-d H:i:s"),
				)
			);
			$tickets = array_to_object($tickets);
			
			// get event info
			$event = $this->events->get($event_id);
			
			// sample transaction
			$transaction = array(
				'transaction_id' => 1,
				'transaction_date' => date("Y-m-d H:i:s"),
				'terminal_code' => 'MOAT1',
				'transaction_cash_payment' => 1000,
				'transaction_card_payment' => 0,
				'transaction_gc_sm_payment' => 0,
				'transaction_gc_sodeho_payment' => 0,
				'transaction_mc_payment' => 0,
				'transaction_other_payment' => 0,
			);
			$transaction = array_to_object($transaction);
			
			// sample branch
			$branch = array(
				'branch_city' => 'Pasay City',
				'branch_tin' => '123-456-789-0000',
			);
			$branch = array_to_object($branch);
		}
		
		else
		{
			// get transaction
			$transaction = $this->transactions->get($transaction_id);
			
			// check if tickets have already been printed
			if ($transaction->transaction_status == 'done')
			{
				// redirect
				//$this->session->set_flashdata('message', assemble_message('Tickets have already been printed.'));
				//redirect('transactions/done/'.$transaction_id);
				
				die('Tickets have already beeen printed.');
				
			}
				
			// get tickets
			$tickets = $this->tickets->get_tickets_by_transaction($transaction_id, $this->session->userdata('cpi'), 'paid');

			if (count($tickets) == 0)
			{
				die('No ticket to print.  Please close this window and redo the transaction.');
			}
			
			// get event info
			$event = $this->events->get($tickets[0]->ticket_event_id);
			
			// get ticket layout
			$ticket_layout = $this->ticket_layouts->get($tickets[0]->ticket_event_id);
			
			// get branch info
			$branch = $this->branches->get($transaction->transaction_branch_id);
		}
		
		//print_array($ticket_layout);
		//print_array($event);
		//print_array($tickets);
		//print_array($transaction);
		//print_array($branch);
		//exit;
		
		// get payment type
		//$pay_type = array();
		//$payment_type = (count($payments) > 1) ? 'Multi' : $payments[0]->payment_type_name;
		
		$payments = $this->payments->get_payments($transaction_id);
		if (count($payments) == 0)
		{
			$payment_type = 'CASH';
		}
		else
		{
			$payment_type = (count($payments) > 1) ? 'Multi' : $payments[0]->payment_type_name;
		}
			
		if ($ticket_layout->logo1 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo1))
		{
			$logo1 = getimagesize('uploads/'.$ticket_layout->logo1);
 			$logo1_width = floor($logo1[0]*$logo_height/$logo1[1]);
			$logo_width += $logo1_width + $logo_margin;
		}
		
		if ($ticket_layout->logo2 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo2))
		{
			$logo2 = getimagesize('uploads/'.$ticket_layout->logo2);
			$logo2_width = floor($logo2[0]*$logo_height/$logo2[1]);
			$logo_width += $logo2_width + $logo_margin;
		}
		
		if ($ticket_layout->logo3 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo3))
		{
			$logo3 = getimagesize('uploads/'.$ticket_layout->logo3);
			$logo3_width = floor($logo3[0]*$logo_height/$logo3[1]);
			$logo_width += $logo3_width + $logo_margin;
		}
		
		if ($ticket_layout->logo4 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo4))
		{
			$logo4 = getimagesize('uploads/'.$ticket_layout->logo4);
			$logo4_width = floor($logo4[0]*$logo_height/$logo4[1]);
			$logo_width += $logo4_width + $logo_margin;
		}
		
		if ($ticket_layout->logo5 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo5))
		{
			$logo5 = getimagesize('uploads/'.$ticket_layout->logo5);
			$logo5_width = floor($logo5[0]*$logo_height/$logo5[1]);
			$logo_width += $logo5_width + $logo_margin;
		}
		$logo_left_margin = floor(($right_panel_width - $logo_width)/2);
		$logo_left_margin = ($logo_left_margin > 0) ? $logo_left_margin : 0;
		$logo_left_margin += $left_panel_width;	
		
		// include pdf libraries
		require(BASEPATH.'application/libraries/tfpdf/tfpdf.php');
		
        $pdf = new tFPDF('L', 'pt', array($in * 4, $in * 2));
		$pdf->AddFont('Arial','','arial.ttf',true);
		$pdf->AddFont('Arial','B','arialbd.ttf',true);
		$pdf->AddFont('Courier','','cour.ttf',true);
		$pdf->AddFont('Courier','B','courbd.ttf',true);
		$pdf->AddFont('Times','','times.ttf',true);
		$pdf->AddFont('Times','B','timesbd.ttf',true);
		
		$pdf->SetDrawColor(207, 207, 207);

		$count = 0;
		foreach ($tickets as $ticket)
		{
			if ($type == 'preview')
			{
				$receipt_number = '000001';
			}
			else
			{
				if ($ticket->ticket_acknowledgment_receipt > 0)
				{
					$receipt_number = $ticket->ticket_acknowledgment_receipt;
				}
				else
				{
					if ($ticket->ticket_type_discount_type == 'Percentage' and $ticket->ticket_type_discount == 100)
					{
						$receipt_number = 'COMPLIMENTARY';
					}
					else
					{
						// get receipt number
						$receipt_number = $this->configurations->get_last_receipt_number();
						
						// update transactions table
						$this->tickets->update_acknowledgment_receipt($ticket->ticket_id, $receipt_number);
					}
				}
			}
			
			$pdf->AddPage();
			$pdf->SetAutoPageBreak('Auto', 0);
			
			// background image
			if ($type == 'preview')
			{
				$pdf->Image(BASEPATH.'application/views/images/ticket_bg.jpg', 0, 0, $in * 4, 0);
				$serial_number = '00001';
			}
			else
			{
				// get section serial number
				$serial_number = $this->prices->get_serial_number($this->session->userdata('cpi'));
			}
			
			
			// left pane
			
			$left_top = 42 + $in * 2 * $count;
			$left = 11;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'EVENT', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 10;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, strtoupper($event->event_code), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'SECTION', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 4; $left_top -= 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, '#'.sprintf('%05s', $ticket->ticket_id), 0, 0, 'R');
			$left_top += $size + $left_text_margin;

			$size = 8;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$pdf->Cell($left_container_width, $size, strtoupper($ticket->section_name), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'ROW - SEAT', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 4; $left_top -= 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, sprintf('%05s', $serial_number), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 8;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$ticket_row = ($ticket->ticket_row) ? $ticket->ticket_row . ' - ' : '';
			$pdf->Cell($left_container_width, $size, strtoupper($ticket_row . $ticket->ticket_seat), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'TICKET PRICE', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
		
			$size = 5; $left_top -= 6;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$text = strtoupper($ticket->ticket_type_code);
			$text .= ($payment_type) ? '/' . strtoupper($payment_type) : '';
			$pdf->Cell($left_container_width, $size, $text , 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			if ($ticket->ticket_type_discount_type == 'Amount')
			{
				$ticket_price = ceil($ticket->price_price - $ticket->ticket_type_discount);
			}
            elseif ($ticket->ticket_type_discount_type == 'Percentage')
			{
            	$ticket_price= ceil($ticket->price_price - (($ticket->price_price * $ticket->ticket_type_discount)/100));
			}
			
			$size = 8;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'Php **' . number_format($ticket_price) . '**', 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			if ($receipt_number != 'COMPLIMENTARY')
				$pdf->Cell($left_container_width, $size, 'AR No.', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 5; $left_top -= 6;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$text = '   TN: ' . sprintf('%05s', $transaction->transaction_id);
			$pdf->Cell($left_container_width, $size, $text , 0, 0, 'R');
			$left_top += $size + $left_text_margin;

			$size = 8;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, sprintf('%07s', $receipt_number), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4; $left_top += 2;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, mysqldatetime_to_date($ticket->transaction_date, $format = "m-d-Y"), 0, 0, 'L');
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, $transaction->terminal_code, 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, mysqldatetime_to_date($ticket->transaction_date, $format = "h:i:sA"), 0, 0, 'L');
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, strtoupper($this->session->userdata('username')), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			// right pane
			
			// reset the left margin
			$left_margin = $logo_left_margin;
			
			if ($ticket_layout->logo1 and isset($logo1))
			{
				$pdf->Image('uploads/'.$ticket_layout->logo1, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
				$left_margin += $logo1_width + $logo_margin;
			}
			
			if ($ticket_layout->logo2 and isset($logo2))
			{
				$pdf->Image('uploads/'.$ticket_layout->logo2, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
				$left_margin += $logo2_width + $logo_margin;
			}
			
			if ($ticket_layout->logo3 and isset($logo3))
			{	
				$pdf->Image('uploads/'.$ticket_layout->logo3, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
				$left_margin += $logo3_width + $logo_margin;
			}
			
			if ($ticket_layout->logo4 and isset($logo4))
			{	
				$pdf->Image('uploads/'.$ticket_layout->logo4, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
				$left_margin += $logo4_width + $logo_margin;
			}
			
			if ($ticket_layout->logo5 and isset($logo5))
			{	
				$pdf->Image('uploads/'.$ticket_layout->logo5, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
			}
			
			// reset the top margin
			$top = $line_top_margin;
			
			// line 1
			//if ($ticket_layout->ticket_text_1)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_1, '', $ticket_layout->ticket_font_size_1);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_1, $ticket_layout->ticket_text_1, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_1 + $text_margin;
			//}
			
			// line 2
			//if ($ticket_layout->ticket_text_2)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_2, '', $ticket_layout->ticket_font_size_2);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_2, $ticket_layout->ticket_text_2, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_2 + $text_margin;
			//}
			
			// line 3
			//if ($ticket_layout->ticket_text_3)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_3, 'B', $ticket_layout->ticket_font_size_3);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_3, $ticket_layout->ticket_text_3, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_3 + $text_margin;
			//}
			
			// line 4
			//if ($ticket_layout->ticket_text_4)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_4, 'B', $ticket_layout->ticket_font_size_4);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_4, $ticket_layout->ticket_text_4, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_4 + $text_margin;
			//}
			
			// line 5
			//if ($ticket_layout->ticket_text_5)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_5, '', $ticket_layout->ticket_font_size_5);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_5, $ticket_layout->ticket_text_5, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_5 + $text_margin;
			//}
			
			// line 6
			//if ($ticket_layout->ticket_text_6)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_6, '', $ticket_layout->ticket_font_size_6);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_6, $ticket_layout->ticket_text_6, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_6 + $text_margin;
			//}

			// line 7
			if ($ticket_layout->ticket_text_7)
			{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_7, '', $ticket_layout->ticket_font_size_7);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_7, $ticket_layout->ticket_text_7, 0, 0, 'C');
			}

			
			// section
			$pdf->SetXY(113, 90 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell($in * 2.5, 4, 'SECTION', 0, 0, 'L');
			
			$pdf->SetXY(113, 95 + $in * 2 * $count); 
			$pdf->SetFont('Arial', 'B', 8);
			$pdf->Cell($in * 2.5, 8, strtoupper($ticket->section_name), 0, 0, 'L');
			
			// row - seat
			$pdf->SetXY(113, 106 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell(50, 4, 'ROW - SEAT', 0, 0, 'L');
			
			$pdf->SetXY(113, 110 + $in * 2 * $count); 
			$pdf->SetFont('Arial', 'B', 8);
			$ticket_row = ($ticket->ticket_row) ? $ticket->ticket_row . ' - ' : '';
			$pdf->Cell($in * 2.5, 8, strtoupper($ticket_row . $ticket->ticket_seat), 0, 0, 'L');
			
			// receipt
			//$pdf->SetXY(180, 106 + $in * 2 * $count); 
			//$pdf->SetFont('Arial', '', 4);
			//$pdf->Cell($in * 2.5, 4, 'ACK RECEIPT #', 0, 0, 'L');
			
			//$pdf->SetXY(180, 110 + $in * 2 * $count); 
			//$pdf->SetFont('Arial', '', 8);
			//$pdf->Cell($in * 2.5, 8, sprintf('%07s', $receipt_number), 0, 0, 'L');
			
			// price
			$pdf->SetXY(180, 106 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell(30, 4, 'PRICE', 0, 0, 'L');
			
			$pdf->SetXY(220, 106 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$text = strtoupper($ticket->ticket_type_code);
			$text .= ($payment_type) ? '/' . strtoupper($payment_type) : '';
			$pdf->Cell(20, 4, $text, 0, 0, 'R');
			
			$pdf->SetXY(180, 110 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 8);
			$pdf->Cell($in * 2.5, 8, 'Php **' . number_format($ticket_price) . '**', 0, 0, 'L');
			
	
			// barcode
			// $pdf->SetXY(247, 88 + $in * 2 * $count); 
			// $pdf->Cell(34, 34, '', 1, 1, 'L');

			// others			
			$pdf->SetXY(113, 121 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell($in * 2.5, 5, sprintf('%05s', $serial_number) . '   ' .  strtoupper($transaction->terminal_code) . '   ' . strtoupper($this->session->userdata('username')) . '   ' . mysqldatetime_to_date($ticket->transaction_date, $format = "m-d-Y h:iA") . '   TN: ' . sprintf('%05s', $transaction->transaction_id) , 0, 0, 'L');
			
			// para sa BIR
			$pdf->SetXY(113, 125 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			if ($receipt_number == 'COMPLIMENTARY')
			{
				$pdf->Cell($in * 2.5, 5, 'COMPLIMENTARY - NOT FOR SALE     ' . strtoupper($this->config->item('company_name')) . '  ' . strtoupper($branch->branch_city), 0, 0, 'L');
			}
			else
			{
				$pdf->Cell($in * 2.5, 5, 'AR No. ' . sprintf('%07s', $receipt_number) . '  ' . strtoupper($this->config->item('company_name')) . '  ' . strtoupper($branch->branch_city) . '  TIN: ' . $branch->branch_tin  , 0, 0, 'L');
			}
			
			
			
			// if preview, just print out the first page
			if ($type == 'preview') break;
		}
	
    	if ($this->session->userdata('claim') == 'claim')
		{
			//echo 'hohoy!';
			
			$pdf->AddPage();
			$pdf->SetAutoPageBreak('Auto', 0);
			
			$num_of_tickets = count($tickets);
			$total_resfee = $num_of_tickets * $event->event_reservation_charge;
			$vatable = $total_resfee / 1.12;
			
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 18);
				$pdf->Cell($in * 2.5, 18, 'Official Receipt', 0, 0, 'C');
				$top += 18 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 2.5, 10, '', 0, 0, 'C');
				$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 12);
				$pdf->Cell($in * 2.5, 12, 'SM PRIME HOLDINGS, INC.', 0, 0, 'C');
				$top += 12 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 2.5, 10, 'Bldg. A, SM Corporate Offices', 0, 0, 'C');
				$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 2.5, 10, 'JW Diokno Blvd., MOA Complex, Pasay City', 0, 0, 'C');
				$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 2.5, 10, 'TIN 003-058-789-041 VAT', 0, 0, 'C');
				$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 2.5, 10, '', 0, 0, 'C');
				$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 2.5, 10, '', 0, 0, 'C');
				$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 2.5, 10, 'Convenience Charge', 0, 0, 'L');
				$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', 'U', 10);
				$pdf->Cell($in * 2.75, 10, 'Convenience Charge', 0, 0, 'L');
				//$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', 'U', 10);
				$pdf->Cell($in * 3.25, 10, 'Unit Price', 0, 0, 'L');
				//$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 2.75, 10, $num_of_tickets, 0, 0, 'L');
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', 'U', 10);
				$pdf->Cell($in * 3.25, 10, $event->event_reservation_charge, 0, 0, 'L');
				//$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 3.75, 10, $total_resfee, 0, 0, 'R');
				$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', 'U', 10);
				$pdf->Cell($in * 2.75, 10, 'VATable Sales', 0, 0, 'L');
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 3.75, 10, $vatable, 0, 0, 'R');
				$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', 'U', 10);
				$pdf->Cell($in * 2.75, 10, 'VAT Amount', 0, 0, 'L');
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 3.75, 10, $total_resfee - $vatable, 0, 0, 'R');
				$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 2.75, 10, 'Official Receipt No. '.str_pad($transaction->transaction_receipt_number, 6, 0, STR_PAD_LEFT), 0, 0, 'R');
				$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 2.75, 10, 'Transaction ID '.$transaction->transaction_id, 0, 0, 'R');
				$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 2.75, 10, date('m/d/Y h:ia', $transaction->transaction_date), 0, 0, 'R');
				$top += 10 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 10);
				$pdf->Cell($in * 2.75, 10, 'This serves as your official receipt.', 0, 0, 'R');
				$top += 10 + $text_margin;
		}
		
		$pdf->Output('ticket', 'I');
		$pdf->Close(); 
		
		// mark transaction and tickets as done
		$this->transactions->transaction_done($transaction_id);
    }

    function print_online_tickets($eid = 0, $transaction_id = false, $barcode = false, $ticket_count = 0)
    {
		if (!$transaction_id and !$barcode) show_404();
		
		if ($ticket_count > 0) {}
		else { 
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Claim Online Tickets';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		$transaction = $this->transactions->get($transaction_id);
		
		if ($transaction->transaction_barcode != $barcode) show_404();
		$tickets = $this->tickets->get_paid_online_tickets($transaction_id);
		if ($ticket_count == count($tickets)) {}
		else {
			show_404();
		}

		// check if tickets have not been printed
		if ($transaction->transaction_status != 'done')
		{
			$this->load->model('smbarcode_model', 'smbarcode');
			$success = $this->smbarcode->attach_smcode_to_transaction_tickets($transaction, $tickets, true);
			
			if ($success) {
				$this->smbarcode->mark_printer_for_online_ticket_claim($transaction_id);
				redirect("/ticket_generator/createXMLTickets/$eid/$transaction_id/$ticket_count/1/");
			} else {
				show_404();
			}

			// mark transaction and tickets as done
			// $this->transactions->transaction_done($transaction_id);
			// $postrequest = @$this->extension->post2mci($transaction_id);
			// moved to delete_pdf call by printapp
			
		}
		else
		{
			redirect('');
		}
		//exit;
	}
	
	function find_seat()
	{
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		$this->load->library('pagination');
		
		// constants
		$limit = $this->pagination->per_page;
		$offset = $this->uri->segment(3);
		
		// prepare data for the template
		$data = $_POST;
		$data['page_title'] = 'Tickets';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Reservation-Admin'));
	
		
		$data['event_names'] = $this->events->get_find_sets_events_dropdown();
		$data['event'] = $this->events->get();
		// pagination
		$config['base_url'] = site_url('tickets/listing');
		$config['total_rows'] = $this->tickets->get_ticket_count();//sizeof( $this->tickets->get_all_tickets(false, false, $searchItems) ); 	

		
		$this->benchmark->mark('query_end');
		$this->load->view('find_seat', $data);
		$this->benchmark->mark('page_end');

		// $querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		// $pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		// $this->logs->benchmark_add($querytime, $pagetime);	
	}
	
	function viewEventPrices($event_id){
		
		// echo 'fdfs';
		// echo $event_id;
		$result =  $this->tickets->get_event_prices($event_id);
		echo json_encode ($result) ;
	}

} 

