<?php

class Ticket_Types extends CI_Controller 
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('venues_model', 'venues');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('events_model', 'events');		
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('ticket_types/listing');
	}
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// prepare data for the template
		$data['page_title'] = 'Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get all Ticket Types
		$data['ticket_types'] = $this->ticket_types->get_ticket_type_list();
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance'));
		
		$this->load->view('ticket_types_listing', $data);
	}
	
		
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($ticket_type_id = FALSE)
	{
		if (!$ticket_type_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'View Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller','Event','Reservation','Reservation-Admin'));
	
		// get ticket types
		$data['ticket_types'] = $this->ticket_types->get($ticket_type_id);
		
		// display the page
		$this->load->view('ticket_types_view', $data);
	}		
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		// prepare data for the template
		$data['page_title'] = 'Add Ticket Type';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));;
			
		$config = array(
			array(
				'field'   => 'ticket_type_code',
				'label'   => 'Code',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[10]'
			),
			array(
				'field'   => 'ticket_type_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'ticket_type_discount',
				'label'   => 'Discount',
				'rules'   => 'trim|required|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
			// get events
			$data['events'] = $this->events->get_events_dropdown();
		
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('ticket_types_add', $data);
		}
		else
		{
			$this->ticket_types->add();
			$this->session->set_flashdata('message', assemble_message('Ticket Type has been successfully added'));
			redirect('ticket_types/listing');
		}
	}	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($ticket_type_id = FALSE)
	{
		if (! $ticket_type_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Ticket Type';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'ticket_type_code',
				'label'   => 'Code',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[10]'
			),
			array(
				'field'   => 'ticket_type_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'ticket_type_discount',
				'label'   => 'Discount',
				'rules'   => 'trim|required|strip_tags'
			),
			
			array(
				'field'   => 'ticket_type_promo',
				'label'   => 'Promo',
				'rules'   => 'trim|strip_tags'
			),
			
			array(
				'field'   => 'ticket_type_active',
				'label'   => 'Active',
				'rules'   => 'trim|strip_tags'
			),
			
			array(
				'field'   => 'expiration',
				'label'   => 'Expiration',
				'rules'   => 'trim|strip_tags'
			),
			
			
			
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get events
		//$data['events'] = $this->events->get_events_dropdown();	
		
		if ($this->form_validation->run() == FALSE)
		{
			// get user's data
			$data['ticket_type'] = $this->ticket_types->get($ticket_type_id);
			
			// display the page
			$this->load->view('ticket_types_edit', $data);
		}
		else
		{
			$this->ticket_types->edit($ticket_type_id);
			$this->session->set_flashdata('message', assemble_message('Ticket Type has been successfully modified'));
			redirect('ticket_types/listing');
		}
	}	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($ticket_type_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Ticket Type');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		$this->ticket_types->delete($ticket_type_id);
		$this->session->set_flashdata('message', assemble_message('Ticket Type has been successfully deleted'));
		redirect('ticket_types/listing/');
	}	
	
	function getTicketTypeByEventId($event_id = FALSE){
		$result =  $this->ticket_types->getTicketTypeByEvent($event_id);
		echo json_encode ($result) ;

		}
	
	function getTicketTypeByEventLongTitle(){
		$event_long = $this->input->post("long_title");
		// echo $event_long = $_POST["long_title"];
		// die();
		// $event_long = $_POST['long_title'];
		$result =  $this->ticket_types->getTicketTypeByEventLongTitle($event_long);
		echo json_encode ($result) ;

		}
	
}
/* End of file Ticket_Types.php */
/* Location: ./application/controllers/Ticket_Types.php */	