<?php

class Ticket_generator extends CI_Controller 
{
	/* NOTE: using a model class to handle dbproc causes 
		memory to run out and greatly affects 
		PDF generation based on XML generator
		
		Tested 100-200 ticket nodes for loading using
		initial output design for db storage and PDF generation
	*/
	
	// template for revised ticket layout
	// var $viewfile = "generator_xml_dynamic_resized_278x206-A";
	// var $viewfile = "generator_xml_dynamic_resized_278x206-B";
	// var $viewfile = "generator_xml_dynamic_resized_278x216-B";
	// var $viewfile = "generator_xml_dynamic_resized_278x216-B-20120326";
	var $viewfile = "generator_xml_dynamic_resized_288x216-C";
	
	// background image for ticket preview
	// var $ticket_bg_expanded  = 'application/views/images/ticket_bg_2012_resized_278x206.jpg';
	// var $ticket_bg_expanded  = 'application/views/images/ticket_bg_2012.jpg';
	var $ticket_bg_expanded  = 'application/views/images/ticket_bg_2013.png';

	public function __construct()
	{
		parent::__construct();
		$this->output->set_header("Cache-Control: no-store, no-cache, must-revalidate");
		$this->output->set_header("Pragma: no-cache");
		$this->output->set_header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date in the past
		$this->load->helper('generator');
		$this->load->model('generator_model', 'ticket_generator');
		$this->load->database('default');
	}
	
	// to generate ticket data format in xml format for db storage
	function newticket2db($count = 0) {

		$data["count"] = $count;
		$text = $this->load->view("generator_xml_4x3", $data, true);
		
		$valid = false;
		$insert_id = 0;
		$yearmonth = date('ym');
		if (!empty($text)) {
			$fields = array(
				'xml_yearmonth' => $yearmonth,
				'xml_content' => $text,
			);
			
			// build insert SQL
			$__isql = $this->db->insert_string("generator", $fields);
			$valid = $this->db->simple_query($__isql);
			$insert_id = $this->db->insert_id();
		}

		if (($valid) && ($insert_id > 0)) {
			// redirect("/printer/db2xml2pdf/$yearmonth/$insert_id");
			echo "Successfully created xml format <BR>";
			echo anchor("/printer/db2xml2pdf/$yearmonth/$insert_id","PDF Display - /printer/db2xml2pdf/$yearmonth/$insert_id","target=_blank");
		} else {
			// 404
			echo $__isql;
		}
	}
	
	// use this to display test xml output of new ticket layout
	function newticket($count = 0) {
		// for proper display of XML output on browser
		
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		
		$data["count"] = $count;
		$this->load->view("generator_xml_4x3",$data);
	}
	
	// use this to properly review stored XML data for printout
	function newticketFromDBReview($yearmonth = false, $id = false){
		if ($id) {} 
		else { die("Invalid access."); }
		// for proper display of XML output on browser
		$xmldata = "";
		if ($id && $yearmonth) {
			$this->db->where("xml_yearmonth", $yearmonth);
			$this->db->where("xml_id", $id);
			$query = $this->db->get("generator");
			
			foreach($query->result() as $row) {
				$xmldata = $row->xml_content;
			}
		}

		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		echo $xmldata;
		// $this->load->view("generator_xml_4x3");
		// $this->load->view($this->viewfile);
	}

	// use this to display test xml output of new ticket layout
	function eventSample($event_id = 0, $preview = false ) {

		$event_id = str_replace(".pdf", "", $event_id);
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;

		$count = 0;
		$data["count"] = $count;
		$data["preview"] = $preview;

		$this->load->model('prices_model', 'prices');
		$this->load->model('events_model', 'events');
		$this->load->model('sections_model', 'sections');
		$this->load->model('generator_model', 'ticket_generator');
		
		$useExpandedTicket = $this->config->item("enable_ticket_4x3");
		// start build of data

		// ticket layout
		$this->load->helper('xml');
		list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($event_id);

		$this->load->helper('xml');

		$bgimage[0] = "";
		if ($preview) {
			// for barcode display
			if ($useExpandedTicket) {
				$bgimage[0] = BASEPATH.$this->ticket_bg_expanded;
			} else {
				$bgimage[0] = BASEPATH.'application/views/images/ticket_bg.jpg';
			}
		}

		$data["layout"] = $layout;
		$data["bgimage"] = $bgimage;

		// empty array of logo (not to be used for new ticket layout)
		$logo1 = array();


		// PREVIEW: Events
		$preview_prices = $this->prices->get_prices($event_id);

		$preview_priceprice = 5000;
		$preview_sectionname = 'PATRON VIP';
		$preview_row = "R";
		$preview_seat = "8";
			
		if (is_array($preview_prices)) {
			$preview_sectionname = $preview_prices[0]->price_name;
			$preview_priceprice = $preview_prices[0]->price_price;
			$preview_pricesections = $preview_prices[0]->price_sections;
		}
		
		// PREVIEW: Info
		$preview_eventcode = "EVENTCODE";
		
		$preview_events = $this->events->get($event_id);
		if(is_object($preview_events)) {
			$preview_eventcode = $preview_events->event_code;
			
			$preview_sections = $this->sections->get_sections($preview_events->event_seatplan_id);
			$preview_sectionseatconfig = "";
			foreach($preview_sections as $ps) {
				if(strpos($preview_pricesections,"\"$ps->section_id\"")>0) {
					$preview_sectionname = $ps->section_name;
					$preview_sectiontype = $ps->section_type;
					$preview_sectionseatconfig = $ps->section_seat_config;
					break;
				}
			}
			
			if ($preview_sectionseatconfig == "") {
				$preview_row = "ROW";
				$preview_seat = "SEAT";
			}
		}

		$tix_info[] = array (
			"tid" => 1,
			"evc" => strtoupper($preview_eventcode),
			"serial" => 1,
			"secname" => $preview_sectionname,
			"row" => $preview_row,
			"seat" => $preview_seat,
			"ttcode" => "RP",
			"paytype" => "CASH",
			"price" => $preview_priceprice,
			"termcode" => "SMMOA",
			"printer" => "TICKETSELLER",
			"arnum" => 0,
			"eid" => sprintf('%06s', $event_id),
			"bc_prefix" => sprintf('%04s', date("ym")),
			"bc_access" => sprintf('%06s', 1),		
		);
			; 
		$data["transaction"] = array(
			"id" => 1,
			"uid" => 1,
			"datetime" => date("Y-m-d H:i:s"),
			"tickets" => $tix_info,
		);
			// sample branch
		$data["branch"] = array(
				'address' => 'Mall of Asia Arena Annex Bldg. Coral Way Cor. JW Diokno Blvd',
				'city' => 'Pasay City',
				'tin' => '123-456-789-0000',
			);

		//for special event
		$data['price_id'] = 1;
		$data['event_id'] = $event_id;
		
		//HARRY STYLES 4137
		if($event_id == 1){
			$this->load->view("generator_xml_dynamic_resized_288x216-C_new", $data);
		}else{
			$this->load->view($this->viewfile, $data);
		}
		
		// $this->load->view($this->viewfile,$data);
		// $this->load->view("generator_xml_dynamic",$data);
		// $this->load->view("generator_xml_dynamic_rev",$data);
		// $this->load->view("generator_xml_4x3.php",$data);
		// $this->load->view("generator_xml_dynamic_resized_278x206",$data);
		// $this->load->view("generator_xml_dynamic_resized_278x206-A",$data);
		// $this->load->view("generator_xml_dynamic_resized_278x206-B",$data);
	}

	function index(){
		$callparam = $_GET;
	
		//the path of the xml that will be converted to pdf
		$url = base_url()."generator/newticket";
		$this->load->library('HTTPCall');
		$this->httpcall->do_http_get_request($url,$callparam);

		$xmldata = $this->httpcall->rawoutput;
	
		$this->load->library('simplexml');  
		$content = $this->simplexml->xml_parse($xmldata, "&amp");
		$data['layout'] = $content['layout']['@attributes'];
		if(isset( $content['ticket'][0])){
			$data['tickets']  = $content['ticket'];
			
		} else {
			$data['tickets'][0]  = $content['ticket'];
		}
		

		$this->load->helper('file');
		$this->load->view('printer_xml2pdf',$data);

	}	

	// use this to display test xml output of new ticket layout
	function createXMLTickets($event_id = 0, $transaction_id = 0, $ticket_count = 0, $online_claim = false) {

		if ($ticket_count > 0) {
			// continue
		} else {
			show_404();
		}
		
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
	

		$this->load->model('prices_model', 'prices');
		$this->load->model('payments_model', 'payments');
		$this->load->model('events_model', 'events');
		$this->load->model('sections_model', 'sections');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('branches_model', 'branches');

		$this->db->where("event_id", $event_id);
		$event = $this->db->get('events')->row();
		$season_pass = $event->event_season_pass;
		
		if($season_pass == 1){
			
			$this->db->where("event_long_title", $event->event_long_title);
			$this->db->where("event_id !=", $event_id);
			$query = $this->db->get('events');
			
			
			if($query->num_rows() > 0){
				$event_ids = array();
				foreach($query->result() as $x){
					 
					$event_ids[] = $x->event_id;
					 
				}
				
				$loop = count($event_ids); 
				
			}else{
				$season_pass = 0;
				$loop = 1;
				
			}
			 
			
		}else{
			
			$loop = 1;
			
		}
		  
		
		//for special season pass
		$res = $this->tickets->get_price_and_ticket_type($transaction_id);
	 
		
		$cpi = $res->price_id;
		$cti = $res->ticket_type_id;
		
		
		//ANIME AND COSPLAY EXPO 2019
		if($cpi == 44378){ 
		
			$event_ids = array(7700, 7701);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		//unburden 44275,44318,44281,44279,44319,44320,44280
		if($cpi == 44318 || $cpi == 44281 || $cpi == 44279 || $cpi == 44319 || $cpi == 44320 || $cpi == 44280){ 
		
			$event_ids = array(7686,7687,7688);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		//unburden 44275,44318,44281,44279,44319,44320,44280
		if($cpi == 44275){ 
		
			$event_ids = array(7685,7687,7688);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		//LEADX
		if($cpi == 43655 || $cpi == 43652 || $cpi == 43649){ 
		
			$event_ids = array(7575 ,7576);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		
		
		
		//COSPLAY CARNIVAL 2019
		if($cpi == 43339){ 
		
			$event_ids = array(7522 ,7523);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		
		//GAMECON 2019
		if($cpi == 43334){ 
		
			$event_ids = array(7520,7521);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		 
		
		//RAKRAKAN 2019
		if($cpi == 43726){ 
		
			$event_ids = array(7498,7499,7498,7499,7498,7499,7498,7499,7498,7499,7498,7499,7498,7499);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 43151){ 
		
			$event_ids = array(7500,7501);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 43163 || $cpi == 43162){ 
		
			$event_ids = array(7498, 7499);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
	 
		
		
	 
	 
		
		//JESUS GLOBAL YOUTH DAY 40220, 40218, 40219
		
		if($cpi == 40220 || $cpi == 40218 || $cpi == 40219 || $cpi == 43736 || $cpi == 43737 || $cpi == 43738){ 
		
			$event_ids = array(7034,7035,7036);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//JESUS GLOBAL YOUTH DAY
		 
		//Manila Auto Con
		
		if($cpi == 42512 || $cpi == 42511 || $cpi == 42510){ 
		
			$event_ids = array(7393,7394,7395,7396);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
  
		//end of manila auto con
		
		
		
		//COSPLAY MATSURI 2018_Ticket Layout Config


		if($cpi == 41187){ 
		
			$event_ids = array(7206, 7207, 7208 );
			$loop = count($event_ids); 
			$season_pass = 1;
		}
 
		
		//end of COSPLAY MATSURI 2018_Ticket Layout Config
 		
		
		//DOTA ALL STAR WEEKEND
		// 34240   6045,6046,6047
		// 34242   6044,6046,6047
		// 34241   6043,6046,6046
		if($cpi == 34240){ 
		
			$event_ids = array(6045,6046,6047);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
 
		if($cpi == 34242){ 
		
			$event_ids = array(6044,6046,6047);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
 
		if($cpi == 34241){ 
		
			$event_ids = array(6043,6046,6047);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
 
  
		if($cpi == 34244){ 
		
			$event_ids = array(6043,6046,6047);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
 
  
  
  
  
		//cosplay mania 2017
		if($cpi == 33318){ 
		
			$event_ids = array(5883,5884);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
 
  
  
        
        // fc bundle promo 
        if($cpi == 33294){ 
		
			$event_ids = array(5876 , 5714 , 5715);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		 
 
  
		//toy con 2017
		$toycon = array(32830, 32829);
		
		// 32830 price id = 5791, 5792, 5793 event id 
		if (in_array($cpi, $toycon)){ 
		
			$event_ids = array(5793);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 32823){ 
		
			$event_ids = array(5791, 5792, 5793);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		 
		
		//bora season pass 
		$bora_season_pass = array(31503, 31504);
		
		
		if (in_array($cpi, $bora_season_pass)){ 
		
			$event_ids = array(5557, 5558,5559,5560);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
	  
		//end of bora season pass
		
		
		//shine forth 
 		
		if($cpi == 31542){ 
		
			$event_ids = array(5570,5569,5563);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		if($cpi == 31543){ 
		
			$event_ids = array(5570,5569,5563);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 31533){ 
		
			$event_ids = array(5568,5569,5563);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		if($cpi == 31532){ 
		
			$event_ids = array(5568,5569);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		if($cpi == 31645){ 
		
			$event_ids = array(5568, 5569,5563);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//end of shine forth season pass
		
		
		//PSL
		if($cpi == 31364){ 
		
			$event_ids = array(5539, 5540,5541);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//end of psl
		 
		
		//35387 price id GameCON,  = 6239 & 6241, 2tickets will be printed
		if($cpi == 35387){ 
		
			$event_ids = array(6239, 6241);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//price id 35464 = 6251&6252 golden disk
		if($cpi == 35464){ 
		
			$event_ids = array(6251, 6252);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 35543){ 
		
			$event_ids = array(6251, 6252);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		////PRICE ID 35951 = 2 TICKETS 6336 6338 EVENT ID FINTECH EVENT
		if($cpi == 35951){ 
		
			$event_ids = array(6339, 6338);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		////cosplay carnival 2018 36406 price id = 2 tickets event id 6406 & 6408
		if($cpi == 36406){ 
		
			$event_ids = array(6406, 6408);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		////BORACAY FEST 2018   36780 or 36787 = 6474 , 6475, 6476, 6477, 6478
		if($cpi == 36780){ 
		
			$event_ids = array(6474 , 6475, 6476, 6477, 6478);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cpi == 36787){ 
		
			$event_ids = array(6474 , 6475, 6476, 6477, 6478);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		// scandal asia tour 2018
		
		
		// 36916		6500 , 6498
		
		if($cpi == 36916){ 
		
			$event_ids = array(6500 , 6498);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		
		// deeper 36999	6513	6514	6515 
		if($cpi == 36999){ 
		
			$event_ids = array(6513 , 6514 , 6515);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		//37000	6513	6514	6515
		if($cpi == 37000){ 
		
			$event_ids = array(6513 , 6514 , 6515);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		//37011		6513	6514	6515
		if($cpi == 37011){ 
		
			$event_ids = array(6513 , 6514 , 6515);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		//37001		6518	6514	6515
		// 37002	6518	6514	6515
		// 37003	6518	6514	6515
		// 37004	6518	6514	6515
		$deeper = array(37001, 37002 , 37003, 37004);
		
		
		if (in_array($cpi, $deeper)){ 
		
			$event_ids = array(6518,6514,6515);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		// jungle circuit 37212 , 6557 , 6558, 6559 , 6560 , 6561  
		if($cpi == 37212){ 
		
			$event_ids = array(6557 , 6558, 6559 , 6560 , 6561);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		// ANIME AND COSPLAY EXPO 2018 38504  - 6757,6756
		if($cpi == 38504){ 
		
			$event_ids = array(6757,6756);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		  
		//Event Name: COSPLAY MANIA 2018 *SEPT 29-30 38541 6762, 6764  
		if($cpi == 38541){ 
		
			$event_ids = array(6762, 6764);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		  
		//Event Name: COSPLAY MANIA 2018 *SEPT 29-30 38552  6765, 6766
		if($cpi == 38552){ 
		
			$event_ids = array(6765, 6766);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		  
		 //Event Name: COSPLAY MANIA 2018 *SEPT 29-30 38553 6767, 6768
		if($cpi == 38553){ 
		
			$event_ids = array(6767, 6768);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		
		//IMPACT Architecture
		
		//40392,40393,40396, 40398, 40400 , 40401 = 7118, 7119,7120


		$impact_prices = array(40392,40393,40396, 40398, 40400 , 40401, 42314);
					
		if (in_array($cpi, $impact_prices)){ 
		
			$event_ids = array(7118, 7119,7120);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		  
		//end if IMPACT Architecture
		  
				
		////GNR P2P bus promo (ticket type) makati
		if($cti == 1270){ 
		
			$event_ids = array(6769, 6995);
			$loop = count($event_ids); 
			$season_pass = 1;
		}	
		
		if($cti == 1272){ 
		
			$event_ids = array(6769, 6995);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		// end of makati GNR promo
		
		////GNR P2P bus promo (ticket type) trinoma
		if($cti == 1271){ 
		
			$event_ids = array(6769,6996);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		if($cti == 1273){ 
		
			$event_ids = array(6769,6996);
			$loop = count($event_ids); 
			$season_pass = 1;
		}
		
		
		//end of trinoma gnr promo
		 
		for ($x = 0; $x <= $loop-1; $x++) {
		   
			if($season_pass == 1){ 
				$eid = $event_ids[$x]; 
				
				
			}else{
				$eid = $event_id;
			}
			
			 
			   
				list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
				$data["layout"] = $layout;
				$data["bgimage"] = $bgimage;
	
				
				// empty array of logo (not to be used for new ticket layout)
				$logo1 = array();

				$event = $this->events->get($event_id);
				if(is_object($event)) {
					$eventcode = $event->event_code;
				}
				
				$payments = $this->payments->get_payments($transaction_id);
					
				if(count($payments) > 1){
						
						$payment_type = 'Multi';
					}elseif(count($payments) == 0){
						
						$payment_type = '';
						
					}else{
						
						$payment_type = $payments[0]->payment_type_code;
					}
					
				$type = "paid";
				$ticketlist = $this->ticket_generator->get_paid_tickets_for_printing($transaction_id);
				
					
				
				$transaction = $this->transactions->get($transaction_id);
				if ($transaction->transaction_user_id == $this->config->item('online_seller_id')) {
					$isweb = 'WEB';
				}
				if ($ticket_count == count($ticketlist)) {
					// ticket count verified, please proceed to next step
				} else {
					// count mismatch
					show_404();
				}
					
				$current_price = '';			
				$current_ticket_type = '';			
				foreach($ticketlist as $tix) {
					
				
					// serial number
					$serial = 1;
					$serial_number = $this->prices_model->get_serial_number($tix->ticket_price_id);
					
					// per ticket price (discount aapplied)
					$ticket_price = 0;
					if ($tix->ticket_type_discount_type == 'Amount')
					{
						$ticket_price = ceil($tix->price_price - $tix->ticket_type_discount);
					}
					elseif ($tix->ticket_type_discount_type == 'Percentage')
					{
						$ticket_price= ceil($tix->price_price - (($tix->price_price * $tix->ticket_type_discount)/100));
					}

					// acknowledgement number
					if ($tix->ticket_type_discount_type == 'Percentage' and $tix->ticket_type_discount == 100)
					{
						$receipt_number = 'COMPLIMENTARY';
					}
					else
					{
						if ($tix->ticket_acknowledgment_receipt > 0) { 
							$receipt_number = $tix->ticket_acknowledgment_receipt;
						}
						else {
							// get receipt number
							$receipt_number = $this->branches->get_last_receipt_number($tix->ticket_branch_id);
							
							// update transactions table
							$this->tickets->update_acknowledgment_receipt($tix->ticket_id, $receipt_number);
						}
					}

					$tix_info[$tix->ticket_id] = array (
						"tid" => $tix->ticket_id,
						"evc" => strtoupper($eventcode),
						"serial" => $serial_number,
						"secname" => $tix->section_name,
						"row" => $tix->ticket_row,
						"seat" => $tix->ticket_seat,
						"ttcode" => $tix->ticket_type_code,
						"paytype" => strtoupper($payment_type),
						"price" => $ticket_price,
						"termcode" => $tix->terminal_code,
						"printer" => strtoupper($tix->username),
						"arnum" => $receipt_number,
						"eid" => sprintf('%06s', $tix->event_id),
						// "bc_prefix" => sprintf('%04s', $tix->sm_prefix),
						"bc_prefix" => sprintf('%04s', $tix->sm_prefix_alt),
						"bc_access" => sprintf('%04s', $tix->sm_code),
					);
					
					$data["branch"] = array(
							'city' => strtoupper($tix->branch_city),
							'address' => strtoupper($tix->branch_address),
							'tin' => $tix->branch_tin,
						);

						
					$price_id = $tix->price_id;
					$ticket_type_id = $tix->ticket_type_id;
					
					 
					$price_ids = array(25500,25497,25505);
					
					if (in_array($price_id, $price_ids)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4577;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}

					
				 
					$dreamplay_vip = array(27280, 27281, 27284, 27285, 27288, 27289,27107,27115,27114,27118,27121,27124, 27135, 27136, 27139, 27140, 27143, 27144,27218,27217,27222,27221,27225,27226,27229,27230);
					if (in_array($price_id, $dreamplay_vip)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4656;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
 
 
 
					$rakrakan = array(28628 , 28636 );
					if (in_array($price_id, $rakrakan)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5022;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
 
					$neverland = array(28892 , 28890 );
					if (in_array($price_id, $neverland)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4948;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
 
					$neverland2 = array(28893 , 28891 );
					if (in_array($price_id, $neverland2)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4949;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
						
					if ($price_id  == 28929){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5087;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 28928){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5086;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
 
					
					if ($price_id  == 28867){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5073;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
				
					if ($price_id  == 28866){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5072;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 28865){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5074;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
 
					if ($price_id  == 27529){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4796;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					if ($price_id  == 28720){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5037;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					

					if ($price_id  == 27530){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4797;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 27531){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 4798;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					
					if ($price_id  == 29285){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5158;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//disney
					
					if ($price_id  == 29616){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5228;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29617){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5229;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29632){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5230;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29633){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5231;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29655){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5233;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29656){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5234;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29868){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5235;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29869){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5236;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29870){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5237;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29871){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5238;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29872){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5239;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29873){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5240;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29874){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5241;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29875){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5242;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29876){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5243;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29877){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5244;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29878){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5245;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29879){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5246;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29880){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5247;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29881){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5248;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29882){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5249;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29883){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5250;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29884){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5251;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29885){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5252;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29886){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5253;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29887){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5254;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29888){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5255;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29889){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5256;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29890){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5257;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29891){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5258;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29892){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5259;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29893){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5260;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29894){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5261;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29895){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5262;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29896){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5263;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 29897){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5264;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 29918 ){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5275;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 30579  ){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5385;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 30633  ){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5394;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					if ($price_id  == 30634  ){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5394;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					if ($price_id  == 30635  ){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5395;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//last
					if ($price_id  == 30952){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5453;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//dota
					if ($price_id  == 31076 && $x == 0){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5482;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 31461 ){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5385;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//boracay music festival
					$bora = array(31475,31473);
					if (in_array($price_id, $bora)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5558;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					$bora2 = array(31472, 31470);
					if (in_array($price_id, $bora2)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5559;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					if ($price_id  == 31471){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5560;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//5565 hot imports night 31520 priceid = 5566
					if ($price_id  == 31520){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5566;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//31519 priceid = 5567
					if ($price_id  == 31519){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5567;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//31571 price id  = 5575 event id
					if ($price_id  == 31571){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5575;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//31571 price id  = 5575 event id
					if ($price_id  == 31591){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5581;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//one kings
					$one_kings = array(32009, 32010, 32011, 32012, 32013);
					if (in_array($price_id, $bora2)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5646;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//motoring music festival 32473 ticket id  = 5728 event id for layout
					if ($price_id  == 32473){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5728;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//anime and cosplay expo
					if ($price_id  == 32572){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5741;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//33005 price id = 5826 event id (ticket layout) history con
					
					
					if ($price_id  == 33005){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5826;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 33261){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5870;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//cosplay mania 2017
					if ($price_id  == 33313){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5882;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 33316){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5881;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 33314){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5880;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 33317){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5879;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 33362){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5883;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 33363){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5884;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 33366){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5881;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 33367){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5882;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 33364){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5879;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 33365){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5880;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//33383 price id to 5741 event id  ANIME AND COSPLAY EXPO
					if ($price_id  == 33383){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5741;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//ESGS 
					//33419 price id = 5891 event id
					if ($price_id  == 33419){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5891;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//33412 price id = 5892 event id
					if ($price_id  == 33412){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5892;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//scout music fest
					if ($ticket_type_id  == 1172){ 
						 
						if($current_ticket_type != $ticket_type_id){
						
						$current_ticket_type = $ticket_type_id;
						
						$eid = 5900;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					
					//33923 price id 33923 = 5980 event id " HYDRO SPLASH PARTY
					if ($price_id  == 33923){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5980;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//1180 ticket type id = 6017 event id DREAMPLAY DISCOUNT
					if ($ticket_type_id  == 1180){ 
						 
						if($current_ticket_type != $ticket_type_id){
						
						$current_ticket_type = $ticket_type_id;
						
						$eid = 6017;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
						
					
					// EVENT NAME airspoken meet and greet
					if ($price_id  == 34179){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6032;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 34181){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6033;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					if ($price_id  == 34184){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6034;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 34187){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6035;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}


					//bumper to bumper
					//34559 price id to 6102 event id
					if ($price_id  == 34559){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6102;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//34558 price id to 6101 event id
					if ($price_id  == 34558){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6101;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//price id 34663 = event id 6118 kidzania
					if ($price_id  == 34663){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6118;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//price id 34666 = event id 6118
					if ($price_id  == 34666){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6118;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
                                       
					//34899 - price id to 6215 event id , NIALL HORAN
					if ($price_id  == 34899){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6215;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					

	
					//35345 & 35341 price id to 6233 event id *** RAKRAKAN 2018
					if ($price_id  == 35345){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6233;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//35345 & 35341 price id to 6233 event id *** RAKRAKAN 2018
					if ($price_id  == 35341){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6233;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					

					//35433 price id GameCON,  = 6241
					if ($price_id  == 35433){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6241;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//FURRYPINAS 35902 6331
					if ($price_id  == 35902){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6331;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//FURRYPINAS
					if ($price_id  == 35903){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6332;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//FURRYPINAS
					if ($price_id  == 35904){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6333;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//FURRYPINAS
					if ($price_id  == 35905){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6334;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					 //FURRYPINAS 35960 =6337 furry, padagdag
					if ($price_id  == 35960){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6337;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 //rusell peters PRICE ID 36247 = EVENT ID 6392
					if ($price_id  == 36247){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6392;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 //cosplay carnival 2018 36411 = 1 ticket event id 6408
					if ($price_id  == 36411){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6408;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 
					// 36632 PRICE ID =  EVENT ID 6115 ( KIDZANIA)
					if ($price_id  == 36632){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6115;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 // BORACAY FEST 2018  36774 = 6474
					if ($price_id  == 36774){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6474;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//37006 , 6474
					if ($price_id  == 37006){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6474;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//37008 , 6476
					if ($price_id  == 37008){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6476;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//37009 , 6477
					if ($price_id  == 37009){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6477;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//37010 , 6478
					if ($price_id  == 37010){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6478;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					
					//37007 , 6475
					if ($price_id  == 37007){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6475;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 
					
					//36775 = 6475
					if ($price_id  == 36775){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6475;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//36778 = 6476
					if ($price_id  == 36778){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6476;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 //36782 = 6477
					if ($price_id  == 36782){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6477;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					  //36784 = 6478
					if ($price_id  == 36784){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6478;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 36853){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6488;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 36854){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6487;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					if ($price_id  == 36855){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6490;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 36862){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6489;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 
					//scandal asia tour 2018 36917		6501 
					if ($price_id  == 36917){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6501;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//36918		6502 
					if ($price_id  == 36918){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6502;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//36919		6499 
					if ($price_id  == 36919){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6499;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//jungle
					//37209 = 6557
					if ($price_id  == 37209){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6557;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//37210 = 6558
					  
					if ($price_id  == 37210){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6558;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					
					//37211 = 6559 
					if ($price_id  == 37211){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6559;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//37216 = 6560  
					if ($price_id  == 37216){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6560;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//37217 = 6561

					if ($price_id  == 37217){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6561;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					// price id 37332 = 6576 eventid
					// JUNGLE BEACH NIGHT PARTY

					if ($price_id  == 37332){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6576;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					// FURRYPINAS
					// VETERAN	        37541    	6333
					// EXPERIENCED	  	37542	      6334
					// NOVICE DAY 1	    37543    	6330
					// NOVICE DAY 2	    37544   	6337

					if ($price_id  == 37541){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6333;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 37542){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6334;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 37543){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6330;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					  
					 if ($price_id  == 37544){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6337;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//ONE FC price id 37545 or 37546 or 37547 = event id 6618		
					if ($price_id  == 37545){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6618;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					if ($price_id  == 37546){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6618;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 37547){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6618;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//harry styles		
					$price_ids = array(38170,38171,38172,38173);
					
					if (in_array($price_id, $price_ids)){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 5808;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//toycon 2018 38269 , 6733
					
					if ($price_id  == 38269){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6733;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//toycon 2018 38268 , 6733
					
					// if ($price_id  == 38268){ 
						 
						// if($current_price != $price_id){
						
						// $current_price = $price_id;
						
						// $eid = 6733;
						 
						// list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						// $data["layout"] = $layout;
						// $data["bgimage"] = $bgimage;
						
						// }
					 
					// }
					
					//toycon 2018 38266 , 6733
					
					if ($price_id  == 38266){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6733;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 //toycon 2018 38273 , 6732
					
					if ($price_id  == 38273){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6732;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 //toycon 2018 38267 , 6731
					
					if ($price_id  == 38267){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6731;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 //toycon 2018 38270 , 6731
					
					if ($price_id  == 38270){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6734;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 //ANIME AND COSPLAY EXPO 2018 
					
					if ($price_id  == 38511){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6757;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 //ANIME AND COSPLAY EXPO 2018 
					
					if ($price_id  == 38512){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6816;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					if ($price_id  == 38501){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6815;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					
					
					//TOY CON 2018 * JUNE 08-10 2018
					
					 if ($price_id  == 38268){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6763;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//COSPLAY MANIA 2018 *SEPT 29-30 38570 6762
					
					if ($price_id  == 38570){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7181;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//COSPLAY MANIA 2018 *SEPT 29-30 38563 6762
					
					if ($price_id  == 38563){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6762;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//COSPLAY MANIA 2018 *SEPT 29-30 38662 6764
					
					if ($price_id  == 38662){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7182;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//COSPLAY MANIA 2018 *SEPT 29-30 38564 6764
					
					if ($price_id  == 38564){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6764;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//COSPLAY MANIA 2018 *SEPT 29-30 38571 6765
					
					if ($price_id  == 38571){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7183;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//COSPLAY MANIA 2018 *SEPT 29-30  38565 6765
					
					if ($price_id  == 38565){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6765;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
					//COSPLAY MANIA 2018 *SEPT 29-30 38663 6766
					
					if ($price_id  == 38663){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7184;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//COSPLAY MANIA 2018 *SEPT 29-30 38566 6766
					
					if ($price_id  == 38566){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6766;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//COSPLAY MANIA 2018 *SEPT 29-30 38569 6767
					
					if ($price_id  == 38569){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7185;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//COSPLAY MANIA 2018 *SEPT 29-30 38567 6767
					
					if ($price_id  == 38567){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6767;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//COSPLAY MANIA 2018 *SEPT 29-30 38664 6768
					
					if ($price_id  == 38664){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7186;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//COSPLAY MANIA 2018 *SEPT 29-30 38568 6768
					
					if ($price_id  == 38568){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6768;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//price id 38897 = 6618 or 38898 =6618 or 38899 =6618

					if ($price_id  == 38897 || $price_id  == 38898 || $price_id  == 38899){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6618;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//gnr 38656 = 6822
					if ($price_id  == 38656){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6822;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//history con  38934	6827
					if ($price_id  == 38934){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6827;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//history con 38933	6826
					if ($price_id  == 38933){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6826;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					
					//history con 38947	6824
					if ($price_id  == 38947){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6824;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//history con 38948	6825
					if ($price_id  == 38948){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6825;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
						
					//THE BEST OF ANIME 2018
					if ($price_id  == 39533){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6929;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//THE BEST OF ANIME 2018
					if ($price_id  == 39537){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6928;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					//THE BEST OF ANIME 2018
					if ($price_id  == 39534){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6927;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//FurryPinas 2019  
					/* 
					40514 = 7099
					40529 = 7100
					40515 = 7101
					40530 = 7102
					40520 = 7103
					40531 = 7104
					40588 = 7105
					40589 = 7106


					*/
					
					if ($price_id  == 40514){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7099;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 40529){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7100;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 40515){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7101;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 40530){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7102;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 40520){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7103;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 40531){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7104;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 40588){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7105;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 40589){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7106;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					//end of FurryPinas 2019 
					
					
					//ONE: CONQUEST OF CHAMPIONS
					
					if ($price_id  == 40738){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6618;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					
					
					if ($price_id  == 40739){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6618;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 
					
					if ($price_id  == 40740){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6618;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 
					
					//end of ONE: CONQUEST OF CHAMPIONS
					
					
					//COSPLAY MATSURI 2018_Ticket Layout Config

					if ($price_id  == 41190 || $price_id  == 41189 || $price_id  == 41188){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7206;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					 
					if ($price_id  == 41191 || $price_id  == 41193 || $price_id  == 41195){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7207;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					  
					
					 
					if ($price_id  == 41192 || $price_id  == 41194 || $price_id  == 41196){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7208;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
					 
					//end of COSPLAY MATSURI 2018_Ticket Layout Config

					
					
					//BUMPER XVI BUMPER *DEC 08-09 2018_Ticket Layout Config

					if ($price_id  == 41345){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7223;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
				 
					if ($price_id  == 41344){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7224;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
				 
					if ($price_id  == 41346){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7222;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					  
					 
					//end of BUMPER XVI BUMPER/
					 
					 
					if ($price_id  == 42076){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6996;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
				 	
					if ($price_id  == 42077){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6995;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					  
					
					//blackpink
					  
					if ($price_id  == 42571){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7401;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					  
					  
					if ($price_id  == 42381){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7400;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					  
					//blackpink  
					
					
					
					//ONE:HERO'S ASCENT
					  
					if ($price_id  == 42613 || $price_id  == 42614 || $price_id  == 42615){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6618;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					  
					   
					//RAKRAKAN 2019
					
					 
					if ($price_id  == 43147){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7500;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					   	 
					if ($price_id  == 43171){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7501;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
					if ($price_id  == 43150 || $price_id  == 43148){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7498;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
					 
					if ($price_id  == 43172 || $price_id  == 43173 || $price_id  == 43671|| $price_id  == 43725){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7499;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
					//GAMECON 2019 SM TICKETS
					  
					if ($price_id  == 43333){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7520;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
					 
					if ($price_id  == 43335){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7521;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
					//COSPLAY CARNIVAL 2019 
					if ($price_id  == 43344 || $price_id  == 43342 || $price_id  == 43340){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7522;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
				
					if ($price_id  == 43343 || $price_id  == 43341 || $price_id  == 43353){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7523;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
					if ($price_id  == 43862){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7498;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
					 
					if ($price_id  == 43863){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7499;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
					 
					 
					if ($price_id  == 43877 || $price_id  == 43878 || $price_id  == 43879){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 6618;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					//	HOT IMPORT NIGHTS 8 MANILA - MAY 4-5					
					if ($price_id  == 44174){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7662;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
					if ($price_id  == 44173){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7663;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
					 
					if ($price_id  == 44380 || $price_id  == 44379 || $price_id  == 44384){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7701;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
				 
					
					
					if ($price_id  == 44799){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7781;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 44803 || $price_id  == 44877){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7780;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					if ($price_id  == 44859){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7789;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					if ($price_id  == 44800 || $price_id  == 44861){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7778;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					 
					if ($price_id  == 44806 || $price_id  == 44896 || $price_id  == 44897 || $price_id  == 44860 || $price_id  == 44898 || $price_id  == 44899){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7791;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					 
					if ($price_id  == 45569){ 
						 
						if($current_price != $price_id){
						
						$current_price = $price_id;
						
						$eid = 7896;
						 
						list($bgimage, $layout) = $this->ticket_generator->GetLayoutDetails($eid);
						$data["layout"] = $layout;
						$data["bgimage"] = $bgimage;
						
						}
					 
					}
					
					
					 
					 
					//end of dynamic layout
					
					
					
					
					 
					
				}
				
				$data["transaction"] = array(
					"id" => $transaction->transaction_id,
					"uid" => $transaction->transaction_user_id,
					"datetime" => $transaction->transaction_date,
					"tickets" => $tix_info,
				);

				//for special event
				$data['price_id'] = $price_id;
				$data['event_id'] = $event_id;
				
				// $xmltext = $this->load->view("generator_xml_dynamic_rev", $data, true);
				 
				//HARRY STYLES 4137
				if($event_id == 1){
					$xmltext = $this->load->view("generator_xml_dynamic_resized_288x216-C_new", $data, true);
				}else{
					$xmltext = $this->load->view($this->viewfile, $data, true);
				}	// $xmltext = 'test';
 	
				 
				
			
			
			  // echo '<pre>';
					// print_r(array_values($tix_info));
					// echo '</pre><br>';
				
				
				// echo '<pre>';
				// print_r( $tix_info);
				// echo '</pre>';
				// echo '<br><br><br><br><br>';
				
				// echo $xmltext . '<br><br><br><br>';
				
				$valid = false;
				$insert_id = 0;
				$yearmonth = date('ym');
				$__isql = "";
			
				if (!empty($xmltext)) {
					$fields = array(
						'xml_yearmonth' => $yearmonth,
						'xml_content' => $xmltext,
						'xml_trans_id' => $transaction_id,
					);
					
					// build insert SQL
					$__isql = $this->db->insert_string("generator", $fields);
					$valid = $this->db->simple_query($__isql);
					$insert_id = $this->db->insert_id();
						
						
					
				}

				
 			}	 
			
	
		
			// die();
		
		if (($valid) && ($insert_id > 0)) {
			if ($online_claim) {
				redirect("/transactions/print_online/$transaction_id/$event_id/$yearmonth/$ticket_count/$insert_id");
			} else {
				redirect("/transactions/done_rev/$transaction_id/$event_id/$yearmonth/$ticket_count/$insert_id/");
			}
			// echo anchor("/printer/db2xml2pdf/$yearmonth/$insert_id","PDF Display - /printer/db2xml2pdf/$yearmonth/$insert_id","target=_blank");
		} else {
			show_404();
			// echo $__isql;
		}
		
		

	}
	
 
}