<?php

class Sessions extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('branches_model', 'branches');
		$this->load->model('sessions_model', 'sessions');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('sessions/listing');
	}
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($session_id = FALSE)
	{
		if (! $session_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'View Session';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller','Reservation','Reservation-Admin'));
	
		// get user's data
		$data['sessions'] = $this->sessions->get($session_id);
		
		// display the page
		$this->load->view('sessions_view', $data);
	}	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		$this->load->library('pagination');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// constants
		$limit = $this->pagination->per_page;
		$offset = $this->uri->segment(3);
		
		// prepare data for the template
		$data['page_title'] = 'Sessions';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['sessions'] = $this->sessions->get_sessions($offset, $limit,'session_date_time desc');
		
		// pagination
		$config['base_url'] = site_url('sessions/listing');
		$config['total_rows'] = $this->sessions->get_session_count();
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		$this->load->view('sessions_listing', $data);
	}	

	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
				
		// prepare data for the template
		$data['page_title'] = 'Add Blank Series';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller','Reservation','Reservation-Admin'));
			
		$config = array(
			array(
				'field'   => 'session_beginning_serial',
				'label'   => 'Beginning Serial Number',
				'rules'   => 'trim|strip_tags|max_length[20]'
			),
			array(
				'field'   => 'session_ending_serial',
				'label'   => 'Ending Serial Number',
				'rules'   => 'trim|strip_tags|max_length[20]'
			),		
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
			// get session info
			$data['sessions'] = $this->sessions->get_by_session_id($this->session->userdata('user_session_id'));
			
			// display the page
			$this->load->view('session_add_blank_series', $data);
		}
		else
		{
			
			$this->sessions->add($this->session->userdata('user_id'), $this->session->userdata('user_branch_id'));
			// redirect
			$this->session->set_flashdata('message', assemble_message('Blank Series has been successfully added'));
			redirect('');
		}		
	}	
}

/* End of file sessions.php */
/* Location: ./application/controllers/sessions.php */	