<?php

class senior extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
 		$this->load->model('users_model', 'users');
		$this->load->model('venues_model', 'venues');
		$this->load->model('sections_model', 'sections');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('events_model', 'events');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('prices_model', 'prices');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('customers_model', 'customers');
		$this->load->model('reservations_model', 'reservations');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('payments_model', 'payments');
		$this->load->model('branches_model', 'branches');
		$this->load->model('printer_model', 'printer');
		$this->load->model('eplus_model', 'eplus');
		$this->load->model('senior_model', 'senior');
		$this->load->database('default');

	 
	}
 	
	function add_senior($count = false){
	
			
	 
			$data['count'] = $count; 
			$this->load->view('senior_dialog',$data);
			
 	 
	
	}
	
	function add_senior2($count = false){
	
		$this->session->set_userdata('seniorData', $_POST);
		
		$config = array(
			array(
				'field'   => 'seniorID[]',
				'label'   => 'ID Number',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[20]|callback__senior_check|callback__senior_check_duplicate|callback__senior_check_name'
			),
			array(
				'field'   => 'seniorLName[]',
				'label'   => 'LastName',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			
			array(
				'field'   => 'seniorFName[]',
				'label'   => 'FirstName',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[20]'
			),
			array(
				'field'   => 'seniorBdate[]',
				'label'   => 'Birthday',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[20]'
			),
		);
		
		$this->form_validation->set_rules($config); 

 		$this->form_validation->set_error_delimiters('', '');
		if ($this->form_validation->run() == FALSE)
		{
			 
			if(!$count){
			
				$count = $this->input->post('count');
			}
			
			echo validation_errors();
			// echo $count;
			// $data['count'] = $count; 
			// $this->load->view('senior_dialog',$data);
	 
			
 		}
		else
		{
		
			$this->senior->add_senior();
			echo 'ok';
		}
	
	}
	
	function _senior_check($str)
	{	
		$senior_exists = $this->senior->is_senior_exist($str);
		if ($senior_exists)
		{
			$this->form_validation->set_message('_senior_check', "Senior ID $senior_exists is already used for this event");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}	
	
	function _senior_check_duplicate()
	{	
	
		$str = $this->input->post('seniorID');
	 
		$dup = $this->array_has_dupes($str);
		
		
		if ($dup)
		{
			$this->form_validation->set_message('_senior_check_duplicate', "Senior ID must be unique");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	function ticket_types($claim = false, $transaction_id = false)
	{
		 
		$_POST = $this->session->userdata('seniorData'); 
		 
		 
		// print_r($_POST);
		// die();
		
		
		if ($claim == 'claim')
		{
			// get price info
			$restore_session =  $this->reservations->get_customer_id($transaction_id);	
			//printr($restore_session);
			$customer_session_id = $restore_session->ticket_session_id;
			$cei = $restore_session->ticket_event_id;
			$cpi = $restore_session->ticket_price_id;
			$tix_qty = $this->transactions->_get_num_of_reserved_tix($transaction_id);
			
			// set session data
			$this->session->set_userdata('cei', $cei);
			$this->session->set_userdata('cpi', $cpi);
			$this->session->set_userdata('customer_session_id', $customer_session_id);
			$this->session->set_userdata('claim', $claim);
			$this->session->set_userdata('tid', $transaction_id);
			$this->session->set_userdata('tix_qty', $tix_qty);
		}
		else
		{
			if (!$this->session->userdata('customer_session_id') or !$this->session->userdata('cei') or !$this->session->userdata('cpi'))
			{
				$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
				redirect('');
			}
			
			$customer_session_id = $this->session->userdata('customer_session_id');
			$cei = $this->session->userdata('cei');
			$cpi = $this->session->userdata('cpi');
		}	

		
		// prepare data for the template
		$data['page_title'] = 'Select Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		 

		if ($claim == 'claim')
		{
			// get tickets
			$data['tickets'] = $this->tickets->get_reserved_tickets($transaction_id);
		
			// get price info
			$data['price'] =  $this->prices->get($cpi);
		
			// get ticket types
			$ticket_types = $this->ticket_types->get_ticket_types($cei);
		}
		else
		{
			
			// get tickets
			$data['tickets'] = $this->tickets->get_tickets_by_session($this->session->userdata('customer_session_id'), $this->session->userdata('cpi'));

			// get price info
			$data['price'] =  $this->prices->get($this->session->userdata('cpi'));
		
	        // get ticket types
	        $ticket_types = $this->ticket_types->get_ticket_types($this->session->userdata('cei'));
		}
		
		$data['event'] = $this->events->get($this->session->userdata('cei'));
		
        $event_ticket_types = unserialize($data['price']->event_ticket_types);
 
        foreach ($ticket_types as $ticket_type)
        {
            if (in_array($ticket_type->ticket_type_id, $event_ticket_types))
            {
                $tt_array[$ticket_type->ticket_type_id] = $ticket_type->ticket_type_name;
            }
        }
        $data['ticket_types'] = $tt_array;
		
		 
			
		if ($this->session->userdata('transaction_type') == 'reserve' && $claim != 'claim')
		{
			// update db
			$this->tickets->edit_ticket_type();
			 
			
			// redirect
			redirect('transactions/customer_info/');
		}
		else
		{			
			// update db
			$this->tickets->edit_ticket_type();
		
			// redirect
			redirect('transactions/payment/'.$claim);
		}	
 
	}
	
	
	function array_has_dupes($array) {
 	   
	 
	   if(count(array_unique($array))<count($array))
		{
			return true;
		}
		else
		{
			return false;
		}
	   
	   
	}
	
	function _senior_check_name()
	{	
 
	
		$senior_exists = $this->senior->is_senior_name_exist();
		if ($senior_exists)
		{
			$this->form_validation->set_message('_senior_check_name', "Senior $senior_exists->senior_fname $senior_exists->senior_lname already used discount for this event");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

		
	
	 
}

