<?php

class Secret2 extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->database('default');
		$this->load->model('users_model', 'users');
		$this->load->model('reports_model', 'reports');
		$this->load->model('ticket_types_model', 'ticket_types');
		
 	}
	 

	function clear_user_sessions(){
	
	$this->db->query("delete  from user_sessions");
	
	
	}
	
		
	function change_password($username = false, $password = false)
	{
 
	
		if($username == '' || $password == ''){
		
			die('invalid parameters');
		}
	
		$fields = array(
			'customer_password'				=> $this->prep_password($password),
		);
	
		// update db
		$this->db->where('customer_username', $username);
		$this->db->update('customers', $fields);
		
		if($this->db->affected_rows() > 0){
		
			echo 'success';
		}else{
			echo 'failed'; 
		}
		
	}	
	
	
	function prep_password($password)
	{
		return sha1($this->config->item('encryption_key').$password);
	}

	 	
	function generate_qno_old($event_id = false, $section_id = false){
		
		if(!$event_id || !$section_id){
			
			echo 'No Event ID or Section ID provided';
			die();
		}
		//check last queue no
		$this->db->query('set transaction isolation level read uncommitted');
		
 		$this->db->where('queue_event_id', $event_id);
 		$this->db->where('queue_section_id', $section_id);
		$this->db->order_by('queue_ticket_id', 'DESC');
 		$queue = $this->db->get('queue q');
		
		if($queue->num_rows() > 0){ 
			$queue = $queue->row(); 
		}else{ 
			$queue = '';
		}
		 
		if($queue){ 
			$this->db->where('transaction_id >', $queue->queue_transaction_id); 
			$last_queue_no = $queue->queue_number;
			
	
			 
		}else{
			
			$last_queue_no = 0;
		}
		 	
		$this->db->select('transaction_id');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->join('tickets t', 't.ticket_transaction_id = tr.transaction_id');
		$this->db->order_by('transaction_date', 'ASC');
		$this->db->group_by('transaction_id'); 
		$this->db->where_in('transaction_status', array('done','paid_online','paid')); 
		// $this->db->limit(10);
		$trans = $this->db->get('transactions tr');
		
		
		if($trans->num_rows() > 0){ 
		
			$trans = $trans->result();
		
		}else{
			
			echo 'No transaction yet';
			die();
		}
		
		
		$trans_array = array();
		foreach($trans as $t){
			
			$trans_array[] = $t->transaction_id;
		}
		
		// echo '<pre>';
		// print_r($trans_array);
		// echo '</pre>';
		// die();
			
		
		if(empty($trans_array) && $last_queue_no != 0 ){
			
			echo 'No new transactions';
			die();
		}else{
			 
		$this->db->where_in('ticket_transaction_id', $trans_array);
 		 
		}
		
		
		// $this->db->order_by('transaction_date', 'ASC');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->join('transactions tr', 't.ticket_transaction_id = tr.transaction_id');
		$this->db->order_by('transaction_date', 'ASC');
		$this->db->group_by('ticket_id'); 
		$this->db->where_in('ticket_status', array('done','paid_online','paid')); 
 		$tickets = $this->db->get('tickets t');
		
		
		if($tickets->num_rows() > 0){ 
			$tickets = $tickets->result(); 
				
				
				// echo '<pre>';
					// print_r($tickets);
					// echo '</pre>';
				// die();
			//generate queue number  then insert to queue table
			foreach($tickets as $x){
				echo $x->ticket_id . '<br>';
				$last_queue_no += 1;
				$fields = array(
					'queue_ticket_id'			=> $x->ticket_id,
					'queue_transaction_id'		=> $x->ticket_transaction_id,
					'queue_event_id'			=> $x->ticket_event_id,
					'queue_section_id'	=> $x->ticket_section_id, 
					'queue_number'	=> $last_queue_no, 
				);
				
				// insert to db
				$this->db->set($fields);
				$this->db->insert('queue');
				
				
			}
		 
			
			
		}else{ 
			echo 'Invalid Event ID or Section ID';
		}
 
	}
	
  	
	function generate_qno($event_id = false, $section_id = false){
		
		if(!$event_id || !$section_id){
			
			echo 'No Event ID or Section ID provided';
			die();
		}
		//check last queue no
		$this->db->query('set transaction isolation level read uncommitted');
		
 		$this->db->where('queue_event_id', $event_id);
 		$this->db->where('queue_section_id', $section_id);
		$this->db->order_by('queue_number', 'DESC');
 		$queue = $this->db->get('queue q');
		
		if($queue->num_rows() > 0){ 
			$queue = $queue->row(); 
		}else{ 
			$queue = '';
		}
		 
		if($queue){ 
			$this->db->where('ticket_transaction_id >', $queue->queue_transaction_id); 
			$last_queue_no = $queue->queue_number;
			
	
			 
		}else{
			
			$last_queue_no = 0;
		}
	 
		 
		// $this->db->order_by('transaction_date', 'ASC');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where('queue_ticket_id is  NULL');
		$this->db->join('transactions tr', 't.ticket_transaction_id = tr.transaction_id');
		$this->db->join('queue q', 'q.queue_ticket_id = t.ticket_id','left');
		$this->db->order_by('transaction_date', 'ASC');
		$this->db->order_by('transaction_id', 'ASC');
		$this->db->order_by('ticket_id', 'ASC');
		$this->db->group_by('ticket_id'); 
		$this->db->where_in('ticket_status', array('done','paid_online','paid')); 
		// $this->db->limit(21);
 		$tickets = $this->db->get('tickets t');
		
		
		if($tickets->num_rows() > 0){ 
			$tickets = $tickets->result(); 
				
				
				// echo '<pre>';
					// print_r($tickets);
					// echo '</pre>';
				// die();
			//generate queue number  then insert to queue table
			foreach($tickets as $x){
				echo $x->ticket_id . '<br>';
				$last_queue_no += 1;
				$fields = array(
					'queue_ticket_id'			=> $x->ticket_id,
					'queue_transaction_id'		=> $x->ticket_transaction_id,
					'queue_event_id'			=> $x->ticket_event_id,
					'queue_section_id'	=> $x->ticket_section_id, 
					'queue_number'	=> $last_queue_no, 
				);
				
				// insert to db
				$this->db->set($fields);
				$this->db->insert('queue');
				
				
			}
		 
			
			
		}else{ 
			echo 'No New Transactions';
		}
 
	}
	
		
	function get_barcode($ticket_id = false){
		
		if(!$ticket_id){
			
			echo 'No Ticket ID provided';
			die();
		}
		
		$barcode = '';
		$this->db->where('sm_ticket_id',$ticket_id);
		$this->db->join('tickets t', 't.ticket_id = sm_ticket_id'); 
		$query = $this->db->get('sm_barcode');
		if($query->num_rows()> 0){
			
			$result = $query->row();
			
			$event_id =  str_pad($result->ticket_event_id,6,"0",STR_PAD_LEFT);
			$prefix_alt =  str_pad($result->sm_prefix_alt,4,"0",STR_PAD_LEFT);
			$smcode =  str_pad($result->sm_code,6,"0",STR_PAD_LEFT);
			echo "$event_id$prefix_alt$smcode";
			
		}else{
			
			echo 'Invalid Ticket ID';
		}
		
		
	}
	
	
	function generate_qno_multiple($event_id = false,$section_id = false, $section_id2 = false ){
		
		
		if(!$event_id || !$section_id || !$section_id2){
			
			echo 'No Event ID or Section ID provided';
			die();
		}
		
		$section_ids = array($section_id, $section_id2);
		
		//check last queue no
		$this->db->query('set transaction isolation level read uncommitted');
		
 		$this->db->where('queue_event_id', $event_id);
 		$this->db->where_in('queue_section_id', $section_ids);
		$this->db->order_by('queue_number', 'DESC');
 		$queue = $this->db->get('queue q');
		
		if($queue->num_rows() > 0){ 
			$queue = $queue->row(); 
		}else{ 
			$queue = '';
		}
		 
		if($queue){ 
			$this->db->where('ticket_transaction_id >', $queue->queue_transaction_id); 
			$last_queue_no = $queue->queue_number;
			
	
			 
		}else{
			
			$last_queue_no = 0;
		}
	 
		 
		// $this->db->order_by('transaction_date', 'ASC');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where_in('ticket_section_id', $section_ids);
		$this->db->where('queue_ticket_id is  NULL');
		$this->db->join('transactions tr', 't.ticket_transaction_id = tr.transaction_id');
		$this->db->join('queue q', 'q.queue_ticket_id = t.ticket_id','left');
		$this->db->order_by('transaction_date', 'ASC');
		$this->db->order_by('transaction_id', 'ASC');
		$this->db->order_by('ticket_id', 'ASC');
		$this->db->group_by('ticket_id'); 
		$this->db->where_in('ticket_status', array('done','paid_online','paid')); 
		// $this->db->limit(21);
 		$tickets = $this->db->get('tickets t');
		
		
		if($tickets->num_rows() > 0){ 
			$tickets = $tickets->result(); 
				
				
				// echo '<pre>';
					// print_r($tickets);
					// echo '</pre>';
				// die();
			//generate queue number  then insert to queue table
			foreach($tickets as $x){
				echo $x->ticket_id . '<br>';
				$last_queue_no += 1;
				$fields = array(
					'queue_ticket_id'			=> $x->ticket_id,
					'queue_transaction_id'		=> $x->ticket_transaction_id,
					'queue_event_id'			=> $x->ticket_event_id,
					'queue_section_id'	=> $x->ticket_section_id, 
					'queue_number'	=> $last_queue_no, 
				);
				
				// insert to db
				$this->db->set($fields);
				$this->db->insert('queue');
				
				
			}
		 
			
			
		}else{ 
			echo 'No New Transactions';
		}
 
	}
	
		function generate_ticket_types_cron($limit = false){
			// $event_id = 4447;
			if(!$limit){
				echo 'Failed';
				die();
			}
			//get last sync
			$this->db->select('date_modified');
			$this->db->order_by('date_modified','desc'); 
			$this->db->limit(1); 
			$query = $this->db->get('event_ticket_types');	
			if($query->num_rows()>0){			
			$last_sync = $query->row()->date_modified;
				$this->db->where('date_modified >=', $last_sync);	
			}
					 
			$this->db->limit($limit); 
			$query = $this->db->get('events');
			if($query->num_rows() > 0){
				$result = $query->result();			
				 // $event_id = $result[0]->event_id;
				// $prices = array();
				// $sections = array();
				$event_ticket_types = array();
				$ticket_types = array();
				foreach($result as $x){
					// $sections[$x->price_id] =  unserialize($x->price_sections);	
					if(isset($ticket_types[$x->event_id])){		
					$ticket_types[$x->event_id]= array_merge(unserialize($x->event_ticket_types), $ticket_types[$x->event_id]);		
					}else{		
					$ticket_types[$x->event_id]= unserialize($x->event_ticket_types);			
					}	
					// $ticket_types[$x->event_id]['price_name'] = $x->price_name;
					// $ticket_types[$x->event_id]['price_price'] = $x->price_price;
					// $ticket_types[$x->event_id]['price_event_id'] = $x->price_event_id;
				}
				// echo '<pre>';
				// print_r($ticket_types);
				// echo '</pre>';
				
				// die();
				foreach($ticket_types as $key=>$value){
					 
					$this->db->select('ticket_type_id, ticket_type_name');
					$this->db->where_in('ticket_type_id', $value);
					$query = $this->db->get('ticket_types');
					$result = $query->result();
					
					foreach($result as $x){	
						$event_id = $key;
						//remove existing
						$this->db->where('event_id',$event_id);
						$this->db->where('ticket_type_id',$x->ticket_type_id);
						$this->db->delete('event_ticket_types');
						
						$fields = array(
							'event_id'			=> $event_id,
							'ticket_type_id'	=> $x->ticket_type_id,
							'ticket_type_name'	=> $x->ticket_type_name,
							);
						// insert to db
						$this->db->set($fields);
						 $this->db->insert('event_ticket_types'); 
					}
				
				}
				
				echo 'Success';
			 
 			}

	} //END EVENT TICKET TYPE CRON
	
	function generate_price_sections_cron($limit = false){
			// $event_id = 4447;
			if(!$limit){
				echo 'Failed';
				die();
			}
			
			//get last sync
			$this->db->select('date_modified');
			$this->db->order_by('date_modified','desc'); 
			$this->db->limit(1); 
			$query = $this->db->get('price_sections');
			
			if($query->num_rows()>0){
				
			$last_sync = $query->row()->date_modified;
				$this->db->where('date_modified >=', $last_sync);
			}	

			// die($last_sync); 
			$this->db->limit($limit);
			$query = $this->db->get('prices');
			if($query->num_rows() > 0){
				$result = $query->result();
				// echo '<pre>';
				// print_r($result);
				// echo '</pre>';
				// die();		
				$prices = array();
				$sections = array();
				$price_sections = array();
				$sections2 = array();
				foreach($result as $x){
					$sections[$x->price_id] =  unserialize($x->price_sections);
					$sections2= array_merge(unserialize($x->price_sections), $sections2);
					$prices[$x->price_id]['price_name'] = $x->price_name;
					$prices[$x->price_id]['price_price'] = $x->price_price;
					$prices[$x->price_id]['price_event_id'] = $x->price_event_id;
				}
				
				$this->db->select('section_id, section_capacity');
				$this->db->where_in('section_id', $sections2);
				$query = $this->db->get('sections');
				$result = $query->result();
				$sections_cap = array();
				foreach($result as $x){
					$sections_cap[$x->section_id]=  $x->section_capacity;
				}
				foreach($sections as $a=>$b){
					foreach($b as $y=>$z){
						$price_sections[$z]['price_event_id'] = $prices[$a]['price_event_id'];
						$price_sections[$z]['price_id'] = $a;
						$price_sections[$z]['price_name'] =$prices[$a]['price_name'];
						$price_sections[$z]['price_price'] =$prices[$a]['price_price'];

						if(isset($sections_cap[$z])){
						$price_sections[$z]['section_capacity'] =$sections_cap[$z];

						}else{

						$price_sections[$z]['section_capacity'] =0;

						}
					}
				}
				foreach($price_sections as $y=>$x){
					//remove existing
					$this->db->where('section_id',$y);
					$this->db->delete('price_sections');
					$fields = array(
						'price_event_id'		=> $x['price_event_id'],
						'price_id'				=> $x['price_id'],
						'section_id'			=> $y,
						'price_name'			=> $x['price_name'],
						'price_price'			=> $x['price_price'],
						'section_capacity'		=> $x['section_capacity'],
						);
					// insert to db
					$this->db->set($fields);
					$this->db->insert('price_sections');
				}

					// echo '<pre>';
					// print_r($price_sections);
					// echo '</pre>';
					echo 'success';
			}

	} //END PRICE SECTION CRON
	
	function generate_price_sections_per_event($event_id = false){

			// $event_id = 4447;

			if(!$event_id){

				echo 'Failed';
				die();
			}
			$this->db->where('price_event_id', $event_id);
			// $this->db->limit(1000);
			$query = $this->db->get('prices');
			if($query->num_rows() > 0){
				$result = $query->result();
				$prices = array();
				$sections = array();
				$price_sections = array();
				$sections2 = array();
				foreach($result as $x){
					$sections[$x->price_id] =  unserialize($x->price_sections);
					$sections2= array_merge(unserialize($x->price_sections), $sections2);
					$prices[$x->price_id]['price_name'] = $x->price_name;
					$prices[$x->price_id]['price_price'] = $x->price_price;
					$prices[$x->price_id]['price_event_id'] = $x->price_event_id;
				}
				
				$this->db->select('section_id, section_capacity');
				$this->db->where_in('section_id', $sections2);
				$query = $this->db->get('sections');
				$result = $query->result();
				$sections_cap = array();
				foreach($result as $x){
					$sections_cap[$x->section_id]=  $x->section_capacity;
				}
				foreach($sections as $a=>$b){
					foreach($b as $y=>$z){
						$price_sections[$z]['price_event_id'] = $prices[$a]['price_event_id'];
						$price_sections[$z]['price_id'] = $a;
						$price_sections[$z]['price_name'] =$prices[$a]['price_name'];
						$price_sections[$z]['price_price'] =$prices[$a]['price_price'];
						
						if(isset($sections_cap[$z])){
						$price_sections[$z]['section_capacity'] =$sections_cap[$z];
						}else{
						$price_sections[$z]['section_capacity'] =0;
						}
					}
				}
				foreach($price_sections as $y=>$x){
					//remove existing
					$this->db->where('section_id',$y);
					$this->db->delete('price_sections');
					$fields = array(
						'price_event_id'		=> $x['price_event_id'],
						'price_id'				=> $x['price_id'],
						'section_id'			=> $y,
						'price_name'			=> $x['price_name'],
						'price_price'			=> $x['price_price'],
						'section_capacity'		=> $x['section_capacity'],
						);
					// insert to db
					$this->db->set($fields);
					$this->db->insert('price_sections');
				}
					// echo '<pre>';
					// print_r($price_sections);
					// echo '</pre>';
		}
	} //END PRICE SECTION PER EVENT
		
}

/* End of file events.php */
/* Location: ./application/controllers/events.php */

