<?php

class Seatplans extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('venues_model', 'venues');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('sections_model', 'sections');
		$this->load->model('files_model', 'files');
		$this->load->model('events_model', 'events');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('seatplans/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// prepare data for the template
		$data['page_title'] = 'Seatplans';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get all seatplans
		$data['seatplans'] = $this->seatplans->get_seatplans();
				
		// remove the event id
		$this->session->unset_userdata('cei');
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		$this->load->view('seatplans_listing', $data);
	}

	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($seatplan_id = false)
	{
		if (!$seatplan_id) show_404();
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Event', 'Seller','Reservation','Reservation-Admin','Finance'));
		
		if ($this->session->userdata('cei'))
		{
			$event_id = $this->session->userdata('cei');
			
			// get event
			$data['event'] = $this->events->get($event_id);
		}
		
		// prepare data for the template
		$data['page_title'] = 'View Seatplan';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get seatplan
		$data['seatplan'] = $this->seatplans->get($seatplan_id);
		
		// get sections
		$arr_sid = $this->sections->get_section_ids_array($seatplan_id);
		if (count($arr_sid) > 0) {
			$sections_info = $this->sections->get_ticket_availability_sections(serialize($arr_sid), $seatplan_id, true);
		} else {
			$sections_info = array();
		}
		
		$data['sections_info'] = $sections_info;
		$data['sections'] = $this->sections->get_sections($seatplan_id);
		
		// display the page
		$this->load->view('seatplans_view', $data);
	}		
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		// prepare data for the template
		$data['page_title'] = 'Add Seatplan';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'seatplan_name',
				'label'   => 'Seatplan Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'venue_id',
				'label'   => 'Venue ID',
				'rules'   => 'trim|required|strip_tags|min_length[1]|integer'
			),
			array(
				'field'   => 'seatplan_photo',
				'label'   => 'Seatplan Picture',
				'rules'   => 'trim|strip_tags|max_length[250]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
			// get venues
			$data['venues'] = $this->venues->get_venues_dropdown();

			// display the page
			$this->load->view('seatplans_add', $data);
		}
		else
		{
			if ($_FILES['seatplan_photo']['name'])
			{
				// upload the photo; params: filename, max width, max height
				$image_path = $this->files->upload_image('seatplan_photo', 640, 1000);
			}
			else
			{
				$image_path = '';
			}
				
			$this->seatplans->add($image_path);
	
			// redirect
			$this->session->set_flashdata('message', assemble_message('Seatplan has been successfully added'));
			redirect('seatplans/listing');
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($seatplan_id = false)
	{
		if (!$seatplan_id) show_404();
		
		if ($this->session->userdata('cei'))
		{
			$event_id = $this->session->userdata('cei');
			
			// get event
			$data['event'] = $this->events->get($event_id);
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Seatplan';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'seatplan_name',
				'label'   => 'Seatplan Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'venue_id',
				'label'   => 'Venue ID',
				'rules'   => 'trim|required|strip_tags|min_length[1]|integer'
			),
			array(
				'field'   => 'seatplan_photo',
				'label'   => 'Seatplan Picture',
				'rules'   => 'trim|strip_tags|max_length[250]'
			),
			array(
				'field'   => 'seatplan_active',
				'label'   => 'Status',
				'rules'   => 'trim|strip_tags|min_length[1]|integer'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get seatplan
		$data['seatplan'] = $this->seatplans->get($seatplan_id);
		
		// get venues
		$data['venues'] = $this->venues->get_venues_dropdown();
			
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('seatplans_edit', $data);
		}
		else
		{
			if ($_FILES['seatplan_photo']['name'])
			{
				// upload the photo; params: filename, max width, max height
				$image_path = $this->files->upload_image('seatplan_photo', 640, 1000);
			}
			else
			{
				$image_path = '';
			}
			
			// save to database
			$this->seatplans->edit($seatplan_id, $image_path);
	
			// redirect
			$this->session->set_flashdata('message', assemble_message('Seatplan has been successfully modified'));
			redirect('seatplans/edit/'.$seatplan_id);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($seatplan_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Seat Plan');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->seatplans->delete($seatplan_id);
		$this->session->set_flashdata('message', assemble_message('Seatplan has been successfully deleted'));
		redirect('seatplans/listing/');
	}

	function copy($seatplan_id,$seatplan_name)
	{
	

	
/* 
	 	$data = array('column1' => $seatplan_name);
		$this->db->insert('test', $data);
		  */
		 
		// copy the seatplan
		
		$new_seatplan_id = $this->seatplans->copy_seatplan($seatplan_id,$seatplan_name);
		
		
		
		// redirect
	 	$this->session->set_userdata('cei', $new_seatplan_id);
		$this->session->set_flashdata('message', assemble_message('Seatplan has been successfully saved'));
		redirect('seatplans/listing/'); 
	}
	
	
	
	}
/* End of file seatplans.php */
/* Location: ./application/controllers/seatplans.php */	