<?php

class Sap extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('reports_model', 'reports');
		$this->load->model('sap_model', 'sap');
		$this->load->model('branches_model', 'branches');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->database('default');
		// $db['archive']['database'] = "live_dbsss";
	// $this->load->database('archive');
	
	}
	
	// --------------------------------------------------------------------



	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		
		if($this->session->userdata('user_type')=='Treasury'){
		$this->session->set_flashdata('message', assemble_message('You are not allowed to access that page'));
			redirect('reports/new_reports_opt_v1_seller/natrpb');
		}else{
			$this->session->set_flashdata('message', assemble_message('You are not allowed to access that page'));
			redirect('reports/new_reports_opt_v1_seller/natrpb');
		}
		
		// prepare data for the template
		$data['page_title'] = 'Reports';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$this->load->view('reports_index', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * view sap report
	 *
	 * @access	public
	 */
	
	
	
	function export_sap_report($branch_id=false){
		$branch_info = $this->sap->get($branch_id);
		// print_r($branch_info);
		$branch_code = str_replace(" ", "_", $branch_info->branch_code);
		
		$data['filename'] =  'SMTickets'.$branch_code.date('mdY');
		// die();						
		
		
		if(in_array($branch_id, array(3,6,7,8,9,37,48,72))){
		$data['reports'] = $this->sap->reports_sap_non_smp($branch_id);
		$this->load->view('sap_interface_non_smp_', $data);
		}else if(in_array($branch_id, array(90))){
		$data['reports'] = $this->sap->reports_sap_online($branch_id);
		$data['filename'] =  'SMTickets'.'ONLINE'.date('mdY');
		$this->load->view('sap_interface_online_', $data);
		}else if(in_array($branch_id, array(1,102,103,109,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,128,129,131,132,134,142,144))){
		$data['reports'] = $this->sap->reports_sap_non_smp($branch_id);
		$this->load->view('sap_interface_non_sm_and_office_', $data);
		}else{
		$data['reports'] = $this->sap->reports_sap_smp($branch_id);
		$ctr2 = 0;
		// $rep = $this->sap->reports_sap_smp($branch_id);
		/* foreach($rep as $key =>  $rdata){
			echo $rdata['event_id'];
			echo $prev = $rep[$ctr2]->event_id;
			$ctr2 += 1;
		}
		die(); */
		// $this->load->view('sap_interface_smp_', $data);	
		$this->load->view('sap_interface_non_smp_', $data);	
		}
	}
	
	function export_sap_report2($branch_id=false){	
		$data['branch_id'] = $branch_id;
		$this->load->view('sap_interface2',$data);
	}
	
	
	
	function email_incomplete_vendor(){
		$promoters = $this->sap->get_no_vendor_key();

		$ctr=1;
		foreach($promoters as $promoter){
			echo $ctr.'. '.$promoter->promoter_name.'</br>';
			$ctr=$ctr+1;
		}
				
	}
	
	function get_promoters_sap(){
		echo $this->sap->get_promoters_sap();
	}
	
	function save_sap_txt($branch_id,$branch_code){
		// unlink("resources/sapSMTicketsSMKL01022019.txt");
		
		// die();
		// $branch_info = $this->sap->get_branch_code($branch_id);
		// echo $branch_info->branch_code;
		// print_r($branch_info);
		// die();
		/* if($branch_id==90){
			$branch_code = "ONLINE";
		}else{
			$branch_code = str_replace(" ", "_", $branch_info->branch_code);
		} */
		// die();
		// $header = 'SMTickets'.$branch_code.date('mdY').'.txt';
		// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
		// $header = 'SMTickets'.$branch_code.date('0328Y').'.txt';
		$date = date('mdY',strtotime("-1 days"));
		$header = 'SMTickets'.$branch_code.$date.'.txt';
		// $this->load->view('sap_test');
		file_put_contents("resources/sap/".$header, file_get_contents(base_url()."sap/export_sap_report_/".$branch_id.'/'.$header));
		// file_put_contents("resources/sap".$header, file_get_contents(base_url()."sap/export_sap_report_test/".$branch_id.'/'.$header));
	}
	
	function get_sap_branches(){
		// unlink('resources/sapSMTicketsSMEO02012019.txt');
		// die();
		 ini_set('memory_limit', '-1');
		$result = $this->sap->get_sap_branches();
		// die();
		// print_r($result);
		foreach($result as $res){
			// echo $res->branches_account_id;
			
			if($res->branch_account_id==90){
				$branch_code = "ONLINE";
			}else{
				$branch_code = str_replace(" ", "_", $res->branch_code);
			}
			
			// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
			// $this->export_sap_report_($res->branch_account_id, $header);
			$this->save_sap_txt($res->branch_account_id, $branch_code);
			
		}
		$this->delete_sap_files(); 
		
		// $branch_id = "2";
		// $branch_code = "SMOA";
		
		// $this->save_sap_txt($branch_id, $branch_code);
		
	}
	
	function get_sap_branches_manual($date,$date_trans){
		// unlink('resources/sapSMTicketsSMEO02012019.txt');
		// die();
		 ini_set('memory_limit', '-1');
		$result = $this->sap->get_sap_branches();
		// die();
		// print_r($result);
		foreach($result as $res){
			// echo $res->branches_account_id;
			
			if($res->branch_account_id==90){
				$branch_code = "ONLINE";
			}else{
				$branch_code = str_replace(" ", "_", $res->branch_code);
			}
			
			// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
			// $this->export_sap_report_($res->branch_account_id, $header);
			$this->save_sap_txt_manual($res->branch_account_id, $branch_code, $date, $date_trans);
			
		}
		$this->delete_sap_files_manual($date); 
		
		// $branch_id = "2";
		// $branch_code = "SMOA";
		
		// $this->save_sap_txt($branch_id, $branch_code);
		
	}
	
	function save_sap_txt_manual($branch_id,$branch_code, $date, $date_trans){
		// unlink("resources/sapSMTicketsSMKL01022019.txt");
		
		// die();
		// $branch_info = $this->sap->get_branch_code($branch_id);
		// echo $branch_info->branch_code;
		// print_r($branch_info);
		// die();
		/* if($branch_id==90){
			$branch_code = "ONLINE";
		}else{
			$branch_code = str_replace(" ", "_", $branch_info->branch_code);
		} */
		// die();
		// $header = 'SMTickets'.$branch_code.date('mdY').'.txt';
		// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
		// $header = 'SMTickets'.$branch_code.date('0328Y').'.txt';
		// $date = date('mdY',strtotime("-1 days"));
		// $date = date('mdY',strtotime("-1 days"));
		$header = 'SMTickets'.$branch_code.$date.'.txt';
		// $this->load->view('sap_test');
		file_put_contents("resources/sap/".$header, file_get_contents(base_url()."sap/export_sap_report_manual/".$branch_id.'/'.$header.'/'.$date_trans));
		// file_put_contents("resources/sap".$header, file_get_contents(base_url()."sap/export_sap_report_test/".$branch_id.'/'.$header));
	}
	
	function export_sap_report_manual($branch_id=false, $header = false, $date = false){
		// $branch_info = $this->sap->get($branch_id);
		// print_r($branch_info);
		// $data['filename'] =  'SMTickets'.$branch_info->branch_code.date('mdY');
		// die();
		// $header = "SMTicketsSMOA03252019.txt";
		$this->load->helper('file');

		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header.'"');
		
		/* $data['reports'] = $this->sap->reports_sap_smp($branch_id);
			// echo count($data['reports']);
			// die();
			if(count($data['reports'])>0){
			echo count($data['reports']);
			$this->load->view('sap_interface_non_sm_and_office', $data);
			// die();
			} */
		if(in_array($branch_id, array(3,6,7,8,9,37,106,130))){
			// echo 'dadsa';
			// die();
			$data['reports'] = $this->sap->reports_sap_non_smp_($branch_id,$date);
			// $this->load->view('sap_interface_non_smp', $data);
			// echo "dsadsa";
			// die();
			// echo '<pre>';
			// print_r($data['reports']);
			// die();
			if(count($data['reports'])>0){
			// echo count($data['reports']);
			// die();
				
			$this->load->view('sap_interface_non_smp', $data);
			}
			// die();
		  }else if(in_array($branch_id, array(90))){
			$data['reports'] = $this->sap->reports_sap_online_($branch_id,$date);
			if(count($data['reports'])>0){
				
				$this->load->view('sap_interface_online', $data);
				$data['filename'] =  'SMTickets'.'ONLINE'.date('0328Y');
				
			}
		}else if(in_array($branch_id, array(1,102,103,109,122,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,128,129,131,134,142,144))){
			$data['reports'] = $this->sap->reports_sap_non_smp_($branch_id, $date);
			if(count($data['reports'])>0){
			
			$this->load->view('sap_interface_non_sm_and_office', $data);
			
			}
		}
		else if(in_array($branch_id, array(2,4,5,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,38,39,40,91,92,104,105,107,108,110,121,132,133,135,136,137,138,139,140,141,143,145,146,147,148))){
			 $data['reports'] = $this->sap->reports_sap_smp_($branch_id,$date);
			
			if(count($data['reports'])>0){
			
			$this->load->view('sap_interface_smp', $data);
			
			}
		}  
	}
	
	
	
	function get_sap_branches_(){
		// unlink('resources/sapSMTicketsSMEO02012019.txt');
		// die();
		ini_set('memory_limit', '-1');
		$result = $this->sap->get_sap_branches();
		// die();
		// print_r($result);
		foreach($result as $res){
			// echo $res->branches_account_id;
			
			if($res->branch_account_id==90){
				$branch_code = "ONLINE";
			}else{
				$branch_code = str_replace(" ", "_", $res->branch_code);
			}
			
			// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
			// $this->export_sap_report_($res->branch_account_id, $header);
			$this->save_sap_txt($res->branch_account_id, $branch_code);
			
		}
		$this->delete_sap_files();
	}
	
	function delete_sap_files(){
		
		$result = $this->sap->get_sap_branches();
		foreach($result as $res){
			// echo $res->branches_account_id;
			
			if($res->branch_account_id==90){
				$branch_code = "ONLINE";
			}else{
				$branch_code = str_replace(" ", "_", $res->branch_code);
			}
			
			// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
			// $this->export_sap_report_($res->branch_account_id, $header);
			// $header = 'SMTickets'.$branch_code.date('0328Y').'.txt';
			$date = date('mdY',strtotime("-1 days"));
			$header = 'SMTickets'.$branch_code.$date.'.txt';
			$this->delete_sap_report($res->branch_account_id, $header);
			
		}
	}
	
	function delete_sap_files_manual($date){
		
		$result = $this->sap->get_sap_branches();
		foreach($result as $res){
			// echo $res->branches_account_id;
			
			if($res->branch_account_id==90){
				$branch_code = "ONLINE";
			}else{
				$branch_code = str_replace(" ", "_", $res->branch_code);
			}
			
			// $header = 'SMTickets'.$branch_code.date('0102Y').'.txt';
			// $this->export_sap_report_($res->branch_account_id, $header);
			// $header = 'SMTickets'.$branch_code.date('0328Y').'.txt';
			// $date = date('mdY',strtotime("-1 days"));
			$header = 'SMTickets'.$branch_code.$date.'.txt';
			$this->delete_sap_report($res->branch_account_id, $header);
			
		}
	}
	
	
	function delete_sap_report($branch_id=false, $header = false){
		$this->load->helper('file');

		if(in_array($branch_id, array(3,6,7,8,9,37,106,130))){
			
			$data['reports'] = $this->sap->reports_sap_non_smp($branch_id);
			// $this->load->view('sap_interface_non_smp', $data);
			if(count($data['reports'])<1){

				unlink("resources/sap/".$header);
			} 
			
		  }else if(in_array($branch_id, array(90))){
			$data['reports'] = $this->sap->reports_sap_online($branch_id);
			if(count($data['reports'])<1){
				unlink("resources/sap/".$header);
			}
		}else if(in_array($branch_id, array(1,102,103,109,122,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,128,129,131,134,142,144))){
			$data['reports'] = $this->sap->reports_sap_non_smp($branch_id);
			if(count($data['reports'])<1){
				unlink("resources/sap/".$header);
			}
		}else if(in_array($branch_id, array(2,4,5,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,38,39,40,91,92,104,105,107,108,110,121,132,133,135,136,137,138,139,140,141,143,145,146,147,148))){
			$data['reports'] = $this->sap->reports_sap_smp($branch_id);
			if(count($data['reports'])<1){
				unlink("resources/sap/".$header);
			}
		}
		 /*  else{
			 $data['reports'] = $this->sap->reports_sap_smp($branch_id);
			
			if(count($data['reports'])<1){
				unlink("resources/sap".$header);
			} 
		} */   
	}
	
	// function export_sap_report_($branch_id=false){
	function export_sap_report_test($branch_id=false, $header = false){
		$this->load->view('sap_test');
	}
	function export_sap_report_($branch_id=false, $header = false){
		// $branch_info = $this->sap->get($branch_id);
		// print_r($branch_info);
		// $data['filename'] =  'SMTickets'.$branch_info->branch_code.date('mdY');
		// die();
		// $header = "SMTicketsSMOA03252019.txt";
		$this->load->helper('file');

		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header.'"');
		
		/* $data['reports'] = $this->sap->reports_sap_smp($branch_id);
			// echo count($data['reports']);
			// die();
			if(count($data['reports'])>0){
			echo count($data['reports']);
			$this->load->view('sap_interface_non_sm_and_office', $data);
			// die();
			} */
		if(in_array($branch_id, array(3,6,7,8,9,37,106,130))){
			// echo 'dadsa';
			// die();
			$data['reports'] = $this->sap->reports_sap_non_smp($branch_id);
			// $this->load->view('sap_interface_non_smp', $data);
			// echo "dsadsa";
			// die();
			// echo '<pre>';
			// print_r($data['reports']);
			// die();
			if(count($data['reports'])>0){
			// echo count($data['reports']);
			// die();
				
			$this->load->view('sap_interface_non_smp', $data);
			}
			// die();
		  }else if(in_array($branch_id, array(90))){
			$data['reports'] = $this->sap->reports_sap_online($branch_id);
			if(count($data['reports'])>0){
				
				$this->load->view('sap_interface_online', $data);
				$data['filename'] =  'SMTickets'.'ONLINE'.date('0328Y');
				
			}
		}else if(in_array($branch_id, array(1,102,103,109,122,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,128,129,131,134,142,144))){
			$data['reports'] = $this->sap->reports_sap_non_smp($branch_id);
			if(count($data['reports'])>0){
			
			$this->load->view('sap_interface_non_sm_and_office', $data);
			
			}
		}
		else if(in_array($branch_id, array(2,4,5,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,38,39,40,91,92,104,105,107,108,110,121,132,133,135,136,137,138,139,140,141,143,145,146,147,148))){
			 $data['reports'] = $this->sap->reports_sap_smp($branch_id);
			
			if(count($data['reports'])>0){
			
			$this->load->view('sap_interface_smp', $data);
			
			}
		}  
	}
	
	function trasfer_files(){
		
		/* Remote File Name and Path */
		$remote_file = 'resources/sapSMTicketsBOMOA02012019.txt';
		  
		/* FTP Account (Remote Server) */
		$ftp_host = '10.140.7.176'; /* host */
		$ftp_user_name = 'user01'; /* username */
		$ftp_user_pass = 'user_01'; /* password */
		  
		  
		/* File and path to send to remote FTP server */
		$local_file = 'resources/sapSMTicketsBOMOA02012019.txt';
		  
		/* Connect using basic FTP */
		$connect_it = ftp_connect( $ftp_host );
		  
		/* Login to FTP */
		$login_result = ftp_login( $connect_it, $ftp_user_name, $ftp_user_pass );
		  
		/* Send $local_file to FTP */
		if ( ftp_put( $connect_it, $remote_file, $local_file, FTP_BINARY ) ) {
			echo "WOOT! Thanks Munshi and OBOYOB! Successfully transfer $local_file\n";
		}
		else {
			echo "Doh! There was a problem\n";
		}
		  
		/* Close the connection */
		ftp_close( $connect_it );

		
		
	}
	
	function branch_info_edit($branch_id)
	{
		// prepare data for the template
		$data['page_title'] = 'Promoters';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		// get all branches
		$data['branch'] = $this->sap->get($branch_id);
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance'));
		
		$config = array(
			array(
				'field'   => 'company_code',
				'label'   => 'Company code',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'profit_center',
				'label'   => 'Profit center',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),	
			array(
				'field'   => 'business_place',
				'label'   => 'Business Place',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),	
			array(
				'field'   => 'cost_center',
				'label'   => 'Cost center',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'profit_center_cash',
				'label'   => 'Profit Center Cash',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'profit_center_card',
				'label'   => 'Profit Center Card',
				'rules'   => 'trim|required|strip_tags|max_length[80]'				
			
			),
			array(
				'field'   => 'cost_center_card',
				'label'   => 'Cost Center card',
				'rules'   => 'trim|strip_tags|max_length[80]'				
			
			),
			array(
				'field'   => 'cash_account',
				'label'   => 'Cash Account',
				'rules'   => 'trim|required|strip_tags|max_length[80]'				
			
			),
			array(
				'field'   => 'eplus_account',
				'label'   => 'Eplus Account',
				'rules'   => 'trim|required|strip_tags|max_length[80]'				
			
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('branches_sap_edit', $data);
		}
		else
		{	
			$this->sap->edit_sap_branch_info($branch_id);
			$this->session->set_flashdata('message', assemble_message('Branch SAP info was successfully updated.'));
			redirect('sap/branch_info_edit/'.$branch_id);
		}
		
		
		
		
	}
	
	/**
	 * payment types list
	 *
	 * @access	public
	 */
	
	function payment_types_listing(){
		$this->users->check_session(array('Admin','Super Admin','Account','Finance'));
		
		// prepare data for the template
		$data['page_title'] = 'Payment Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		// get all terminals
		$data['payment_types'] = $this->sap->get_payment_types();
		
		$this->load->view('sap_payment_types_listing', $data);
	}
	
	/**
	 * edit payment types
	 *
	 * @access	public
	 */
	function edit_payment_type($payment_type_id = FALSE)
	{
		if (! $payment_type_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Payment Type';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Account','Finance'));
			
		$config = array(
			
			array(
				'field'   => 'payment_mdr_rate',
				'label'   => 'Payment mdr rate',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
			// get events
			// $data['branches'] = $this->branches->get_branches_dropdown();	
		
		if ($this->form_validation->run() == FALSE)
		{
			// get terminal's data
			$data['payment_type'] = $this->sap->get_payment_type($payment_type_id);
			
			// display the page
			$this->load->view('sap_edit_payment_type', $data);
		}
		else
		{
			$this->sap->edit_payment_type($payment_type_id);
			$this->session->set_flashdata('message', assemble_message('Payment Type  MDR Rate has been successfully modified'));
			redirect('sap/payment_types_listing');
		}
	}
	
	function generate_txtfile($branch_id = false){
		$data['form_url'] = uri_string();
		$data['page_title'] = "Generate Txt file";
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'Date',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'branch_code',
				'label'   => 'Branch Code',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('generate_txt', $data);
		}else{
			$date = $this->input->post('date_from');
			$branch_id = $this->input->post('branch_id');
			$branch_code = $this->input->post('branch_code');
			$date_ = date_create($date);
			$format_date = date_format($date_, 'mdY');
			if($branch_id==90){
				$branch_code = "ONLINE";
			}else{
				$branch_code = str_replace(" ", "_", $branch_code);
			}
			
			$header_ =  "SMTickets".$branch_code.$format_date;
			$this->export_sap_txt($branch_id,$header_,$date);
			
		}
	}
	
	function export_sap_txt($branch_id=false, $header_ = false, $date = false){
		// $branch_info = $this->sap->get($branch_id);
		// print_r($branch_info);
		// $data['filename'] =  'SMTickets'.$branch_info->branch_code.date('mdY');
		// die();
		
		$header = $header_.'.txt';
		// die();
		$this->load->helper('file');

		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		
		$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
		if(in_array($branch_id, array(3,6,7,8,9,37))){
			
			$data['reports'] = $this->sap->reports_sap_non_smp_($branch_id,$date);
			// $this->load->view('sap_interface_non_smp', $data);
			if(count($data['reports'])>0){
				
				
				$this->load->view('sap_interface_non_smp', $data);
			}
			
		  }else if(in_array($branch_id, array(90))){
			$data['reports'] = $this->sap->reports_sap_online_($branch_id,$date);
			if(count($data['reports'])>0){
				
				$this->load->view('sap_interface_online', $data);
				$data['filename'] =  'SMTickets'.'ONLINE'.date('0102Y');
				
			}
		}else if(in_array($branch_id, array(1,102,103,109,122,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,128,129,131,132,134,142,144))){
			$data['reports'] = $this->sap->reports_sap_non_smp_($branch_id,$date);
			if(count($data['reports'])>0){
			
			$this->load->view('sap_interface_non_sm_and_office', $data);
			
			}
		}
		 else{
			 $data['reports'] = $this->sap->reports_sap_smp_($branch_id,$date);
			
			if(count($data['reports'])>0){
			
			$this->load->view('sap_interface_smp', $data);
			
			}
		}  
	}
	
	
}

/* End of file reports.php */
/* Location: ./application/controllers/reports.php */