<?php

class Reservations extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('reservations_model', 'reservations');	
		$this->load->model('transactions_model', 'transactions');		
		$this->load->model('tickets_model', 'tickets');	
		$this->load->model('customers_model', 'customers');	
		$this->load->model('reservations_model', 'reservations');	
		$this->load->model('prices_model', 'prices');
		$this->load->model('sections_model', 'sections');
		$this->load->model('events_model', 'events');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('reservations/listing');
	}
	

		// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// $this->benchmark->mark('page_start');
		// $this->benchmark->mark('query_start');
		
		$this->load->library('pagination');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin','Finance'));
		
		// constants
		$limit = $this->pagination->per_page;
		$limit = 20;
		$offset = $this->uri->segment(3);
		
		// prepare data for the template
		$data['page_title'] = 'Reservation List';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$searchkey = array();
		$searchflds = array('event_type','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			if($this->input->post($fld) != ""){
				$searchkey[ $fld ] = $this->input->post($fld);
			}
			
			$data[$fld]= $this->input->post($fld);
		}

		$data['reservations'] = $this->reservations->search_reservations($searchkey, $offset, $limit);
		
		// pagination
		$config['base_url'] = site_url('reservations/listing');
		// $config['total_rows'] = count($this->reservations->count_reservations($searchkey));
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		// $this->benchmark->mark('query_end');
		$this->load->view('reservations_listing', $data);
		// $this->benchmark->mark('page_end');
		
		// $querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		// $pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		// $this->logs->benchmark_add($querytime, $pagetime);
	}
	
		// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function eventlisting($event_id)
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin','Finance'));
				
		// prepare data for the template
		$data['page_title'] = 'Reservation List';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$data['reservations'] = $this->reservations->search_reservations_v2($event_id);
		$data['event'] = $this->events->get($event_id);		// get event
				
		$this->load->view('reservations_eventlisting', $data);
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * manager login
	 *
	 * @access	public
	 */
	function manager_login($transaction_id = false, $type = false)
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation'));
		
		// prepare data for the template
		$data['page_title'] = 'Reservation List';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['transaction_id'] = $transaction_id;
		$data['type'] = $type;
		$this->load->view('reservations_extend_validation', $data);
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * reservation view
	 *
	 * @access	public
	 */
	function view($transaction_id = false)
	{
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		if (!$transaction_id) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'Reservation Info';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Finance','Reservation-Admin'));
		
		// get data
		$data['transaction'] = $this->transactions->get($transaction_id);
		$data['customer'] = $this->customers->get($data['transaction']->transaction_customer_id);
		$data['tickets'] = $this->tickets->get_reserved_tickets($transaction_id);
		$data['reservation_expiry'] = $this->reservations->reservation_expiry($transaction_id);
		if (count($data['tickets']) > 0)
			$data['event'] =  $this->events->get($data['tickets'][0]->ticket_event_id);
		else
			$data['event'] = '';
		$data['user'] = $this->users->get($data['transaction']->transaction_user_id);
		
		$this->benchmark->mark('query_end');
		// display the page
		$this->load->view('reservations_view', $data);
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
		
	}		

// --------------------------------------------------------------------
	
	/**
	 * extend
	 *
	 * @access	public
	 */
	function extend($transaction_id = false)
	{
		if (!$transaction_id) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'Extend Reservation';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
	
		$this->form_validation->set_rules('username', 'Username', 'trim|required|strip_tags|max_length[20]|callback__check_manager_login');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|strip_tags|max_length[20]');
		$this->form_validation->set_rules('comment', 'Comment', 'trim|required|strip_tags|max_length[255]');
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get data
		$data['transaction'] = $this->transactions->get($transaction_id);
		$data['customer'] = $this->customers->get($data['transaction']->transaction_customer_id);
		$data['tickets'] = $this->tickets->get_reserved_tickets($transaction_id);

		if (count($data['tickets']) == 0)
		{
			//$this->session->set_flashdata('message', assemble_message('Tickets not found.  Please delete that transaction.'));
			redirect('reservations/listing');
		}
		
		$data['event']= $this->events->get($data['tickets'][0]->ticket_event_id);
		
		if ($this->form_validation->run() != FALSE)
		{
			$this->reservations->extend($transaction_id);
			
			$this->session->set_flashdata('message', assemble_message('Reservation date has been successfully extended'));
			
			if ($this->session->userdata('cei')) 
			{
				$event_id = $this->session->userdata('cei');
				redirect('reservations/eventlisting/' . $event_id);
			}
			else
			{
				redirect('reservations/listing');
			}
		}
		else
		{
			// display the page
			$this->load->view('reservations_extend', $data);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _check_manager_login
	 *
	 * @access	private
	 */
	function _check_manager_login($str)
	{	
		if (!$this->users->manager_login())
		{
			$this->form_validation->set_message('_check_manager_login', "Manager username and password combination is incorrect");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	// --------------------------------------------------------------------
	
	/**
	 * reservation extend
	 *
	 * @access	public
	 */
	/*function extend_date($transaction_id = false)
	{
//		if (!$transaction_id)
//		{
//			show_404();
//		}
		
		// prepare data for the template
		$data['page_title'] = 'Reservation Info';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		//restore session
		$restore_session =  $this->reservations->get_customer_id($transaction_id);	
		$customer_session_id = $restore_session->customer_id;
		$cei = $restore_session->ticket_event_id;
		$cpi = $restore_session->ticket_price_id;
		
		//$this->form_validation->set_rules($config); 
		//$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get price info
		$data['price'] =  $this->prices->get($cpi);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		// get transaction detail
		$data['transaction'] = $this->transactions->get($transaction_id);
		
		// get customer detail
		$data['customer'] = $this->customers->get($data['transaction']->transaction_customer_id);
		
		// get reservation expiry
		$data['reservation_expiry'] = $this->reservations->reservation_expiry($transaction_id);
		//print_array($data['reservation_expiry']);
		
		// get tickets
		//$data['tickets'] = $this->tickets->get_tickets('transaction', $transaction_id, $cpi);
		$data['tickets'] = $this->tickets->get_tickets_by_transaction($transaction_id, $cpi);
		// display the page
		
		//$this->load->view('reservations_extend_date', $data);
		
		if ($this->form_validation->run() == FALSE)
		{
			$data['transaction_id'] = $transaction_id;
			
			// display the page
			$this->load->view('reservations_extend_date', $data);
		}
		else
		{
			$data['events']= $this->events->reservation_expiry($this->session->userdata('cei'));
			
			print_array($data['events']);
			$this->reservations->date_extend($transaction_id, $data['tickets']->ticket_reservation_expiry, $data['events']->event_reservation_expire);
			$this->session->set_flashdata('message', assemble_message('Reservation Date has been successfully extend'));
			redirect('reservations/listing');
		}
	}	*/

	// --------------------------------------------------------------------
	
	/**
	 * cancel
	 *
	 * @access	public
	 */
	function cancel($transaction_id = false)
	{
		if (!$transaction_id) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'Cancel Reservation';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		$this->form_validation->set_rules('tickets[]', 'Ticket', 'trim|required|strip_tags');
		$this->form_validation->set_rules('username', 'Username', 'trim|required|strip_tags|max_length[20]|callback__check_manager_login');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|strip_tags|max_length[20]');
		$this->form_validation->set_rules('comment', 'Comment', 'trim|required|strip_tags|max_length[255]');
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get data
		$data['transaction'] = $this->transactions->get($transaction_id);
		$data['customer'] = $this->customers->get($data['transaction']->transaction_customer_id);
		$data['reservation_expiry'] = $this->reservations->reservation_expiry($transaction_id);
		$data['tickets'] = $this->tickets->get_reserved_tickets($transaction_id);
			
		if ($this->form_validation->run() != FALSE)
		{
			list($section_id, $ticket_count) = $this->tickets->reservation_cancel($data['transaction'], $data['tickets']);
		
			// update available tickets
			if ($section_id != 0)
			{
				$this->sections->update_available($section_id, 'increase', $ticket_count);
			}
			$message = ($ticket_count > 1) ? 'Tickets have' : 'Ticket has';
			$message .= ' been successfully cancelled';
			$this->session->set_flashdata('message', assemble_message($message));
			
			if ($this->session->userdata('cei')) 
			{
				$event_id = $this->session->userdata('cei');
				redirect('reservations/eventlisting/' . $event_id);
			}
			else
			{
				redirect('reservations/listing/');
			}
		}
		else
		{
			// display the page
			$this->load->view('reservations_cancel', $data);
		}
	}
	
	function edit($resID = false){
	  
			$data['reservation'] = $this->reservations->get_reservations_details($resID);
 			$this->load->view('reservation_dialog',$data);
		  
	}
	
	function update(){
	 
		 
			$config = array(
				array(
					'field'   => 'customer_firstname',
					'label'   => 'First Name',
					'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
				),
				array(
					'field'   => 'customer_lastname',
					'label'   => 'Last Name',
					'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
				),
				
				array(
					'field'   => 'customer_mobile',
					'label'   => 'Mobile Number',
					'rules'   => 'trim|required|strip_tags|max_length[80]'
				),
				
				array(
					'field'   => 'customer_notes',
					'label'   => 'Notes',
					'rules'   => 'trim|strip_tags|min_length[2]|max_length[255]'
				),
				 
			);
		
 
		
		 
		$this->form_validation->set_rules($config); 

 		$this->form_validation->set_error_delimiters('', '');
		if ($this->form_validation->run() == FALSE)
		{
		 
			
			echo validation_errors();
			
 		}
		else
		{
		
			$this->reservations->update_reservation();
			echo 'ok';
		}
	
	}
 

}

/* End of file reservations.php */
/* Location: ./application/controllers/reservations.php */	