<?php

class Reports extends CI_ontroller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('reports_model', 'reports');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('admin_model', 'admin');
		$this->load->database('default');
		// $db['archive']['database'] = "live_dbsss";
	// $this->load->database('archive');
	
	}
	
	// --------------------------------------------------------------------


	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		
		if($this->session->userdata('user_type')=='Treasury'){
		$this->session->set_flashdata('message', assemble_message('You are not allowed to access that page'));
			redirect('reports/new_reports_opt_v1_seller/natrpb');
		}else{
			$this->session->set_flashdata('message', assemble_message('You are not allowed to access that page'));
			redirect('reports/new_reports_opt_v1_seller/natrpb');
		}
		
		// prepare data for the template
		$data['page_title'] = 'Reports';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$this->load->view('reports_index', $data);
	}
	

	function audit_trail_new($eventgroup = "")
	{
		ini_set('memory_limit', '-1');
		//sync historical data 
		// $this->admin->copy_tickets();
		// $this->admin->copy_transactions();
		// $this->admin->copy_payments();
		// $this->admin->copy_charges();
		
		
		// ini_set("memory_limit","3200M");
	
		// $this->benchmark->mark('page_start');
		// $this->benchmark->mark('query_start');

		//$data['date_from'] = $date_from;
		//$data['date_to'] = $date_to;
		//$data['branch'] = $branch;
		$data['form_url'] = uri_string();
		$data['eventgroup'] = $eventgroup;
		
		$data['page_title'] = "New Audit Trail Report";
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|strip_tags|max_length[10]'
			),
			
			
			array(
				'field'   => 'branch_id',
				'label'   => 'Branch',
				'rules'   => 'trim|required|strip_tags|max_length[10]'
			),
			
			
			
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('reports_new_audit_trail_filter', $data);
		}
		else
		{
		 
			$data['reports'] = $this->reports->reports_filter('NEWREPORTSATR');
 
			if ($data['reports']['branch_id']!= '')
			{
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
				$data['branch_id'] = $data['reports']['branch_id'];
				if ($data['reports']['report_dl'] != '')
				{
					
					$this->load->helper('file');

					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Audit Trail Report[$date_from to $date_to].csv";
				 
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					
 					$this->load->view('reports_audit_trail_per_branch_new_dl',$data);
 				 
					
				}
				else 
				{
 					$this->load->view('reports_audit_trail_per_branch_sap',$data);
				 
					 
				}

			}
			else 
			{
				if ($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');

					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "All Branches' Audit Trail Report[$date_from to $date_to].csv";
 					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					
				 
					$this->load->view('reports_audit_trail_all_branch_new_dl',$data);
					 

					
				}
				else 
				{
 					$this->load->view('reports_audit_trail_all_branch_sap',$data);
				 
				}
			}
			 
		 
		}
	}
	
	
	
	// --------------------------------------------------------------------
	
	/**
	 * seller_filter
	 *
	 * @access	public
	 */

	function seller_filter()
	{
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		// prepare data for the template
		$data['page_title'] = 'Seller Reports';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'FOR THE PERIOD OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			/*array(
				'field'   => 'actual_spoilages',
				'label'   => 'Input Number of Spoilages',
				'rules'   => 'trim|numerical|required|strip_tags|max_length[5]'
			),
			array(
				'field'   => 'void_returns',
				'label'   => 'Input Number of Void/Returns',
				'rules'   => 'trim|numerical|required|strip_tags|max_length[5]'
			),*/
		);

		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		// get branches
		$data['branches'] = $this->branches->get_branches_dropdown();
		
		// get terminals
		$data['terminals'] = $this->terminals->get_terminals_dropdown();
		//print_array($data['terminals']);
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('reports_seller_filter', $data);
		}
		else
		{	
		
			$data['reports'] = $this->reports->reports_filter('SELLER');
			
			//echo $data['reports']['user_id']; 
			//echo $data['reports']['event_id']; 
			//echo $data['reports']['date']; 
			
			
			$data['price'] =  $this->prices->get2($data['reports']['event_id']);
			$ticket_types = $this->reports->get_ticket_types($data['reports']['event_id']);
			//print_array($ticket_types);
			if (count($ticket_types) > 0)
			{
				$count_tt_array = 0;
				$event_ticket_types = unserialize($data['price']->event_ticket_types);
				//print_array($event_ticket_types);
         		foreach ($ticket_types as $ticket_type)
        			{
            			if (in_array($ticket_type->ticket_type_id, $event_ticket_types))
            				{
                				$tt_array[$ticket_type->ticket_type_id] = $ticket_type->ticket_type_name;
								$count_tt_array = $count_tt_array + 1;
            				}
							else
							{
								//$tt_array[$ticket_type->ticket_type_id] = 'NONE';
							}
        			}
				if($count_tt_array > 0)
				{
        			$data['ticket_types'] = $tt_array;
					$data['checks_'] = 1;
					//print_array($data['ticket_types']);
				}
				else
				{
					$data['checks_'] = 0;
				}
			}
			else
			{
				$data['checks_'] = 0;
			}
		
			// For ticket type which is Status = 1
			$ticket_types_2 = $this->reports->get_ticket_types_2($data['reports']['event_id']);
			
			if (count($ticket_types_2) > 0)
			{
				$count_tt_array_2 = 0;
				$event_ticket_types_2 = unserialize($data['price']->event_ticket_types);
        			foreach ($ticket_types_2 as $ticket_type_2)
        			{
            			if (in_array($ticket_type_2->ticket_type_id, $event_ticket_types_2))
            				{
                				$tt_array_2[$ticket_type_2->ticket_type_id] = $ticket_type_2->ticket_type_name;
								$count_tt_array_2 = $count_tt_array_2 + 1;
           	 				}
							else
							{
								//$ticket_types_2 = false;
							}
					}
				if($count_tt_array_2 > 0)
				{		
        			$data['ticket_types_2'] = $tt_array_2;
					$data['check_'] = 1;
				}
				else
				{
					$data['check_'] = 0;
				}		
			}
			else
			{
				$data['check_'] = 0;
			}
			//-------------
		
			//get branches
			$data['branches'] = $this->reports->get_branch($data['reports']['event_id']);
			//print_array($data['branches']);
		
			//get events
			$data['users'] = $this->reports->get_users($data['reports']['user_id']);
			//print_array($data['users']);
		
			//get events
			$data['events'] = $this->reports->get_events($data['reports']['event_id']);

			// get prices
			$data['prices'] = $this->reports->prices($data['reports']['event_id']);
	
			// count prices
			$data['prices1'] = $this->prices->count_prices($data['reports']['event_id']);
			
			//actual spoilages
			//$data['ap'] = 

//			$this->load->helper('file');
//			$firstname = $data['users']->user_firstname;
//			$lastname = $data['users']->user_lastname;
//			$datetime = $data['reports']->reports_date;
//			$header = "$firstname $lastname's Sellers Report [$datetime].csv";
//			$this->output->set_header('Content-type: '.get_mime_by_extension($header));
//			$this->output->set_header('Content-Disposition: attachment; filename="' . $header . '"');
//			$this->load->view('reports_seller_downloadable', $data);

			if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$sel_fname = $data['users']->user_firstname;
					$sel_lname = $data['users']->user_lastname;
					$sel_name = $sel_fname . ' ' . $sel_lname;
					$eve_name = $data['events']->event_title;
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['reports_date'];
					//$date_to = $data['reports']['date_to'];
					
					$header = "$sel_name 'from' $eve_name 'Reports'[$date_from].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
			$this->benchmark->mark('query_end');
			$this->load->view('reports_seller', $data);
			$this->benchmark->mark('page_end');
			
			$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
			$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
			$this->logs->benchmark_add($querytime, $pagetime);

		}
	}
	
	function advance_sales_optimal_v5_lite($eventgroup = false, $branchkey = "", $dl = false) 
	{
		// echo 'dsad';
		// die();
		ini_set('max_execution_time', 60);
		ini_set("memory_limit","4000M");

		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sale Reports (Consolidated)';
		}
		else if ($eventgroup == 'event') {
			$data['page_title'] = 'Advance Sale Reports (Per Show)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Advance Sale Reports (Summary)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);


		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->load->view('reports_advance_sales_optimal_filter_v5', $data);
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_optimal_v5_lite',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}
			else 
			{
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				$data['event_date_from'] = $this->input->post('event_date_from');
				$data['event_date'] = $this->input->post('event_date');
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
			 
	function seller_filter_rev($eventgroup = false, $branchkey = "")
	{
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		$data['page_title'] = "Sellers's Report";

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->benchmark->mark('query_end');			
			$this->load->view('reports_seller_filter_rev', $data);
			$this->benchmark->mark('page_end');
			
			$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
			$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
			$this->logs->benchmark_add($querytime, $pagetime);	
			
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			$data['reports']['reports_date'] = $data['reports']['reports_date'];
			$data['reports']['reports_date_from'] = $data['reports']['reports_date_from'];
			$data['users'] = $this->reports->get_users($data['reports']['sellerr']);
			
			$this->benchmark->mark('query_end');
			$this->load->view('reports_seller_rev',$data);
			$this->benchmark->mark('page_end');
			
			$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
			$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
			$this->logs->benchmark_add($querytime, $pagetime);

		}
	}
	
		
	// --------------------------------------------------------------------
	
	/**
	 * seller_filter
	 *
	 * @access	public
	 */
	function audit_trail()
	{
		// prepare data for the template
		$data['page_title'] = 'Audit Trail Reports';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date_to',
				'label'   => 'FROM',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'TO',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		// get branches
		$data['branches'] = $this->branches->get_branches_dropdown();
		
		// get terminals
		$data['terminals'] = $this->terminals->get_terminals_dropdown();
		//print_array($data['terminals']);
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('reports_audit_trail_filter', $data);
		}
		else
		{	
		
			$data['reports'] = $this->reports->reports_filter('AUDIT');
			
			//get branches
			//$data['branches'] = $this->reports->get_branch($data['reports']['branch_id']);
			//print_array($data['branches']);
		
			//get events
			$data['users'] = $this->reports->get_users($data['reports']['user_id']);
			//print_array($data['users']);
		
			//get events
			$data['events'] = $this->reports->get_events($data['reports']['event_id']);			
			$this->load->view('reports_audit_trail', $data);
		}
	}
	
	function voided_transactions_seller()
	{
		// prepare data for the template
		$data['page_title'] = 'Summary of Voided Transactions by Seller';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date_to',
				'label'   => 'FROM',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'TO',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		// get branches
		$data['branches'] = $this->branches->get_branches_dropdown();
		
		// get terminals
		$data['terminals'] = $this->terminals->get_terminals_dropdown();
		//print_array($data['terminals']);
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('reports_voided_transactions_seller_filter', $data);
		}
		else
		{	
		
			$data['reports'] = $this->reports->reports_filter('AUDIT');
			
			//get branches
			//$data['branches'] = $this->reports->get_branch($data['reports']['branch_id']);
			//print_array($data['branches']);
		
			//get events
			$data['users'] = $this->reports->get_users($data['reports']['user_id']);
			//print_array($data['users']);
		
			//get events
			$data['events'] = $this->reports->get_events($data['reports']['event_id']);			
			$this->load->view('reports_voided_transactions_seller', $data);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * voided_branch_filter
	 *
	 * @access	public
	 */
	function voided_transactions()
	{
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		// prepare data for the template
		$data['page_title'] = 'Summary of Voided Transactions by Branch';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date_to',
				'label'   => 'FROM',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'TO',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		// get branches
		$data['branches'] = $this->branches->get_branches_dropdown();
		
		// get terminals
		$data['terminals'] = $this->terminals->get_terminals_dropdown();
		//print_array($data['terminals']);
		if ($this->form_validation->run() == FALSE)
		{
			$this->benchmark->mark('query_end');
			// display the page
			$this->load->view('reports_voided_transactions_filter', $data);
			$this->benchmark->mark('page_end');
			
			$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
			$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
			$this->logs->benchmark_add($querytime, $pagetime);


		}
		else
		{	
		
			$data['reports'] = $this->reports->reports_filter2('AUDIT');
			
			//get branches
			$data['branches'] = $this->reports->get_branch($data['reports']['branch_id']);
			//print_array($data['branches']);
		
			//get events
			//$data['users'] = $this->reports->get_users($data['reports']['user_id']);
			//print_array($data['users']);
		
			//get events
			$data['events'] = $this->reports->get_events($data['reports']['event_id']);	

			$this->benchmark->mark('query_end');
			$this->load->view('reports_voided_transactions', $data);
			$this->benchmark->mark('page_end');

			$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
			$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
			$this->logs->benchmark_add($querytime, $pagetime);

		}
	}
				
	// --------------------------------------------------------------------

	/**
	 * audit_filter
	 *
	 * @access	public
	 */
	function audit_trail2()
	{		
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		// prepare data for the template
		$data['page_title'] = 'Audit Trail Reports';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date_to',
				'label'   => 'FROM',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'TO',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'branch_id',
				'label'   => 'Select Branch',
				'rules'	  => 'required'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		// get branches
		$data['branches'] = $this->reports->get_branches_dropdown_for_cc();
		
		// get terminals
		$data['terminals'] = $this->terminals->get_terminals_dropdown();
		//print_array($data['terminals']);
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('reports_audit_trail_filter2', $data);
		}
		else
		{	
		
			$data['reports'] = $this->reports->reports_filter2('AUDIT');
			
			//get branches
			$data['branches'] = $this->reports->get_branch($data['reports']['branch_id']);
			//print_array($data['branches']);
		
			//get events
			//$data['users'] = $this->reports->get_users($data['reports']['user_id']);
			//print_array($data['users']);
		
			//get events
			$data['events'] = $this->reports->get_events($data['reports']['event_id']);	
			
			$this->benchmark->mark('query_end');
			$this->load->view('reports_audit_trail2', $data);
			$this->benchmark->mark('page_end');
			
			$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
			$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
			$this->logs->benchmark_add($querytime, $pagetime);

		}
	}
	
	// --------------------------------------------------------------------

	/**
	 * audit_filter
	 *
	 * @access	public
	 */
	function consolidated_audit_trail()
	{
		// prepare data for the template
		$data['page_title'] = 'Audit Trail Reports';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date_to',
				'label'   => 'FROM',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'TO',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		// get branches
		$data['branches'] = $this->branches->get_branches_dropdown();
		
		// get terminals
		$data['terminals'] = $this->terminals->get_terminals_dropdown();
		//print_array($data['terminals']);
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('reports_consolidated_audit_filter', $data);
		}
		else
		{	
		
			$data['reports'] = $this->reports->reports_filter2('AUDIT');
			
			//get branches
			//$data['branches'] = $this->reports->get_branch($data['reports']['branch_id']);
			//print_array($data['branches']);
		
			//get events
			//$data['users'] = $this->reports->get_users($data['reports']['user_id']);
			//print_array($data['users']);
		
			//get events
			$data['events'] = $this->reports->get_events($data['reports']['event_id']);			
			$this->load->view('reports_consolidated_audit', $data);
		}
	}

	
	// --------------------------------------------------------------------	
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// prepare data for the template
		$data['page_title'] = 'Reports';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$this->load->view('reports_listing', $data);
	}

	// --------------------------------------------------------------------
	
	/**
	 * seller reports
	 *
	 * @access	public
	 */
	function seller_reports()
	{
/*		// prepare data for the template
		$data['page_title'] = 'Seller Reports';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		$data['price'] =  $this->prices->get('1');
		$ticket_types = $this->reports->get_ticket_types('1');
		$event_ticket_types = unserialize($data['price']->event_ticket_types);
         foreach ($ticket_types as $ticket_type)
        {
            if (in_array($ticket_type->ticket_type_id, $event_ticket_types))
            {
                $tt_array[$ticket_type->ticket_type_id] = $ticket_type->ticket_type_name;
            }
        }
        $data['ticket_types'] = $tt_array;
		
		// For ticket type which is Status = 0
		$ticket_types_2 = $this->reports->get_ticket_types_2('1');
		$event_ticket_types_2 = unserialize($data['price']->event_ticket_types);
         foreach ($ticket_types_2 as $ticket_type_2)
        {
            if (in_array($ticket_type_2->ticket_type_id, $event_ticket_types_2))
            {
                $tt_array_2[$ticket_type_2->ticket_type_id] = $ticket_type_2->ticket_type_name;
            }
        }
        $data['ticket_types_2'] = $tt_array_2;		
		//-------------
		
		//get branches
		$data['branches'] = $this->reports->get_branch('1');
		//print_array($data['branches']);
		
		//get events
		$data['users'] = $this->reports->get_users('1');
		//print_array($data['users']);
		
		//get events
		$data['events'] = $this->reports->get_events('1');

		// get prices
		$data['prices'] = $this->reports->prices('1');
	
		// count prices
		$data['prices1'] = $this->prices->count_prices('1');

		$this->load->view('reports_seller', $data);*/
	}	
	
	function advance_sales_in_day($eventgroup = false, $event_date = false, $dl = false) 
	{
		ini_set("memory_limit","3000M");
		// ini_set("max_execution_time", 120);
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$event_info = explode(".",$event_date);
		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		// $data['event_day'] = $event_day;
		$data['eventgroup'] = $eventgroup;
		$data['event_day'] = $event_info[0];
		$data['event_id'] = $event_info[1];
		$data['branch_id'] = $event_info[2];
		
		
		
		// die();
		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sale Reports (Consolidated)';
		}
		else if ($eventgroup == 'dtd_event') {
			$data['page_title'] = 'Advance Sale Reports (Per Show)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Advance Sale Reports (Summary)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		
		$data['page_title'] = 'Advance Sale Reports (Per Show)';

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				// if (($data['reports']['report_dl'] != '')  || ($dl))
				// {
					// $this->load->helper('file');
					// if ($eventgroup == 'conso')
					// {
						// $rep_type = "(Consolidated)";
					// }
					// {
					// else
						// $rep_type = "(Event)";
					// }
					// $datet = $data['reports']['reports_date'];
					// $date_from = $data['reports']['reports_date_from'];
					
					// if ($date_from != '')
					// {
						// $header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					// }
					// else 
					// {
						// $header = "Advance Sales Report $rep_type [$datet].csv";
					// } 
					// echo $header;
					// $this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					// $this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				// }
				
				$data["referrer"] = $this->input->get_post("referrer");
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_in_day',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}else{
				
				
				
				
				// if ($data['reports']['report_dl'] != '')
				// { 
					// $this->load->helper('file');
					// $datet = $data['reports']['reports_date'];
						
					// $header = "Advance Sales Report (Summary) [$datet].csv";
					// echo $header;
					// $this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					// $this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				// }
				
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		
	}
	
	function advance_sales_optimal_v3($eventgroup = false, $branchkey = "", $dl = false) 
	{
		ini_set("memory_limit","3000M");
		// ini_set("max_execution_time", 120);
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sale Reports (Consolidated)';
		}
		else if ($eventgroup == 'event') {
			$data['page_title'] = 'Advance Sale Reports (Per Show)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Advance Sale Reports (Summary)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);


		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->load->view('reports_advance_sales_optimal_filter', $data);
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				$data["referrer"] = $this->input->get_post("referrer");
				$data["date_validity"] = $this->input->get_post("event_dates");
				
				
				
				$this->benchmark->mark('query_end');
				/* if ($eventgroup == 'conso'){
				$this->load->view('reports_advance_sales_optimal_conso',$data);
				}else if($eventgroup == 'event'){
					$this->load->view('reports_advance_sales_optimal',$data);
				} */
				
				$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}else{
				
				
				
				
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	function advance_sales_optimal_consolidated($eventgroup = false, $branchkey = "", $dl = false) 
	{
		ini_set("memory_limit","8000M");
		// ini_set("max_execution_time", 120);
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sale Reports (Consolidated)';
		}
		else if ($eventgroup == 'event') {
			$data['page_title'] = 'Advance Sale Reports (Per Show)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Advance Sale Reports (Summary)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);


		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->load->view('reports_advance_sales_optimal_filter', $data);
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				$data["referrer"] = $this->input->get_post("referrer");
				
				$this->benchmark->mark('query_end');
				
				$this->load->view('reports_advance_sales_optimal_conso',$data);
				
				
				// $this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}else{
				
				
				
				
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	function day_to_day_report($eventgroup = false, $branchkey = "", $dl = false) 
	{
		ini_set("memory_limit","3000M");
		// ini_set("max_execution_time", 120);
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sale Reports (Consolidated)';
		}
		else if ($eventgroup == 'day_event') {
			$data['page_title'] = 'Summary of Daily Sales (Per event)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Summary of Daily Sales (Per event)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			$data['ticket_types'] = $this->ticket_types->get_ticket_types_dropdown_sort();
			// display the page
			$this->load->view('reports_advance_sales_optimal_filter', $data);
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				$data["referrer"] = $this->input->get_post("referrer");
				$data["branch_id"] = $this->input->get_post("branch_id");
				$data['branchess'] = $this->branches->get(131);
				$data['ticket_types'] = $this->input->get_post("ticket_types");

				$this->benchmark->mark('query_end');
				$this->load->view('reports_day_to_day_summary',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}else{
				
				
				
				
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	function day_to_day_refund_report($eventgroup = false, $branchkey = "", $dl = false) 
	{
		$this->users->check_session(array('Admin','Super Admin', 'Finance'));
		ini_set("memory_limit","3000M");
		// ini_set("max_execution_time", 120);
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;
		$data['report_type'] = 'refund';
		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sale Reports (Consolidated)';
		}
		else if ($eventgroup == 'event') {
			$data['page_title'] = 'Day to Day Refund Report (Per event)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Day to Day Refund Report (Per event)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);


		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->load->view('reports_advance_sales_optimal_filter', $data);
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				$data["referrer"] = $this->input->get_post("referrer");
				$data["branch_id"] = $this->input->get_post("branch_id");
				$this->benchmark->mark('query_end');
				$this->load->view('reports_refund_day_to_day_summary',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}else{
				
				
				
				
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}


	function per_venue_and_type($eventgroup = false, $branchkey, $dl = false) 
	{
		$this->users->check_session(array('Admin','Super Admin', 'Finance'));
		ini_set("memory_limit","3000M");
		// ini_set("max_execution_time", 120);
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sale Reports (Consolidated)';
		}
		else if ($eventgroup == 'event') {
			$data['page_title'] = 'Per Venue and Type Report';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Advance Sale Reports (Summary)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);
		if($branchkey){
			$data['venue'] = 'venue';
			$branchkey="venue";
			$data['event_date_from'] = $this->input->post('event_date_from');
			$data['event_date'] = $this->input->post('event_date');
			$data['event_type'] = $this->input->get_post("event_type");
			$data['reports_date'] = $this->input->get_post("reports_date");
			$data['reports_date_from'] = $this->input->get_post("reports_date_from");
			$data['venue_category'] = $this->input->get_post("venue_category");
		}
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->load->view('reports_per_venue_per_type_filter', $data);
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				// $data
				$data["referrer"] = $this->input->get_post("referrer");
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_per_venue_per_type',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}else{
				
				
				
				
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	
	
			
	function advance_sales_optimal_new_v4($eventgroup = false, $branchkey = "", $dl = false) 
	{
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sale Reports (Consolidated)';
		}
		else if ($eventgroup == 'event') {
			$data['page_title'] = 'Advance Sale Reports (Per Show)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Advance Sale Reports (Summary)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);


		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->load->view('reports_advance_sales_optimal_filter', $data);
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_optimal_v4',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}
			else 
			{
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	function new_detailed_sales_summary(){
	
	$this->benchmark->mark('page_start');
	$this->benchmark->mark('query_start');

	$data['form_url'] = uri_string();
	
	$data['page_title'] = "New Detailed Sales Summary - Online Report";
	$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
	// log this
	$this->logs->add($data['page_title']);

	// check user session
	$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
		
	$config = array(
		array(
			'field'   => 'date_from',
			'label'   => 'From',
			'rules'   => 'trim|required|required|strip_tags|max_length[10]'
		),
		array(
			'field'   => 'date_to',
			'label'   => 'To',
			'rules'   => 'trim|required|required|strip_tags|max_length[10]'
		),
	);
	
	$this->form_validation->set_rules($config); 
	
	$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
	if ($this->form_validation->run() == FALSE) 
	{
		// display the page
		$this->load->view('new_detailed_sales_summary_filter', $data);
	}
	else
	{
		$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
		if($data['reports']['report_dl'] != '')
		{
			$this->load->helper('file');
			
			$branch_name = 'Online Branch';
			$date_from =$data['reports']['date_from'];
			$date_to = $data['reports']['date_to'];
			
			$header = "$branch_name's Detailed Sales Summary Online[$date_from to $date_to].csv";
			$this->output->set_header('Content-type: '.get_mime_by_extension($header));
			$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
		}
		
		
		$this->benchmark->mark('query_end');
		$this->load->view('reports_dsso_new',$data);
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
	}
	}
	
	function new_reports_opt_v1($eventgroup = "")
	{
			
		ini_set("memory_limit","3200M");
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		//$data['date_from'] = $date_from;
		//$data['date_to'] = $date_to;
		//$data['branch'] = $branch;
		$data['form_url'] = uri_string();
		$data['eventgroup'] = $eventgroup;
		
		if ($eventgroup == 'cc')
		{
			$data['page_title'] = "Convenience Charge Report";
			
			// get branches
			$data['branches'] = $this->branches->get_branches_dropdown();
		}
		elseif ($eventgroup == 'tr')
		{
			$this->users->check_session(array('Admin','Super Admin', 'Finance'));	
			$data['page_title'] = "Ticket Reservation Report";
		}
		elseif ($eventgroup == 'dsso')
		{
			$this->users->check_session(array('Admin','Super Admin', 'Finance'));	
			$data['page_title'] = "Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'dss')
		{
			$this->users->check_session(array('Admin','Super Admin', 'Finance'));	
			$data['page_title'] = "Detailed Sales Summary Report";
		}
		elseif ($eventgroup == 'natrpb')
		{
			$data['page_title'] = "New Audit Trail Report";
		}
		elseif ($eventgroup == 'ndsso')
		{
			$data['page_title'] = "New Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'nsvspb')
		{
			$data['page_title'] = "New Summary of Voided Sales (Per Branch) Report";
		}
		elseif ($eventgroup == 'nsvspbn')
		{
			$data['page_title'] = "New Summary of Voided Sales (Per Branch) Report -Audit";
		}
		elseif ($eventgroup == 'upgrade_tickets')
		{
			$data['page_title'] = "Summary of Upgraded Ticket Sales (Per Branch)";
		}
		elseif ($eventgroup == 'otc')
		{
			$data['page_title'] = "Online Transaction Report";
		}
		elseif ($eventgroup == 'ei')
		{
			$data['page_title'] = "Daily Sales Report on E-Invoicing";
		}
		else 
		{
			redirect($data['form_url'].'/event/');
		}
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('reports_new_reports_opt_filter', $data);
		}
		else
		{
			if($eventgroup == 'cc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif($eventgroup == 'tr')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Ticket Reservation Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_ticket_reservation',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dsso')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_online_detailed_sales',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dss')
			{
				ini_set("memory_limit","1500M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				$this->benchmark->mark('query_end');
				$this->load->view('reports_detailed_sales',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'natrpb')
			{
				
				

				// ini_set("memory_limit","1024M");
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSATR');
				//print_r($data['reports']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				if ($data['reports']['branch_id']!= '')
				{
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$data['branch_id'] = $data['reports']['branch_id'];
					if ($data['reports']['report_dl'] != '')
					{
						
						$this->load->helper('file');

						$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "$branch_name's Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						// $this->output->cache(60);
						$this->load->view('reports_audit_trail_per_branch_newest',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}

				}
				else 
				{
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');

						//$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "All Branches' Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}
				}
			}
			elseif ($eventgroup == 'ndsso')
			{
				ini_set("memory_limit","1000M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = 'Online Branch';
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Detailed Sales Summary Online[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_dsso_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);


			}
			elseif ($eventgroup == 'nsvspb')
			{
			
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSSVS');
				
				//echo $data['reports']['branch_id'];

				
				if ($data['reports']['report_view'] != '' and $data['reports']['branch_id'] != '')
				{
				
					//retrieve needed branch details --> as of 12-07-2010 only branch name
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					

					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);

				}
				elseif($data['reports']['report_view'] != '' and $data['reports']['branch_id'] == '')

				{

					$this->benchmark->mark('query_end');		
					$this->load->view('reports_svsab_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] == '')
				{
					$this->load->helper('file');
                                        //$branch_name = $data['branch_details'][0]->branch_name;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales all Branches[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svsab_new_dl',$data);

					$this->benchmark->mark('page_end');

					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] != '')
				{
					$this->load->helper('file');
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales by Branch[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				
			}elseif ($eventgroup == 'nsvspbn')
			{
				
			 
			
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSSVS');
				
				//echo $data['reports']['branch_id'];

				
				if ($data['reports']['report_view'] != '' and $data['reports']['branch_id'] != '')
				{
				
					//retrieve needed branch details --> as of 12-07-2010 only branch name
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					

					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new2',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);

				}
				elseif($data['reports']['report_view'] != '' and $data['reports']['branch_id'] == '')

				{

					$this->benchmark->mark('query_end');		
					// $this->load->view('reports_svsab_new2',$data);
					$this->load->view('reports_svspb_new2',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] == '')
				{
					$this->load->helper('file');
                                        //$branch_name = $data['branch_details'][0]->branch_name;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales all Branches[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svsab_new2_dl',$data);

					$this->benchmark->mark('page_end');

					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] != '')
				{
					$this->load->helper('file');
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales by Branch[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new2',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				
			}
			elseif ($eventgroup == 'upgrade_tickets')
			{
				
			 
			
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSSVS');
				
				//echo $data['reports']['branch_id'];

				
				if ($data['reports']['report_view'] != '' and $data['reports']['branch_id'] != '')
				{
				
					//retrieve needed branch details --> as of 12-07-2010 only branch name
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					

					$this->benchmark->mark('query_end');
					$this->load->view('reports_upgrade_tickets',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);

				}
				elseif($data['reports']['report_view'] != '' and $data['reports']['branch_id'] == '')

				{
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$this->benchmark->mark('query_end');		
					$this->load->view('reports_upgrade_tickets',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] == '')
				{
					$this->load->helper('file');
                                        //$branch_name = $data['branch_details'][0]->branch_name;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales all Branches[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svsab_new2_dl',$data);

					$this->benchmark->mark('page_end');

					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] != '')
				{
					$this->load->helper('file');
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales by Branch[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_upgrade_tickets',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				
			}
			
			elseif ($eventgroup == 'otc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('REPORTSOTC');
				$data['events'] = $this->reports->get_events($data['reports']['event_id']);
				$data['users'] = $this->reports->get_users($data['reports']['user_id']);
				$data['branch_details'] = $this->reports->get_branch($data['reports']['branch_id']);
				//$data['terminals'] = $this->reports->get_terminal_details($data['reports']['terminal_id']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				//$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');
						error_reporting(0);
						
						$branch_name = $data['branch_details']->branch_name;
						$eve_name = $data['events']->event_title;
						$otc_fname = $data['users']->user_firstname;
						$otc_lname = $data['users']->user_lastname;
						$otc_name = $otc_fname . ' ' . $otc_lname;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						if($branch_name == '' || $eve_name == '' || $otc_lname == '')
						{
							$header = "All Events All Branch All Users [$date_from to $date_to].csv";
						}
						else 
						{
							$header = "$eve_name $branch_name $otc_name [$date_from to $date_to].csv";
						}
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						//}
					}
					
				$this->benchmark->mark('query_end');
				$this->load->view('reports_otc',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}elseif($eventgroup == 'ei')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets_invoicing',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	function new_reports_opt_v1_2016($eventgroup = "")
	{
			
		ini_set("memory_limit","3000M");
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		//$data['date_from'] = $date_from;
		//$data['date_to'] = $date_to;
		//$data['branch'] = $branch;
		$data['form_url'] = uri_string();
		$data['eventgroup'] = $eventgroup;
		
		if ($eventgroup == 'cc')
		{
			$data['page_title'] = "Convenience Charge Report";
			
			// get branches
			$data['branches'] = $this->branches->get_branches_dropdown();
		}
		elseif ($eventgroup == 'tr')
		{
			$data['page_title'] = "Ticket Reservation Report";
		}
		elseif ($eventgroup == 'dsso')
		{
			$data['page_title'] = "Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'dss')
		{
			$data['page_title'] = "Detailed Sales Summary Report";
		}
		elseif ($eventgroup == 'natrpb')
		{
			$data['page_title'] = "New Audit Trail Report";
		}
		elseif ($eventgroup == 'ndsso')
		{
			$data['page_title'] = "New Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'nsvspb')
		{
			$data['page_title'] = "New Summary of Voided Sales (Per Branch) Report";
		}
		elseif ($eventgroup == 'otc')
		{
			$data['page_title'] = "Online Transaction Report";
		}
		elseif ($eventgroup == 'ei')
		{
			$data['page_title'] = "Daily Sales Report on E-Invoicing";
		}
		else 
		{
			redirect($data['form_url'].'/event/');
		}
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('reports_new_reports_opt_filter', $data);
		}
		else
		{
			if($eventgroup == 'cc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif($eventgroup == 'tr')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Ticket Reservation Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_ticket_reservation',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dsso')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_online_detailed_sales',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dss')
			{
				ini_set("memory_limit","1500M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				$this->benchmark->mark('query_end');
				$this->load->view('reports_detailed_sales',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'natrpb')
			{
				// ini_set("memory_limit","1024M");
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSATR');
				//print_r($data['reports']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				if ($data['reports']['branch_id']!= '')
				{
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$data['branch_id'] = $data['reports']['branch_id'];
					if ($data['reports']['report_dl'] != '')
					{
						
						$this->load->helper('file');

						$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "$branch_name's Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_newest',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}

				}
				else 
				{
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');

						//$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "All Branches' Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}
				}
			}
			elseif ($eventgroup == 'ndsso')
			{
				ini_set("memory_limit","1000M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = 'Online Branch';
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Detailed Sales Summary Online[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_dsso_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);


			}
			elseif ($eventgroup == 'nsvspb')
			{
			
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSSVS');
				
				//echo $data['reports']['branch_id'];

				
				if ($data['reports']['report_view'] != '' and $data['reports']['branch_id'] != '')
				{
				
					//retrieve needed branch details --> as of 12-07-2010 only branch name
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					

					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new_2016',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);

				}
				elseif($data['reports']['report_view'] != '' and $data['reports']['branch_id'] == '')

				{

					$this->benchmark->mark('query_end');		
					$this->load->view('reports_svsab_new_2016',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] == '')
				{
					$this->load->helper('file');
                                        //$branch_name = $data['branch_details'][0]->branch_name;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales all Branches[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svsab_new_dl',$data);

					$this->benchmark->mark('page_end');

					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] != '')
				{
					$this->load->helper('file');
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales by Branch[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				
			}
			elseif ($eventgroup == 'otc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('REPORTSOTC');
				$data['events'] = $this->reports->get_events($data['reports']['event_id']);
				$data['users'] = $this->reports->get_users($data['reports']['user_id']);
				$data['branch_details'] = $this->reports->get_branch($data['reports']['branch_id']);
				//$data['terminals'] = $this->reports->get_terminal_details($data['reports']['terminal_id']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				//$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');
						error_reporting(0);
						
						$branch_name = $data['branch_details']->branch_name;
						$eve_name = $data['events']->event_title;
						$otc_fname = $data['users']->user_firstname;
						$otc_lname = $data['users']->user_lastname;
						$otc_name = $otc_fname . ' ' . $otc_lname;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						if($branch_name == '' || $eve_name == '' || $otc_lname == '')
						{
							$header = "All Events All Branch All Users [$date_from to $date_to].csv";
						}
						else 
						{
							$header = "$eve_name $branch_name $otc_name [$date_from to $date_to].csv";
						}
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						//}
					}
					
				$this->benchmark->mark('query_end');
				$this->load->view('reports_otc',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}elseif($eventgroup == 'ei')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets_invoicing',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}


	
	function advance_sales_optimal_new_v1($asr_type = false, $branchkey = false, $dl = false)
	{
		$this->users->check_session(array('Admin','Super Admin', 'Finance'));
		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $asr_type;

		// prepare data for the template
		if ($asr_type == 'conso') {
			$data['page_title'] = 'NEW Advance Sale Reports (Consolidated)';
		}
		else if ($asr_type == 'event') {
			$data['page_title'] = 'Advance Sale Reports 2 (Per Show)';
		}
		else if ($asr_type == 'summary') {
			$data['page_title'] = 'NEW Advance Sale Reports (Summary)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);

		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->load->view('reports_advance_sales_optimal_filter_new', $data);
		}
		else
		{
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($asr_type == 'event')
			{
				$this->load->view('reports_advance_sales_optimal_new', $data);
			}
			else 
			{
				$this->load->view('reports_advance_sales_optimal_new', $data);
			}
		}
	}
	
	function advance_sales_optimal_new($asr_type = "")
	{
		redirect("/reports/advance_sales_optimal_new_v1/$asr_type");
	}
	
	function advance_sales_optimal($eventgroup = "") {
		redirect("/reports/advance_sales_optimal_v3/$eventgroup");
	}

	function new_reports_opt($eventgroup = "")
	{
		redirect("/reports/new_reports_opt_v1/$eventgroup");
	}
	
		function new_reports_opt_2016($eventgroup = "")
	{
		redirect("/reports/new_reports_opt_v1_2016/$eventgroup");
	}
	
	function asr_allevents() {
		redirect("/reports/advance_sales_optimal_allevents");


	}

	function advance_sales_optimal_allevents($eventgroup = false, $branchkey = "") 
	{
		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		$data['page_title'] = 'Advance Sale Reports (For All Events)';
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$this->load->view('reports_advance_sales_optimal_allevents',$data);
		
	}
	
	function archive($year=false){
	
	$this->session->set_userdata('year', $year);
	redirect('archive/report_list');
	
	}
	
	function advance_sales_optimal_v5($eventgroup = false, $branchkey = "", $dl = false) 
	{
		ini_set('max_execution_time', 60);
		ini_set("memory_limit","4000M");

		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sale Reports (Consolidated)';
		}
		else if ($eventgroup == 'event') {
			$data['page_title'] = 'Advance Sale Reports (Per Show)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Advance Sale Reports (Summary)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);


		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->load->view('reports_advance_sales_optimal_filter_v5', $data);
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_optimal_v5',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}
			else 
			{
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				$data['event_date_from'] = $this->input->post('event_date_from');
				$data['event_date'] = $this->input->post('event_date');
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	function advance_sales_optimal_v5_2016($eventgroup = false, $branchkey = "", $dl = false) 
	{
		ini_set('max_execution_time', 60);
		ini_set("memory_limit","4000M");

		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sale Reports (Consolidated)';
		}
		else if ($eventgroup == 'event') {
			$data['page_title'] = 'Advance Sale Reports (Per Show)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Advance Sale Reports (Summary)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);


		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->load->view('reports_advance_sales_optimal_filter_v5', $data);
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_optimal_v5_2016',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}
			else 
			{
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				$data['event_date_from'] = $this->input->post('event_date_from');
				$data['event_date'] = $this->input->post('event_date');
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	function advance_sales_optimal_v5_new($eventgroup = false, $branchkey = "", $dl = false) 
	{
		
		$this->users->check_session(array('Admin','Super Admin', 'Finance'));
		ini_set("memory_limit","10000M");
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sale Reports (Consolidated)';
		}
		else if ($eventgroup == 'event') {
			$data['page_title'] = 'Advance Sale Reports (Per Show)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Advance Sale Reports (Summary)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'event_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);


		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->load->view('reports_advance_sales_optimal_filter_v5_new', $data);
		}
		else
		{
			ini_set("memory_limit","10000M");
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_optimal_v5',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}
			else 
			{
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				$data['event_date_from'] = $this->input->post('event_date_from');
				$data['event_date'] = $this->input->post('event_date');
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	function bir_report(){
		$this->users->check_session(array('Admin','Super Admin', 'Finance'));
		$data['page_title'] = 'BIR REPORTS';
		$data['form_url'] = uri_string();
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('bir_reports_filter', $data);
		}
		else
		{
			$result = $this->reports->get_bir_reports();
			
			// echo '<pre>';
			// print_r($result);
			// echo '</pre><br>';
			 
			$data['date_from'] = $this->input->post('date_from');
			$data['date_to'] = $this->input->post('date_to');
			 
			$data['total'] = 0;
			$data['vatsales'] = 0;
			$data['count'] = 0;
			foreach($result as $x){
				
				$data['receipt'][] =  $x->transaction_receipt_number;
				$data['total'] +=  $x->charge_amount;
				$data['count'] += 1;
				 
				
			}
			
			$data['vatamount'] = $data['total'] / 1.12 * .12;
			$data['vatsales'] = $data['total'] - $data['vatamount'];
			$data['count'] = $data['count'] - 1;
			
			// echo '<pre>';
			// print_r($data);
			// echo '</pre>';
			
			
			$this->load->view('bir_report' , $data);
		
		
		}
	}
	
	function regular_transaction_report(){
		
		
		$this->load->view('regular_transaction_report');

	}
	
/* 		function day_to_day_report($eventgroup = false, $branchkey = "", $dl = false) 
	{
		ini_set("memory_limit","3000M");
		// ini_set("max_execution_time", 120);
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sale Reports (Consolidated)';
		}
		else if ($eventgroup == 'event') {
			$data['page_title'] = 'Day to Day report (Per event)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Day to Day report (Per event)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);


		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->load->view('reports_advance_sales_optimal_filter', $data);
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				$data["referrer"] = $this->input->get_post("referrer");
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_day_to_day_summary',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}else{
				
				
				
				
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	} */
	
		function event_by_long_title($eventgroup = false, $branchkey = "", $dl = false) 
	{
		ini_set("memory_limit","3000M");
		// ini_set("max_execution_time", 120);
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Event by Long Title';
		}
		else if ($eventgroup == 'event') {
			$data['page_title'] = 'Advance Sale Reports (Per Show)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Advance Sale Reports (Summary)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);


		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			$this->load->view('reports_event_by_long_title_filter', $data);
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				$data['ticket_types'] = $this->input->get_post("ticket_types");
				$data["referrer"] = $this->input->get_post("referrer");
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_event_by_long_title',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}else{
				
				
				
				
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	function sales_report($eventgroup = false, $branchkey = "", $dl = false) 
	{
		ini_set("memory_limit","3000M");
		// ini_set("max_execution_time", 120);
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sale Reports (Consolidated)';
		}
		else if ($eventgroup == 'day_event') {
			$data['page_title'] = 'Sales Report (Per event)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Summary of Daily Sales (Per event)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			$data['ticket_types'] = $this->ticket_types->get_ticket_types_dropdown_sort();
			// display the page
			$this->load->view('reports_advance_sales_optimal_filter', $data);
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				$data["referrer"] = $this->input->get_post("referrer");
				$data["branch_id"] = $this->input->get_post("branch_id");
				$data['branchess'] = $this->branches->get(131);
				$data['ticket_types'] = $this->input->get_post("ticket_types");

				$this->benchmark->mark('query_end');
				$this->load->view('reports_sales_report',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}else{
				
				
				
				
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_sales_report',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}

	function advance_sales_consolidated_v2($eventgroup = false, $branchkey = "", $dl = false) 
	{
		ini_set("memory_limit","3000M");
		// ini_set("max_execution_time", 120);
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['branchkey'] = $branchkey;
		$data['eventgroup'] = $eventgroup;

		// prepare data for the template
		if ($eventgroup == 'conso') {
			$data['page_title'] = 'Advance Sales Report (Consolidated v2)';
		}
		else if ($eventgroup == 'event') {
			$data['page_title'] = 'Advance Sale Reports (Per Show)';
		}
		else if ($eventgroup == 'summary') {
			$data['page_title'] = 'Advance Sale Reports (Summary)';
		}
		else {
			redirect($data['form_url'].'/event/');
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'reports_date',
				'label'   => 'AS OF',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'reports_date_from',
				'label'   => 'AS OF',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
		);


		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if (!is_numeric($branchkey) && ($this->form_validation->run() == FALSE))
		{
			// display the page
			// $this->load->view('reports_event_by_long_title_filter', $data);
			$this->load->view('reports_advance_sales_optimal_filter', $data);
		}
		else
		{
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			
			if ($eventgroup != 'summary')
			{
				if (($data['reports']['report_dl'] != '')  || ($dl))
				{
					$this->load->helper('file');
					if ($eventgroup == 'conso')
					{
						$rep_type = "(Consolidated)";
					}
					else
					{
						$rep_type = "(Event)";
					}
					$datet = $data['reports']['reports_date'];
					$date_from = $data['reports']['reports_date_from'];
					
					if ($date_from != '')
					{
						$header = "Advance Sales Report $rep_type [$date_from to $datet].csv";
					}
					else 
					{
						$header = "Advance Sales Report $rep_type [$datet].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				$data['ticket_types'] = $this->input->get_post("ticket_types");
				$data["referrer"] = $this->input->get_post("referrer");
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_event_by_long_title_concise',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);
	
			}else{
				
				
				
				
				if ($data['reports']['report_dl'] != '')
				{ 
					$this->load->helper('file');
					$datet = $data['reports']['reports_date'];
						
					$header = "Advance Sales Report (Summary) [$datet].csv";
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
				}
				
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_advance_sales_summary',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	function new_reports_opt_v1_test($eventgroup = "")
	{
			
		ini_set("memory_limit","3000M");
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		//$data['date_from'] = $date_from;
		//$data['date_to'] = $date_to;
		//$data['branch'] = $branch;
		$data['form_url'] = uri_string();
		$data['eventgroup'] = $eventgroup;
		
		if ($eventgroup == 'cc')
		{
			$data['page_title'] = "Convenience Charge Report";
			
			// get branches
			$data['branches'] = $this->branches->get_branches_dropdown();
		}
		elseif ($eventgroup == 'tr')
		{
			$data['page_title'] = "Ticket Reservation Report";
		}
		elseif ($eventgroup == 'dsso')
		{
			$data['page_title'] = "Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'dss')
		{
			$data['page_title'] = "Detailed Sales Summary Report";
		}
		elseif ($eventgroup == 'natrpb')
		{
			$data['page_title'] = "New Audit Trail Report";
		}
		elseif ($eventgroup == 'ndsso')
		{
			$data['page_title'] = "New Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'nsvspb')
		{
			$data['page_title'] = "New Summary of Voided Sales (Per Branch) Report";
		}
		elseif ($eventgroup == 'otc')
		{
			$data['page_title'] = "Online Transaction Report";
		}
		elseif ($eventgroup == 'ei')
		{
			$this->users->check_session(array('Admin','Super Admin', 'Finance'));
			$data['page_title'] = "Daily Sales Report on E-Invoicing";
		}
		else 
		{
			redirect($data['form_url'].'/event/');
		}
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('reports_new_reports_opt_filter', $data);
		}
		else
		{
			if($eventgroup == 'cc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif($eventgroup == 'tr')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Ticket Reservation Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_ticket_reservation',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dsso')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_online_detailed_sales',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dss')
			{
				ini_set("memory_limit","1500M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				$this->benchmark->mark('query_end');
				$this->load->view('reports_detailed_sales',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'natrpb')
			{
				// ini_set("memory_limit","1024M");
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSATR');
				//print_r($data['reports']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				if ($data['reports']['branch_id']!= '')
				{
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$data['branch_id'] = $data['reports']['branch_id'];
					if ($data['reports']['report_dl'] != '')
					{
						
						$this->load->helper('file');

						$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "$branch_name's Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_newest_test',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}

				}
				else 
				{
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');

						//$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "All Branches' Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}
				}
			}
			elseif ($eventgroup == 'ndsso')
			{
				ini_set("memory_limit","1000M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = 'Online Branch';
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Detailed Sales Summary Online[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_dsso_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);


			}
			elseif ($eventgroup == 'nsvspb')
			{
			
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSSVS');
				
				//echo $data['reports']['branch_id'];

				
				if ($data['reports']['report_view'] != '' and $data['reports']['branch_id'] != '')
				{
				
					//retrieve needed branch details --> as of 12-07-2010 only branch name
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					

					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);

				}
				elseif($data['reports']['report_view'] != '' and $data['reports']['branch_id'] == '')

				{

					$this->benchmark->mark('query_end');		
					$this->load->view('reports_svsab_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] == '')
				{
					$this->load->helper('file');
                                        //$branch_name = $data['branch_details'][0]->branch_name;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales all Branches[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svsab_new_dl',$data);

					$this->benchmark->mark('page_end');

					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] != '')
				{
					$this->load->helper('file');
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales by Branch[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				
			}
			elseif ($eventgroup == 'otc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('REPORTSOTC');
				$data['events'] = $this->reports->get_events($data['reports']['event_id']);
				$data['users'] = $this->reports->get_users($data['reports']['user_id']);
				$data['branch_details'] = $this->reports->get_branch($data['reports']['branch_id']);
				//$data['terminals'] = $this->reports->get_terminal_details($data['reports']['terminal_id']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				//$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');
						error_reporting(0);
						
						$branch_name = $data['branch_details']->branch_name;
						$eve_name = $data['events']->event_title;
						$otc_fname = $data['users']->user_firstname;
						$otc_lname = $data['users']->user_lastname;
						$otc_name = $otc_fname . ' ' . $otc_lname;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						if($branch_name == '' || $eve_name == '' || $otc_lname == '')
						{
							$header = "All Events All Branch All Users [$date_from to $date_to].csv";
						}
						else 
						{
							$header = "$eve_name $branch_name $otc_name [$date_from to $date_to].csv";
						}
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						//}
					}
					
				$this->benchmark->mark('query_end');
				$this->load->view('reports_otc',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}elseif($eventgroup == 'ei')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets_invoicing',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	function new_reports_opt_v1_seller($eventgroup = "")
	{
			
		ini_set("memory_limit","8000M");
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		//$data['date_from'] = $date_from;
		//$data['date_to'] = $date_to;
		//$data['branch'] = $branch;
		$data['form_url'] = uri_string();
		$data['eventgroup'] = $eventgroup;
		
		if ($eventgroup == 'cc')
		{
			$data['page_title'] = "Convenience Charge Report";
			
			// get branches
			$data['branches'] = $this->branches->get_branches_dropdown();
		}
		elseif ($eventgroup == 'tr')
		{
			$data['page_title'] = "Ticket Reservation Report";
		}
		elseif ($eventgroup == 'dsso')
		{
			$data['page_title'] = "Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'dss')
		{
			$data['page_title'] = "Detailed Sales Summary Report";
		}
		elseif ($eventgroup == 'natrpb')
		{
			$data['page_title'] = "New Audit Trail Report";
		}
		elseif ($eventgroup == 'natrpbps')
		{
			$data['page_title'] = "Audit Trail Report Per Seller";
		}
		elseif ($eventgroup == 'ndsso')
		{
			$data['page_title'] = "New Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'nsvspb')
		{
			$data['page_title'] = "New Summary of Voided Sales (Per Branch) Report";
		}
		elseif ($eventgroup == 'otc')
		{
			$data['page_title'] = "Online Transaction Report";
		}
		elseif ($eventgroup == 'ei')
		{
			$data['page_title'] = "Daily Sales Report on E-Invoicing";
		}
		else 
		{
			redirect($data['form_url'].'/event/');
		}
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance','Treasury','Manager'));
			
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('reports_new_reports_opt_filter', $data);
		}
		else
		{
			if($eventgroup == 'cc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif($eventgroup == 'tr')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Ticket Reservation Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_ticket_reservation',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dsso')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_online_detailed_sales',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dss')
			{
				ini_set("memory_limit","1500M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				$this->benchmark->mark('query_end');
				$this->load->view('reports_detailed_sales',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'natrpbps')
			{
				
				ini_set("memory_limit","8024M");
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSATR');
				//print_r($data['reports']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				if ($data['reports']['branch_id']!= '')
				{
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$data['branch_id'] = $data['reports']['branch_id'];
					if ($data['reports']['report_dl'] != '')
					{
						
						$this->load->helper('file');

						$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "$branch_name's Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_newest_bySeller',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						// echo 'da';
						// die();
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_newest_bySeller',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}

				}
				else 
				{
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');

						//$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "All Branches' Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}
				}
			}
			elseif ($eventgroup == 'natrpb')
			{
				
				ini_set("memory_limit","8024M");
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSATR');
				//print_r($data['reports']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				if ($data['reports']['branch_id']!= '')
				{
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$data['branch_id'] = $data['reports']['branch_id'];
					if ($data['reports']['report_dl'] != '')
					{
						
						$this->load->helper('file');

						$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "$branch_name's Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_newest_bySeller',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						// echo 'da';
						// die();
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_newest_bySeller',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}

				}
				else 
				{
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');

						//$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "All Branches' Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}
				}
			}
			elseif ($eventgroup == 'ndsso')
			{
				ini_set("memory_limit","1000M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = 'Online Branch';
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Detailed Sales Summary Online[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_dsso_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);


			}
			elseif ($eventgroup == 'nsvspb')
			{
			
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSSVS');
				
				//echo $data['reports']['branch_id'];

				
				if ($data['reports']['report_view'] != '' and $data['reports']['branch_id'] != '')
				{
				
					//retrieve needed branch details --> as of 12-07-2010 only branch name
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					

					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);

				}
				elseif($data['reports']['report_view'] != '' and $data['reports']['branch_id'] == '')

				{

					$this->benchmark->mark('query_end');		
					$this->load->view('reports_svsab_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] == '')
				{
					$this->load->helper('file');
                                        //$branch_name = $data['branch_details'][0]->branch_name;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales all Branches[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svsab_new_dl',$data);

					$this->benchmark->mark('page_end');

					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] != '')
				{
					$this->load->helper('file');
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales by Branch[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				
			}
			elseif ($eventgroup == 'otc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('REPORTSOTC');
				$data['events'] = $this->reports->get_events($data['reports']['event_id']);
				$data['users'] = $this->reports->get_users($data['reports']['user_id']);
				$data['branch_details'] = $this->reports->get_branch($data['reports']['branch_id']);
				//$data['terminals'] = $this->reports->get_terminal_details($data['reports']['terminal_id']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				//$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');
						error_reporting(0);
						
						$branch_name = $data['branch_details']->branch_name;
						$eve_name = $data['events']->event_title;
						$otc_fname = $data['users']->user_firstname;
						$otc_lname = $data['users']->user_lastname;
						$otc_name = $otc_fname . ' ' . $otc_lname;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						if($branch_name == '' || $eve_name == '' || $otc_lname == '')
						{
							$header = "All Events All Branch All Users [$date_from to $date_to].csv";
						}
						else 
						{
							$header = "$eve_name $branch_name $otc_name [$date_from to $date_to].csv";
						}
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						//}
					}
					
				$this->benchmark->mark('query_end');
				$this->load->view('reports_otc',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}elseif($eventgroup == 'ei')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets_invoicing',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	function new_reports_opt_v1_seller_test($eventgroup = "")
	{
			
		ini_set("memory_limit","50000M");
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		//$data['date_from'] = $date_from;
		//$data['date_to'] = $date_to;
		//$data['branch'] = $branch;
		$data['form_url'] = uri_string();
		$data['eventgroup'] = $eventgroup;
		
		if ($eventgroup == 'cc')
		{
			$data['page_title'] = "Convenience Charge Report";
			
			// get branches
			$data['branches'] = $this->branches->get_branches_dropdown();
		}
		elseif ($eventgroup == 'tr')
		{
			$data['page_title'] = "Ticket Reservation Report";
		}
		elseif ($eventgroup == 'dsso')
		{
			$data['page_title'] = "Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'dss')
		{
			$data['page_title'] = "Detailed Sales Summary Report";
		}
		elseif ($eventgroup == 'natrpb')
		{
			$data['page_title'] = "New Audit Trail Report";
		}
		elseif ($eventgroup == 'ndsso')
		{
			$data['page_title'] = "New Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'nsvspb')
		{
			$data['page_title'] = "New Summary of Voided Sales (Per Branch) Report";
		}
		elseif ($eventgroup == 'otc')
		{
			$data['page_title'] = "Online Transaction Report";
		}
		elseif ($eventgroup == 'ei')
		{
			$data['page_title'] = "Daily Sales Report on E-Invoicing";
		}
		else 
		{
			redirect($data['form_url'].'/event/');
		}
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin', 'Finance','Treasury'));
			
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('reports_new_reports_opt_filter', $data);
		}
		else
		{
			if($eventgroup == 'cc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif($eventgroup == 'tr')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Ticket Reservation Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_ticket_reservation',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dsso')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_online_detailed_sales',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dss')
			{
				ini_set("memory_limit","1500M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				$this->benchmark->mark('query_end');
				$this->load->view('reports_detailed_sales',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'natrpb')
			{
				
				ini_set("memory_limit","8024M");
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSATR');
				//print_r($data['reports']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				if ($data['reports']['branch_id']!= '')
				{
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$data['branch_id'] = $data['reports']['branch_id'];
					if ($data['reports']['report_dl'] != '')
					{
						
						$this->load->helper('file');

						$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "$branch_name's Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_newest_bySeller_test',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						// echo 'da';
						// die();
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_newest_bySeller_test',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}

				}
				else 
				{
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');

						//$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "All Branches' Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}
				}
			}
			elseif ($eventgroup == 'ndsso')
			{
				ini_set("memory_limit","1000M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = 'Online Branch';
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Detailed Sales Summary Online[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_dsso_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);


			}
			elseif ($eventgroup == 'nsvspb')
			{
			
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSSVS');
				
				//echo $data['reports']['branch_id'];

				
				if ($data['reports']['report_view'] != '' and $data['reports']['branch_id'] != '')
				{
				
					//retrieve needed branch details --> as of 12-07-2010 only branch name
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					

					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);

				}
				elseif($data['reports']['report_view'] != '' and $data['reports']['branch_id'] == '')

				{

					$this->benchmark->mark('query_end');		
					$this->load->view('reports_svsab_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] == '')
				{
					$this->load->helper('file');
                                        //$branch_name = $data['branch_details'][0]->branch_name;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales all Branches[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svsab_new_dl',$data);

					$this->benchmark->mark('page_end');

					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] != '')
				{
					$this->load->helper('file');
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales by Branch[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				
			}
			elseif ($eventgroup == 'otc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('REPORTSOTC');
				$data['events'] = $this->reports->get_events($data['reports']['event_id']);
				$data['users'] = $this->reports->get_users($data['reports']['user_id']);
				$data['branch_details'] = $this->reports->get_branch($data['reports']['branch_id']);
				//$data['terminals'] = $this->reports->get_terminal_details($data['reports']['terminal_id']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				//$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');
						error_reporting(0);
						
						$branch_name = $data['branch_details']->branch_name;
						$eve_name = $data['events']->event_title;
						$otc_fname = $data['users']->user_firstname;
						$otc_lname = $data['users']->user_lastname;
						$otc_name = $otc_fname . ' ' . $otc_lname;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						if($branch_name == '' || $eve_name == '' || $otc_lname == '')
						{
							$header = "All Events All Branch All Users [$date_from to $date_to].csv";
						}
						else 
						{
							$header = "$eve_name $branch_name $otc_name [$date_from to $date_to].csv";
						}
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						//}
					}
					
				$this->benchmark->mark('query_end');
				$this->load->view('reports_otc',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}elseif($eventgroup == 'ei')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets_invoicing',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	
	function harry_report($eventgroup = "")
	{
			
		ini_set("memory_limit","3000M");
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		//$data['date_from'] = $date_from;
		//$data['date_to'] = $date_to;
		//$data['branch'] = $branch;
		$data['form_url'] = uri_string();
		$data['eventgroup'] = $eventgroup;
		
		if ($eventgroup == 'cc')
		{
			$data['page_title'] = "Convenience Charge Report";
			
			// get branches
			$data['branches'] = $this->branches->get_branches_dropdown();
		}
		elseif ($eventgroup == 'tr')
		{
			$data['page_title'] = "Ticket Reservation Report";
		}
		elseif ($eventgroup == 'dsso')
		{
			$data['page_title'] = "Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'dss')
		{
			$data['page_title'] = "Detailed Sales Summary Report";
		}
		elseif ($eventgroup == 'natrpb')
		{
			$data['page_title'] = "New Audit Trail Report";
		}
		elseif ($eventgroup == 'ndsso')
		{
			$data['page_title'] = "New Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'nsvspb')
		{
			$data['page_title'] = "New Summary of Voided Sales (Per Branch) Report";
		}
		elseif ($eventgroup == 'otc')
		{
			$data['page_title'] = "Online Transaction Report";
		}
		elseif ($eventgroup == 'ei')
		{
			$data['page_title'] = "Daily Sales Report on E-Invoicing";
		}
		else 
		{
			redirect($data['form_url'].'/event/');
		}
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance','Treasury'));
			
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('reports_new_reports_opt_filter', $data);
		}
		else
		{
			if($eventgroup == 'cc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif($eventgroup == 'tr')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Ticket Reservation Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_ticket_reservation',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dsso')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_online_detailed_sales',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dss')
			{
				ini_set("memory_limit","1500M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				$this->benchmark->mark('query_end');
				$this->load->view('reports_detailed_sales',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'natrpb')
			{
				// ini_set("memory_limit","1024M");
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSATR');
				//print_r($data['reports']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				if ($data['reports']['branch_id']!= '')
				{
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$data['branch_id'] = $data['reports']['branch_id'];
					if ($data['reports']['report_dl'] != '')
					{
						
						$this->load->helper('file');

						$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "$branch_name's Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_harry',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}

				}
				else 
				{
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');

						//$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "All Branches' Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_harry',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}
				}
			}
			elseif ($eventgroup == 'ndsso')
			{
				ini_set("memory_limit","1000M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = 'Online Branch';
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Detailed Sales Summary Online[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_dsso_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);


			}
			elseif ($eventgroup == 'nsvspb')
			{
			
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSSVS');
				
				//echo $data['reports']['branch_id'];

				
				if ($data['reports']['report_view'] != '' and $data['reports']['branch_id'] != '')
				{
				
					//retrieve needed branch details --> as of 12-07-2010 only branch name
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					

					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);

				}
				elseif($data['reports']['report_view'] != '' and $data['reports']['branch_id'] == '')

				{

					$this->benchmark->mark('query_end');		
					$this->load->view('reports_svsab_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] == '')
				{
					$this->load->helper('file');
                                        //$branch_name = $data['branch_details'][0]->branch_name;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales all Branches[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svsab_new_dl',$data);

					$this->benchmark->mark('page_end');

					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] != '')
				{
					$this->load->helper('file');
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales by Branch[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				
			}
			elseif ($eventgroup == 'otc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('REPORTSOTC');
				$data['events'] = $this->reports->get_events($data['reports']['event_id']);
				$data['users'] = $this->reports->get_users($data['reports']['user_id']);
				$data['branch_details'] = $this->reports->get_branch($data['reports']['branch_id']);
				//$data['terminals'] = $this->reports->get_terminal_details($data['reports']['terminal_id']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				//$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');
						error_reporting(0);
						
						$branch_name = $data['branch_details']->branch_name;
						$eve_name = $data['events']->event_title;
						$otc_fname = $data['users']->user_firstname;
						$otc_lname = $data['users']->user_lastname;
						$otc_name = $otc_fname . ' ' . $otc_lname;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						if($branch_name == '' || $eve_name == '' || $otc_lname == '')
						{
							$header = "All Events All Branch All Users [$date_from to $date_to].csv";
						}
						else 
						{
							$header = "$eve_name $branch_name $otc_name [$date_from to $date_to].csv";
						}
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						//}
					}
					
				$this->benchmark->mark('query_end');
				$this->load->view('reports_otc',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}elseif($eventgroup == 'ei')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets_invoicing',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	/*ATR NEW*/
	
	function new_reports_v1_by_promoter_sap($eventgroup = false){
			
		ini_set("memory_limit","3000M");
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		//$data['date_from'] = $date_from;
		//$data['date_to'] = $date_to;
		//$data['branch'] = $branch;
		$data['form_url'] = uri_string();
		$data['eventgroup'] = $eventgroup;
		
		if ($eventgroup == 'cc')
		{
			$data['page_title'] = "Convenience Charge Report";
			
			// get branches
			$data['branches'] = $this->branches->get_branches_dropdown();
		}
		elseif ($eventgroup == 'tr')
		{
			$data['page_title'] = "Ticket Reservation Report";
		}
		elseif ($eventgroup == 'dsso')
		{
			$data['page_title'] = "Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'dss')
		{
			$data['page_title'] = "Detailed Sales Summary Report";
		}
		elseif ($eventgroup == 'natrpb')
		{
			$data['page_title'] = "New Audit Trail Report";
		}
		elseif ($eventgroup == 'ndsso')
		{
			$data['page_title'] = "New Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'nsvspb')
		{
			$data['page_title'] = "New Summary of Voided Sales (Per Branch) Report";
		}
		elseif ($eventgroup == 'otc')
		{
			$data['page_title'] = "Online Transaction Report";
		}
		elseif ($eventgroup == 'ei')
		{
			$data['page_title'] = "Daily Sales Report on E-Invoicing";
		}
		else 
		{
			redirect($data['form_url'].'/event/');
		}
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('reports_new_reports_opt_filter', $data);
		}
		else
		{
			if($eventgroup == 'cc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif($eventgroup == 'tr')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Ticket Reservation Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_ticket_reservation',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dsso')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_online_detailed_sales',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dss')
			{
				ini_set("memory_limit","1500M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				$this->benchmark->mark('query_end');
				$this->load->view('reports_detailed_sales',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'natrpb')
			{
				// ini_set("memory_limit","1024M");
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSATR');
				//print_r($data['reports']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				// if ($data['reports']['branch_id']!= '')
				// {
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$data['branch_id'] = $data['reports']['branch_id'];
				/* 	if ($data['reports']['report_dl'] != '')
					{
						
						$this->load->helper('file');

						$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "$branch_name's Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{ */
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_newest_by_promoter_sap',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					// }

			/* 	}
				else 
				{
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');

						//$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "All Branches' Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}
				} */
			}
			elseif ($eventgroup == 'ndsso')
			{
				ini_set("memory_limit","1000M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = 'Online Branch';
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Detailed Sales Summary Online[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_dsso_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);


			}
			elseif ($eventgroup == 'nsvspb')
			{
			
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSSVS');
				
				//echo $data['reports']['branch_id'];

				
				if ($data['reports']['report_view'] != '' and $data['reports']['branch_id'] != '')
				{
				
					//retrieve needed branch details --> as of 12-07-2010 only branch name
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					

					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);

				}
				elseif($data['reports']['report_view'] != '' and $data['reports']['branch_id'] == '')

				{

					$this->benchmark->mark('query_end');		
					$this->load->view('reports_svsab_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] == '')
				{
					$this->load->helper('file');
                                        //$branch_name = $data['branch_details'][0]->branch_name;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales all Branches[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svsab_new_dl',$data);

					$this->benchmark->mark('page_end');

					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] != '')
				{
					$this->load->helper('file');
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales by Branch[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				
			}
			elseif ($eventgroup == 'otc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('REPORTSOTC');
				$data['events'] = $this->reports->get_events($data['reports']['event_id']);
				$data['users'] = $this->reports->get_users($data['reports']['user_id']);
				$data['branch_details'] = $this->reports->get_branch($data['reports']['branch_id']);
				//$data['terminals'] = $this->reports->get_terminal_details($data['reports']['terminal_id']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				//$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');
						error_reporting(0);
						
						$branch_name = $data['branch_details']->branch_name;
						$eve_name = $data['events']->event_title;
						$otc_fname = $data['users']->user_firstname;
						$otc_lname = $data['users']->user_lastname;
						$otc_name = $otc_fname . ' ' . $otc_lname;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						if($branch_name == '' || $eve_name == '' || $otc_lname == '')
						{
							$header = "All Events All Branch All Users [$date_from to $date_to].csv";
						}
						else 
						{
							$header = "$eve_name $branch_name $otc_name [$date_from to $date_to].csv";
						}
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						//}
					}
					
				$this->benchmark->mark('query_end');
				$this->load->view('reports_otc',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}elseif($eventgroup == 'ei')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets_invoicing',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
		
		
		
	
	
	function new_reports_opt_v1_by_promoter($eventgroup = "")
	{
			
		ini_set("memory_limit","3000M");
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		//$data['date_from'] = $date_from;
		//$data['date_to'] = $date_to;
		//$data['branch'] = $branch;
		$data['form_url'] = uri_string();
		$data['eventgroup'] = $eventgroup;
		
		if ($eventgroup == 'cc')
		{
			$data['page_title'] = "Convenience Charge Report";
			
			// get branches
			$data['branches'] = $this->branches->get_branches_dropdown();
		}
		elseif ($eventgroup == 'tr')
		{
			$data['page_title'] = "Ticket Reservation Report";
		}
		elseif ($eventgroup == 'dsso')
		{
			$data['page_title'] = "Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'dss')
		{
			$data['page_title'] = "Detailed Sales Summary Report";
		}
		elseif ($eventgroup == 'natrpb')
		{
			$data['page_title'] = "New Audit Trail Report";
		}
		elseif ($eventgroup == 'ndsso')
		{
			$data['page_title'] = "New Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'nsvspb')
		{
			$data['page_title'] = "New Summary of Voided Sales (Per Branch) Report";
		}
		elseif ($eventgroup == 'otc')
		{
			$data['page_title'] = "Online Transaction Report";
		}
		elseif ($eventgroup == 'ei')
		{
			$data['page_title'] = "Daily Sales Report on E-Invoicing";
		}
		else 
		{
			redirect($data['form_url'].'/event/');
		}
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('reports_new_reports_opt_filter', $data);
		}
		else
		{
			if($eventgroup == 'cc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif($eventgroup == 'tr')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Ticket Reservation Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_ticket_reservation',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dsso')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_online_detailed_sales',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dss')
			{
				ini_set("memory_limit","1500M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				$this->benchmark->mark('query_end');
				$this->load->view('reports_detailed_sales',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'natrpb')
			{
				// ini_set("memory_limit","1024M");
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSATR');
				//print_r($data['reports']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				// if ($data['reports']['branch_id']!= '')
				// {
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$data['branch_id'] = $data['reports']['branch_id'];
				/* 	if ($data['reports']['report_dl'] != '')
					{
						
						$this->load->helper('file');

						$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "$branch_name's Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{ */
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_newest_by_promoter',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					// }

			/* 	}
				else 
				{
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');

						//$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "All Branches' Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}
				} */
			}
			elseif ($eventgroup == 'ndsso')
			{
				ini_set("memory_limit","1000M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = 'Online Branch';
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Detailed Sales Summary Online[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_dsso_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);


			}
			elseif ($eventgroup == 'nsvspb')
			{
			
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSSVS');
				
				//echo $data['reports']['branch_id'];

				
				if ($data['reports']['report_view'] != '' and $data['reports']['branch_id'] != '')
				{
				
					//retrieve needed branch details --> as of 12-07-2010 only branch name
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					

					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);

				}
				elseif($data['reports']['report_view'] != '' and $data['reports']['branch_id'] == '')

				{

					$this->benchmark->mark('query_end');		
					$this->load->view('reports_svsab_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] == '')
				{
					$this->load->helper('file');
                                        //$branch_name = $data['branch_details'][0]->branch_name;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales all Branches[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svsab_new_dl',$data);

					$this->benchmark->mark('page_end');

					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] != '')
				{
					$this->load->helper('file');
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales by Branch[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				
			}
			elseif ($eventgroup == 'otc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('REPORTSOTC');
				$data['events'] = $this->reports->get_events($data['reports']['event_id']);
				$data['users'] = $this->reports->get_users($data['reports']['user_id']);
				$data['branch_details'] = $this->reports->get_branch($data['reports']['branch_id']);
				//$data['terminals'] = $this->reports->get_terminal_details($data['reports']['terminal_id']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				//$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');
						error_reporting(0);
						
						$branch_name = $data['branch_details']->branch_name;
						$eve_name = $data['events']->event_title;
						$otc_fname = $data['users']->user_firstname;
						$otc_lname = $data['users']->user_lastname;
						$otc_name = $otc_fname . ' ' . $otc_lname;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						if($branch_name == '' || $eve_name == '' || $otc_lname == '')
						{
							$header = "All Events All Branch All Users [$date_from to $date_to].csv";
						}
						else 
						{
							$header = "$eve_name $branch_name $otc_name [$date_from to $date_to].csv";
						}
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						//}
					}
					
				$this->benchmark->mark('query_end');
				$this->load->view('reports_otc',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}elseif($eventgroup == 'ei')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets_invoicing',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
	
	function new_reports_opt_v1_by_promoter_test($eventgroup = "")
	{
			
		ini_set("memory_limit","3000M");
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		//$data['date_from'] = $date_from;
		//$data['date_to'] = $date_to;
		//$data['branch'] = $branch;
		$data['form_url'] = uri_string();
		$data['eventgroup'] = $eventgroup;
		
		if ($eventgroup == 'cc')
		{
			$data['page_title'] = "Convenience Charge Report";
			
			// get branches
			$data['branches'] = $this->branches->get_branches_dropdown();
		}
		elseif ($eventgroup == 'tr')
		{
			$data['page_title'] = "Ticket Reservation Report";
		}
		elseif ($eventgroup == 'dsso')
		{
			$data['page_title'] = "Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'dss')
		{
			$data['page_title'] = "Detailed Sales Summary Report";
		}
		elseif ($eventgroup == 'natrpb')
		{
			$data['page_title'] = "New Audit Trail Report";
		}
		elseif ($eventgroup == 'ndsso')
		{
			$data['page_title'] = "New Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'nsvspb')
		{
			$data['page_title'] = "New Summary of Voided Sales (Per Branch) Report";
		}
		elseif ($eventgroup == 'otc')
		{
			$data['page_title'] = "Online Transaction Report";
		}
		elseif ($eventgroup == 'ei')
		{
			$data['page_title'] = "Daily Sales Report on E-Invoicing";
		}
		else 
		{
			redirect($data['form_url'].'/event/');
		}
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('reports_new_reports_opt_filter', $data);
		}
		else
		{
			if($eventgroup == 'cc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif($eventgroup == 'tr')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Ticket Reservation Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_ticket_reservation',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dsso')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_online_detailed_sales',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dss')
			{
				ini_set("memory_limit","1500M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				$this->benchmark->mark('query_end');
				$this->load->view('reports_detailed_sales',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'natrpb')
			{
				// ini_set("memory_limit","1024M");
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSATR');
				//print_r($data['reports']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				// if ($data['reports']['branch_id']!= '')
				// {
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$data['branch_id'] = $data['reports']['branch_id'];
				/* 	if ($data['reports']['report_dl'] != '')
					{
						
						$this->load->helper('file');

						$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "$branch_name's Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{ */
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_newest_test_by_promoter_test',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					// }

			/* 	}
				else 
				{
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');

						//$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "All Branches' Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}
				} */
			}
			elseif ($eventgroup == 'ndsso')
			{
				ini_set("memory_limit","1000M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = 'Online Branch';
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Detailed Sales Summary Online[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_dsso_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);


			}
			elseif ($eventgroup == 'nsvspb')
			{
			
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSSVS');
				
				//echo $data['reports']['branch_id'];

				
				if ($data['reports']['report_view'] != '' and $data['reports']['branch_id'] != '')
				{
				
					//retrieve needed branch details --> as of 12-07-2010 only branch name
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					

					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);

				}
				elseif($data['reports']['report_view'] != '' and $data['reports']['branch_id'] == '')

				{

					$this->benchmark->mark('query_end');		
					$this->load->view('reports_svsab_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] == '')
				{
					$this->load->helper('file');
                                        //$branch_name = $data['branch_details'][0]->branch_name;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales all Branches[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svsab_new_dl',$data);

					$this->benchmark->mark('page_end');

					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] != '')
				{
					$this->load->helper('file');
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales by Branch[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				
			}
			elseif ($eventgroup == 'otc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('REPORTSOTC');
				$data['events'] = $this->reports->get_events($data['reports']['event_id']);
				$data['users'] = $this->reports->get_users($data['reports']['user_id']);
				$data['branch_details'] = $this->reports->get_branch($data['reports']['branch_id']);
				//$data['terminals'] = $this->reports->get_terminal_details($data['reports']['terminal_id']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				//$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');
						error_reporting(0);
						
						$branch_name = $data['branch_details']->branch_name;
						$eve_name = $data['events']->event_title;
						$otc_fname = $data['users']->user_firstname;
						$otc_lname = $data['users']->user_lastname;
						$otc_name = $otc_fname . ' ' . $otc_lname;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						if($branch_name == '' || $eve_name == '' || $otc_lname == '')
						{
							$header = "All Events All Branch All Users [$date_from to $date_to].csv";
						}
						else 
						{
							$header = "$eve_name $branch_name $otc_name [$date_from to $date_to].csv";
						}
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						//}
					}
					
				$this->benchmark->mark('query_end');
				$this->load->view('reports_otc',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}elseif($eventgroup == 'ei')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets_invoicing',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}
	
		function export_sap_report($branch_id=false){
		$data['reports'] = $this->reports->reports_bir($branch_id);
		$this->load->view('sap_interface', $data);
	}
	
		function export_sap_report2($branch_id=false){	
		$data['branch_id'] = $branch_id;
		$this->load->view('sap_interface2',$data);
	}

	/*ATR promoter SAP*/
	
	function new_reports_opt_v1_by_promoter_sap($eventgroup = "")
	{
			
		ini_set("memory_limit","3000M");
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		//$data['date_from'] = $date_from;
		//$data['date_to'] = $date_to;
		//$data['branch'] = $branch;
		$data['form_url'] = uri_string();
		$data['eventgroup'] = $eventgroup;
		
		if ($eventgroup == 'cc')
		{
			$data['page_title'] = "Convenience Charge Report";
			
			// get branches
			$data['branches'] = $this->branches->get_branches_dropdown();
		}
		elseif ($eventgroup == 'tr')
		{
			$data['page_title'] = "Ticket Reservation Report";
		}
		elseif ($eventgroup == 'dsso')
		{
			$data['page_title'] = "Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'dss')
		{
			$data['page_title'] = "Detailed Sales Summary Report";
		}
		elseif ($eventgroup == 'natrpb')
		{
			$data['page_title'] = "New Audit Trail Report";
		}
		elseif ($eventgroup == 'ndsso')
		{
			$data['page_title'] = "New Detailed Sales Summary - Online Report";
		}
		elseif ($eventgroup == 'nsvspb')
		{
			$data['page_title'] = "New Summary of Voided Sales (Per Branch) Report";
		}
		elseif ($eventgroup == 'otc')
		{
			$data['page_title'] = "Online Transaction Report";
		}
		elseif ($eventgroup == 'ei')
		{
			$data['page_title'] = "Daily Sales Report on E-Invoicing";
		}
		else 
		{
			redirect($data['form_url'].'/event/');
		}
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin', 'Finance'));
			
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			// display the page
			$this->load->view('reports_new_reports_opt_filter', $data);
		}
		else
		{
			if($eventgroup == 'cc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif($eventgroup == 'tr')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Ticket Reservation Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_ticket_reservation',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dsso')
			{
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}

				$this->benchmark->mark('query_end');
				$this->load->view('reports_online_detailed_sales',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'dss')
			{
				ini_set("memory_limit","1500M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					//$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "Detailed Sales Summary Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				$this->benchmark->mark('query_end');
				$this->load->view('reports_detailed_sales',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
			elseif ($eventgroup == 'natrpb')
			{
				// ini_set("memory_limit","1024M");
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSATR');
				//print_r($data['reports']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				// if ($data['reports']['branch_id']!= '')
				// {
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$data['branch_id'] = $data['reports']['branch_id'];
				/* 	if ($data['reports']['report_dl'] != '')
					{
						
						$this->load->helper('file');

						$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "$branch_name's Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{ */
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_per_branch_newest_by_promoter_sap',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					// }

			/* 	}
				else 
				{
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');

						//$branch_name = $data['branch_details'][0]->branch_name;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						
						$header = "All Branches' Audit Trail Report[$date_from to $date_to].csv";
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new_dl',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);

						
					}
					else 
					{
						$this->benchmark->mark('query_end');
						$this->load->view('reports_audit_trail_all_branch_new',$data);
						$this->benchmark->mark('page_end');
						
						$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
						$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
						$this->logs->benchmark_add($querytime, $pagetime);
					}
				} */
			}
			elseif ($eventgroup == 'ndsso')
			{
				ini_set("memory_limit","1000M");
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSTR');
				
				
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = 'Online Branch';
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Detailed Sales Summary Online[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				}
				
				$this->benchmark->mark('query_end');
				$this->load->view('reports_dsso_new',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);


			}
			elseif ($eventgroup == 'nsvspb')
			{
			
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSSVS');
				
				//echo $data['reports']['branch_id'];

				
				if ($data['reports']['report_view'] != '' and $data['reports']['branch_id'] != '')
				{
				
					//retrieve needed branch details --> as of 12-07-2010 only branch name
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					

					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);

				}
				elseif($data['reports']['report_view'] != '' and $data['reports']['branch_id'] == '')

				{

					$this->benchmark->mark('query_end');		
					$this->load->view('reports_svsab_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] == '')
				{
					$this->load->helper('file');
                                        //$branch_name = $data['branch_details'][0]->branch_name;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales all Branches[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svsab_new_dl',$data);

					$this->benchmark->mark('page_end');

					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				elseif($data['reports']['report_dl'] != '' and $data['reports']['branch_id'] != '')
				{
					$this->load->helper('file');
					$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					$header = "Summary of Voided Sales by Branch[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
									
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					$this->benchmark->mark('query_end');
					$this->load->view('reports_svspb_new',$data);
					$this->benchmark->mark('page_end');
					
					$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
					$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
					$this->logs->benchmark_add($querytime, $pagetime);
				}
				
				
			}
			elseif ($eventgroup == 'otc')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('REPORTSOTC');
				$data['events'] = $this->reports->get_events($data['reports']['event_id']);
				$data['users'] = $this->reports->get_users($data['reports']['user_id']);
				$data['branch_details'] = $this->reports->get_branch($data['reports']['branch_id']);
				//$data['terminals'] = $this->reports->get_terminal_details($data['reports']['terminal_id']);
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				//$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		
					if ($data['reports']['report_dl'] != '')
					{
						$this->load->helper('file');
						error_reporting(0);
						
						$branch_name = $data['branch_details']->branch_name;
						$eve_name = $data['events']->event_title;
						$otc_fname = $data['users']->user_firstname;
						$otc_lname = $data['users']->user_lastname;
						$otc_name = $otc_fname . ' ' . $otc_lname;
						$date_from = $data['reports']['date_from'];
						$date_to = $data['reports']['date_to'];
						if($branch_name == '' || $eve_name == '' || $otc_lname == '')
						{
							$header = "All Events All Branch All Users [$date_from to $date_to].csv";
						}
						else 
						{
							$header = "$eve_name $branch_name $otc_name [$date_from to $date_to].csv";
						}
						//echo $header;
						$this->output->set_header('Content-type: '.get_mime_by_extension($header));
						
						$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
						//}
					}
					
				$this->benchmark->mark('query_end');
				$this->load->view('reports_otc',$data);
				$this->benchmark->mark('page_end');

				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}elseif($eventgroup == 'ei')
			{
				// retrieve form filter values: date_from / date_to / branch_id
				$data['reports'] = $this->reports->reports_filter('NEWREPORTSCC');
				
				//retrieve needed branch details --> as of 12-07-2010 only branch name
				$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
		        
				if($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					
					$branch_name = $data['branch_details'][0]->branch_name;
					$date_from =$data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					
					$header = "$branch_name's Convenience Charge Report[$date_from to $date_to].csv";
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
					
				}
			
				/* --> used for checking what data was passed with get_branch_details
				print_r($data['branch_details']);
				echo "<br />";
				print_r($this->db->last_query());
				//*/
				
				//$this->load->view('reports_advance_sales_optimal',$data);
				$this->benchmark->mark('query_end');
				$this->load->view('reports_etickets_invoicing',$data);
				$this->benchmark->mark('page_end');
				
				$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
				$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
				$this->logs->benchmark_add($querytime, $pagetime);

			}
		}
	}



}

/* End of file reports.php */
/* Location: ./application/controllers/reports.php */