<?php

class Promoters extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('contacts_model', 'contacts');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('promoters/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing($vendor = false)
	{
		// prepare data for the template
		$data['page_title'] = 'Promoters';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get all promoter
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('promoter_vendor_key');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		if($vendor!=""){
			$data['promoters'] = $this->promoters->no_vendor($vendor);
		}else{
			$data['promoters'] = $this->promoters->get_promoters($searchkey);
		}
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance'));
		
		$this->load->view('promoters_listing', $data);
		
		
		
	}
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($promoter_id = FALSE)
	{
		if (! $promoter_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'View Promoter';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller','Event','Reservation','Reservation-Admin', 'Finance'));
	
		// get user's data
		$data['promoters'] = $this->promoters->get($promoter_id);
		
		// get contacts
		$data['contacts'] = $this->contacts->get_contacts('promoters', $promoter_id);		
		
		// display the page
		$this->load->view('promoters_view', $data);
	}	
		
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		// prepare data for the template
		$data['page_title'] = 'Add Promoter';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			 array(
				'field'   => 'promoters_username',
				'label'   => 'Username',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[50]|callback__username_check'
			),
			/* array(
				'field'   => 'promoters_password',
				'label'   => 'Password',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[50]'
			), */
			array(
				'field'   => 'promoters_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|max_length[80]'				
			
			),
			
			array(
				'field'   => 'promoters_signatory',
				'label'   => 'Signatory',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'promoters_position',
				'label'   => 'Position',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),	
			/* array(
				'field'   => 'promoters_ctc_number',
				'label'   => 'promoters ctc number',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'promoters_ctc_date',
				'label'   => 'promoters ctc date',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'promoters_ctc_place',
				'label'   => 'promoters ctc place',
				'rules'   => 'trim|required|strip_tags|max_length[80]'				
			
			), */

			array(
				'field'   => 'promoters_zip',
				'label'   => 'promoters zip',
				'rules'   => 'trim|required|strip_tags|max_length[80]'				
			
			),
			array(
				'field'   => 'promoters_tin',
				'label'   => 'promoters TIN',
				'rules'   => 'trim|required|strip_tags|max_length[10]|callback__promoters_tin_check'				
			
			),
			array(
				'field'   => 'promoters_vendor_key',
				'label'   => 'promoters vendor key',
				'rules'   => 'trim|required|strip_tags|max_length[10]'				
			
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('promoters_add', $data);
		}
		else
		{
			$promoter_id = $this->promoters->add();
			$this->session->set_flashdata('message', assemble_message('Promoter has been successfully added.  Please add the contact person.'));
			redirect('contacts/add/promoters/'.$promoter_id);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($promoter_id = FALSE)
	{
		if (! $promoter_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Promoter';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'promoter_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'promoter_signatory',
				'label'   => 'Signatory',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'promoter_position',
				'label'   => 'Position',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'promoter_tin',
				'label'   => 'promoters TIN',
				'rules'   => 'trim|required|strip_tags|max_length[10]|callback__promoters_tin_check['. $promoter_id .']'			
			
			),
			array(
				'field'   => 'promoter_vendor_key',
				'label'   => 'promoters vendor key',
				'rules'   => 'trim|required|strip_tags|max_length[10]'				
			
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
			// get promoter's data
			$data['promoter'] = $this->promoters->get($promoter_id);
						
			// get all contacts
			$data['contacts'] = $this->contacts->get_contacts('promoter', $promoter_id);

			
			
			// display the page
			$this->load->view('promoters_edit', $data);
		}
		else
		{
			$this->promoters->edit($promoter_id);
			$this->session->set_flashdata('message', assemble_message('Promoter has been successfully modified.<a href="">click here</a>'));
			
			redirect('promoters/view/'.$promoter_id);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($promoter_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Promoter');
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		$this->promoters->delete($promoter_id);
		$this->session->set_flashdata('message', assemble_message('Promoter has been successfully deleted'));
		redirect('promoters/listing/');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _username_check
	 *
	 * @access	private
	 */
	function _username_check($str)
	{	
		$username_exists = $this->promoters->is_username_exist($str);
		if ($username_exists)
		{
			$this->form_validation->set_message('_username_check', "Username $str is already taken");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	function _promoters_tin_check($str = false, $id = false)
	{	
		$event_code_exists = $this->promoters->is_promoters_tin_exist($str, $id);
		if ($event_code_exists)
		{
			$this->form_validation->set_message('_promoters_tin_check', "Promoter already exist.");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	function _promoters_vendor_key_check($str = false, $id = false)
	{	
		$event_code_exists = $this->promoters->is_promoters_vendor_exist($str, $id);
		if(!$str){
			return TRUE;
		}
		else if ($event_code_exists)
		{
			$this->form_validation->set_message('_promoters_vendor_key_check', "Promoter already exist.");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
}

/* End of file promoters.php */
/* Location: ./application/controllers/promoters.php */