<?php

class Promo_Codes extends CI_Controller 
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promo_codes_model', 'promo_codes');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('venues_model', 'venues');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('prices_model', 'prices');
		$this->load->model('events_model', 'events');
		$this->load->model('sections_model', 'sections');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('promo_codes/listing');
	}
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		// prepare data for the template
		$data['page_title'] = 'Promo Code';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
 		$data['promo_codes'] = $this->promo_codes->get_promo_codes($event_id);
				
		// get the event info
		$data['event'] = $this->events->get($event_id);
		
		$this->load->view('promo_codes_listing', $data);
	}
 
 
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Add Promo Code';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'promo_code_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'promo_code_code',
				'label'   => 'Promo Code',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'promo_code_qty',
				'label'   => 'Quantity',
				'rules'   => 'trim|required|strip_tags|numeric|max_length[2]'
			),
			array(
				'field'   => 'ticket_type',
				'label'   => 'Ticket Type',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'promo_code_prices[]',
				'label'   => 'Prices',
				'rules'   => 'trim|required|strip_tags'
			),			
			
			array(
				'field'   => 'date_from',
				'label'   => 'Date From',
				'rules'   => 'trim|required|strip_tags|callback__date_check'
			),	
			
			array(
				'field'   => 'date_to',
				'label'   => 'Date To',
				'rules'   => 'trim|required|strip_tags|callback__date_check'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
	
		
		if ($this->form_validation->run() == FALSE)
		{
		
		
			// get the event info
			$data['event'] = $this->events->get($event_id);
			
			// get event sections
			$data['prices'] = $this->prices->get_prices_dropdown_for_promo($event_id);
			 
			// get event sections
			$data['ticket_types'] = $this->ticket_types->get_ticket_types_dropdown_promo($data['event']->event_ticket_types);
			 
			// display the page
			
			$this->load->view('promo_codes_add', $data);
		}
		else
		{
			$this->promo_codes->add($event_id);
			$this->session->set_flashdata('message', assemble_message('Promo Code has been successfully added'));
			redirect('promo_codes/listing/');
		}
	}
		
 
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($promo_code_id = false)
	{
	
		if (!$promo_code_id) show_404();
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Promo Code';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(

			array(
				'field'   => 'promo_code_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'promo_code_code',
				'label'   => 'Promo Code',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'promo_code_qty',
				'label'   => 'Quantity',
				'rules'   => 'trim|required|strip_tags|numeric|max_length[2]'
			),
			array(
				'field'   => 'ticket_type[]',
				'label'   => 'Ticket Type',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'promo_code_prices[]',
				'label'   => 'Sections',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'date_from',
				'label'   => 'Date From',
				'rules'   => 'trim|required|strip_tags|callback__date_check'
			),	
			
			array(
				'field'   => 'date_to',
				'label'   => 'Date To',
				'rules'   => 'trim|required|strip_tags|callback__date_check'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
	
		
		if ($this->form_validation->run() == FALSE)
		{
				
			// get the event info
			$data['event'] = $this->events->get($event_id);
			
			// get event sections
			$data['prices'] = $this->prices->get_prices_dropdown_for_promo($event_id);
			
			// get user's data
			$data['promo_code'] = $this->promo_codes->get($promo_code_id);
				 
			// get event sections
			$data['ticket_types'] = $this->ticket_types->get_ticket_types_dropdown_promo($data['event']->event_ticket_types);
			 
			// display the page
			$this->load->view('promo_codes_edit', $data);
		}
		else
		{
			$this->promo_codes->edit($promo_code_id);
			$this->session->set_flashdata('message', assemble_message('Promo Code has been successfully modified'));
			redirect('promo_codes/listing/');
		}
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($promo_code_id = false)
	{
		if (!$promo_code_id) show_404();
		
		// log this
		$this->logs->add('Delete Promo Code');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		$this->promo_codes->delete($promo_code_id);
		$this->session->set_flashdata('message', assemble_message('Promo Code has been successfully deleted'));
		redirect('promo_codes/listing/');
	}	

	
	
	function _date_check($str = false)
	{	
		$date_from = $this->input->post('date_from');
		$date_to = $this->input->post('date_to');
		 
		if ($date_to < $date_from)
		{
			$this->form_validation->set_message('_date_check', "Date to cannot be earlier than date from!");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
}
/* End of file prices.php */
/* Location: ./application/controllers/prices.php */	

