<?php

class promo extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
 		$this->load->model('users_model', 'users');
		$this->load->model('venues_model', 'venues');
		$this->load->model('sections_model', 'sections');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('events_model', 'events');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('prices_model', 'prices');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('customers_model', 'customers');
		$this->load->model('reservations_model', 'reservations');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('payments_model', 'payments');
		$this->load->model('branches_model', 'branches');
		$this->load->model('printer_model', 'printer');
		$this->load->model('eplus_model', 'eplus');
		$this->load->model('promos_model', 'promo');
		$this->load->database('default');

	 
	}
 	
	function add_discount($count = false,$p_count = false){
	 
			//7127 maroon 5
			$events = array(5485, 5487, 5731,5807, 5823, 6769, 6762, 6819, 6850 , 7127);
			 
			
			if (in_array($this->session->userdata('cei'), $events) && $count == 0){
			
				$p_count = 1;
			
			}
	 
	 
			$data['count'] = $count; 
			$data['p_count'] = $p_count; 
			$this->load->view('promo_dialog',$data);
		  
	}
	
	function add_promo(){
	
		$this->session->set_userdata('discountData', $_POST);
		$count = $this->input->post('count');
		$p_count = $this->input->post('p_count');
		
		if($count > 0 && $p_count < 1){
		
			$config = array(
				array(
					'field'   => 'seniorID[]',
					'label'   => 'ID Number',
					'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[20]|callback__senior_check|callback__senior_check_duplicate|callback__senior_check_name'
				),
				array(
					'field'   => 'seniorLName[]',
					'label'   => 'LastName',
					'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
				),
				
				array(
					'field'   => 'seniorFName[]',
					'label'   => 'FirstName',
					'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[20]'
				),
				array(
					'field'   => 'seniorBdate[]',
					'label'   => 'Birthday',
					'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[20]'
				),
			);
		
		}elseif($count < 1 && $p_count > 0){
		
		
			$config = array(
				array(
					'field'   => 'promoCode[]',
					'label'   => 'Promo Code',
					'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[20]|callback__promo_check'
				), 
			);
		
		
		
		}else{
		
			$config = array(
				array(
					'field'   => 'seniorID[]',
					'label'   => 'ID Number',
					'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[20]|callback__senior_check|callback__senior_check_duplicate|callback__senior_check_name'
				),
				array(
					'field'   => 'seniorLName[]',
					'label'   => 'LastName',
					'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[80]'
				),
				
				array(
					'field'   => 'seniorFName[]',
					'label'   => 'FirstName',
					'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[20]'
				),
				array(
					'field'   => 'seniorBdate[]',
					'label'   => 'Birthday',
					'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[20]'
				),
				array(
					'field'   => 'promoCode[]',
					'label'   => 'Promo Code',
					'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[20]|callback__promo_check'
				), 
			);
		
		 
		}
		
		 
		$this->form_validation->set_rules($config); 

 		$this->form_validation->set_error_delimiters('', '');
		if ($this->form_validation->run() == FALSE)
		{
		 
			
			echo validation_errors();
			 
 		}
		else
		{
		
			$this->promo->add_promo();
			echo 'ok';
		}
	
	}

	
	function _senior_check($str)
	{	
		$senior_exists = $this->promo->is_senior_exist($str);
		if ($senior_exists)
		{
			$this->form_validation->set_message('_senior_check', "Senior ID $senior_exists is already used for this event");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}	
	
	function _senior_check_duplicate()
	{	
	
		$str = $this->input->post('seniorID');
	 
		$dup = $this->array_has_dupes($str);
		
		
		if ($dup)
		{
			$this->form_validation->set_message('_senior_check_duplicate', "Senior ID must be unique");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	function ticket_types($claim = false, $transaction_id = false)
	{
		 
		$_POST = $this->session->userdata('discountData'); 
		 
		 
		// print_r($_POST);
		// die();
		
		
		if ($claim == 'claim')
		{
			// get price info
			$restore_session =  $this->reservations->get_customer_id($transaction_id);	
			//printr($restore_session);
			$customer_session_id = $restore_session->ticket_session_id;
			$cei = $restore_session->ticket_event_id;
			$cpi = $restore_session->ticket_price_id;
			$tix_qty = $this->transactions->_get_num_of_reserved_tix($transaction_id);
			
			// set session data
			$this->session->set_userdata('cei', $cei);
			$this->session->set_userdata('cpi', $cpi);
			$this->session->set_userdata('customer_session_id', $customer_session_id);
			$this->session->set_userdata('claim', $claim);
			$this->session->set_userdata('tid', $transaction_id);
			$this->session->set_userdata('tix_qty', $tix_qty);
		}
		else
		{
			if (!$this->session->userdata('customer_session_id') or !$this->session->userdata('cei') or !$this->session->userdata('cpi'))
			{
				$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
				redirect('');
			}
			
			$customer_session_id = $this->session->userdata('customer_session_id');
			$cei = $this->session->userdata('cei');
			$cpi = $this->session->userdata('cpi');
		}	

		
		// prepare data for the template
		$data['page_title'] = 'Select Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		 

		if ($claim == 'claim')
		{
			// get tickets
			$data['tickets'] = $this->tickets->get_reserved_tickets($transaction_id);
		
			// get price info
			$data['price'] =  $this->prices->get($cpi);
			
		
			// get ticket types
			$ticket_types = $this->ticket_types->get_ticket_types($cei);
		}
		else
		{
			
			// get tickets
			$data['tickets'] = $this->tickets->get_tickets_by_session($this->session->userdata('customer_session_id'), $this->session->userdata('cpi'));

			// get price info
			$data['price'] =  $this->prices->get($this->session->userdata('cpi'));
		
	        // get ticket types
	        $ticket_types = $this->ticket_types->get_ticket_types($this->session->userdata('cei'));
		}
		
		$data['event'] = $this->events->get($this->session->userdata('cei'));
		
        $event_ticket_types = unserialize($data['price']->event_ticket_types);
 
        foreach ($ticket_types as $ticket_type)
        {
            if (in_array($ticket_type->ticket_type_id, $event_ticket_types))
            {
                $tt_array[$ticket_type->ticket_type_id] = $ticket_type->ticket_type_name;
            }
        }
        $data['ticket_types'] = $tt_array;
		
		 
			
		if ($this->session->userdata('transaction_type') == 'reserve' && $claim != 'claim')
		{
			// update db
			$this->tickets->edit_ticket_type();
			 
			
			// redirect
			redirect('transactions/customer_info/');
		}
		else
		{			
			// update db
			$this->tickets->edit_ticket_type();
		
			// redirect
			redirect('transactions/payment/'.$claim);
		}	
 
	}
	
	
	function array_has_dupes($array) {
 	   
	 
	   if(count(array_unique($array))<count($array))
		{
			return true;
		}
		else
		{
			return false;
		}
	   
	   
	}
	
	function _senior_check_name()
	{	
 
	
		$senior_exists = $this->promo->is_senior_name_exist();
		if ($senior_exists)
		{
			$this->form_validation->set_message('_senior_check_name', "Senior $senior_exists->senior_fname $senior_exists->senior_lname already used discount for this event");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
 
	
	function _promo_check($str)
	{	
		// $qr_exist = $this->promo->is_promo_code_exist($str);
		

		$eid = $this->session->userdata('cei');
		 

		$turok = array(5577,5628,5627,5630,5629,5631,5632,5634,5633,5636,5635,5638,5637,5640,5639);
		$galaxy_battles = array(6255, 6256, 6257 , 6254);

		if($eid == 5732){
			//SCOUT MUSIC FEST
			$qr_exist = $this->promo->is_promo_code_exist_static($str);
			
		}elseif($eid == 5661){
			//in the mix
			$qr_exist = $this->promo->is_promo_code_exist_static_itm($str);
			
		}elseif($eid == 5731){
			
			$qr_exist = $this->promo->is_promo_code_exist_ariana($str);
			
		}elseif(in_array($eid, $turok)){
		
			$qr_exist = $this->promo->is_promo_code_exist_turok($str);
		
		}elseif($eid == 6821){
			
			$qr_exist = $this->promo->is_promo_code_exist_one_legends($str);
			
		}elseif($eid == 6054){
			
			$qr_exist = $this->promo->is_promo_code_exist_mb($str);
			
		}elseif($eid == 5735){
			
			$qr_exist = $this->promo->is_promo_code_exist_laurus($str);
			
		}elseif(in_array($eid, $galaxy_battles)){
			
			$qr_exist = $this->promo->is_promo_code_exist_gb($str);
			
		}elseif($eid == 6335){
			//joe and tamiya
			$qr_exist = $this->promo->is_promo_code_exist_joe($str);
			
		}elseif($eid == 6411){
			 
			$qr_exist = $this->promo->is_promo_code_exist_celine($str);
			
		}elseif($eid == 6299){
			 
			$qr_exist = $this->promo->is_promo_code_exist_katy($str);
			
		}elseif($eid == 6895){
			 
			$qr_exist = $this->promo->is_promo_code_exist_neon($str);
			
		}elseif($eid == 6730){
			 
			$qr_exist = $this->promo->is_promo_code_exist_bowling($str);
			
		}elseif($eid == 6819){ //acon
			 
			$qr_exist = $this->promo->is_promo_code_exist_acon($str);
			
		}elseif($eid == 7126){ //one fc 2018
			 
			$qr_exist = $this->promo->is_promo_code_exist_onefc($str);
			
		}elseif($eid == 7131){ //PLUS63 HALLOWEEN & SINULOG
			 
			$qr_exist = $this->promo->is_promo_code_exist_plus($str);
			
		}elseif($eid == 7132){ //PLUS63 HALLOWEEN & SINULOG
			 
			$qr_exist = $this->promo->is_promo_code_exist_plus($str);
			
		}elseif($eid == 7027){ //Project 5Star | Ticket Promo Mechanics
			 
			$qr_exist = $this->promo->is_promo_code_exist_project($str);
			
		}elseif($eid == 4137){ //Nice to meet you promo 6890
			 
			$qr_exist = $this->promo->is_promo_code_exist_pdmn($str);
			
		}elseif($eid == 7327){ //LAUV CEBU
			 
			$qr_exist = $this->promo->is_promo_code_exist_lauv($str);
			
		}elseif($eid == 7341){ //JASON MRAZ
			 
			$qr_exist = $this->promo->is_promo_code_exist_jason($str);
			
		}elseif($eid == 6998){ //KAMIKAZEE
			 
			$qr_exist = $this->promo->is_promo_code_exist_kamikazee($str);
			
		}elseif($eid == 7366){ //BLACKPINK
			 
			$qr_exist = $this->promo->is_promo_code_exist_blackpink($str);
			
		}elseif(in_array($eid, array(7346,7342, 7349, 7357 , 7358, 7359,7360,7361,7362,7347,7508,7509,7510,7511,7512,7349,7514,7515,7516,7517,7518,7519,7534,7540,7541,7568,7569,7570))){ // madame butterfly
			 
			$qr_exist = $this->promo->is_promo_code_exist_madame($str);
			
		}elseif($eid == 7607){ //ONE: ROOTS OF HONOR
			 
			$qr_exist = $this->promo->is_promo_code_exist_onehero($str);
			
		}elseif($eid == 7526){ //Troye Sivan Fan Club pre sale
			 
			$qr_exist = $this->promo->is_promo_code_exist_sevenfivetwosix($str);
			
		}elseif($eid == 7504){ //DREAMCATCHER 
			 
			$qr_exist = $this->promo->is_promo_code_exist_sevenfivezerofour($str);
			
		}elseif($eid == 7503){ //BRAVE22 
			 
			$qr_exist = $this->promo->is_promo_code_exist_sevenfivezerothree($str);
			
		}elseif($eid == 7847){ //BRAVE22 
			 
			$qr_exist = $this->promo->is_promo_code_exist_chain($str);
			
		}else{
			
			$qr_exist = $this->promo->is_promo_code_exist($str);
		
		}



		
		if ($qr_exist)
		{
			$qrcode = explode("|", $qr_exist);
			$result = $qrcode[1];
			$qrcode = $qrcode[0];
			
		 
			if($result == 'ok'){ 
 				return TRUE;
			}
			
			if($result == 'not'){ 
				$this->form_validation->set_message('_promo_check', "PromoCode $qrcode is already used for this event");
				return FALSE;
			}elseif($result == 'selected'){ 
			
				$this->form_validation->set_message('_promo_check', "PromoCode $qrcode is currently in use");
				return FALSE;
			
			}elseif($result == 'qty'){ 
			
				$this->form_validation->set_message('_promo_check', "Sorry, please select 2 tickets");
				return FALSE;
			
			} 
	  
		}
		else
		{
			// coke event promo
			if($eid==7689){
				$this->form_validation->set_message('_promo_check', "PromoCode $str could not be recognized/expired. Please try other sections or ticket type.");
			}else{
				$this->form_validation->set_message('_promo_check', "PromoCode $str could not be recognized. Please try other sections or ticket type.");
			}
			return FALSE;
		}
	}	
	

	function gtqr_ticket_types($claim = false, $transaction_id = false)
	{
		 
		$_POST = $this->session->userdata('discountData'); 
		 
		 
		// print_r($_POST);
		// die();
		
		
		if ($claim == 'claim')
		{
			// get price info
			$restore_session =  $this->reservations->get_customer_id($transaction_id);	
			//printr($restore_session);
			$customer_session_id = $restore_session->ticket_session_id;
			$cei = $restore_session->ticket_event_id;
			$cpi = $restore_session->ticket_price_id;
			$tix_qty = $this->transactions->_get_num_of_reserved_tix($transaction_id);
			
			// set session data
			$this->session->set_userdata('cei', $cei);
			$this->session->set_userdata('cpi', $cpi);
			$this->session->set_userdata('customer_session_id', $customer_session_id);
			$this->session->set_userdata('claim', $claim);
			$this->session->set_userdata('tid', $transaction_id);
			$this->session->set_userdata('tix_qty', $tix_qty);
		}
		else
		{
			if (!$this->session->userdata('customer_session_id') or !$this->session->userdata('cei') or !$this->session->userdata('cpi'))
			{
				$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
				redirect('');
			}
			
			$customer_session_id = $this->session->userdata('customer_session_id');
			$cei = $this->session->userdata('cei');
			$cpi = $this->session->userdata('cpi');
		}	

		
		// prepare data for the template
		$data['page_title'] = 'Select Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		 

		if ($claim == 'claim')
		{
			// get tickets
			$data['tickets'] = $this->tickets->get_reserved_tickets($transaction_id);
		
			// get price info
			$data['price'] =  $this->prices->get($cpi);
			
		
			// get ticket types
			$ticket_types = $this->ticket_types->get_ticket_types($cei);
		}
		else
		{
			
			// get tickets
			$data['tickets'] = $this->tickets->get_tickets_by_session($this->session->userdata('customer_session_id'), $this->session->userdata('cpi'));

			// get price info
			$data['price'] =  $this->prices->get($this->session->userdata('cpi'));
		
	        // get ticket types
	        $ticket_types = $this->ticket_types->get_ticket_types($this->session->userdata('cei'));
		}
		
		$data['event'] = $this->events->get($this->session->userdata('cei'));
		
        $event_ticket_types = unserialize($data['price']->event_ticket_types);
 
        foreach ($ticket_types as $ticket_type)
        {
            if (in_array($ticket_type->ticket_type_id, $event_ticket_types))
            {
                $tt_array[$ticket_type->ticket_type_id] = $ticket_type->ticket_type_name;
            }
        }
        $data['ticket_types'] = $tt_array;
		
		 
			
		if ($this->session->userdata('transaction_type') == 'reserve' && $claim != 'claim')
		{
			// update db
			$this->tickets->edit_ticket_type();
			 
			
			// redirect
			redirect('gtqr_transactions/customer_info/');
		}
		else
		{			
			// update db
			$this->tickets->edit_ticket_type();
		
			// redirect
			redirect('gtqr_transactions/payment/'.$claim);
		}	
 
	}
	
	 function check_gc($gc_code,$gc_set){
	$gc_code_array = $this->promo->view_gc_code(	$gc_code 	);
	if($gc_code_array){
		if(	$gc_code_array->gc_status == "available" && $gc_code_array->gc_reference_info == 0 && $gc_code_array->gc_set == $gc_set	){
			echo $gc_code_array->gc_amount;
		}else if($gc_code_array->gc_status == "selected"){
			echo "invalid. currently being used";
		}else if($gc_code_array->gc_status == "used"){
			echo "invalid. already used";
		}
	}else{
		echo "invalid. non-existent";
	}

 }
 
	 function select_gc($gc_code,$gc_set){
		$affected_row = $this->promo->select_gc_code(	$gc_code, $gc_set 	);

		if($affected_row > 0){
			echo "success";
		}else{
			echo "failed";
		}
		
	 }
	 
	 function unselect_gc($gc_code,$gc_set){
		$affected_row = $this->promo->unselect_gc_code(	$gc_code, $gc_set 	);

		if($affected_row > 0){
			echo "success";
		}else{
			echo "failed";
		}
		
	 }
	
	function reset_promo($code,$transaction_id = FALSE){
		
		$affected_row = $this->promo->reset_code($code,$transaction_id);

		if($affected_row > 0){
			echo "success";
		}else{
			echo "failed";
		}
	}
	
	 
}
