<?php
class PrintOut extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('ekbarcode_model', 'ekbarcode');
		$this->load->model('events_model', 'events');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('prices_model', 'prices');
		$this->load->model('printout_model', 'printout');
		$this->load->model('sections_model', 'sections');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('users_model', 'users');
		$this->load->database('default');

		// cannot restrict to certain access group since printing is via 3rd party application
	}
	
	function index()
	{
		// $this->load->view('welcome_message');
	}

	function dynamic($event_id = 0, $transaction_id = false, $user_id = 0) {
		$this->logs->add("Generating Ticket... $transaction_id");
		$transaction_id = str_replace(".pdf","",$transaction_id);
		
		// define if necessary like when bcode uses this
		$serial = "";
		
		// define this according to user_type: use "paid_online" if it is by online_seller
		$type = "paid";
		
		$transaction = $this->transactions->get($transaction_id);
		if  (count($transaction) > 0) {} 
		else { 
			show_404(); 
			// print_r($transaction);
		}
		$tickets = $this->tickets->get_tickets_by_transaction($transaction_id, '', $type);
		if  (count($tickets) > 0) {} 
		else { 
			show_404(); 
			// print_r($tickets);
		}
		
		if ($transaction->transaction_status != 'done') {
			$data['transaction'] = $transaction;
			$data['type'] = $type;
			// $data['event'] = $this->events_model->get($event_id);
			$data['tickets'] = $tickets;
			$data['serial'] = $serial;

			// set proper header for PDF formats
			$this->load->helper('file');
			$header = "$transaction_id.pdf";
			$this->output->set_header('Content-type: '.get_mime_by_extension($header));
			$this->output->set_header('Content-Disposition: ; filename="'. $header .'"');
			
			// check if tickets have not been printed
			// and fetch the tickets from the server then print
			$this->load->view('printout_dynamic_ticket', $data);
			
			// mark the transaction and tickets as Done
			// $this->transactions->transaction_done($transaction_id);
			$this->printout->setTicketPrintDate($transaction_id);
			$this->logs->add('Ticket Generated for Printing');

		} else { show_404(); }
	}
	
	function sample() 
	{
		$this->logs->add("Sample Printout");
		$this->load->helper('file');
		$header = "ticket.pdf";
		$this->output->set_header('Content-type: '.get_mime_by_extension($header));
		$this->output->set_header('Content-Disposition: ; filename="'. $header .'"');
		echo read_file('./uploads/sample/'.$header);
	}
}
?>