<?php

class Prices extends CI_Controller 
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('venues_model', 'venues');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('prices_model', 'prices');
		$this->load->model('events_model', 'events');
		$this->load->model('sections_model', 'sections');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('prices/listing');
	}
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		// prepare data for the template
		$data['page_title'] = 'Price';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get ticket prices
		$data['prices'] = $this->prices->get_prices($event_id);
				
		// get the event info
		$data['event'] = $this->events->get($event_id);
		
		$this->load->view('prices_listing', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($price_id = FALSE)
	{
		if (!$price_id) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'View Price';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
	
		// get ticket types
		$data['price'] = $this->prices->get($price_id);
		
		// display the page
		$this->load->view('prices_view', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Add Price';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'price_name',
				'label'   => 'Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'price_price',
				'label'   => 'Price',
				'rules'   => 'trim|numeric|required|strip_tags'
			),
			array(
			'field' => 'price_package',
			'label' => 'Package',
			'rules' => 'trim|numeric|required|strip_tags|min_length[1]|max_length[2]'
			),
 
			array(
				'field'   => 'price_sections[]',
				'label'   => 'Sections',
				'rules'   => 'trim|required|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get the event info
		$data['event'] = $this->events->get($event_id);
		
		
		
		$status=$this->events->get_valid_date_status($event_id);

		if($status == 1){
			$used = FALSE;
		}else{
			$used = $this->prices->get_used_sections($event_id);
		}
		
		
		// echo '<pre>';
		// print_r($data['event']);
		// echo '</pre>';
		
		
		// get event sections
		$data['sections'] = $this->sections->get_unique_sections_dropdown($data['event']->event_seatplan_id, $used);
		
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('prices_add', $data);
		}
		else
		{
			$this->prices->add($event_id);
			$this->events->generate_price_sections_per_event($event_id); //for smphi reports
			$this->session->set_flashdata('message', assemble_message('Price has been successfully added'));
			redirect('prices/listing/');
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($price_id = false)
	{
		if (!$price_id) show_404();
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');

		// prepare data for the template
		$data['page_title'] = 'Edit Price';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));

		$config = array(

			array(
			'field' => 'price_name',
			'label' => 'Name',
			'rules' => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
			array(
			'field' => 'price_price',
			'label' => 'Price',
			'rules' => 'trim|numeric|required|strip_tags|min_length[1]|max_length[255]'
			),
			
			
			array(
			'field' => 'price_package',
			'label' => 'Package',
			'rules' => 'trim|numeric|required|strip_tags|min_length[1]|max_length[2]'
			),
			array( 
			'field' => 'price_sections[]',
			'label' => 'Sections',
			'rules' => 'trim|required|strip_tags'
			),
		);

		$this->form_validation->set_rules($config);

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		// get the event info
		$data['event'] = $this->events->get($event_id);
		
		$status=$this->events->get_valid_date_status($event_id);

		if($status == 1){
			$used = FALSE;
		}else{
			$used = $this->prices->get_used_sections($event_id,$price_id);
		}
		
		
		// get event sections
		$data['sections'] = $this->sections->get_unique_sections_dropdown($data['event']->event_seatplan_id,$used);


		if ($this->form_validation->run() == FALSE)
		{
			// get user's data
			$data['price'] = $this->prices->get($price_id);

			
			// display the page
			$this->load->view('prices_edit', $data);
		}
		else
		{
			$this->prices->edit($price_id);
			$this->events->generate_price_sections_per_event($event_id); //for smphi reports
			$this->session->set_flashdata('message', assemble_message('Price has been successfully modified'));
			redirect('prices/listing/');
		}
	}

	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($price_id = false)
	{
		if (!$price_id) show_404();
		
		// log this
		$this->logs->add('Delete Price');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		$this->prices->delete($price_id);
		$this->session->set_flashdata('message', assemble_message('Price has been successfully deleted'));
		redirect('prices/listing/');
	}	
}
/* End of file prices.php */
/* Location: ./application/controllers/prices.php */	
