<?php

class Price_event_dates extends CI_Controller 
{
	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('venues_model', 'venues');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('prices_model', 'prices');
		$this->load->model('events_model', 'events');
		$this->load->model('sections_model', 'sections');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('price_event_dates/listing');
	}
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		// prepare data for the template
		$data['page_title'] = 'Price Dates';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get ticket price dates
		$data['price_dates'] = $this->prices->get_price_dates($event_id);
				
		// get the event info
		$data['event'] = $this->events->get($event_id);
		
		$this->load->view('price_dates_listing', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($price_id = FALSE)
	{
		if (!$price_id) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'View Price';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
	
		// get ticket types
		$data['price'] = $this->prices->get($price_id);
		
		// display the page
		$this->load->view('prices_view', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Add Price Date';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'price_event_date_name',
				'label'   => 'Price Date Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'price_event_date_price_id[]',
				'label'   => 'Prices',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
			'field' => 'price_event_date_date',
			'label' => 'Price Dates',
			'rules' => 'trim|required|strip_tags'
			),
 
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get the event info
		$data['event'] = $this->events->get($event_id);
		
		// get the price id array
		$data['prices'] = $this->prices->get_array($event_id);
		
		// get used price dates
		$data['used_dates'] = $this->prices->get_used_dates($event_id);
		
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('price_dates_add', $data);
		}
		else
		{
			$this->prices->add_price_date($event_id);
			$this->session->set_flashdata('message', assemble_message('Price date has been successfully added'));
			redirect('price_event_dates/listing/');
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($price_date_id = false)
	{
		if (!$price_date_id) show_404();
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');

		// prepare data for the template
		$data['page_title'] = 'Edit Price Date';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));

		$config = array(
			array(
				'field'   => 'price_event_date_name',
				'label'   => 'Price Date Name',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'price_event_date_price_id[]',
				'label'   => 'Prices',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
			'field' => 'price_event_date_date',
			'label' => 'Price Dates',
			'rules' => 'trim|required|strip_tags'
			),
 
		);

		$this->form_validation->set_rules($config);

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		// get the event info
		$data['event'] = $this->events->get($event_id);

		
		// get the price id array
		$data['prices'] = $this->prices->get_array($event_id);
		
		// get used price dates
		$data['used_dates'] = $this->prices->get_used_dates($event_id,$price_date_id);


		if ($this->form_validation->run() == FALSE)
		{
			// get price_date's data
			$data['price_date'] = $this->prices->get_price_date_info($price_date_id);		

			// display the page
			$this->load->view('price_dates_edit', $data);
		}
		else
		{
			$this->prices->edit_price_date($event_id,$price_date_id);
			$this->session->set_flashdata('message', assemble_message('Price has been successfully modified'));
			redirect('price_event_dates/listing/'.$event_id);
		}
	}

	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($price_date_id = false)
	{
		if (!$price_date_id) show_404();
		
		// log this
		$this->logs->add('Delete Price Date');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
		
		$this->prices->delete_price_date($price_date_id);
		$this->session->set_flashdata('message', assemble_message('Price date has been successfully deleted'));
		redirect('price_event_dates/listing/');
	}
	
	function change_status($stat,$price_dates_id){
		$status = $this->prices->edit_status($stat,$price_dates_id);
		$event_id = $this->session->userdata('cei');
		if($status){
			$this->session->set_flashdata('message', assemble_message('Price date has been successfully modified'));
			redirect('price_event_dates/listing/'.$event_id);
		}else{
			$this->session->set_flashdata('message', assemble_message('An error occured. Please try again.'));
			redirect('price_event_dates/listing/'.$event_id);
		}
	}
}
/* End of file prices.php */
/* Location: ./application/controllers/prices.php */	
