<?php

class Online_transactions extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('venues_model', 'venues');
		$this->load->model('sections_model', 'sections');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('events_model', 'events');
		$this->load->model('online_transactions_model', 'otransactions');
		$this->load->model('prices_model', 'prices');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('customers_model', 'customers');
		$this->load->model('reservations_model', 'reservations');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('payments_model', 'payments');
		$this->load->model('branches_model', 'branches');
		$this->load->model('new_reports_model', 'new_reports');
		$this->load->database('default');
		// $this->load->model('tourgroup_model', 'tourgroup');
	}
	
	function index()
	{
		show_404();
	}
	
	function listing($offset = 0)
	{
	
		if($offset == 1){
		
			$this->session->unset_userdata('searchkey');
			 
		}
 
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		// check user session
		$this->users->check_session(array('Dashboard', 'Admin','Super Admin','Admin2','Finance','Reservation-Admin','Reservation','Seller'));
		
		// constants
		$this->load->library('pagination');		
		$limit = $this->pagination->per_page;
		// $offset = $this->uri->segment(3);
		
		// prepare data for the template
		$data['page_title'] = 'Dashboard - Online Transactions';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$searchkey = array();
		$searchflds = array('transaction_id', 'name', 'customer_mobile', 'event_id' , 'transtat_def');
		foreach ($searchflds as $fld)
		{
			if ($this->input->post($fld))
			{ 
				// use the term from POST and set it to session
				$searchkey[ $fld ] = $this->input->post($fld); 
				$this->session->set_userdata('searchkey', $searchkey);  
			}
			else 
			{

				// if term is not in POST use existing term from session
				$searchkey = $this->session->userdata('searchkey');
				
			}
			 
			if(isset($searchkey[ $fld ])){
			
				$data[$fld]= $searchkey[ $fld ];
			}else{ 
				$data[$fld]= '';
			}

		}
		
	  
	    $transtat = $data['transtat_def'];
		$data["transtatus"] = $this->otransactions->get_transaction_status();
		$transtat_def = $this->input->post('transtat_def');
			$data["transtat_def"] = $transtat_def;
		$transdate_def = $this->input->post('transdate');
			$data["transdate_def"] = $transdate_def;
		if (empty($transdate_def)) { $data["limit"] = $limit = 20; } else { $data["limit"] = $limit = 0; }
		$data['transactions'] = $this->otransactions->get_all_online_transactions($transdate_def, $transtat, $data['transaction_id'], $data['name'], $data['customer_mobile'], $data['event_id'], $offset, $limit);
		
		// $data['transdate'] = $this->otransactions->get_online_transaction_dates();
		$data['offset'] = $offset;
		// pagination
		$config['base_url'] = site_url('online_transactions/listing');
		// $config['total_rows'] = $this->otransactions->get_terminal_transactions_allcount($this->input->post('transaction_id'), $this->input->post('name'), $this->input->post('customer_mobile'));
		// $config['total_rows'] = $this->otransactions->get_terminal_transactions_allcount_alt(0,$this->input->post('transaction_id'), $this->input->post('name'), $this->input->post('customer_mobile'), $this->input->post('event_id'));
		// $config['total_rows'] = $this->otransactions->get_terminal_transaction_count($searchkey);

		
		// echo count($data['transactions']);
		// die();
		$config['total_rows'] = count($data['transactions']);
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		$this->session->unset_userdata('senior_id');
		$this->benchmark->mark('query_end');	
		$this->load->view('online_transactions_listing', $data);
		$this->benchmark->mark('page_end');
		
		// $querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		// $pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		// $this->logs->benchmark_add($querytime, $pagetime);
		
	}	
	
	function listing_by_customer($customer = 0, $offset = 0)
	{
	
		if($customer == 0)
		$customer = $this->session->userdata('oci');
		else
		$this->session->set_userdata('oci', $customer);
		
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		// check user session
		$this->users->check_session(array('Dashboard', 'Admin','Super Admin','Admin2'));
		
		// constants
		$this->load->library('pagination');		
		$limit = $this->pagination->per_page;
		// $offset = $this->uri->segment(3);
		
		// prepare data for the template
		$data['page_title'] = 'Transactions';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$searchkey = array();
		$searchflds = array('transaction_id', 'name', 'customer_mobile');
		foreach ($searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		$data['transactions'] = $this->otransactions->get_terminal_transactions_by_customer($customer, $this->input->post('transaction_id'), $this->input->post('name'), $this->input->post('customer_mobile'), $offset, $limit);
		$data['customer'] = $this->customers->get($customer);
	
		$config['uri_segment'] = 4;
		$data['offset'] = $offset;
		// pagination
		$config['base_url'] = site_url('online_transactions/listing_by_customer/'. + $customer);
		// $config['total_rows'] = $this->otransactions->get_terminal_transactions_allcount($this->input->post('transaction_id'), $this->input->post('name'), $this->input->post('customer_mobile'));
		$config['total_rows'] = $this->otransactions->get_terminal_transactions_allcount_alt($customer, $this->input->post('transaction_id'), $this->input->post('name'), $this->input->post('customer_mobile'));
		// $config['total_rows'] = $this->otransactions->get_terminal_transaction_count($searchkey);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		$this->session->unset_userdata('senior_id');
		$this->benchmark->mark('query_end');	
		$this->load->view('online_transactions_by_customer', $data);
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
		
	}
	
	function edit_details($transaction_id= false){
	
		if (!$transaction_id) show_404();
		
		
			// prepare data for the template
		$data['page_title'] = 'Edit Payment Details';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Dashboard', 'Admin','Super Admin'));
			
		$config = array(
			array(
				'field'   => 'card_number',
				'label'   => 'Card Number',
				'rules'   => 'trim|required|strip_tags|min_length[2]|max_length[16]'
			),
			array(
				'field'   => 'extra_field',
				'label'   => 'Extra Field',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[100]'
			),


		);
		
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
				
			//get details
			$data['result'] = $this->otransactions->get_payment_details($transaction_id);
		
			
			$data['transaction_id'] = $transaction_id;
			// display the page
			$this->load->view('payment_details_edit', $data);
		}
		else
		{
			$this->otransactions->edit_details($transaction_id);
			$this->session->set_flashdata('message', assemble_message('Payment details has been successfully added.'));
			redirect('online_transactions/listing');
		}
	
	}

	// --------------------------------------------------------------------
	
	/**
	 * transaction view
	 *
	 * @access	public
	 */
	function view($transaction_id = false)
	{
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		
		if (!$transaction_id) show_404();
				
		// prepare data for the template
		$data['page_title'] = 'Transaction Details';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Dashboard', 'Admin','Super Admin','Seller','Finance','Reservation-Admin'));
	
		// get details
		$data['transaction'] = $this->otransactions->get($transaction_id);
		// $data['tourgroup'] = $this->tourgroup->get_tour_inf($transaction_id);
		$data['tickets2void'] = $this->tickets->get_ticket_count_for_void($transaction_id);
		$data['tickets'] = $this->tickets->get_done_tickets($transaction_id);
		$data['tickets'] = $this->tickets->get_tickets_by_transaction($transaction_id, '', '');
		$data['payments'] = $this->payments->get_payments($transaction_id);
		
		if (count($data['tickets']) > 0)
		{
			$data['event'] =  $this->events->get($data['tickets'][0]->ticket_event_id);
		}
		/*else
		{
			show_404();
		}*/
		
		$this->benchmark->mark('query_end');
		// display the page
		$this->load->view('online_transactions_view', $data);
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
		
	}	
	
	// --------------------------------------------------------------------
	
	function test(){
	
	$result = $this->otransactions->get_payment_details(32767);
	
	if($result)
	echo 'yes';
	else
	echo 'no';
	
	// echo '<pre>';
	// print_r($result);
	// echo '</pre>';

	}

}	
/* End of file transactions.php */
/* Location: ./application/controllers/transactions.php */	
