`<?php
class Newsletter extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('venues_model', 'venues');
		$this->load->model('contacts_model', 'contacts');
		$this->load->model('news_model', 'news');
		$this->load->model('newsletter_model', 'newsletter');
		$this->load->model('logs_model', 'logs');
		$this->load->model('reports_model', 'reports');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('newsletter/listing');
	}
	
	
	function listing() {
		// prepare data for the template
		$data['page_title'] = 'Newsletter Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		
		
		$this->load->view('newsletter_listing', $data);
	}
	
	
	
	
	function shows_by_venue() {
		// prepare data for the template
		$data['page_title'] = 'Image Upload Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

	
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		
			$config = array(
			array(
				'field'   => 'venue_id',
				'label'   => 'Venue',
				'rules'   => 'trim|required|strip_tags|max_length[20]'
			), 
		
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		
		if ($this->form_validation->run() == FALSE)
		{		
			
			$data['newsletter'] = $this->newsletter->get_shows_by_venue();
			$data['venues'] = $this->newsletter->get_venues_dropdown();
			$this->load->view('newsletter_shows_by_venue', $data);
		 
			
		}
		else
		{

		
			$this->newsletter->update_shows_by_venue($this->input->post('venue_id'));
		
			redirect('newsletter/');
		
		}
		
		

		
	}
	
	function type_of_event() {
		// prepare data for the template
		$data['page_title'] = 'Image Upload Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

	
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		
			$config = array(
			array(
				'field'   => 'event_type',
				'label'   => 'Event Type',
				'rules'   => 'trim|required|strip_tags|max_length[20]'
			), 
		
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		
		if ($this->form_validation->run() == FALSE)
		{		
			
			$data['newsletter'] = $this->newsletter->get_type_of_event();
			// $data['venues'] = $this->venues->get_venues_dropdown();
			$this->load->view('newsletter_type_of_event', $data);
		 
			
		}
		else
		{

		
			$this->newsletter->update_type_of_event($this->input->post('event_type'));
		
			redirect('newsletter/');
		
		}
		
		

		
	}
	
	function single_event() {
		// prepare data for the template
		$data['page_title'] = 'Image Upload Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

	
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		
			$config = array(
			array(
				'field'   => 'event_long_title',
				'label'   => 'Event',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			), 
		
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		
		if ($this->form_validation->run() == FALSE)
		{		
			
			$data['newsletter'] = $this->newsletter->get_single_event();
			// $data['venues'] = $this->venues->get_venues_dropdown();
			$this->load->view('newsletter_single_event', $data);
		 
			
		}
		else
		{

		
			$this->newsletter->update_single_event($this->input->post('event_long_title')); 
			redirect('newsletter/');
		
		}
		
		

		
	}
	
	function pick_of_week() {
		// prepare data for the template
		$data['page_title'] = 'Image Upload Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

	
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		
			$config = array(
			array(
				'field'   => 'events[]',
				'label'   => 'Event',
				'rules'   => 'trim|required|strip_tags'
			), 
		
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		
		if ($this->form_validation->run() == FALSE)
		{		
			
			$data['events'] = $this->newsletter->get_event_list(); 
			$data['newsletter'] = $this->newsletter->get_pick_of_week();
			$this->load->view('newsletter_pick_of_week', $data);
		 
			
		}
		else
		{
 
			$this->newsletter->update_pick_of_week($this->input->post('events')); 
			redirect('newsletter/');
		
		}
		
		

		
	}
	
	function hot_events() {
		// prepare data for the template
		$data['page_title'] = 'Image Upload Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

	
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		
			$config = array(
			array(
				'field'   => 'events[]',
				'label'   => 'Event',
				'rules'   => 'trim|required|strip_tags'
			), 
		
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		
		if ($this->form_validation->run() == FALSE)
		{		
			
			$data['events'] = $this->newsletter->get_event_list(); 
			$data['newsletter'] = $this->newsletter->get_hot_events();
			$this->load->view('newsletter_hot_events', $data);
		 
			
		}
		else
		{
 
			$this->newsletter->update_hot_events($this->input->post('events')); 
			redirect('newsletter/');
		
		}
		
		

		
	}
	
	function top_events() {
		// prepare data for the template
		$data['page_title'] = 'Image Upload Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

	
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		
			$config = array(
			array(
				'field'   => 'events[]',
				'label'   => 'Event',
				'rules'   => 'trim|required|strip_tags'
			), 
		
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		
		if ($this->form_validation->run() == FALSE)
		{		
			
			$data['events'] = $this->newsletter->get_event_list(); 
			$data['newsletter'] = $this->newsletter->get_top_events();
			$this->load->view('newsletter_top_events', $data);
		 
			
		}
		else
		{
 
			$this->newsletter->update_top_events($this->input->post('events')); 
			redirect('newsletter/');
		
		}
		
		

		
	}
	
	
	
	
	
}
/* End of file news.php */
/* Location: ./application/controllers/news.php */	
