<?php
class News extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('venues_model', 'venues');
		$this->load->model('contacts_model', 'contacts');
		$this->load->model('news_model', 'news');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('news/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// prepare data for the template
		$data['page_title'] = 'News';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get all venues
		$data['allnews'] = $this->news->get_all();
		
		$this->load->view('news_listing', $data);
	}
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($news_id = FALSE)
	{
		if (! $news_id) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'View news';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get user's data
		$data['news'] = $this->news->get($news_id);
				
		// display the page
		$this->load->view('news_view', $data);
	}		
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add()
	{
		// prepare data for the template
		$data['page_title'] = 'Add News';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$config = array(
			array(
				'field'   => 'news_title',
				'label'   => 'Title',
				'rules'   => 'trim|required|strip_tags|min_length[2]'
			),
			array(
				'field'   => 'news_content',
				'label'   => 'Content',
				'rules'   => 'trim|required|strip_tags|min_length[1]'
			),
			array(
				'field'   => 'news_dateposted',
				'label'   => 'Date Posted',
				'rules'   => 'trim|required|strip_tags'
			),
			
		);
		
		$this->form_validation->set_rules($config); 		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');		
		if ($this->form_validation->run() == FALSE)
		{					
			// display the page
			$this->load->view('news_add', $data);
		}
		else
		{	
			$news_id = $this->news->add();
			$this->session->set_flashdata('message', assemble_message('News has been successfully added'));
			redirect('news/listing');
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _newsname_check
	 *
	 * @access	private
	 */
	function _newsname_check($str)
	{	
		$newsname_exists = $this->news->is_newsname_exist($str);
		if ($newsname_exists)
		{
			$this->form_validation->set_message('_newsname_check', "The news $str already exists.");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($news_id = FALSE)
	{
		if (! $news_id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit news';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'news_title',
				'label'   => 'Title',
				'rules'   => 'trim|required|strip_tags|min_length[2]'
			),
			array(
				'field'   => 'news_content',
				'label'   => 'Content',
				'rules'   => 'trim|required|strip_tags|min_length[1]'
			),
			array(
				'field'   => 'news_dateposted',
				'label'   => 'Date Posted',
				'rules'   => 'trim|required|strip_tags'
			),
			
		);
		
		$this->form_validation->set_rules($config); 		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{			
			// get data
			$data['news'] = $this->news->get($news_id);
			
			// display the page
			$this->load->view('news_edit', $data);
		}
		else
		{
			$this->news->edit($news_id);
			$this->session->set_flashdata('message', assemble_message('News has been successfully modified'));
			redirect('news/listing');
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($news_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete news');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->news->delete($news_id);
		$this->session->set_flashdata('message', assemble_message('News has been successfully deleted'));
		redirect('news/listing/');
	}

	// --------------------------------------------------------------------
	
	/**
	 * activate
	 *
	 * @access	public
	 */
	function activate($news_id = false)
	{
		// log this
		$this->logs->add('Activate news', $news_id);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->news->activate($news_id);
		$this->session->set_flashdata('message', assemble_message('News has been successfully activated'));
		redirect('news/listing/');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * deactivate
	 *
	 * @access	public
	 */
	function deactivate($news_id = false)
	{
		// log this
		$this->logs->add('Activate news', $news_id);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->news->deactivate($news_id);
		$this->session->set_flashdata('message', assemble_message('News has been successfully deactivated'));
		redirect('news/listing/');
	}
}
/* End of file news.php */
/* Location: ./application/controllers/news.php */	
