<?php

class New_reports extends CI_Controller {

    public function __construct()
	{
		parent::__construct();
        $this->load->model('users_model', 'users');
        $this->load->model('reports_model', 'reports');
        $this->load->model('new_reports_model', 'new_reports');
         $this->load->model('logs_model', 'logs');
		$this->load->database('default');


    }

    // --------------------------------------------------------------------


    /**
     * index
     *
     * @access    public
     */
    function index()
    {

    }

    function unredeemed_report_list()
    {

        $data['form_url'] = uri_string();

        $data['page_title'] = 'Unredeemed Report List';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

        $config = array(
            array(
                'field'   => 'event_id',
                'label'   => 'Event',
                'rules'   => 'trim|required|required|strip_tags|max_length[10]'
            ),
        );

        $this->form_validation->set_rules($config);

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE)
        {
            // display the page
            $this->load->view('new_report_unredeemed_filter', $data);
        }
        else
        {

            // retrieve form filter values: event_id / reports_date
            $data['reports'] = $this->new_reports->get_report_details();
            $data['result'] = $this->new_reports->get_unredeemed_list();
            $data['dl']    = $this->input->post('dl');
                if ($data['dl'] != '')
                {
                    $this->load->helper('file');

                    $header = "Unredeemed Report List.csv";
                    //echo $header;
                    $this->output->set_header('Content-type: '.get_mime_by_extension($header));

					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
                }

				$this->load->view('new_reports_unredeemed_list',$data);


        }
    }

    function top_spenders_list(){
        $data['form_url'] = uri_string();

        $data['page_title'] = 'Top Spenders List';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

        $config = array(
            array(
                'field'   => 'event_id',
                'label'   => 'Event',
                'rules'   => 'trim|required|required|strip_tags|max_length[10]'
            ),
        );

        $this->form_validation->set_rules($config);
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE){
            // display the page
            $this->load->view('new_top_spenders_filter', $data);
        }
        else{
            // retrieve form filter values: event_id / reports_date
            $data['reports'] = $this->new_reports->get_report_details();

            $data['dl']    = $this->input->post('dl');
            $category = $this->input->post('category');

                if ($data['dl'] != ''){
                    $this->load->helper('file');
                    $header = "Unredeemed Report List.csv";
                    $this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
                }


                if($category == "qty"){
                    $data['result'] = $this->new_reports->top_spenders_list_by_qty();
					$this->load->view('new_reports_top_spenders_list_by_qty',$data);
                }

                elseif($category == "amount"){
                $data['result'] = $this->new_reports->top_spenders_list_by_amount();
					$this->load->view('new_reports_top_spenders_list_by_amount',$data);
                }

        }
    }

    function eplus_report()
    {

        $data['form_url'] = uri_string();

        $data['page_title'] = 'EPLUS Report List';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

        $config = array(
            array(
                'field'   => 'reports_date',
                'label'   => 'Report Date',
                'rules'   => 'trim|required|required|strip_tags'
            ),
        );

        $this->form_validation->set_rules($config);

$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE)
        {
            // display the page
            $this->load->view('eplus_report_filter', $data);
        }
        else
        {

            // retrieve form filter values: event_id / reports_date
            $data['reports'] = $this->new_reports->get_report_details();
            $data['result'] = $this->new_reports->get_eplus_report_list();
            $data['dl']    = $this->input->post('dl');
                if ($data['dl'] != '')
                {
                    $this->load->helper('file');

                    $header = "EPLUS Report List.csv";
                    //echo $header;
                    $this->output->set_header('Content-type: '.get_mime_by_extension($header));

$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
                }

                $this->load->view('new_reports_eplus',$data);


        }
    }

  /*   function sold_seats($status= false, $event_id = false){


    }

 */

 
	function sold_seats($status= false, $event_id = false)
	{

	if(!$status && !$event_id){

	die('Please check parameters..');
	}


	$data['form_url'] = uri_string();

	$data['page_title'] = 'Unredeemed Report List';
	$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

	// log this
	$this->logs->add($data['page_title']);

	// check user session
	$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));


	// retrieve form filter values: event_id / reports_date
	$data['result'] = $this->new_reports->get_sold_seats($status,$event_id);

	$this->load->helper('file');

	$header = "Sold Ticket List.csv";
	//echo $header;
	$this->output->set_header('Content-type: '.get_mime_by_extension($header));

	$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');


	$this->load->view('new_reports_sold_seat_list',$data);

 }
 
 
    function depstore()
    {

        $data['form_url'] = uri_string();

        $data['page_title'] = 'SM Sales and Commission Report';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);

        $this->form_validation->set_rules($config);

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE)
        {
            // display the page
            $this->load->view('new_report_depstore_filter', $data);
        }
        else
        {

            // retrieve form filter values: event_id / reports_date
            // $data['reports'] = $this->new_reports->get_report_details();
            // $data['result'] = $this->new_reports->get_unredeemed_list();
            $data['dl']    = $this->input->post('dl');
                if ($data['dl'] != '')
                {
                    $this->load->helper('file');

                    $header = "SM Sales and Commission Report.csv";
                    //echo $header;
                    $this->output->set_header('Content-type: '.get_mime_by_extension($header));

			$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
							}

			$this->load->view('depstore',$data);
 
		}
	}
	
	function depstore_online()
    {

        $data['form_url'] = uri_string();

        $data['page_title'] = 'SM Sales and Commission Online Report';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);

        $this->form_validation->set_rules($config);

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE)
        {
            // display the page
            $this->load->view('new_report_online_depstore_filter', $data);
        }
        else
        {
 
			// retrieve form filter values: date_from / date_to / branch_id
			$data['reports'] = $this->reports->reports_filter('REPORTSOTC');
			$data['events'] = $this->reports->get_events($data['reports']['event_id']);
			$data['users'] = $this->reports->get_users($data['reports']['user_id']);
			$data['branch_details'] = $this->reports->get_branch($data['reports']['branch_id']);
			//$data['terminals'] = $this->reports->get_terminal_details($data['reports']['terminal_id']);
			//retrieve needed branch details --> as of 12-07-2010 only branch name
			//$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
	
				if ($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					error_reporting(0);
					
					$branch_name = $data['branch_details']->branch_name;
					$eve_name = $data['events']->event_title;
					$otc_fname = $data['users']->user_firstname;
					$otc_lname = $data['users']->user_lastname;
					$otc_name = $otc_fname . ' ' . $otc_lname;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					if($branch_name == '' || $eve_name == '' || $otc_lname == '')
					{
						$header = "All Events All Branch All Users [$date_from to $date_to].csv";
					}
					else 
					{
						$header = "$eve_name $branch_name $otc_name [$date_from to $date_to].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					//}
				}
		 
			$this->load->view('depstore_online',$data);
 
  
 
 
		}
	}
	
	

	function ticket_list()
    {

        $data['form_url'] = uri_string();

        $data['page_title'] = 'Ticket List';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		$data['ticket_list_type'] = '';
        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),	
			
			array(
				'field'   => 'event_id',
				'label'   => 'Event',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			
			array(
				'field'   => 'status',
				'label'   => 'Status',
				'rules'   => 'trim|required|required|strip_tags|max_length[20]'
			),
		);

        $this->form_validation->set_rules($config);

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE)
        {
            // display the page
			$data['ticket_types'] = $this->new_reports->get_ticket_types_dropdown();
            $this->load->view('new_report_ticket_list_filter', $data);
        }
        else
        {
 
            $data['result'] = $this->new_reports->get_ticket_list();
			
			// print_r($data['result']);
            $data['dl']    = $this->input->post('dl');
                if ($data['dl'] != '')
                {
                    $this->load->helper('file');

                    $header = "Ticket Report List.csv";
                    //echo $header;
                    $this->output->set_header('Content-type: '.get_mime_by_extension($header));

			$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
							}

			
			if($this->input->post('status') == 'voided'){
				 
				$this->load->view('ticket_list_void',$data);
				
			}else{
				
				$this->load->view('ticket_list',$data);
				 
			}
			
			
			
			
 
		}
	}

  
	function customer_list()
    {

        $data['form_url'] = uri_string();

        $data['page_title'] = 'Customer List';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),	
			
			array(
				'field'   => 'event_id',
				'label'   => 'Event',
				'rules'   => 'trim|required|required|strip_tags'
			),
			
			array(
				'field'   => 'status',
				'label'   => 'Status',
				'rules'   => 'trim|required|required|strip_tags|max_length[20]'
			),
		);

        $this->form_validation->set_rules($config);

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE)
        {
            // display the page
			$data['ticket_types'] = $this->new_reports->get_ticket_types_dropdown();
            $this->load->view('new_report_customer_list_filter', $data);
        }
        else
        {
 
			
			if($this->input->post('online_registration') == 1){
			
 				$data['result'] = $this->new_reports->get_customer_list_online();
			
			}else{
			 
				$data['result'] = $this->new_reports->get_customer_list();
			 
			}
			
			
			
			// print_r($data['result']);
            $data['dl']    = $this->input->post('dl');
                if ($data['dl'] != '')
                {
                    $this->load->helper('file');

                    $header = "Customer Report List.csv";
                    //echo $header;
                    $this->output->set_header('Content-type: '.get_mime_by_extension($header));

			$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
							}

			if($this->input->post('online_registration') == 1){
			
 				$this->load->view('customer_list_online',$data);
			
			}else{
			 
 				$this->load->view('customer_list',$data);
			 
			}
			
							
 
 
 
 
 
		}
	}

	function eplus_card_report(){
		
		
		$data['form_url'] = uri_string();
		$data['page_title'] = "Summary of Issued e-PLUS Cards";
		  
 		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
		
		
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			$data['branches'] = $this->new_reports->get_branches_dropdown();
			// display the page
			$this->load->view('new_report_eplus_filter', $data);
		}
		else
		{

			$data['date_from'] = $this->input->post('date_from');
			$data['date_to'] = $this->input->post('date_to');
			
			$data['branches'] = $this->input->post('branches');
			
			
			
			$data['report_view'] = $this->input->post('view');
			$data['report_dl'] = $this->input->post('dl');
			
			 
			
			if($data['report_dl'] != '')
			{
				$this->load->helper('file');
				
 				$date_from = $data['date_from'];
				$date_to = $data['date_to'];
				
				$header = "Regular Sales Report[$date_from to $date_to].csv";
				$this->output->set_header('Content-type: '.get_mime_by_extension($header));
				$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				
			}
	  
  			$this->load->view('new_report_eplus',$data);
		 
			
		 
		}
	
	}
 	
	function eplus_card_report_one(){
		
		
		$data['form_url'] = uri_string();
		$data['page_title'] = "Summary of Issued One Direction Cards";
		  
 		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
		
		
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			$data['branches'] = $this->new_reports->get_branches_dropdown();
			// display the page
			$this->load->view('new_report_eplus_filter', $data);
		}
		else
		{

			$data['date_from'] = $this->input->post('date_from');
			$data['date_to'] = $this->input->post('date_to');
			
			$data['branches'] = $this->input->post('branches');
			
			
			
			$data['report_view'] = $this->input->post('view');
			$data['report_dl'] = $this->input->post('dl');
			
			 
			
			if($data['report_dl'] != '')
			{
				$this->load->helper('file');
				
 				$date_from = $data['date_from'];
				$date_to = $data['date_to'];
				
				$header = "Regular Sales Report[$date_from to $date_to].csv";
				$this->output->set_header('Content-type: '.get_mime_by_extension($header));
				$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				
			}
	  
  			$this->load->view('new_report_eplus_one',$data);
		 
			
		 
		}
	
	}
 
 	function eplus_card_report_one_group(){
		
		
		$data['form_url'] = uri_string();
		$data['page_title'] = "Summary of Issued One Direction Cards";
		  
 		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
		
		
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			$data['branches'] = $this->new_reports->get_branches_dropdown();
			// display the page
			$this->load->view('new_report_eplus_filter', $data);
		}
		else
		{

			$data['date_from'] = $this->input->post('date_from');
			$data['date_to'] = $this->input->post('date_to');
			
			$data['branches'] = $this->input->post('branches');
			
			
			
			$data['report_view'] = $this->input->post('view');
			$data['report_dl'] = $this->input->post('dl');
			
			 
			
			if($data['report_dl'] != '')
			{
				$this->load->helper('file');
				
 				$date_from = $data['date_from'];
				$date_to = $data['date_to'];
				
				$header = "Regular Sales Report[$date_from to $date_to].csv";
				$this->output->set_header('Content-type: '.get_mime_by_extension($header));
				$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				
			}
	  
  			$this->load->view('new_report_eplus_one_group',$data);
		 
			
		 
		}
	
	}
 
 	
    function megaworld()
    {

        $data['form_url'] = uri_string();

        $data['page_title'] = 'SM Sales and Commission Report (Megaworld)';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);

        $this->form_validation->set_rules($config);

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE)
        {
            // display the page
            $this->load->view('new_report_megaworld_filter', $data);
        }
        else
        {

            // retrieve form filter values: event_id / reports_date
            // $data['reports'] = $this->new_reports->get_report_details();
            // $data['result'] = $this->new_reports->get_unredeemed_list();
            $data['dl']    = $this->input->post('dl');
                if ($data['dl'] != '')
                {
                    $this->load->helper('file');

                    $header = "SM Sales and Commission Report.csv";
                    //echo $header;
                    $this->output->set_header('Content-type: '.get_mime_by_extension($header));

			$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
							}

			$this->load->view('megaworld',$data);
 
		}
	}
	
	function megaworld_online()
    {

        $data['form_url'] = uri_string();

        $data['page_title'] = 'SM Sales and Commission Online Report';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);

        $this->form_validation->set_rules($config);

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE)
        {
            // display the page
            $this->load->view('new_report_megaworld_online_filter', $data);
        }
        else
        {
 
			// retrieve form filter values: date_from / date_to / branch_id
			$data['reports'] = $this->reports->reports_filter('REPORTSOTC');
			$data['events'] = $this->reports->get_events($data['reports']['event_id']);
			$data['users'] = $this->reports->get_users($data['reports']['user_id']);
			$data['branch_details'] = $this->reports->get_branch($data['reports']['branch_id']);
			//$data['terminals'] = $this->reports->get_terminal_details($data['reports']['terminal_id']);
			//retrieve needed branch details --> as of 12-07-2010 only branch name
			//$data['branch_details'] = $this->reports->get_branch_details($data['reports']['branch_id']);
	
				if ($data['reports']['report_dl'] != '')
				{
					$this->load->helper('file');
					error_reporting(0);
					
					$branch_name = $data['branch_details']->branch_name;
					$eve_name = $data['events']->event_title;
					$otc_fname = $data['users']->user_firstname;
					$otc_lname = $data['users']->user_lastname;
					$otc_name = $otc_fname . ' ' . $otc_lname;
					$date_from = $data['reports']['date_from'];
					$date_to = $data['reports']['date_to'];
					if($branch_name == '' || $eve_name == '' || $otc_lname == '')
					{
						$header = "All Events All Branch All Users [$date_from to $date_to].csv";
					}
					else 
					{
						$header = "$eve_name $branch_name $otc_name [$date_from to $date_to].csv";
					}
					//echo $header;
					$this->output->set_header('Content-type: '.get_mime_by_extension($header));
					
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
					//}
				}
		 
			$this->load->view('megaworld_online',$data);
 
  
 
 
		}
	}
	
	//iptl
	function eplus_card_report_iptl($id = false){
		
		
		$data['form_url'] = uri_string();
		$data['page_title'] = "Summary of Issued e-PLUS Cards";
		  
 		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
		
		
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			$data['branches'] = $this->new_reports->get_branches_dropdown();
			// display the page
			$this->load->view('new_report_eplus_filter', $data);
		}
		else
		{

			$data['date_from'] = $this->input->post('date_from');
			$data['date_to'] = $this->input->post('date_to');
			
			$data['branches'] = $this->input->post('branches');
			
			
			
			$data['report_view'] = $this->input->post('view');
			$data['report_dl'] = $this->input->post('dl');
			
			 
			
			if($data['report_dl'] != '')
			{
				$this->load->helper('file');
				
 				$date_from = $data['date_from'];
				$date_to = $data['date_to'];
				
				$header = "Regular Sales Report[$date_from to $date_to].csv";
				$this->output->set_header('Content-type: '.get_mime_by_extension($header));
				$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				
			}
			
			$data['e_id'] = $id;
  			$this->load->view('new_report_eplus_iptl',$data);
		 
			
		 
		}
	
	}
 	
	 
	function eplus_card_voided_report_iptl($id = false){
		
		
		$data['form_url'] = uri_string();
		$data['page_title'] = "Summary of Voided e-PLUS Cards";
		  
 		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
		
		
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			$data['branches'] = $this->new_reports->get_branches_dropdown();
			// display the page
			$this->load->view('new_report_eplus_filter', $data);
		}
		else
		{

			$data['date_from'] = $this->input->post('date_from');
			$data['date_to'] = $this->input->post('date_to');
			
			$data['branches'] = $this->input->post('branches');
			
			
			
			$data['report_view'] = $this->input->post('view');
			$data['report_dl'] = $this->input->post('dl');
			
			 
			
			if($data['report_dl'] != '')
			{
				$this->load->helper('file');
				
 				$date_from = $data['date_from'];
				$date_to = $data['date_to'];
				
				$header = "Regular Sales Report[$date_from to $date_to].csv";
				$this->output->set_header('Content-type: '.get_mime_by_extension($header));
				$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				
			}
	  
			$data['e_id'] = $id;
  			$this->load->view('new_report_eplus_voided_iptl',$data);
		 
			
		 
		}
	
	}
 	
	function ticket_list_conso()
    {

        $data['form_url'] = uri_string(); 
        $data['page_title'] = 'Ticket List';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		//to identify ticket list conso from ticket list
		$data['ticket_list_type'] = 'conso';
		
        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance', 'Promoter'));

		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),	
			
			array(
				'field'   => 'event_id',
				'label'   => 'Event',
				'rules'   => 'trim|required|required|strip_tags'
			),
			
			array(
				'field'   => 'status',
				'label'   => 'Status',
				'rules'   => 'trim|required|required|strip_tags|max_length[20]'
			),
		);

        $this->form_validation->set_rules($config);

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE)
        {
            // display the page
			$data['ticket_types'] = $this->new_reports->get_ticket_types_dropdown();
            $this->load->view('new_report_ticket_list_filter', $data);
        }
        else
        {
 
            $data['result'] = $this->new_reports->get_ticket_list_conso();
			
			// print_r($data['result']);
            $data['dl']    = $this->input->post('dl');
                if ($data['dl'] != '')
                {
                    $this->load->helper('file');

                    $header = "Ticket Report List.csv";
                    //echo $header;
                    $this->output->set_header('Content-type: '.get_mime_by_extension($header));

			$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
							}

			// $this->load->view('ticket_list_conso',$data);
 
			if($this->input->post('status') == 'voided'){
				 
				$this->load->view('ticket_list_conso_void',$data);
				
			}else{
				
				$this->load->view('ticket_list_conso',$data);
				 
			}
			
 
		}
	}
	
	
	function keka(){
		
		$stack = $this->reports->get_event_title();
		
		// $stack = array_push($stack, "All Events");
		// $stack[10] = "All Events";
		
		echo "<pre>";
		print_r($stack);
		echo "</pre>";
		die();
	}
 
	
	function ticket_list_v2()
    {

        $data['form_url'] = uri_string();

        $data['page_title'] = 'Ticket List';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		$data['ticket_list_type'] = '';
        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),	
			
			array(
				'field'   => 'event_id',
				'label'   => 'Event',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			
			array(
				'field'   => 'status',
				'label'   => 'Status',
				'rules'   => 'trim|required|required|strip_tags|max_length[20]'
			),
		);

        $this->form_validation->set_rules($config);

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE)
        {
            // display the page
			$data['ticket_types'] = $this->new_reports->get_ticket_types_dropdown();
            $this->load->view('new_report_ticket_list_filter', $data);
        }
        else
        {
 
            $data['result'] = $this->new_reports->get_ticket_list_v2();
			
			// print_r($data['result']);
            $data['dl']    = $this->input->post('dl');
                if ($data['dl'] != '')
                {
                    $this->load->helper('file');

                    $header = "Ticket Report List.csv";
                    //echo $header;
                    $this->output->set_header('Content-type: '.get_mime_by_extension($header));

			$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
							}

			
			
			if($this->input->post('status') == 'voided'){
				 
				$this->load->view('ticket_list_v2_void',$data);
				
			}else{
				
				$this->load->view('ticket_list_v2',$data);
				 
			}
			
  
		}
	}

		//iptl
	function eplus_card_report_generic($id = false){
		
		
		$data['form_url'] = uri_string();
		$data['page_title'] = "Summary of Issued e-PLUS Cards";
		  
 		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
		
		
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			$data['branches'] = $this->new_reports->get_branches_dropdown();
			// display the page
			$this->load->view('new_report_eplus_filter', $data);
		}
		else
		{

			$data['date_from'] = $this->input->post('date_from');
			$data['date_to'] = $this->input->post('date_to');
			
			$data['branches'] = $this->input->post('branches');
			
			
			
			$data['report_view'] = $this->input->post('view');
			$data['report_dl'] = $this->input->post('dl');
			
			 
			
			if($data['report_dl'] != '')
			{
				$this->load->helper('file');
				
 				$date_from = $data['date_from'];
				$date_to = $data['date_to'];
				
				$header = "Regular Sales Report[$date_from to $date_to].csv";
				$this->output->set_header('Content-type: '.get_mime_by_extension($header));
				$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				
			}
			
			$data['e_id'] = $id;
  			$this->load->view('new_report_eplus_iptl',$data);
		 
			
		 
		}
	
	}
 		
	function eplus_card_voided_report_generic($id = false){
		
		
		$data['form_url'] = uri_string();
		$data['page_title'] = "Summary of Voided e-PLUS Cards";
		  
 		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
		
		
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			$data['branches'] = $this->new_reports->get_branches_dropdown();
			// display the page
			$this->load->view('new_report_eplus_filter', $data);
		}
		else
		{

			$data['date_from'] = $this->input->post('date_from');
			$data['date_to'] = $this->input->post('date_to');
			
			$data['branches'] = $this->input->post('branches');
			
			
			
			$data['report_view'] = $this->input->post('view');
			$data['report_dl'] = $this->input->post('dl');
			
			 
			
			if($data['report_dl'] != '')
			{
				$this->load->helper('file');
				
 				$date_from = $data['date_from'];
				$date_to = $data['date_to'];
				
				$header = "Regular Sales Report[$date_from to $date_to].csv";
				$this->output->set_header('Content-type: '.get_mime_by_extension($header));
				$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				
			}
	  
			$data['e_id'] = $id;
  			$this->load->view('new_report_eplus_voided_iptl',$data);
		 
			
		 
		}
	
	}
 	
	
	//dreamplay
	
	function dreamplay_annual_pass($id = false){
		
		
		$data['form_url'] = uri_string();
		$data['page_title'] = "Summary of Issued e-PLUS Cards";
		  
 		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
		
		
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			$data['branches'] = $this->new_reports->get_branches_dropdown();
			// display the page
			$this->load->view('new_report_eplus_filter', $data);
		}
		else
		{

			$data['date_from'] = $this->input->post('date_from');
			$data['date_to'] = $this->input->post('date_to');
			
			$data['branches'] = $this->input->post('branches');
			
			
			
			$data['report_view'] = $this->input->post('view');
			$data['report_dl'] = $this->input->post('dl');
			
			 
			
			if($data['report_dl'] != '')
			{
				$this->load->helper('file');
				
 				$date_from = $data['date_from'];
				$date_to = $data['date_to'];
				
				$header = "Regular Sales Report[$date_from to $date_to].csv";
				$this->output->set_header('Content-type: '.get_mime_by_extension($header));
				$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				
			}
			
			$data['e_id'] = $id;
  			$this->load->view('new_report_eplus_dreamplay',$data);
		 
			
		 
		}
	
	}
 	
	function dreamplay_annual_pass_voided($id = false){
		
		
		$data['form_url'] = uri_string();
		$data['page_title'] = "Summary of Voided e-PLUS Cards";
		  
 		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
		
		
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			$data['branches'] = $this->new_reports->get_branches_dropdown();
			// display the page
			$this->load->view('new_report_eplus_filter', $data);
		}
		else
		{

			$data['date_from'] = $this->input->post('date_from');
			$data['date_to'] = $this->input->post('date_to');
			
			$data['branches'] = $this->input->post('branches');
			
			
			
			$data['report_view'] = $this->input->post('view');
			$data['report_dl'] = $this->input->post('dl');
			
			 
			
			if($data['report_dl'] != '')
			{
				$this->load->helper('file');
				
 				$date_from = $data['date_from'];
				$date_to = $data['date_to'];
				
				$header = "Regular Sales Report[$date_from to $date_to].csv";
				$this->output->set_header('Content-type: '.get_mime_by_extension($header));
				$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				
			}
			
			$data['e_id'] = $id;
  			$this->load->view('new_report_eplus_dreamplay_voided',$data);
		 
			
		 
		}
	
	}
 	
	function dreamplay_annual_pass_voided2($id = false){
		
		
		$data['form_url'] = uri_string();
		$data['page_title'] = "Summary of Voided e-PLUS Cards";
		  
 		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
		
		
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			$data['branches'] = $this->new_reports->get_branches_dropdown();
			// display the page
			$this->load->view('new_report_eplus_filter', $data);
		}
		else
		{

			$data['date_from'] = $this->input->post('date_from');
			$data['date_to'] = $this->input->post('date_to');
			
			$data['branches'] = $this->input->post('branches');
			
			
			
			$data['report_view'] = $this->input->post('view');
			$data['report_dl'] = $this->input->post('dl');
			
			 
			
			if($data['report_dl'] != '')
			{
				$this->load->helper('file');
				
 				$date_from = $data['date_from'];
				$date_to = $data['date_to'];
				
				$header = "Regular Sales Report[$date_from to $date_to].csv";
				$this->output->set_header('Content-type: '.get_mime_by_extension($header));
				$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				
			}
			
			$data['e_id'] = $id;
  			$this->load->view('new_report_eplus_dreamplay_voided2',$data);
		 
			
		 
		}
	
	}
 	
	function dreamplay_annual_pass_entry($id = false){
		
		
		$data['form_url'] = uri_string();
		$data['page_title'] = "Summary of e-PLUS Card Entry";
		  
 		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));
		
		
		$config = array(
			array(
				'field'   => 'date_from',
				'label'   => 'From',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'date_to',
				'label'   => 'To',
				'rules'   => 'trim|required|required|strip_tags|max_length[10]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE) 
		{
			$data['branches'] = $this->new_reports->get_branches_dropdown();
			// display the page
			$this->load->view('new_report_eplus_filter', $data);
		}
		else
		{

			$data['date_from'] = $this->input->post('date_from');
			$data['date_to'] = $this->input->post('date_to');
			
			$data['branches'] = $this->input->post('branches');
			
			
			
			$data['report_view'] = $this->input->post('view');
			$data['report_dl'] = $this->input->post('dl');
			
			 
			
			if($data['report_dl'] != '')
			{
				$this->load->helper('file');
				
 				$date_from = $data['date_from'];
				$date_to = $data['date_to'];
				
				$header = "Regular Sales Report[$date_from to $date_to].csv";
				$this->output->set_header('Content-type: '.get_mime_by_extension($header));
				$this->output->set_header('Content-Disposition: attachment; filename = "'. $header .'"');
				
			}
			
			$data['e_id'] = $id;
  			$this->load->view('new_report_eplus_dreamplay_entry',$data);
		 
			
		 
		}
	
	}
 	
		
	function lgu_report(){
        $data['form_url'] = uri_string();

        $data['page_title'] = 'LGU Report';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

        $config = array(
            array(
                'field'   => 'event_id',
                'label'   => 'Event',
                'rules'   => 'trim|required|required|strip_tags|max_length[10]'
            ),
			array(
                'field'   => 'date_filter',
                'label'   => 'Date To',
                'rules'   => 'trim|required|required|strip_tags|max_length[10]'
            ),
			
			array(
                'field'   => 'date_filter_from',
                'label'   => 'Date From',
                'rules'   => 'trim|required|required|strip_tags|max_length[10]'
            ),
        );

        $this->form_validation->set_rules($config);
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE){
            // display the page
            $this->load->view('new_report_lgu_filter', $data);
        }
        else{
            // retrieve form filter values: event_id / reports_date
            $data['reports'] = $this->new_reports->get_report_details();

            $data['dl']    = $this->input->post('dl');
            $category = $this->input->post('category');

                if ($data['dl'] != ''){
                    $this->load->helper('file');
                    $header = "Unredeemed Report List.csv";
                    $this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
                }

				$data['result'] = $this->new_reports->get_lgu_report();
				$this->load->view('new_reports_lgu',$data);
			

        }
    }
		
	function lgu_report_list(){
        $data['form_url'] = uri_string();

        $data['page_title'] = 'LGU Report-List';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

        $config = array(
            array(
                'field'   => 'event_id',
                'label'   => 'Event',
                'rules'   => 'trim|required|required|strip_tags|max_length[10]'
            ),
        );

        $this->form_validation->set_rules($config);
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE){
            // display the page
            $this->load->view('new_report_lgu_filter', $data);
        }
        else{
            // retrieve form filter values: event_id / reports_date
            $data['reports'] = $this->new_reports->get_report_details();

            $data['dl']    = $this->input->post('dl');
            $category = $this->input->post('category');

                if ($data['dl'] != ''){
                    $this->load->helper('file');
                    $header = "Unredeemed Report List.csv";
                    $this->output->set_header('Content-type: '.get_mime_by_extension($header));
					$this->output->set_header('Content-Disposition: attachment; filename="'. $header .'"');
                }

				$data['result'] = $this->new_reports->get_lgu_report_list();
				$this->load->view('new_reports_lgu_list',$data);
			

        }
    }
	
	
	function payment_tender_report(){
        $data['form_url'] = uri_string();

        $data['page_title'] = 'Payment Tender Report';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

        $config = array(
            array(
                'field'   => 'event_id',
                'label'   => 'Event',
                'rules'   => 'trim|required|required|strip_tags|max_length[10]'
            ),
			array(
                'field'   => 'reports_date',
                'label'   => 'AS OF',
                'rules'   => 'trim|required|required|strip_tags'
            ),
        );

        $this->form_validation->set_rules($config);
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE){
            // display the page
            $this->load->view('new_report_payment_tender_filter', $data);
        }
        else{
            // retrieve form filter values: event_id / reports_date
            $data['reports'] = $this->new_reports->get_report_details();
            $data['event_id'] = $this->input->post('event_id');

  

			$this->load->view('new_reports_payment_tender',$data);
			

        }
    }
	
	
	function payment_tender_report2(){
        $data['form_url'] = uri_string();

        $data['page_title'] = 'Payment Tender Report (Ticket Type)';
        $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

        // log this
        $this->logs->add($data['page_title']);

        // check user session
        $this->users->check_session(array('Admin','Super Admin','Admin2', 'Finance'));

        $config = array(
            array(
                'field'   => 'event_id',
                'label'   => 'Event',
                'rules'   => 'trim|required|required|strip_tags|max_length[10]'
            ),
			array(
                'field'   => 'reports_date',
                'label'   => 'AS OF',
                'rules'   => 'trim|required|required|strip_tags'
            ),
        );

        $this->form_validation->set_rules($config);
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
        if ($this->form_validation->run() == FALSE){
            // display the page
            $this->load->view('new_report_payment_tender_filter', $data);
        }
        else{
            // retrieve form filter values: event_id / reports_date
            $data['reports'] = $this->new_reports->get_report_details();
            $data['event_id'] = $this->input->post('event_id');

  

			$this->load->view('new_reports_payment_tender2',$data);
			

        }
    }
	
	
	
}

/* End of file reports.php */
/* Location: ./application/controllers/reports.php */