<?php

class Misc extends CI_Controller {

	/* NOTE: using a model class to handle dbproc causes 
		memory to run out and greatly affects 
		PDF generation based on XML generator
		
		Tested 100-200 ticket nodes for loading using
		initial output design for db storage and PDF generation
	*/
		
	public function __construct()
	{
		parent::__construct();
		$this->load->model('generator_model', 'ticket_generator');
	}

	function reprint($yearmonth = false, $id = false, $trans_id = false){
		// called by PrinterApp - remove .pdf filename extension
		$trans_id = str_replace(".pdf","",$trans_id);
		
		$xmldata = "";
		$validcall = false;
		if (($trans_id > 0) && ($yearmonth > 0) && ($id > 0)){
			// validate transaction 
			// $validcall = $this->generator->validatePaidTransactionWithXML($yearmonth, $id, $trans_id);
			$validcall = true;
		}
		
		if (!$validcall) {
			show_404();
			// echo $this->db->last_query();
			die("invalid call");
		}
		
		if ($yearmonth && $id) {
			$this->db->where("xml_id", $id);
			$this->db->where("xml_yearmonth", $yearmonth);
			$query = $this->db->get("generator");
			
			foreach($query->result() as $row) {
				$xmldata = $row->xml_content;
			}
		} else {
			die ("Invalid access.");
		}


		$this->load->library('simplexml');  
		$content = $this->simplexml->xml_parse($xmldata, "&amp");
		
		$data['layout'] = $content['layout']['@attributes'];
		if(isset( $content['ticket'][0])){
			$data['tickets']  = $content['ticket'];
		} else {
			$data['tickets'][0]  = $content['ticket'];
		}
		$this->load->helper('file'); 
		$this->load->view('printer_xml2pdf',$data);

	}

	function printer($yearmonth = false, $id = false, $trans_id = false){
		$redirect = "smticket:10.96.100.78/misc/reprint/$yearmonth/$id/$trans_id";
		exit('<meta http-equiv="refresh" content="0; url=' . urldecode($redirect) . '"/>');
	}

} 