<?php

class GTQR_transactions extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('venues_model', 'venues');
		$this->load->model('sections_model', 'sections');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('events_model', 'events');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('prices_model', 'prices');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('customers_model', 'customers');
		$this->load->model('reservations_model', 'reservations');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('payments_model', 'payments');
		$this->load->model('branches_model', 'branches');
		$this->load->model('gtqr_model', 'gtqr');
		$this->load->model('promos_model', 'promo'); 
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		show_404();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing($offset = 0)
	{
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager', 'Finance','Reservation','Reservation-Admin'));
		
		// constants
		$this->load->library('pagination');		
		$limit = $this->pagination->per_page;
		// $offset = $this->uri->segment(3);
		
		// prepare data for the template
		$data['page_title'] = 'Transactions';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$searchkey = array();
		$searchflds = array('transaction_id', 'name', 'customer_mobile');
		foreach ($searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		$data['transactions'] = $this->transactions->get_terminal_transactions($this->input->post('transaction_id'), $this->input->post('name'), $this->input->post('customer_mobile'), $offset, $limit);
		$data['offset'] = $offset;
		// pagination
		$config['base_url'] = site_url('transactions/listing');
		// $config['total_rows'] = $this->transactions->get_terminal_transactions_allcount($this->input->post('transaction_id'), $this->input->post('name'), $this->input->post('customer_mobile'));
		$config['total_rows'] = $this->transactions->get_terminal_transactions_allcount_alt($this->input->post('transaction_id'), $this->input->post('name'), $this->input->post('customer_mobile'));
		// $config['total_rows'] = $this->transactions->get_terminal_transaction_count($searchkey);

		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		$this->benchmark->mark('query_end');	
		$this->load->view('transactions_listing', $data);
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
		
	}	
	
	/**
	 * eventlisting
	 *
	 * @access	public
	 */
	function eventlisting($event_id)
	{				
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager', 'Finance','Reservation','Reservation-Admin'));
		
		// prepare data for the template
		$data['page_title'] = 'Transactions Event Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$searchkey = array();
		$searchflds = array('customer_mobile','transaction_id','name');
		foreach ( $searchflds as $fld)
		{
			$searchkey[$fld] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		// get transactions
		$data['transactions'] = $this->transactions->get_event_transactions_rev($event_id,$searchkey);
		
		// get event
		$data['event'] = $this->events->get($event_id);
	
		$this->load->view('gtqr_transactions_eventlisting', $data);
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * online
	 *
	 * @access	public
	 */
	function online($type = false)
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		// prepare data for the template
		$data['page_title'] = 'Online Transactions';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$this->form_validation->set_rules('barcode', 'Bar Code', 'trim|required|strip_tags|exact_length[8]');
		$this->form_validation->set_error_delimiters('<div class="errors">', '</div>');

		if ($this->form_validation->run() != FALSE)
		{
			if ($type == 'transaction')
			{
				$data['transactions'] = $this->transactions->get_by_barcode($this->input->post('barcode'));
				$data['transactions_tickets'] = $this->transactions->get_by_barcode_ticket_breakdown($this->input->post('barcode'));
			}
			elseif ($type == 'ticket')
			{
				$data['tickets'] = $this->tickets->get_by_barcode($this->input->post('barcode'));
				$data['tickets_detail'] = $this->tickets->get_by_barcode_details($this->input->post('barcode'));
			}
		}
		
		// $this->load->view('transactions_online', $data);
		if ($this->config->item("display_new_ticket")) { 
			$this->load->view('transactions_online_arena', $data);
		} else {
			$this->load->view('transactions_online_rev', $data);
		}
	}	

	// --------------------------------------------------------------------
	
	/**
	 * transaction view
	 *
	 * @access	public
	 */
	function view($transaction_id = false)
	{
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		
		if (!$transaction_id) show_404();
				
		// prepare data for the template
		$data['page_title'] = 'Transaction Details';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
	
		// get details
		$data['transaction'] = $this->transactions->get($transaction_id);
		$data['tickets2void'] = $this->tickets->get_ticket_count_for_void($transaction_id);
		$data['tickets'] = $this->tickets->get_done_tickets($transaction_id);
		$data['tickets'] = $this->tickets->get_tickets_by_transaction($transaction_id, '', '');
		$data['payments'] = $this->payments->get_payments($transaction_id);
		
		if (count($data['tickets']) > 0)
		{
			$data['event'] =  $this->events->get($data['tickets'][0]->ticket_event_id);
		}
		/*else
		{
			show_404();
		}*/
		
		$this->benchmark->mark('query_end');
		// display the page
		$this->load->view('transactions_view', $data);
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * manager login for voiding
	 *
	 * @access	public
	 */
	function manager_login($transaction_id = false)
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		// prepare data for the template
		$data['page_title'] = 'Manager Login';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['transaction_id'] = $transaction_id;
		$this->load->view('managers_login', $data);
	}	
		
	// --------------------------------------------------------------------
	
	/**
	 * void
	 *
	 * @access	public
	 */
	function void($transaction_id = false)
	{
		// prepare data for the template
		$data['page_title'] = 'Void Transaction';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		// get details
		$data['transaction'] = $this->transactions->get($transaction_id);
		$data['customer'] = $this->customers->get($data['transaction']->transaction_customer_id);
		$data['reservation_expiry'] = $this->reservations->reservation_expiry($transaction_id);
		// $data['tickets'] = $this->tickets->get_done_tickets($transaction_id);
		$data['tickets'] = $this->tickets->get_tickets_to_void($transaction_id);
		$data['transaction_id'] = $transaction_id;
		
		if (count($data['tickets']) > 0) {
		$data['event'] =  $this->events->get($data['tickets'][0]->ticket_event_id);
		$this->form_validation->set_rules('tickets[]', 'Ticket', 'trim|required|strip_tags');
		}
		
		$this->form_validation->set_rules('username', 'Username', 'trim|required|strip_tags|max_length[20]|callback__check_manager_login');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|strip_tags|max_length[20]');
		$this->form_validation->set_rules('transaction_comment', 'transaction_comment', 'trim|required|strip_tags|max_length[255]');
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() != FALSE)
		{
			
			if (count($data['tickets']) > 0) { 
				// update db
				list($section_id, $ticket_count) = $this->tickets->void($data['transaction'], $data['tickets']);
				$this->transactions->void($transaction_id);
				
				// update available tickets
				if ($section_id != 0)
				{
					$this->sections->update_available($section_id, 'increase', $ticket_count);
				}
				$message = ($ticket_count > 1) ? 'Tickets have' : 'Ticket has';
				$message .= ' been successfully voided.';
				$this->session->set_flashdata('message', assemble_message($message));
				// redirect('transactions/listing/');
			}
			else {
				$this->transactions->void_transaction_only($transaction_id);
				$message = 'Void request has been processed. Please review status of your transaction.';
				$this->session->set_flashdata('message', assemble_message($message));
			}
			redirect("transactions/view/$transaction_id");

		}
		else
		{
			// display the page
			$this->load->view('transactions_void', $data);		
		}
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * _check_manager_login
	 *
	 * @access	private
	 */
	function _check_manager_login($str)
	{	
		if (!$this->users->manager_login())
		{
			$this->form_validation->set_message('_check_manager_login', "Manager username and password combination is incorrect");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * cancel
	 *
	 * @access	public
	 */
	function cancel($transaction_id = false)
	{
		// prepare data for the template
		$data['page_title'] = 'Cancel Transaction';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager', 'Finance'));
		
		// get details
		$data['transaction'] = $this->transactions->get($transaction_id);
		$data['customer'] = $this->customers->get($data['transaction']->transaction_customer_id);
		$data['reservation_expiry'] = $this->reservations->reservation_expiry($transaction_id);
		$data['tickets'] = $this->tickets->get_done_tickets($transaction_id);
		$data['transaction_id'] = $transaction_id;
		$data['event'] =  $this->events->get($data['tickets'][0]->ticket_event_id);
		
		$this->form_validation->set_rules('tickets[]', 'Ticket', 'trim|required|strip_tags');
		
		if ($this->session->userdata('user_type') == 'Seller')
		{
			$this->form_validation->set_rules('username', 'Username', 'trim|required|strip_tags|max_length[20]|callback__check_manager_login');
			$this->form_validation->set_rules('password', 'Password', 'trim|required|strip_tags|max_length[20]');
			$this->form_validation->set_rules('comment', 'Comment', 'trim|required|strip_tags|max_length[255]');
		}
		
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() != FALSE)
		{
			// update db
			list($section_id, $ticket_count) = $this->tickets->cancel($data['transaction'], $data['tickets']);
			
			// update available tickets
			if ($section_id != 0)
			{
				$this->sections->update_available($section_id, 'increase', $ticket_count);
			}
			$message = ($ticket_count > 1) ? 'Tickets have' : 'Ticket has';
			$message .= ' been successfully cancelled';
			$this->session->set_flashdata('message', assemble_message($message));
			redirect('transactions/listing/');
		}
		else
		{
			// display the page
			$this->load->view('transactions_cancel', $data);		
		}
	}


				
	// --------------------------------------------------------------------
	
	/**
	 * sections
	 *
	 * @access	public
	 */
	function sections($transaction_type = false)
	{
		// check for parameters
		//if (!$price_id) show_404();
		
		$this->load->helper('simplejson');
		
		// check if event id is present or qr is valid
		if (!$this->session->userdata('cei') or !$this->session->userdata('cqr') )
		{
			$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
			redirect('');
		}
		
		// prepare data for the template
		$data['page_title'] = 'Select Section';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		// add session id for the current customer
		if (!$this->session->userdata('customer_session_id'))
		{
			$this->session->set_userdata('customer_session_id', $this->users->prep_password(time() . $this->session->userdata('session_id')));
		}
		
		
		// add price id to session





		// get event
		$event = $this->events->get($this->session->userdata('cei'));
		$data['event'] = $event; 
		
		// get price info




		if ($transaction_type == 'reserve')
		{
			// create session for reserve
			$this->session->set_userdata(array('transaction_type' => 'reserve',));
		}
		else
		{
			// create session for reserve
			$this->session->set_userdata(array('transaction_type' => 'sell',));
		}
		
		// get prices
		$prices = $this->prices->get_prices($event->event_id);
		


		$array = array();


		


		$get_section_names = $this->sections->get_sections($event->event_seatplan_id);
		if ($get_section_names)
		{
			foreach($get_section_names as $r)
				$array[$r->section_id] = $r->section_name;
		}
		$data['section_names'] = $array;
		$data['sections'] = $get_section_names;

		$priceseclist = array();
		foreach($prices as $price):
			$price_section_info = $this->sections->get_ticket_availability($price->price_sections, $event->event_seatplan_id, true, true); 
			$section_type = $price_section_info['type'];







				$available = $price_section_info['total_available'];


			
			$priceseclist[] = array(
				$price->price_name,
				($available > 0)? "" : "*SOLD OUT",
				($section_type == 'Reserved') ? 'Reserved Seats' : $section_type,
				$price->price_price,
				unserialize($price->price_sections),
				$price_section_info,
			);
		endforeach;
		$data['priceseclist'] = $priceseclist;




		

		// echo '<pre>';
		// print_r($priceseclist);
		// echo '</pre>';
		// die();
		
		
		
		
		// display the page
		$this->load->view('gtqr_transactions_sections', $data);
	}	
	 



	// --------------------------------------------------------------------
	
	/**
	 * seats
	 *
	 * @access	public
	 */
	function seats($section_id = false)
	{
		if (!$section_id or !$this->session->userdata('cqr') ) show_404();
		// prepare data for the template
		$data['page_title'] = 'Select Seats';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data['header'] = "<META HTTP-EQUIV=\"PRAGMA\" CONTENT=\"NO-CACHE\">\n<META HTTP-EQUIV=\"CACHE-CONTROL\" CONTENT=\"NO-CACHE\">\n<META HTTP-EQUIV=\"EXPIRES\" CONTENT=\"0\">\n";
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		// add section id to session
		$this->session->set_userdata('csi', $section_id);
		
		// get section info
		$section = $this->sections->get($section_id);
		
		// add price id to session
		$price_id = $this->prices->get_price_id($this->session->userdata('cei'), $section->section_id);
		$this->session->set_userdata('cpi', $price_id);
		
		// redirect if section is not reserved seating
		if ($section->section_type != 'Reserved')
		{
			redirect('gtqr_transactions/ticket_quantity/'.$section_id.'/'.$price_id);
		}

		$config = array(
			array(
				'field'   => 'seat[]',
				'label'   => 'Seat',
				'rules'   => 'trim|required|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		
		if ($this->form_validation->run() != FALSE)
		{
			// add to db
			//$ticket_count = $this->tickets->add($this->session->userdata('cei'), $section);
			
			//if ($ticket_count)
			//{
				// update available tickets
				//$this->sections->update_available($section_id, 'decrease', $ticket_count);
				
				$elem_qty = count($_POST['seat']);
				$seat_qty = count($_POST['seat'], COUNT_RECURSIVE) - $elem_qty;
				//echo '<br />'.$seat_qty;
				
				// add qty of tickets selected to session
				$this->session->set_userdata('tix_qty', $seat_qty);
				
				$get_seat_qty_db = count($this->tickets->get_tickets_by_session($this->session->userdata('customer_session_id'), $this->session->userdata('cpi')));
				//echo '<br />'.$get_seat_qty_db;
				//echo '<br />'.$seat_qty_db;
				
				if ($get_seat_qty_db != $seat_qty)
				{
					$this->session->set_flashdata('message', assemble_error('Error encountered during seats selection. Please try again.<br />'));
					redirect('');
				}
				else
				{
					if($this->session->userdata('transaction_type') == 'reserve')
					{
						// redirect
						//redirect('transactions/customer_info/');
						redirect('gtqr_transactions/ticket_types/');
					}
					else
					{			
						// redirect
						redirect('gtqr_transactions/ticket_types/');
					}
					
				}
				
			//}
			//else
			//{
			//	$this->session->set_flashdata('message', assemble_message('One or more selected tickets are already taken'));
			//	redirect('transactions/seats/'.$section_id.'/'.$price_id);
			//}
		}
		else
		{
			// remove previsouly selected tickets
			$this->tickets->clear_tickets($this->session->userdata('customer_session_id'));
			
			// data
			$data['section'] = $section;
			$data['seat_config'] = unserialize($section->section_seat_config);
			$data['event'] = $this->events->get($this->session->userdata('cei'));
			$data['seats_taken'] = $this->tickets->get_taken_seats($this->session->userdata('cei'), $section_id);		
			$data['price_id'] = $price_id;
			$data['price_price'] = $this->prices->get($price_id);
	
			// display the page
			$this->load->view('gtqr_transactions_seats', $data);
		}
	}
	function ticket_types_json()
	{
		$seats = $this->input->post('ticket_types');
		if($seats)
		{
			$ticket_types_json = $this->ticket_types->get_ticket_types_details(unserialize($seats));
			
			print json_encode(array('ticket_types_json' => $ticket_types_json));
		}
	}
	function get_discount()
	{
		$id = $this->input->post('discount');
		
		$discount = $this->ticket_types->get_ticket_types_discount($id);
		
		print json_encode(array('price_discount' => $discount[0], 'ticket_type_discount_type' => $discount[1]));
		//echo $discount;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * ticket_quantity
	 *
	 * @access	public
	 */
	function ticket_quantity($section_id = false, $price_id = false)
	{
		if (!$section_id or !$this->session->userdata('cqr')) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'Enter Ticket Quantity';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		$event = $this->events->get($this->session->userdata('cei'));
		
		// get section info
		$section = $this->sections->get($section_id);
		$section_info = $this->sections->get_ticket_availability($section_id, $event->event_seatplan_id); 
		// $maxval = $section->section_available;
		
			
		if(	$event->event_id == "4032" || $event->event_id == "4034"){
			$maxval = 2;
		}else{
			$maxval = $section_info['total_available'];
		}
	
		$this->form_validation->set_rules('ticket_quantity', 'Ticket Quantity', 'min_value[1]|max_value['.$maxval.']|trim|required|strip_tags|max_length[3]|integer');
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		// data
		$data['section'] = $section;
		$data['section_info'] = $section_info;
		$data['event'] = $event;
		$data['price_id'] = $price_id;

		if ( $this->form_validation->run() != FALSE )
		{		
			// add to db
			$ticket_count =  $this->tickets->add($this->session->userdata('cei'), $section);
			
			$ticket_qty = $_POST['ticket_quantity'];
			$ticket_qty_db = count($this->tickets->get_tickets_by_session($this->session->userdata('customer_session_id'), $this->session->userdata('cpi')));
			//echo $ticket_qty.','.$ticket_qty_db;
			
			// add qty of tickets selected to session
			$this->session->set_userdata('tix_qty', $ticket_qty);
			
			if (number_format($ticket_qty) != number_format($ticket_qty_db))
			{
				$this->session->set_flashdata('message', assemble_error('Invalid access. Please restart transaction from beginning.<br />'));
				redirect('');
			}
			else 
			{
			
				if ($this->session->userdata('transaction_type') == 'reserve')
				{
					// redirect
					//redirect('transactions/customer_info/');
					redirect('gtqr_transactions/ticket_types/');
				}
				else
				{			
					// redirect
					redirect('gtqr_transactions/ticket_types/');
				}	
			}
		}

		//print_r($this->session->all_userdata());
		
		// display the page
		$this->load->view('gtqr_transactions_ticket_quantity', $data);
	}
	
	
	// ---------------------------------------------------------------------
	/**
	 * customer_add
	 *
	 * @access public
	 */
	 function customer_info()
	 {
	 	 // check for customer session
		if (!$this->session->userdata('customer_session_id') or !$this->session->userdata('cei') or !$this->session->userdata('cpi') or !$this->session->userdata('cqr'))
		{
			$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
			redirect('');
		}
		
		$customer_session_id = $this->session->userdata('customer_session_id');
		
	 	// prepare data for the template
		$data['page_title'] = 'Add Customer';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data['tickets'] = $this->tickets->get_tickets_by_session($customer_session_id);
		$data['price'] =  $this->prices->get($this->session->userdata('cpi'));
		$data['event'] = $this->events->get($this->session->userdata('cei'));
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		// check ticket status
		$this->transactions->_check_tix_stat($customer_session_id, $data['event']->event_id, array('selected'), $this->session->userdata('tix_qty'));
		
		$config = array(
			array(
				'field'   => 'customer_mobile',
				'label'   => 'Mobile Number',
				'rules'   => 'trim|required|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'customer_firstname',
				'label'   => 'First Name',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[20]'
			),
			array(
				'field'   => 'customer_lastname',
				'label'   => 'Last Name',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[20]'
			),
			array(
				'field'   => 'customer_age_bracket',
				'label'   => 'Age',
				'rules'   => 'trim|strip_tags|min_length[1]|max_length[8]'
			),
			array(
				'field'   => 'customer_gender',
				'label'   => 'Gender',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[6]'
			),
			
			array(
				'field'   => 'customer_marital_status',
				'label'   => 'Marital Status',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[20]'
			),
			
			array(
				'field'   => 'customer_notes',
				'label'   => 'Notes',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[20]'
			),
			
			
			array(
				'field'   => 'customer_address1',
				'label'   => 'Address 1',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'customer_address2',
				'label'   => 'Address 2',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[255]'
			),
			array(
				'field'   => 'customer_city',
				'label'   => 'City',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[50]'
			),
			array(
				'field'   => 'customer_zip',
				'label'   => 'Zip Code',
				'rules'   => 'trim|strip_tags|min_length[4]|max_length[10]'
			),
			array(
				'field'   => 'customer_nationality',
				'label'   => 'Nationality',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_phone',
				'label'   => 'Phone Number',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[20]'
			),
			array(
				'field'   => 'customer_fax',
				'label'   => 'Fax Number',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[20]'
			),
			
			array(
				'field'   => 'customer_email',
				'label'   => 'Email Address',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			array(
				'field'   => 'customer_website',
				'label'   => 'Website Address',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[80]'
			),
			
			array(
				'field'   => 'customer_notes',
				'label'   => 'Notes',
				'rules'   => 'trim|strip_tags|min_length[2]|max_length[255]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() == FALSE)
		{
		
			// display the page
			$this->load->view('gtqr_transactions_customer_info',$data);
		}
		else
		{
			// add customer to db
			$customer_id = $this->customers->quick_add();
			$data['events']= $this->events->reservation_expiry($this->session->userdata('cei'));
			$transaction_id = $this->transactions->customer_info($customer_id, $data['events']->event_reservation_expire);
			
			//$this->session->set_flashdata('message', assemble_message('Customer has been successfully added'));
			redirect('gtqr_transactions/reservation_number/'.$transaction_id);
		}

	 }

	// --------------------------------------------------------------------
	
	/**
	 * ticket_types
	 *
	 * @access	public
	 */
	function ticket_types($claim = false, $transaction_id = false)
	{
		$this->session->unset_userdata('seniorData');  
		if ($claim == 'claim')
		{
			// get price info
			$restore_session =  $this->reservations->get_customer_id($transaction_id);	
			//printr($restore_session);
			$customer_session_id = $restore_session->ticket_session_id;
			$cei = $restore_session->ticket_event_id;
			$cpi = $restore_session->ticket_price_id;
			$tix_qty = $this->transactions->_get_num_of_reserved_tix($transaction_id);
			
			// set session data
			$this->session->set_userdata('cei', $cei);
			$this->session->set_userdata('cpi', $cpi);
			$this->session->set_userdata('customer_session_id', $customer_session_id);
			$this->session->set_userdata('claim', $claim);
			$this->session->set_userdata('tid', $transaction_id);
			$this->session->set_userdata('tix_qty', $tix_qty);
		}
		else
		{
			if (!$this->session->userdata('customer_session_id') or !$this->session->userdata('cei') or !$this->session->userdata('cpi') or !$this->session->userdata('cqr'))
			{
				$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
				redirect('');
			}
			
			$customer_session_id = $this->session->userdata('customer_session_id');
			$cei = $this->session->userdata('cei');
			$cpi = $this->session->userdata('cpi');
		}	

		
		// prepare data for the template
		$data['page_title'] = 'Select Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		$config = array(
			array(
				'field'   => 'ticket[]',
				'label'   => 'Ticket',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'ticket_type[]',
				'label'   => 'Ticket Type',
				'rules'   => 'trim|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($claim == 'claim')
		{
			// get tickets
			$data['tickets'] = $this->tickets->get_reserved_tickets($transaction_id);
		
			// get price info
			$data['price'] =  $this->prices->get($cpi);
		
			// get ticket types
			$ticket_types = $this->ticket_types->get_ticket_types($cei);
		}
		else
		{
			
			// get tickets
			$data['tickets'] = $this->tickets->get_tickets_by_session($this->session->userdata('customer_session_id'), $this->session->userdata('cpi'));

			// get price info
			$data['price'] =  $this->prices->get($this->session->userdata('cpi'));
		
	        // get ticket types
	        $ticket_types = $this->ticket_types->get_ticket_types_seller($this->session->userdata('cei'));
		}
		
		$data['event'] = $this->events->get($this->session->userdata('cei'));
		
        $event_ticket_types = unserialize($data['price']->event_ticket_types);
 
        foreach ($ticket_types as $ticket_type)
        {
            if (in_array($ticket_type->ticket_type_id, $event_ticket_types))
            {
                $tt_array[$ticket_type->ticket_type_id] = $ticket_type->ticket_type_name;
            }
        }
		
		if( empty( $tt_array ) )
		{
			 $tt_array = array();
		}
		  

        $data['ticket_types'] = $tt_array;
		
		if ($this->form_validation->run() != FALSE)
		{
			
			if ($this->session->userdata('transaction_type') == 'reserve' && $claim != 'claim')
			{
				// update db
            	$this->tickets->edit_ticket_type();
				
				// redirect
				redirect('gtqr_transactions/customer_info/');
			}
			else
			{			
				// update db
            	$this->tickets->edit_ticket_type();
			
				// redirect
				redirect('gtqr_transactions/payment/'.$claim);
			}	
		}
		else
		{
			$data['uri'] = ($claim == 'claim') ? 'claim/'.$transaction_id : '';
			$data['ticket_type_promo'] = $this->promo->get_ticket_types_promo($cei);

  
			// display the page
			$this->load->view('gtqr_transactions_ticket_types', $data);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * payment
	 *
	 * @access	public
	 */
	function payment()
	{
		// check for customer session
		if (!$this->session->userdata('customer_session_id') or !$this->session->userdata('cei') or !$this->session->userdata('cpi') or !$this->session->userdata('cqr'))
		{
			$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
			redirect('');
		}
				
		$customer_session_id = $this->session->userdata('customer_session_id');
		$cei = $this->session->userdata('cei');
		$cpi = $this->session->userdata('cpi');

		// prepare data for the template
		$data['page_title'] = 'Enter Payment';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation'));
		
		// check ticket status
		$this->transactions->_check_tix_stat($customer_session_id, $cei, array('selected', 'reserved'), $this->session->userdata('tix_qty'));
		
		// get payment types
		//$data['payment_types'] = $this->payment_types->get_payment_types();
		$data['payment_types'] = $this->payment_types->get_payment_type_categories();
		$data['credit_cards'] = $this->payment_types->get_payment_types_dropdown('Credit Card');
		$data['debit_cards'] = $this->payment_types->get_payment_types_dropdown('Debit Card');
		$data['gift_checks'] = $this->payment_types->get_payment_types_dropdown('Gift Check');
		$data['reward_cards'] = $this->payment_types->get_payment_types_dropdown('Reward Card');
		$data['accounts'] = $this->payment_types->get_payment_types_dropdown('Account');
		
		$data['default_cc'] = $this->payment_types->get_payment_type_id_by_categories('Credit Card');
		$data['default_dc'] = $this->payment_types->get_payment_type_id_by_categories('Debit Card');
		$data['default_gc'] = $this->payment_types->get_payment_type_id_by_categories('Gift Check');
		$data['default_rc'] = $this->payment_types->get_payment_type_id_by_categories('Reward Card');
		$data['default_ac'] = $this->payment_types->get_payment_type_id_by_categories('Account');
		
		// validate form
		$this->form_validation->set_rules('customer_mobile', 'Mobile Number', 'trim|required|strip_tags|max_length[15]');
		$this->form_validation->set_rules('customer_firstname', 'First Name', 'trim|strip_tags|max_length[80]');
		$this->form_validation->set_rules('customer_lastname', 'Last Name', 'trim|strip_tags|max_length[20]');
		
		$this->form_validation->set_rules('transaction_payment_cash', 'Cash', 'trim|strip_tags');
		$this->form_validation->set_rules('transaction_payment_credit_card_1', 'Credit Card 1', 'trim|strip_tags|callback__cc1_check');
		$this->form_validation->set_rules('transaction_payment_credit_card_2', 'Credit Card 2', 'trim|strip_tags|callback__cc2_check');
		$this->form_validation->set_rules('transaction_payment_debit_card', 'Debit Card', 'trim|strip_tags|callback__dc_check');
		$this->form_validation->set_rules('transaction_payment_gift_check', 'Gift Check', 'trim|strip_tags|callback__gc_check');
		$this->form_validation->set_rules('transaction_payment_reward_card', 'Reward Card', 'trim|strip_tags|callback__rc_check');
		$this->form_validation->set_rules('transaction_payment_account', 'Account', 'trim|strip_tags|callback__ac_check');
		
		$this->form_validation->set_rules('transaction_credit_card_1', 'Credit Card 1', 'trim|strip_tags');
		$this->form_validation->set_rules('transaction_credit_card_2', 'Credit Card 2', 'trim|strip_tags');
		$this->form_validation->set_rules('transaction_debit_card', 'Debit Card', 'trim|strip_tags');
		$this->form_validation->set_rules('transaction_gift_check', 'Gift Check', 'trim|strip_tags');
		$this->form_validation->set_rules('transaction_reward_card', 'Reward Card', 'trim|strip_tags');
		$this->form_validation->set_rules('transaction_account', 'Account', 'trim|strip_tags');
		
		$this->form_validation->set_rules('total_change', 'Total Change', 'trim|strip_tags|max_length[10]|callback__check_total_change');
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get data
		$data['tickets'] = $this->tickets->get_tickets_by_session($customer_session_id);
		$data['price'] =  $this->prices->get($this->session->userdata('cpi'));
		$data['event'] = $this->events->get($this->session->userdata('cei'));

		if ($this->session->userdata('claim') == 'claim')
		{
			// get transaction detail
			$data['transaction'] = $this->transactions->get($this->session->userdata('tid'));

			// get customer detail
			$data['customer'] = $this->customers->get($data['transaction']->transaction_customer_id);
		}
		if ($this->form_validation->run() != FALSE)
		{
			// add customer to db
			$customer_id = $this->customers->quick_add();
			
			if ($this->session->userdata('claim') == 'claim')
			{
				// update the transaction
				$transaction_id = $this->session->userdata('tid');

				$this->transactions->update($transaction_id, $data['event']->event_reservation_fee, $customer_id);
			}
			else
			{
				// add transaction
				$transaction_id = $this->transactions->add($customer_id);
			}
			
			if ($transaction_id)
			{
				
				$this->gtqr->mark_qrcode_for_transaction_id($cei, $transaction_id, $this->session->userdata('cqr'));
				$this->session->unset_userdata('cqr');
				redirect('gtqr_transactions/done/'.$transaction_id);
			}
			else
			{
				$this->session->set_flashdata('message', assemble_message('Something went wrong with your transaction.  Please try again.'));
				redirect('gtqr_transactions/payment/');
			}
		}
		else
		{
			// display the page
			$this->load->view('gtqr_transactions_payment', $data);
		}
	}
	
	function done($transaction_id = false)
	{
		if (!$transaction_id)
		{
			show_404();
		}
		
		//restore session
		$restore_session =  $this->reservations->get_customer_id($transaction_id);	
		$customer_session_id = $restore_session->customer_id;

		// unset the manager's override on Other Tender Types
		$this->session->unset_userdata('ott');
		
		// prepare data for the template
		$data['page_title'] = 'Transaction Done';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation'));
		$transaction = $data['transaction'] = $this->transactions->get($transaction_id);

		// get data
		$tickets = $this->tickets->get_paid_tickets($transaction_id);
		$cei = $this->session->userdata('cei');
		
		$ticket_count = count($tickets);
		
		// check if there are tickets to print
		if ($ticket_count > 0) { }
 		else { 
			show_404();
		}
		
		if ($transaction->transaction_status != 'done')
		{
			if ($this->config->item("display_new_ticket")) { 
			// NEW: follow process for new ticket generation for normal transactions
				$this->load->model('smbarcode_model', 'smbarcode');
				$success = $this->smbarcode->attach_smcode_to_transaction_tickets($transaction, $tickets);
				
				if ($success) {
					redirect("/ticket_generator/createXMLTickets/$cei/$transaction_id/$ticket_count");
				} else {
					show_404();
				}
				
			} else {
			// OLD: follow old process of ticket generation for normal transactions
			
				$data['tickets'] = $tickets;
				$data['event'] = $this->events->get_by_transaction_id($transaction_id);
				$data['price'] =  $this->prices->get($this->session->userdata('cpi'));
				$ticket_types = $this->ticket_types->get_ticket_types($cei);
				$data['payments'] = $this->payments->get_payments($transaction_id);
				$data['customer'] = $this->customers->get($data['transaction']->transaction_customer_id);

				// generate the ticket
				$this->tickets->generate($transaction_id);
				$this->logs->add('Generate Ticket');
				
				// mark the transaction and tickets as Done
				$this->transactions->transaction_done($transaction_id);
				$this->logs->add('Print Ticket');

				// body onload
				$data['onload'] =  'onLoad="window.location=\'smtickets:'.$_SERVER["HTTP_HOST"].'/uploads/'.md5($transaction_id).'\'"';

				// check ticket status
				$this->transactions->_check_tix_stat($this->session->userdata('customer_session_id'), $data['event']->event_id, array('done'), $this->session->userdata('tix_qty'));

				// display the page
				$this->load->view('gtqr_transactions_done', $data);
			}

		}
		else
		{
			// redirect
			$this->session->set_flashdata('message', assemble_message('Something went wrong with your transaction.  Please try again.'));
			redirect('gtqr_transactions/payment/');
		}
	}	

	function done_rev($transaction_id = 0, $event_id = 0, $param1 = 0, $ticket_count = 0, $param2 = 0)
	{
		if (($transaction_id > 0) && ($event_id > 0) && ($ticket_count > 0)) {}
		else {
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Transaction Done';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		// get data
		$tickets = $this->tickets->get_paid_tickets($transaction_id);
		$cei = $event_id;
		// print_r($tickets);
		// check if there are tickets to print
		 
		if ($ticket_count == count($tickets))
		{
			$data['tickets'] = $tickets;
			$data['event'] = $this->events->get_by_transaction_id($transaction_id);
			$data['price'] =  $this->prices->get($this->session->userdata('cpi'));
			$ticket_types = $this->ticket_types->get_ticket_types($cei);
			$data['transaction'] = $this->transactions->get($transaction_id);
			$data['payments'] = $this->payments->get_payments($transaction_id);
			$data['customer'] = $this->customers->get($data['transaction']->transaction_customer_id);


			// body onload
			// $data['onload'] =  'onLoad="window.location=\'smtickets:'.$_SERVER["HTTP_HOST"].'/uploads/'.md5($transaction_id).'\'"';
			$printcall = site_url("/printer/payment_done_db2xml2pdf/$param1/$param2/$transaction_id");
			$printcall = str_replace("http://","smtickets:", $printcall);
			$data['onload'] =  "onLoad='window.location=\"$printcall\"'";

			// check ticket status
			$this->transactions->_check_tix_stat($this->session->userdata('customer_session_id'), $data['event']->event_id, array('paid'), $this->session->userdata('tix_qty'));

			// display the page
			$this->load->view('gtqr_transactions_done', $data);

		}
		else
		{
			// redirect
			// $this->session->set_flashdata('message', assemble_message('Something went wrong with your transaction.  Please try again.'));
			// redirect('/');
		}
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * reservation Number
	 *
	 * @access	public
	 */
	function reservation_number($transaction_id = false)
	{
		if (!$transaction_id) show_404();
				
		//restore session
		//$restore_session =  $this->reservations->get_customer_id($transaction_id);	
		//$customer_session_id = $restore_session->customer_id;
		//$cei = $restore_session->ticket_event_id;
		//$cpi = $restore_session->ticket_price_id;
		
		// prepare data for the template
		$data['page_title'] = 'Reservation Done';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
	
	
		// get transaction detail
		$data['transaction'] = $this->transactions->get($transaction_id);
		
		// get customer detail
		$data['customer'] = $this->customers->get($data['transaction']->transaction_customer_id);
		
		// get tickets
		$data['tickets'] = $this->tickets->get_tickets_by_transaction($transaction_id);
		
		// get event info
		$data['event'] =  $this->events->get($data['tickets'][0]->ticket_event_id);
		
		// check ticket status
		$this->transactions->_check_tix_stat($this->session->userdata('customer_session_id'), $data['event']->event_id, array('reserved'), $this->session->userdata('tix_qty'));
		
		// display the page
		$this->load->view('transactions_reservation_no', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * migrate_payments
	 *
	 * @access	public
	 */
	function migrate_payments()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$transactions = $this->transactions->get_transactions();
		
		foreach ($transactions as $transaction)
		{
			echo $transaction->transaction_id . '<br />';
			if ($transaction->transaction_cash_payment > 0)
			{
				$this->payments->add($transaction->transaction_id, 1, $transaction->transaction_cash_payment);
			}
			else if ($transaction->transaction_card_payment > 0)
			{
				$this->payments->add($transaction->transaction_id, 2, $transaction->transaction_card_payment);
			}
		}
		//print_array($transactions);
		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * _cc1_check
	 *
	 * @access	private
	 */
	function _cc1_check($str)
	{	
		if ($str and !$this->input->post('transaction_credit_card_1'))
		{
			$this->form_validation->set_message('_cc1_check', "Please select the credit card in the pulldown menu.");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _cc2_check
	 *
	 * @access	private
	 */
	function _cc2_check($str)
	{	
		if ($str and !$this->input->post('transaction_credit_card_2'))
		{
			$this->form_validation->set_message('_cc2_check', "Please select the credit card in the pulldown menu.");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _dc_check
	 *
	 * @access	private
	 */
	function _dc_check($str)
	{	
		if ($str and !$this->input->post('transaction_debit_card'))
		{
			$this->form_validation->set_message('_dc_check', "Please select the debit card in the pulldown menu.");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _gc_check
	 *
	 * @access	private
	 */
	function _gc_check($str)
	{	
		if ($str and !$this->input->post('transaction_gift_check'))
		{
			$this->form_validation->set_message('_gc_check', "Please select the gift check in the pulldown menu.");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _rc_check
	 *
	 * @access	private
	 */
	function _rc_check($str)
	{	
		if ($str and !$this->input->post('transaction_reward_card'))
		{
			$this->form_validation->set_message('_rc_check', "Please select the card in the pulldown menu.");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _ac_check
	 *
	 * @access	private
	 */
	function _ac_check($str)
	{	
		if ($str and !$this->input->post('transaction_account'))
		{
			$this->form_validation->set_message('_ac_check', "Please select the account in the pulldown menu.");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * _check_total_change
	 *
	 * @access	private
	 */
	function _check_total_change($str)
	{	
		if ($str < 0 or !$str)
		{
			$this->form_validation->set_message('_check_total_change', "Please enter the full payment");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}


	function print_online($transaction_id = 0, $event_id = 0, $param1 = 0, $ticket_count = 0, $param2 = 0)
	{
		if (($transaction_id > 0) && ($event_id > 0) && ($ticket_count > 0)) {}
		else {
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Claiming Online Tickets';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		$printcall = site_url("/printer/payment_done_db2xml2pdf/$param1/$param2/$transaction_id");
		$printcall = str_replace("http://","smtickets:", $printcall);
		$data['onload'] =  "onLoad='window.location=\"$printcall\"'";
		$data["transaction_id"] = $transaction_id;
		// display the page
		$this->load->view('transactions_print_online', $data);
	}
	
}	
