<?php

class Extra extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		/*
		$this->load->model('users_model', 'users');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('reports_model', 'reports');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('payment_types_model', 'payment_types');
		*/
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('/extra/ticket_seat_tracker/');
	}
	
	function ticket_seat_tracker($eventid = false, $option = false)
	{
		$data['starttime'] = microtime(true);
		$data['form_url'] = uri_string();
		$data['event_id'] = $eventid;

		// prepare data for the template
		if (! $eventid) {
			$data['page_title'] = 'Ticket Seat Tracker - Listing';
		} else {
			$data['page_title'] = "Ticket Seat Tracker ($eventid)";
		}
		

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		// $this->users->check_session(array('Admin','Super Admin'));
		
		if (!is_numeric($eventid))
		{
			$this->load->library('calendar');
		
			// display event listing
			$this->load->view('extra_ticket_seat_tracker_listing', $data);
		}
		elseif (is_numeric($option)) {
			$data["year"] = $option;
			$data["month"] = $this->uri->segment(4);
			$data["day"] = $this->uri->segment(5);
			print_r($data);
			$this->load->view('extra_ticket_seat_tracker_per_day',$data);
		}
		else
		{
			$data["option"] = $option;
			$this->load->view('extra_ticket_seat_tracker_per_event',$data);
		}
	}
	
	function ticket_seat_tracker_daily()
	{

		// prepare data for the template
		$data['page_title'] = "Ticket Seat Tracker Daily";
		
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// check user session
		// $this->users->check_session(array('Admin','Super Admin'));
		
		// $data["year"] = $option;
		$data["year"] = $this->uri->segment(3);
		$data["month"] = $this->uri->segment(4);
		$data["day"] = $this->uri->segment(5);
		// print_r($data);
		$this->load->view('extra_ticket_seat_tracker_per_day',$data);
	}

}

/* End of file reports.php */
/* Location: ./application/controllers/reports.php */