<?php

class Extension extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('extension_model', 'extension');
		$this->load->model('logs_model', 'logs');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('tickets_model', 'tickets');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		
	}
	
	// for POST method test
	function post_get_method_test() 
	{
		print_r($_POST);
		print_r($_GET);
	}

	// provide MCI with transaction data in CSV format
	function mcidata()
	{
		$token = $this->input->post('token');
		$accesskey = $this->input->post('accesskey');
		$trackingnumber = $this->input->post('trackingnumber');
		$arrtid = explode('-',$trackingnumber);
		
		if (count($arrtid) == 2) {
			$prefix = $arrtid[0];
			$tid = $arrtid[1];
		}
		else {
			$prefix = 0;
			$tid = 0;
		}
		
		$secret = $this->customers->prep_password($tid.$this->config->item('encryption_key').$token);
		
		if ($secret === $accesskey) {
		
			$query = $this->db->query("
			SELECT 
				t.transaction_id AS TRANS_ID
				, t.transaction_date AS TRANS_DATE
				, CONCAT(c.customer_firstname, ' ', c.customer_lastname) CUSTOMER_NAME
				, COUNT(*) TIX_COUNT
				, SUM(pay.payment_amount) AMOUNT
				, t.transaction_status AS TRANS_STATUS
				, e.event_title EVT_TITLE
				, e.event_date_time SHOW_DATETIME
				, v.venue_name VENUE
				FROM transactions t
					LEFT JOIN tickets tix 
						ON tix.ticket_transaction_id = t.transaction_id
					LEFT JOIN customers c
						ON c.customer_id = t.transaction_customer_id
					LEFT JOIN payments pay
						ON pay.payment_transaction_id = t.transaction_customer_id
					LEFT JOIN events e
						ON e.event_id = tix.ticket_event_id
					LEFT JOIN venues v
						ON e.event_venue_id = v.venue_id
				WHERE t.transaction_id = ?
				GROUP BY t.transaction_id
			
			", $tid);
			$this->load->dbutil();
			echo $this->dbutil->csv_from_result($query);
		}
		else {
			echo "Invalid data access.";
		}
	
		
	}

	function bcode($action = false)
    {
		// valid API calls
		$actionlist = array("REDEEM","DONE","DETAILS");
		$action = strtoupper($action);
		
		// check if valid request
		if (in_array($action, $actionlist) == false) { echo "Invalid access."; exit; }
		
		parse_str($_SERVER['QUERY_STRING'],$_GET);
		
		// retrieve credentials
		$user = $this->input->get_post('user');
		$pass = $this->input->get_post('password');
		$app = $this->input->get_post('application');
		$bcode = $this->input->get_post('bcode', true);
		
		$tmp_user = $this->config->item('bcode_user');
		$tmp_pass = $this->config->item('bcode_pass');
		$tmp_app = $this->config->item('bcode_app');
		
		if (($user == $tmp_user) && ($pass == $tmp_pass) && ($app == $tmp_app)) {} else { echo "BCode access parameters do not match."; exit;}
		
		$transaction_id = $this->extension->get_bcode_transaction($bcode);
		if ($transaction_id < 1) { echo "Transaction not found."; exit;} 
			
		// log this
		$page_title = "BCode Access - $action";
		$this->logs->add($page_title);
		
		$transaction = $this->transactions->get($transaction_id);
		$tickets = $this->tickets->get_tickets_by_transaction($transaction_id, '', 'paid_online');
		
		if (($transaction->transaction_status != 'done') && count($tickets) > 0) {
			if ($action == "REDEEM") {
				$data['transactions'] = $transaction;
				$data['type'] = 'paid_online';
				
				// check if tickets have not been printed
				// and fetch the tickets from the server then print
				$this->load->view('extension_bcode_ticket', $data);
			}
			else if ($action == "DONE") {
				echo $this->transactions->transaction_done($transaction_id);
			}
			else if ($action == "DETAILS") {
				$query = $this->db->query("
					SELECT 
						e.event_long_title 'Event Name'
						, v.venue_name 'Event Venue'
						, e.event_date_time 'Event Time/Date'
						, group_concat(concat_ws(' ',s.section_code,concat_ws('' ,tix.ticket_row, tix.ticket_seat))) 'Seat Number'
						, COUNT(*) 'Ticket Count'
						FROM transactions t
							LEFT JOIN tickets tix 
								ON tix.ticket_transaction_id = t.transaction_id
							LEFT JOIN events e
								ON e.event_id = tix.ticket_event_id
							LEFT JOIN venues v
								ON e.event_venue_id = v.venue_id
							LEFT JOIN sections s
								ON tix.ticket_section_id = s.section_id
						WHERE t.transaction_id = ?
							AND t.transaction_status = 'paid_online'
							AND tix.ticket_status = 'paid_online'
				", $transaction_id);
				$this->load->dbutil();
				echo $this->dbutil->csv_from_result($query);
			}
			else {
				echo "Function not yet available."; exit;
			}
			
		}
		else
		{
			echo "Ticket has already been claimed.";
		}

	}

	function xml2pdf(){
	$callparam = $_GET;
	//the path of the xml that will be converted to pdf
	$url = "http://smserboy.com/ticket_generator/newticket";
	$this->load->library('HTTPCall');
	$this->httpcall->do_http_get_request($url,$callparam);

	$xmldata = $this->httpcall->rawoutput;
	
	$this->load->library('simplexml');  
	$content = $this->simplexml->xml_parse($xmldata, "&amp");
	$data['layout'] = $content['layout']['@attributes'];
	if(isset( $content['ticket'][0])){
		$data['tickets']  = $content['ticket'];
		
	} else {
		$data['tickets'][0]  = $content['ticket'];
	}
	

	$this->load->helper('file');
	$this->load->view('pdf',$data);

	}
	

}
