<?php

class Events extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('events_model', 'events');
		$this->load->model('users_model', 'users');
		$this->load->model('venues_model', 'venues');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('files_model', 'files');
		$this->load->model('sections_model', 'sections');
		$this->load->model('logs_model', 'logs');
		$this->load->model('pages_model', 'pages');
		$this->load->model('extension_model', 'extension');
		$this->load->model('video_model', 'video');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------

	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		if($this->session->userdata('user_type')=='Treasury'){
		$this->session->set_flashdata('message', assemble_message('You are not allowed to access that page'));
			redirect('reports/new_reports_opt_v1_seller/natrpb');
		}
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_id event_title event_active event_date_time venue_name promoter_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_current_events($searchkey);

		$this->session->set_userdata('breadcrumbs', array());
		$this->benchmark->mark('query_end');		
		$this->load->view('events_listing', $data);
		$this->benchmark->mark('page_end');

		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);

	}
	
	function all()
	{
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_id event_title event_active event_date_time venue_name promoter_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_all_events($searchkey);
		//print_r($this->db->last_query());
		
		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing', $data);
	}
	
	function active()
	{
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_id event_title event_active event_date_time venue_name promoter_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_active_events($searchkey);

		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing', $data);
	}
	
	function inactive()
	{
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_id event_title event_active event_date_time venue_name promoter_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_inactive_events($searchkey);
	
		
		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing', $data);
	}
	
	function current()
	{
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_id event_title event_active event_date_time venue_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_current_events($searchkey);

		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		redirect('');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($event_id = FALSE)
	{
		//unset valid date
		$this->session->unset_userdata('valid_date');
		
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$this->load->helper('simplejson');
		
		if (!$event_id) 
		{
			if ($this->session->userdata('cei')) 
			{
				$event_id = $this->session->userdata('cei');

				
			}
			else
			{
				show_404();
			}
		}
		else
		{
			if ($this->session->flashdata('message'))
				$this->session->set_flashdata('message', $this->session->flashdata('message'));
				
			$this->session->set_userdata('cei', $event_id);
			$this->session->unset_userdata('cqr');
			redirect('events/view');
		}
		
		 
		if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2','Finance'))){
		
			$this->db->query('set transaction isolation level read uncommitted');
			$sql = "select event_active from events e where e.event_id = ?";

			$query= $this->db->query($sql, array($this->session->userdata('cei'))); 
			$row = $query->row();
			$status = $row->event_active;
			if($status == 0)
			redirect('');
			// $this->session->set_flashdata('message', assemble_message('Event has been successfully added'));
		 
			//lite version
			// redirect('events/view_lite');
		}
		
		 
		
		//hide event
		// if($this->session->userdata('user_type') != 'Admin','Super Admin' && ($event_id == 10 || $event_id == 5157)){

		if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2')) && $event_id == 10){
			
			redirect('');
		}
		
		
		//check login session 
		$this->users->check_user_session();
		
	
		// prepare data for the template
		$data['page_title'] = 'View Event';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
			
		// check user session
		//$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller'));
	
	
	
	
		// clear previously selected tickets that are due for clearing
		$this->tickets->clear_selected_seats();
		
		// remove current customer session and tickets
		$this->tickets->clear_tickets($this->session->userdata('customer_session_id'));
		$this->session->set_userdata(array('customer_session_id' => '', 'claim' => ''));
	
		// add event id to session
		$this->session->set_userdata('cei', $event_id);
	
		// get event
		$event = $this->events->get($event_id);
		
		
			
				
		//update section availability 
		if($event->events_date_validity == 0 || $event->events_date_validity == ''){
			$this->update_availability($event_id);
		
		}
		 
		
		// get prices
		$prices = $this->prices->get_prices_compact($event_id);
		$sec_type_price = array();
		foreach($prices as $price):
			$price_section_info = $this->sections->get_ticket_availability_lite($price->price_sections, $event->event_seatplan_id, true); 
			$section_type = $price_section_info['type'];
			// if (strtolower($section_type) == "reserved") { 
				// $available = $price_section_info['total_available_db'];
			// } else {
				$available = $price_section_info['total_available'];
			// }
		 
			
			$sec_type_price[] = array(
				$price->price_name,
				($available > 0)? "" : "*SOLD OUT",
				($section_type == 'Reserved') ? 'Reserved Seats' : $section_type,
				number_format($price->price_price),
				$price_section_info['total_capacity'],
				$price_section_info['total_reserved'],
				$available,
 			);
			 
			// $total_availability += $available;
		endforeach;

		$data["event"] = $event;
		$data["sec_type_price"] = $sec_type_price;
		
		$this->benchmark->mark('query_end');

	
		$this->db->select('events_config_qrcode_active');
		$this->db->where('events_config_eventid', $event_id);
		$q = $this->db->get('events_config');
		$qr = $q->row();
		$count = $q->num_rows();
		
		
		if(($count > 0) && ($qr->events_config_qrcode_active) &&  $event->event_promo ==0){

			$this->load->view('gtqr_events_view', $data);
		}else{
			
			

			
			
			//toruk special access
			$turok = array(5577,5628,5627,5630,5629,5631,5632,5634,5633,5636,5635,5638,5637,5640,5639);
			$turok_seller = array(4243,4242,4185 ,4226,4227,4228,4229,4230,4231,4232,4234,4235);

			if (in_array($this->session->userdata('user_id'), $turok_seller)){
				 
				 
				$this->load->view('events_view_toruk', $data);
				 
			}elseif($event_id == 5803){
				 
				 
				$this->load->view('events_view_harry', $data);
				 
			}else{
				
				
				$lock = $this->events->check_event_lock_status($event_id);
				if($lock){
					 
				$this->load->view('events_view_locked', $data);
					
				}else{
					
					
				$this->load->view('events_view', $data);
				}
				
				
			}
			
			
			
		}
		
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
	
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */



	 function add()
	{
		// prepare data for the template
		$data['page_title'] = 'Add Event';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin'));
			
		$config = array(
			array(
				'field'   => 'event_code',
				'label'   => 'Event Code',
				'rules'   => 'trim|required|strip_tags|max_length[20]|callback__event_code_check'
			),
			array(
				'field'   => 'event_title',
				'label'   => 'Title of Event',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'event_long_title',
				'label'   => 'Long Title of Event',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			// array(
				// 'field'   => 'event_type',


				// 'label'   => 'Event Type',
				// 'rules'   => 'trim|required|strip_tags|max_length[80]'
			// ),

			array(
				'field'   => 'event_performers',
				'label'   => 'Performers',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_performers_website',
				'label'   => 'Performers Website Address',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_description',
				'label'   => 'Description/Synopsis',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'venue_id',
				'label'   => 'Venue Name',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'date_time',
				'label'   => 'Date and Time',
				'rules'   => 'trim|required|strip_tags|max_length[20]'
			),			
			
			array(
				'field'   => 'event_expiration',
				'label'   => 'Event Expiration',
				'rules'   => 'trim|strip_tags|max_length[3]'
			),
			array(
				'field'   => 'event_photo',
				'label'   => 'Event Photo',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),	
			array(
				'field'   => 'event_photo_1',
				'label'   => 'Event Picture',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_2',
				'label'   => 'Event Picture 2',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_3',
				'label'   => 'Event Picture 3',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),	
			array(
				'field'   => 'promoter_id',
				'label'   => 'Promoter Name',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'seatplan_id',
				'label'   => 'Seat Plan',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'event_reservation_expire',
				'label'   => 'Reservation Expiry',
				'rules'   => 'trim|required|strip_tags|max_length[2]|integer'
			),	
			array(
				'field'   => 'event_internet_sales_charge',
				'label'   => 'Internet Sales Charge',
				'rules'   => 'trim|required|strip_tags|integer'
			),
			
			array(

				'field'   => 'event_tags',
				'label'   => 'Event Tags',
				'rules'   => 'trim|required|strip_tags'
			),


			
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		
		// get venues
		$data['venues'] = $this->venues->get_venues_dropdown();
		
		// get promoters
		$data['promoters'] = $this->promoters->get_promoters_dropdown();
		
		// get seatplans
		$data['seatplans'] = $this->seatplans->get_seatplans_dropdown();
		
		if ($this->form_validation->run() == FALSE)
		{	
			// display the page
			$this->load->view('events_add', $data);
		}
		else
		{
				
				
		
			// upload the photo; params: filename, max width, max height
			$image_path = $this->files->upload_image('event_photo', 640, 1000);
			
			
			$image_path_1 = $this->files->upload_image_1('event_photo_1', 640, 1000);
			$image_path_2 = $this->files->upload_image_1('event_photo_2', 640, 1000);
			$image_path_3 = $this->files->upload_image_1('event_photo_3', 640, 1000);


			// add to db
			$id = $this->events->add($image_path);

			for($i=1;$i<=20;$i++){

			if($this->input->post('video_name_'. $i) && $this->input->post('video_url_'. $i))
			{
				$this->video->embed($this->input->post('video_name_'. $i),$id,$this->input->post('video_url_'. $i));
			}
		}

			
			
			// redirect
			$this->session->set_flashdata('message', assemble_message('Event has been successfully added'));
			redirect('');

		}
	}
	

 
	/**
	 * add video
	 *
	 * @access	public
	 */
	function video($event_id = false)
	{
		if(!$event_id)
		{
			$event_id = $this->session->userdata('cei');
			//echo '1';
		}
		else
		{
		$this->session->set_userdata('cei', $event_id);

			//echo '2';
		}
		// prepare data for the template
		$data['page_title'] = 'Add Video';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
			
		$config = array(
			array(
				'field'   => 'event_title',
				'label'   => 'Event Title',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'event_long_title',
				'label'   => 'Long Title',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'page_content',
				'label'   => 'Page Content',
				'rules'   => 'trim'
			),	
		);
		//$this->db->select('event_long_title');
		//$this->db->where('event_id', $event_id);
		//$query = $this->db->get('events');
		
		//$event_long = $query->row();
		//$page_id = preg_replace("/[^0-9a-z]/","", strtolower($event_long));
		// get event data
		//$data['pages'] = $this->pages->get($page_id);
		$data['event'] = $this->events->get($event_id);
		//$data['pages'] = $this->pages->get($page_id->page_id);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
				
		if ($this->form_validation->run() == FALSE)
		{	
			// display the page
			$this->load->view('events_video', $data);
		}
		else
		{
			$this->pages->add_video();
			//print_r($this->db->last_query());
			// redirect
			$this->session->set_flashdata('message', assemble_message('Video has been successfully added/updated.'));
			redirect('events/video/');
		}
	}
	
	function remove_video(){
	
		$result = $this->pages->remove_video();
		echo $result;
		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */



 
	 function edit($event_id = false)
	{

		 
		if(!$event_id)
		{
			$event_id = $this->session->userdata('cei');

		}
		else
		{
		$this->session->set_userdata('cei', $event_id);


		}
		
		
		$lock = $this->events->check_event_lock_status($event_id);
		if($lock){
			$this->session->set_flashdata('message', assemble_message('Unauthorized event access'));
			redirect('');
			
		}
		
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			
			$this->db->where('e.event_id', $event_id);
			$this->db->where('e.event_cod', 1);
			$q = $this->db->get('events e');
			
			if ($q->num_rows() < 1){
			
			 $this->session->set_flashdata('message', assemble_message('Unauthorized event access'));
			redirect('');
			
			}
			
		}
		
		
		
		

	
		// prepare data for the template
		$data['page_title'] = 'Edit Event';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			

	 
		$config = array(
			array(
				'field'   => 'event_code',
				'label'   => 'Event Code',
				'rules'   => 'trim|required|strip_tags|max_length[20]|callback__event_code_check['. $event_id .']'
			),
			array(
				'field'   => 'event_title',
				'label'   => 'Title of Event',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'event_long_title',
				'label'   => 'Long Title of Event',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			// array(
				// 'field'   => 'event_url',

				// 'label'   => 'Event url',
				// 'rules'   => 'trim|required|strip_tags|max_length[255]|callback__event_url_check['. $event_id .']'
			// ),


			array(
				'field'   => 'event_category',
				'label'   => 'Category',
				'rules'   => 'trim|required|strip_tags||max_length[80]'
			),
			array(
				'field'   => 'event_performers',
				'label'   => 'Performers',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_performers_website',
				'label'   => 'Performers Website Address',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_description',
				'label'   => 'Description/Synopsis',
				'rules'   => 'trim|required'
			),
			array(
				'field'   => 'venue_id',
				'label'   => 'Venue Name',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'date_time',
				'label'   => 'Date and Time',
				'rules'   => 'trim|required|strip_tags|max_length[20]'
			),
			array(
				'field'   => 'event_expiration',
				'label'   => 'Event Expiration',
				'rules'   => 'trim|strip_tags|max_length[3]'
			),
			array(
				'field'   => 'event_photo',
				'label'   => 'Event Picture',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),	
			array(
				'field'   => 'event_photo_1',
				'label'   => 'Event Picture',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_2',
				'label'   => 'Event Picture 2',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_3',
				'label'   => 'Event Picture 3',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'promoter_id',
				'label'   => 'Promoter Name',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'seatplan_id',
				'label'   => 'Seat Plan',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),	
			array(
				'field'   => 'event_reservation_expire',
				'label'   => 'Reservation Expiry',
				'rules'   => 'trim|required|strip_tags|max_length[2]|integer'


			),	
			
			
			array(
				'field'   => 'event_max_ticket',
				'label'   => 'Max Ticket',
				'rules'   => 'trim|required|strip_tags|max_length[2]|integer'


			),		
			
			array(
				'field'   => 'event_promo',
				'label'   => 'Promo',
				'rules'   => 'trim|strip_tags'


			),

			
			array(
				'field'   => 'event_tags',
				'label'   => 'Tags',
				'rules'   => 'trim|required|strip_tags'
			),

			array(
				'field'   => 'event_season',
				'label'   => 'Season Pass',
				'rules'   => 'trim|strip_tags'
			),







		
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get venues
		$data['venues'] = $this->venues->get_venues_dropdown();
		
		// get promoters
		$data['promoters'] = $this->promoters->get_promoters_dropdown();
		
		// get event data
		$data['event'] = $this->events->get($event_id);		
		
		// get video
		$data['video'] = $this->video->get_video($event_id);


		// get seatplans
		$current_seatplan['seatplan_id'] = $data['event']->seatplan_id;
		$current_seatplan['seatplan_name'] = $data['event']->seatplan_name;
		$data['seatplans'] = $this->seatplans->get_seatplans_dropdown($current_seatplan);
		

		if ($this->form_validation->run() == FALSE){		

			// display the page
			$this->load->view('events_edit', $data);

		}else{



		for($i=1;$i<=20;$i++){
			if($this->input->post('video_id_'.$i)){
			if ($_FILES['video_thumb_'. $i]['name'])
			{
				// upload the photo; params: filename, max width, max height
				$videoThumbnailLink = $this->files->upload_image_1('video_thumb_'. $i, 640, 1000,'vThumb_');
			}else{
			$videoThumbnailLink = false;
			}
				$this->video->update($this->input->post('video_id_'. $i),$this->input->post('video_name_'. $i),$event_id,$this->input->post('video_url_'. $i), $videoThumbnailLink, $this->input->post('video_active_' . $i));
			}
			else if(!$this->input->post('video_id_'.$i) && $this->input->post('video_name_'. $i))
			{
				if ($_FILES['video_thumb_'. $i]['name'])
				{
					// upload the photo; params: filename, max width, max height
					$videoThumbnailLink = $this->files->upload_image_1('video_thumb_'. $i, 640, 1000,'vThumb_');
				}else{
				$videoThumbnailLink = false;
				}
				$this->video->embed($this->input->post('video_name_'. $i),$event_id, $this->input->post('video_url_'. $i), $videoThumbnailLink );
			}
		}
		
		
			//Upload images
			if ($_FILES['event_photo']['name'])
			{
				// upload the photo; params: filename, max width, max height
				$image_path = $this->files->upload_image('event_photo', 640, 1000,'large');
			}
			else 
			{
				$image_path = '';
			}
			if ($_FILES['event_photo_1']['name'])
			{
				// upload the photo; params: filename, max width, max height
				$image_path_1 = $this->files->upload_image_1('event_photo_1', 640, 1000,'large');
			}
			else 
			{
				$image_path_1 = '';
			}
			
			if ($_FILES['event_photo_2']['name'])
			{
				// upload the photo; params: filename, max width, max height
				$image_path_2 = $this->files->upload_image_1('event_photo_2', 640, 1000,'medium');
			}
			else 
			{
				$image_path_2 = '';
			}
			
			if ($_FILES['event_photo_3']['name'])
			{
				// upload the photo; params: filename, max width, max height
				$image_path_3 = $this->files->upload_image_1('event_photo_3', 640, 1000,'thumb');
			}
			else 
			{
				$image_path_3 = '';
			} 

			
			// add to db
			$this->events->edit($event_id, $image_path, $image_path_1,$image_path_2,$image_path_3);






			// redirect
			$this->session->set_flashdata('message', assemble_message('Event has been successfully modified'));
			redirect('events/edit/');
		}

	}
 

	
	// --------------------------------------------------------------------
	
	/**
	 * copy
	 *
	 * @access	public
	 */
	
	
	
	
	
	
	function copy($event_id)
	{
		// copy the event
		$new_event_id = $this->events->copy($event_id);
		
		// redirect
		$this->session->set_userdata('cei', $new_event_id);
		$this->session->set_flashdata('message', assemble_message('Event has been successfully copied except the price sections.  You may manually specify them now.'));
		redirect('prices/listing/');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_ticket_types
	 *
	 * @access	public
	 */
	function edit_ticket_types($event_id = false)
	{
		if ((!$this->session->userdata('cei'))  && (!$event_id)) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance'));
			
		$config = array(
			array(
				'field'   => 'ticket_types[]',
				'label'   => 'Ticket Types',
				'rules'   => 'trim|required|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get the event info
		$data['event'] = $this->events->get($event_id);
	
		if ($this->form_validation->run() == FALSE)
		{
			// get ticket types
			$data['ticket_types'] = $this->ticket_types->get_ticket_types_dropdown_sort();
		
			// display the page
			$this->load->view('events_edit_ticket_types', $data);
		}
		else
		{
			$this->events->edit_ticket_types($event_id);
			$this->events->generate_ticket_types_per_event($event_id); //for smphi reports
			$this->session->set_flashdata('message', assemble_message('Ticket types has been successfully modified'));
			redirect('events/edit_ticket_types/');
		}
	}	
	// --------------------------------------------------------------------
	
	/**
	 * edit charges
	 *
	 * @access	public
	 */
	function edit_charges($event_id=false)
	{
		if ((!$this->session->userdata('cei')) && (!$event_id) ) show_404();
		if($this->session->userdata('user_type')=='Finance' && ($event_id)){
			$event_id = $event_id;
		}else{
			$event_id = $this->session->userdata('cei');
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Charges';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance'));
			
		$config = array(
			array(
				'field'   => 'event_venue_amusement_tax',
				'label'   => 'Venue Amusement Tax',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_withholding_tax',
				'label'   => 'Venue Withholding Tax',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_tax',
				'label'   => 'Venue Tax',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_1',
				'label'   => 'Event Charge 1',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_2',
				'label'   => 'Event Charge 2',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_3',
				'label'   => 'Event Charge 3',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_4',
				'label'   => 'Event Charge 4',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_5',
				'label'   => 'Event Charge 5',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),									
			array(
				'field'   => 'event_venue_commission',
				'label'   => 'Venue Commission',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_service_charge',
				'label'   => 'Service Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_ticket_charge',
				'label'   => 'Ticket Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_vat',
				'label'   => 'VAT',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_withholding_tax',
				'label'   => 'WithholdinG Tax',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),	
			array(
				'field'   => 'event_bank_charge_internet',
				'label'   => 'Service Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_bank_charge_outlet',
				'label'   => 'Bank Charge Outlet',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_administrative_fee',
				'label'   => 'Administrative Fee',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_minimum_guarantee',
				'label'   => 'Minimum Guarantee',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_internet_sales_charge',
				'label'   => 'Internet Sales Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_delivery_charge',
				'label'   => 'Delivery Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),		
			array(
				'field'   => 'event_revenue_pullout',
				'label'   => 'Revenue Pull - Out',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_complimentary_pullout',
				'label'   => 'Complimentary Pull - Out',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_interest_fee',
				'label'   => 'Interest Fee',
				'rules'   => 'trim|strip_tags|max_length[10]'

			),
			array(
				'field'   => 'event_reservation_fee',
				'label'   => 'Reservartion Fee',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(

				'field'   => 'event_charge_01',
				'label'   => 'Charge 01',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_02',
				'label'   => 'Charge 02',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_03',
				'label'   => 'Charge 03',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_04',
				'label'   => 'Charge 04',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_05',
				'label'   => 'Charge 05',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_06',
				'label'   => 'Charge 06',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_07',
				'label'   => 'Charge 07',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_08',
				'label'   => 'Charge 08',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_09',
				'label'   => 'Charge 09',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_10',
				'label'   => 'Charge 10',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),										
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE)
		{
			// get data
			$data['event'] = $this->events->get($event_id);
			
			// display the page
			$this->load->view('events_charge', $data);
		}
		else
		{
			$this->events->edit_charge($event_id);
			$this->session->set_flashdata('message', assemble_message('Charges has been successfully modified'));
			redirect('events/edit_charges');
		}
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($event_id = FALSE)
	{
		// log this
		$this->logs->add('Delete Event');
		
		
		$lock = $this->events->check_event_lock_status($event_id);
		if($lock){
			$this->session->set_flashdata('message', assemble_message('Unauthorized event access'));
			redirect('');
			
		}
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->events->delete($event_id);
		$this->session->set_flashdata('message', assemble_message('Event has been successfully deleted'));
		redirect('');
	}
	
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function recommend($event_id = FALSE)
	{
		// log this
		$this->logs->add('Add To Recommended Event');
			
		$lock = $this->events->check_event_lock_status($event_id);
		if($lock){
			$this->session->set_flashdata('message', assemble_message('Unauthorized event access'));
			redirect('');
			
		}
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->events->recommend($event_id);
		$this->session->set_flashdata('message', assemble_message('Event has been successfully added to Recommended Events'));


		redirect('events/edit/');
		// redirect('');
	}
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function unrecommend($event_id = FALSE)
	{
		// log this
		$this->logs->add('Remove From Recommended Event');
			
		$lock = $this->events->check_event_lock_status($event_id);
		if($lock){
			$this->session->set_flashdata('message', assemble_message('Unauthorized event access'));
			redirect('');
			
		}
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->events->unrecommend($event_id);
		$this->session->set_flashdata('message', assemble_message('Event has been successfully removed from Recommended'));


		redirect('events/edit/');
		// redirect('');
	}		
	
	function images() {
		// prepare data for the template
		$data['page_title'] = 'Image Upload Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Finance'));

		$this->load->view('events_image_upload_links', $data);
	}	
	
	function images_sync_list() {
		// prepare data for the template
		$data['page_title'] = 'Image Synchronized';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		$this->load->view('events_images_sync_list');
	}
	
	
	function images_sync() {
		// prepare data for the template
		$data['page_title'] = 'Synchronize Website Images';
		// $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$url = $this->config->item("images_sync_url");
		@$this->extension->do_http_post_request($url,array());
		shell_exec("wget -nH -r -l 2 -p $url");
		
		
		// $url1 = $this->config->item("images_sync_url1"); 
		// @$this->extension->do_http_post_request($url1,array());  
		// shell_exec("wget -nH -r -l 2 -p $url1");


		
		
		
		 

		$this->session->set_flashdata('message', assemble_message("Image sync done. Please double-check images on $url"));
		redirect('/events/images/');
	}
	
	function data_sync() {
		// prepare data for the template
		$data['page_title'] = 'Synchronize Website Data';
		// $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$url = $this->config->item("data_sync_url");
		@$this->extension->do_http_post_request($url,array());
		shell_exec("wget -nH -r -l 2 -p $url");
		

  
		
		// $url1 = $this->config->item("data_sync_url1");
		// @$this->extension->do_http_post_request($url1,array());
		// shell_exec("wget -nH -r -l 2 -p $url1");

		$this->db->cache_delete_all();
		
		
		
		$this->session->set_flashdata('message', assemble_message("Data sync done. Please double-check datas on $url"));
		redirect('events/images');
	}
	
 
 
	function test()
	{
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_title event_active event_date_time venue_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_current_events($searchkey);
		
			$evs_list = array();
		foreach($data['events'] as $x){
		
			$evs_list[] = $x->event_id;
		
		}
		
		if (!empty($evs_list))
		{
			
		}
		else
		{
			$evs_list[] = 0;
			// $ev_det[][] = 0;
		}
		 
		$data['event_array'] = $this->events->get_event_status($evs_list);

		
		$this->session->set_userdata('breadcrumbs', array());
		$this->benchmark->mark('query_end');		
		$this->load->view('events_listing_current', $data);
		$this->benchmark->mark('page_end');

		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);

	}
	
	
	function _event_code_check($str = false, $id = false)
	{	
		$event_code_exists = $this->events->is_event_code_exist($str, $id);
		if ($event_code_exists)
		{
			$this->form_validation->set_message('_event_code_check', "Event Code $str is already taken");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	 	function _event_url_check($str, $id)
	{	
		$event_code_exists = $this->events->is_event_url_exist($str, $id);
		if ($event_code_exists)
		{
			$this->form_validation->set_message('_event_url_check', "Event Url $str is already taken");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}

	
	 
	function edit_payment_types()
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Payment Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
			
		$config = array(
			array(
				'field'   => 'payment_types[]',
				'label'   => 'Payment Types',
				'rules'   => 'trim|required|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get the event info 
		$data['event'] = $this->events->get($event_id);
		$data['payment_types'] = $this->events->get_payment_types($event_id);
	
		if ($this->form_validation->run() == FALSE)
		{
			 
		
			// display the page
			$this->load->view('events_edit_payment_types', $data);
		}
		else
		{
			$this->events->edit_payment_types($event_id);
			$this->session->set_flashdata('message', assemble_message('Payment types has been successfully modified'));
			redirect('events/edit_payment_types/');
		}
	}	
	// --------------------------------------------------------------------
	
	function all_events(){

		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
			
			redirect('');
		}


		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_title event_active event_date_time venue_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_all_events_sorted(1,'');

		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing_all', $data);
	}
	

	
	
	function get_query(){
		echo $this->events->get_all_events_sorted(2);
	}
	
	 
	function save_event_cms(){
		
		$event_ids = $this->input->get_post("event_ids");
		$category =	$this->input->get_post("category");

		$IDs = "";
		foreach(	$event_ids	as $event_id){
			$IDs = $IDs . "$event_id,";
		}	



		echo $this->events->save_event_cms($IDs,$category);
		
	}

		function get_event_in_cms(){
		
		parse_str(substr(strrchr($_SERVER['REQUEST_URI'], "?"), 1), $_GET);

		$sort = $_GET['event_type']; 	
		$filter = $_GET['filter']; 	
		
		$id = $this->events->get_all_events_filter($sort);
	
		// $ids = $id->event_id;
		if(count($id)>0){
			$ids = $id->event_ids;
		}else{
			$ids = '';
		}
		
		// echo $this->events->get_event_in_cms($sort,$ids);
		echo json_encode($this->events->get_event_in_cms($sort,$ids,$filter));
		
	}
	
	function get_event_in_cms2(){
		
		parse_str(substr(strrchr($_SERVER['REQUEST_URI'], "?"), 1), $_GET);

		$sort = $_GET['event_type']; 	
		$filter = $_GET['filter']; 	
		
		$id = $this->events->get_all_events_filter($sort);
				if(count($id)>0){
			$ids = $id->event_ids;
		}else{
			$ids = '';
		}
		// echo $this->events->get_event_in_cms($sort,$ids);
		echo json_encode($this->events->get_event_in_cms($sort,$ids,$filter));
		
	}
	// function get_all_events_filter(){
		
		 // $ids = $this->events->get_all_events_filter(2);
		 // echo $ids->event_id;
	// }
	
	function get_all_events_sorted(){
		
		parse_str(substr(strrchr($_SERVER['REQUEST_URI'], "?"), 1), $_GET);

		$sort = $_GET['event_type']; 
		$ids = $_GET['ids']; 
		
		$sorted = $this->events->get_all_events_sorted($sort,$ids);
		
		echo json_encode($sorted);
	}
	
	function get_postponed_date($event_id){
		$postponed_date = $this->events->get_postponed_date($event_id);
	}
	
	function remove_expired_events(){
		
		
		
		$hot_events = $this->events->get_all_events_filter(1);
		$hot_events = $hot_events->event_id;

		$hot_event_result =  $this->events->get_active_filtered_events($hot_events);

		$active_hot_events = "";
		foreach($hot_event_result as $res){
			$active_hot_events .= $res->event_id.',';
		}
		echo $active_hot_events = substr($active_hot_events, 0,-1);
		echo '<br>';
		$just_announce = $this->events->get_all_events_filter(2);
		$just_announce = $just_announce->event_id;
		
		$just_announce_result =  $this->events->get_active_filtered_events($just_announce);

		$active_just_announce = "";
		foreach($just_announce_result as $res){
			$active_just_announce .= $res->event_id.',';
		}
		echo $active_just_announce = substr($active_just_announce, 0,-1);
		echo '<br>';
		$featured = $this->events->get_all_events_filter(3);
		$featured = $featured->event_id;
		
		$active_featured_result =  $this->events->get_active_filtered_events($featured);

		$active_featured = "";
		foreach($active_featured_result as $res){
			$active_featured .= $res->event_id.',';
		}
		echo $active_featured = substr($active_featured, 0,-1);
		echo '<br>';
		$caroussel = $this->events->get_all_events_filter(1);
		$caroussel = $caroussel->event_id;
		
		$active_caroussel_result =  $this->events->get_active_filtered_events($caroussel);

		$active_caroussel = "";
		foreach($active_caroussel_result as $res){
			$active_caroussel .= $res->event_id.',';
		}
		
		echo $active_caroussel = substr($active_caroussel, 0,-1);
		// die();
		echo '<br>'.$active_featured;
		
		$save_active_hot_events = $this->events->save_event_cms($active_hot_events,1);
		$save_active_just_announce = $this->events->save_event_cms($active_just_announce,2);
		$save_active_featured_events = $this->events->save_event_cms($active_featured, 3);
		$save_active_caroussel = $this->events->save_event_cms($active_caroussel,4);
		
	}
	
	function edit_seo($event_id)
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Charges';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'meta_description_content',
				'label'   => 'Meta Description Content',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'meta_keywords_content',
				'label'   => 'Meta Keywords Content',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'link_rel_canonical',
				'label'   => 'Link rel Canonical',
				'rules'   => 'trim|required|strip_tags'
			),
												
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE)
		{
			// get data
			$data['event'] = $this->events->get_seo($event_id);
			// print_r($this->events->get_seo($event_id));
			// die();
			// display the page
			$this->load->view('event_seo', $data);
		}
		else
			
		
		{
			
			$meta = $this->events->get_seo($event_id)->meta_description_content;
			if($meta==''){
			$this->events->add_seo($event_id);
			$this->session->set_flashdata('message', assemble_message('Event SEO has been successfully added'));
			redirect('events/edit_seo/'.$event_id);
			}else{
			
			$this->events->edit_seo($event_id);
			$this->session->set_flashdata('message', assemble_message('Event SEO has been successfully modified'));
			redirect('events/edit_seo/'.$event_id);
			}
		}
	}
	
	function mail_test(){
		// echo 'dsf';
		// die();
		$to = "johnny.bayod@mobilegroupinc.com";
		$subject = "test";
		// $date_today = date("Y-m-d");
		// Get HTML contents from file
		// $asr_url = base_url()."auto_email/email_asr/".$a_email->event_id;
		
		// die();
		$htmlContent = "asaffsd";

		// Set content-type for sending HTML email
		$headers = "MIME-Version: 1.0" . "\r\n";
		$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

		// Additional headers
		$headers .= 'From: smtickets' . "\r\n";
		// $headers .= 'Cc: test@gmail.com' . "\r\n";

		// Send email
		mail($to,$subject,$htmlContent,$headers);
	}

	function date_validity($event_id)
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Date Validity';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event'));
			
		$config = array(
			array(
				'field'   => 'events_valid_dates',
				'label'   => 'Select valid dates',
				'rules'   => 'trim|strip_tags'
			),
												
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE)
		{
			// get data
			$data['event'] = $this->events->get_valid_dates($event_id);
			
			// get used price dates
			$data['used_dates'] = $this->prices->get_used_dates($event_id);

			// display the page
			$this->load->view('event_date_validity', $data);
		}
		else
			
		
		{
			
			$valid_dates = $this->events->get_valid_dates($event_id)->meta_description_content;
			$result = $this->events->edit_valid_dates($event_id);
			if($result){
				if($valid_dates==''){	
					$this->session->set_flashdata('message', assemble_message('Event Valid Dates have been successfully added'));	
				}else{
					$this->session->set_flashdata('message', assemble_message('Event Valid Dates have been successfully modified'));
				}
				redirect('events/date_validity/'.$event_id);
			}else{
				$this->session->set_flashdata('message', assemble_message('An error occured. Please try again.'));
				redirect('events/date_validity/'.$event_id);
			}
			
		}
	}
	
	function set_session_data($session_variable=false,$session_data=false){
		
		if(!$session_variable){$session_variable = $this->input->get_post('variable');}
		if(!$session_data){$session_data = $this->input->get_post('data');}
		
		
		$this->session->set_userdata($session_variable, $session_data);
			
		// echo $session_variable." : ".$this->session->userdata('valid_date');
	}
	
	function get_prices_per_date($event_id){
		
		$session_variable = $this->input->get_post('variable');
		$session_data = $this->input->get_post('data');
		
		$this->set_session_data($session_variable,$session_data);
		
		$date=date_format(date_create($session_data),"m/d/Y");
		$date2=date_format(date_create($session_data),"Y-m-d");
		
		$price_dates = $this->prices->get_price_dates($event_id,$date);
		
		if($price_dates){		
			$prices_id = unserialize($price_dates[0]->price_event_date_price_id);	
			
			// print_r($prices_name);
			// die();
			
			// get event
			$event = $this->events->get($event_id);
			
			// get prices
			$prices = $this->prices->get_prices_compact($event_id);
			$sec_type_price = array();
			
			
			
			foreach($prices as $price):
				// print_r($price); die();
				if(in_array($price->price_id, $prices_id)):
				$price_section_info = $this->sections->get_ticket_availability_kid($date2 , $price->price_sections, $event->event_seatplan_id, true); 
				$section_type = $price_section_info['type'];
				// if (strtolower($section_type) == "reserved") { 
					// $available = $price_section_info['total_available_db'];
				// } else {
					$available = $price_section_info['total_available'];
				// }
				$sec_type_price[] = array(
					$price->price_name,
					($available > 0)? "" : "*SOLD OUT",
					($section_type == 'Reserved') ? 'Reserved Seats' : $section_type,
					number_format($price->price_price),
					$price_section_info['total_capacity'],
					$price_section_info['total_reserved'],
					$available,
				);
				// $total_availability += $available;
				endif;
			endforeach;
			
		}else{
			$sec_type_price[] = array(
				'Not Available',
				'N/A',
				'N/A',
				'N/A',
				'N/A',
				'N/A',
				'N/A',
			);
			$this->events->remove_date_availabililty($event_id,$date);
		}
		
		
		
		echo json_encode($sec_type_price);
	}

	function view_lite($event_id = FALSE)
	{
		
		//unset valid date
		$this->session->unset_userdata('valid_date');
		$this->db->cache_on();
		// $this->benchmark->mark('page_start');
		// $this->benchmark->mark('query_start');

		$this->load->helper('simplejson');
		
		if (!$event_id) 
		{
			if ($this->session->userdata('cei')) 
			{
				$event_id = $this->session->userdata('cei');

				
			}
			else
			{
				show_404();
			}
		}
		else
		{
			if ($this->session->flashdata('message'))
				$this->session->set_flashdata('message', $this->session->flashdata('message'));
				
			$this->session->set_userdata('cei', $event_id);
			$this->session->unset_userdata('cqr');
			redirect('events/view');
		}
		
 	
		if (!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
		
			$this->db->query('set transaction isolation level read uncommitted');
			$sql = "select event_active from events e where e.event_id = ?";

			$query= $this->db->query($sql, array($this->session->userdata('cei'))); 
			$row = $query->row();
			$status = $row->event_active;
			if($status == 0)
			redirect('');
			// $this->session->set_flashdata('message', assemble_message('Event has been successfully added'));
		 
		
		}
		
		 
		
		//hide event
		// if($this->session->userdata('user_type') != 'Admin','Super Admin' && ($event_id == 10 || $event_id == 5157)){

		if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2')) && $event_id == 10){
			
			redirect('');
		}
	
		// prepare data for the template
		$data['page_title'] = 'View Event';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
			
		// check user session
		//$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller'));
	
		// clear previously selected tickets that are due for clearing
		$this->tickets->clear_selected_seats();
		
		// remove current customer session and tickets
		$this->tickets->clear_tickets($this->session->userdata('customer_session_id'));
		$this->session->set_userdata(array('customer_session_id' => '', 'claim' => ''));
		
		// add event id to session
		$this->session->set_userdata('cei', $event_id);
	
		// get event
		$event = $this->events->get($event_id);
		
		// get prices
		$prices = $this->prices->get_prices_compact($event_id);
		$sec_type_price = array();
		foreach($prices as $price):
			$price_section_info = $this->sections->get_ticket_availability_lite($price->price_sections, $event->event_seatplan_id, true); 
			$section_type = $price_section_info['type'];
			if (strtolower($section_type) == "reserved") { 
				$available = $price_section_info['total_available_db'];
			} else {
				$available = 0;
			}
		 
			
			$sec_type_price[] = array(
				$price->price_name,
				($available > 0)? "" : "*SOLD OUT",
				($section_type == 'Reserved') ? 'Reserved Seats' : $section_type,
				number_format($price->price_price), 
 			);
			 
			// $total_availability += $available;
		endforeach;

		$data["event"] = $event;
		$data["sec_type_price"] = $sec_type_price;
		
		$this->benchmark->mark('query_end');

	
		$this->db->select('events_config_qrcode_active');
		$this->db->where('events_config_eventid', $event_id);
		$q = $this->db->get('events_config');
		$qr = $q->row();
		$count = $q->num_rows();
		
		
		if(($count > 0) && ($qr->events_config_qrcode_active) &&  $event->event_promo ==0){

			$this->load->view('gtqr_events_view', $data);
		}else{
			
			
		$this->db->cache_off();
			
			
			//toruk special access
			$turok = array(5577,5628,5627,5630,5629,5631,5632,5634,5633,5636,5635,5638,5637,5640,5639);
			$turok_seller = array(4243,4242,4185 ,4226,4227,4228,4229,4230,4231,4232,4234,4235);

			if (in_array($this->session->userdata('user_id'), $turok_seller)){
				 
				 
				$this->load->view('events_view_toruk', $data);
				 
			}else{
				
				
				$this->load->view('events_view_lite', $data);
				
			}
			
			
			
		}
		
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
	
	}
	
 
	function update_availability($event_id = false)
	{
		
		if($event_id == 7788) return false;
		
		
		// get event
		$event = $this->events->get($event_id);
		
		
		// get prices
		$prices = $this->prices->get_prices_compact2($event_id);
		$sec_type_price = array();
		foreach($prices as $price):
			$this->sections->update_ticket_availability_sections($price->price_sections, $event->event_seatplan_id, true); 
			 
		endforeach;

		 
	}
	
	function update_availability_per_event($event_id = false)
	{
		
		// if($event_id == 7788) return false;
	 
		// get event
		$event = $this->events->get($event_id);
		
		
		// get prices
		$prices = $this->prices->get_prices_compact2($event_id);
		$sec_type_price = array();
		foreach($prices as $price):
			$this->sections->update_ticket_availability_sections_per_event($price->price_sections, $event->event_seatplan_id, true); 
			 
		endforeach;

		 
	}
	
	

	
	
}

/* End of file events.php */
/* Location: ./application/controllers/events.php */



