<?php

class Events extends Controller
{



	function Events()
	{
		parent::Controller();
		$this->load->model('events_model', 'events');
		$this->load->model('users_model', 'users');
		$this->load->model('venues_model', 'venues');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('files_model', 'files');
		$this->load->model('sections_model', 'sections');
		$this->load->model('logs_model', 'logs');
		$this->load->model('pages_model', 'pages');
		$this->load->model('extension_model', 'extension');
		$this->load->model('video_model', 'video');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------

	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
	
		// die('kamote');
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_title event_active event_date_time venue_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_current_events($searchkey);

		$this->session->set_userdata('breadcrumbs', array());
		$this->benchmark->mark('query_end');		
		$this->load->view('events_listing', $data);
		$this->benchmark->mark('page_end');

		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);

	}
	
	function all()
	{
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_title event_active event_date_time venue_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_all_events($searchkey);
		//print_r($this->db->last_query());
		
		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing', $data);
	}
	
	function active()
	{
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_title event_active event_date_time venue_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_active_events($searchkey);

		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing', $data);
	}
	
	function inactive()
	{
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_title event_active event_date_time venue_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_inactive_events($searchkey);
	
		
		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing', $data);
	}
	
	function current()
	{
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_title event_active event_date_time venue_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_current_events($searchkey);

		$this->session->set_userdata('breadcrumbs', array());
		$this->load->view('events_listing', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		redirect('');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * view
	 *
	 * @access	public
	 */
	function view($event_id = FALSE)
	{
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');

		$this->load->helper('simplejson');
		
		if (!$event_id) 
		{
			if ($this->session->userdata('cei')) 
			{
				$event_id = $this->session->userdata('cei');

				
			}
			else
			{
				show_404();
			}
		}
		else
		{
			if ($this->session->flashdata('message'))
				$this->session->set_flashdata('message', $this->session->flashdata('message'));
				
			$this->session->set_userdata('cei', $event_id);
			$this->session->unset_userdata('cqr');
			redirect('events/view');
		}
		
 	
		if ($this->session->userdata('user_type') == 'Seller' or $this->session->userdata('user_type') == 'Reservation'){
		
		 
			$sql = "select event_active from events e where e.event_id = ?";

			$query= $this->db->query($sql, array($this->session->userdata('cei'))); 
			$row = $query->row();
			$status = $row->event_active;
			if($status == 0)
			redirect('');
			// $this->session->set_flashdata('message', assemble_message('Event has been successfully added'));
		 
		
		}
		
		 
		
		//hide event
		if($this->session->userdata('user_type') != 'Admin' && $event_id == 10){
			
			redirect('');
		}
	
		// prepare data for the template
		$data['page_title'] = 'View Event';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
			
		// check user session
		//$this->users->check_session(array('Admin','Super Admin', 'Seller'));
	
		// clear previously selected tickets that are due for clearing
		$this->tickets->clear_selected_seats();
		
		// remove current customer session and tickets
		$this->tickets->clear_tickets($this->session->userdata('customer_session_id'));
		$this->session->set_userdata(array('customer_session_id' => '', 'claim' => ''));
		
		// add event id to session
		$this->session->set_userdata('cei', $event_id);
	
		// get event
		$event = $this->events->get($event_id);
		
		// get prices
		$prices = $this->prices->get_prices_compact($event_id);
		$sec_type_price = array();
		foreach($prices as $price):
			$price_section_info = $this->sections->get_ticket_availability($price->price_sections, $event->event_seatplan_id, true); 
			$section_type = $price_section_info['type'];
			// if (strtolower($section_type) == "reserved") { 
				// $available = $price_section_info['total_available_db'];
			// } else {
				$available = $price_section_info['total_available'];
			// }
			$sec_type_price[] = array(
				$price->price_name,
				($available > 0)? "" : "*SOLD OUT",
				($section_type == 'Reserved') ? 'Reserved Seats' : $section_type,
				number_format($price->price_price),
				$price_section_info['total_capacity'],
				$price_section_info['total_reserved'],
				$available,
			);
			// $total_availability += $available;
		endforeach;

		$data["event"] = $event;
		$data["sec_type_price"] = $sec_type_price;
		
		$this->benchmark->mark('query_end');

	
		$this->db->select('events_config_qrcode_active');
		$this->db->where('events_config_eventid', $event_id);
		$q = $this->db->get('events_config');
		$qr = $q->row();
		$count = $q->num_rows();
		
		
		if(($count > 0) && ($qr->events_config_qrcode_active) &&  $event->event_promo ==0){

			$this->load->view('gtqr_events_view', $data);
		}else{
			$this->load->view('events_view', $data);
		}
		
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
	
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */



	 function add()
	{
		// prepare data for the template
		$data['page_title'] = 'Add Event';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session('Admin','Super Admin');
			
		$config = array(
			array(
				'field'   => 'event_code',
				'label'   => 'Event Code',
				'rules'   => 'trim|required|strip_tags|max_length[20]'
			),
			array(
				'field'   => 'event_title',
				'label'   => 'Title of Event',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'event_long_title',
				'label'   => 'Long Title of Event',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_type',
				'label'   => 'Event Type',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'event_performers',
				'label'   => 'Performers',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_performers_website',
				'label'   => 'Performers Website Address',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_description',
				'label'   => 'Description/Synopsis',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'venue_id',
				'label'   => 'Venue Name',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'date_time',
				'label'   => 'Date and Time',
				'rules'   => 'trim|required|strip_tags|max_length[20]'
			),			
			
			array(
				'field'   => 'event_expiration',
				'label'   => 'Event Expiration',
				'rules'   => 'trim|strip_tags|max_length[3]'
			),
			array(
				'field'   => 'event_photo',
				'label'   => 'Event Photo',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),	
			array(
				'field'   => 'event_photo_1',
				'label'   => 'Event Picture',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_2',
				'label'   => 'Event Picture 2',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_3',
				'label'   => 'Event Picture 3',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),	
			array(
				'field'   => 'promoter_id',
				'label'   => 'Promoter Name',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'seatplan_id',
				'label'   => 'Seat Plan',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'event_reservation_expire',
				'label'   => 'Reservation Expiry',
				'rules'   => 'trim|required|strip_tags|max_length[2]|integer'
			),	
			array(
				'field'   => 'event_internet_sales_charge',
				'label'   => 'Internet Sales Charge',
				'rules'   => 'trim|required|strip_tags|integer'
			),
			array(
				'field'   => 'event_tags',
				'label'   => 'Event Tags',
				'rules'   => 'trim|required|strip_tags'
			),
			
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		
		// get venues
		$data['venues'] = $this->venues->get_venues_dropdown();
		
		// get promoters
		$data['promoters'] = $this->promoters->get_promoters_dropdown();
		
		// get seatplans
		$data['seatplans'] = $this->seatplans->get_seatplans_dropdown();
		
		if ($this->form_validation->run() == FALSE)
		{	
			// display the page
			$this->load->view('events_add', $data);
		}
		else
		{
				
				
		
			// upload the photo; params: filename, max width, max height
			$image_path = $this->files->upload_image('event_photo', 640, 1000);
			
			
			$image_path_1 = $this->files->upload_image_1('event_photo_1', 640, 1000);
			$image_path_2 = $this->files->upload_image_1('event_photo_2', 640, 1000);
			$image_path_3 = $this->files->upload_image_1('event_photo_3', 640, 1000);


			// add to db
			$id = $this->events->add($image_path);

			for($i=1;$i<=20;$i++){

			if($this->input->post('video_name_'. $i) && $this->input->post('video_url_'. $i))
			{
				$this->video->embed($this->input->post('video_name_'. $i),$id,$this->input->post('video_url_'. $i));
			}
		}

			
			
			// redirect
			$this->session->set_flashdata('message', assemble_message('Event has been successfully added'));
			redirect('');

		}
	}
	

 
	/**
	 * add video
	 *
	 * @access	public
	 */
	function video($event_id = false)
	{
		if(!$event_id)
		{
			$event_id = $this->session->userdata('cei');
			//echo '1';
		}
		else
		{
		$this->session->set_userdata('cei', $event_id);

			//echo '2';
		}
		// prepare data for the template
		$data['page_title'] = 'Add Video';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session('Admin','Super Admin');
			
			
		$config = array(
			array(
				'field'   => 'event_title',
				'label'   => 'Event Title',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'event_long_title',
				'label'   => 'Long Title',
				'rules'   => 'trim|required|strip_tags'
			),
			array(
				'field'   => 'page_content',
				'label'   => 'Page Content',
				'rules'   => 'trim'
			),	
		);
		//$this->db->select('event_long_title');
		//$this->db->where('event_id', $event_id);
		//$query = $this->db->get('events');
		
		//$event_long = $query->row();
		//$page_id = preg_replace("/[^0-9a-z]/","", strtolower($event_long));
		// get event data
		//$data['pages'] = $this->pages->get($page_id);
		$data['event'] = $this->events->get($event_id);
		//$data['pages'] = $this->pages->get($page_id->page_id);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
				
		if ($this->form_validation->run() == FALSE)
		{	
			// display the page
			$this->load->view('events_video', $data);
		}
		else
		{
			$this->pages->add_video();
			//print_r($this->db->last_query());
			// redirect
			$this->session->set_flashdata('message', assemble_message('Video has been successfully added/updated.'));
			redirect('events/video/');
		}
	}
	
		function edit_gallery($event_id = false)
	{
		if(!$event_id)
		{
			$event_id = $this->session->userdata('cei');
			//echo '1';
		}
		else
		{
		$this->session->set_userdata('cei', $event_id);

			//echo '2';
		}
		// check user session
		$this->users->check_session('Admin','Super Admin');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Event gallery';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		// $this->logs->add($data['page_title']);
		
		$data['event_gallery'] = $this->events->get_event_gallery($event_id);
		
		$this->load->view('event_gallery_listing', $data);
	}
	
	
	function remove_video(){
	
		$result = $this->pages->remove_video();
		echo $result;
		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */



 
	 function edit($event_id = false)
	{


		if(!$event_id)
		{
			$event_id = $this->session->userdata('cei');

		}
		else
		{
		$this->session->set_userdata('cei', $event_id);


		}
		
		
		
		if($this->session->userdata('user_branch_id') == $this->config->item('melco_branch_id')){
		
			
			$this->db->where('e.event_id', $event_id);
			$this->db->where('e.event_cod', 1);
			$q = $this->db->get('events e');
			
			if ($q->num_rows() < 1){
			
			 $this->session->set_flashdata('message', assemble_message('Unauthorized event access'));
			redirect('');
			
			}
			
		}
		
		
		
		

	
		// prepare data for the template
		$data['page_title'] = 'Edit Event';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		// $this->logs->add($data['page_title']);
			
		// check user session
		// $this->users->check_session('Admin','Super Admin');
			

	 
		$config = array(
			array(
				'field'   => 'event_code',
				'label'   => 'Event Code',
				'rules'   => 'trim|required|strip_tags|max_length[20]|callback__event_code_check['. $event_id .']'
			),
			array(
				'field'   => 'event_title',
				'label'   => 'Title of Event',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'event_long_title',
				'label'   => 'Long Title of Event',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_type',
				'label'   => 'Type of Event',
				'rules'   => 'trim|required|strip_tags||max_length[80]'
			),
			array(
				'field'   => 'event_performers',
				'label'   => 'Performers',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_performers_website',
				'label'   => 'Performers Website Address',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'event_description',
				'label'   => 'Description/Synopsis',
				'rules'   => 'trim|required'
			),
			array(
				'field'   => 'venue_id',
				'label'   => 'Venue Name',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'date_time',
				'label'   => 'Date and Time',
				'rules'   => 'trim|required|strip_tags|max_length[20]'
			),
			array(
				'field'   => 'event_expiration',
				'label'   => 'Event Expiration',
				'rules'   => 'trim|strip_tags|max_length[3]'
			),
			array(
				'field'   => 'event_photo',
				'label'   => 'Event Picture',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),	
			array(
				'field'   => 'event_photo_1',
				'label'   => 'Event Picture',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_2',
				'label'   => 'Event Picture 2',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),			
			array(
				'field'   => 'event_photo_3',
				'label'   => 'Event Picture 3',
				'rules'   => 'trim|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'promoter_id',
				'label'   => 'Promoter Name',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),
			array(
				'field'   => 'seatplan_id',
				'label'   => 'Seat Plan',
				'rules'   => 'trim|required|strip_tags|max_length[5]|integer'
			),	
			array(
				'field'   => 'event_reservation_expire',
				'label'   => 'Reservation Expiry',
				'rules'   => 'trim|required|strip_tags|max_length[2]|integer'


			),	
			
			
			array(
				'field'   => 'event_max_ticket',
				'label'   => 'Max Ticket',
				'rules'   => 'trim|required|strip_tags|max_length[2]|integer'


			),		
			
			array(
				'field'   => 'event_promo',
				'label'   => 'Promo',
				'rules'   => 'trim|strip_tags'


			),	


			array(
				'field'   => 'event_tags',
				'label'   => 'Tags',
				'rules'   => 'trim|required|strip_tags'
			),

		
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get venues
		$data['venues'] = $this->venues->get_venues_dropdown();

		// echo '<pre>';
		// print_r($this->venues->get_venues_dropdown());
		// echo '</pre>';
		// die();
		// get promoters
		$data['promoters'] = $this->promoters->get_promoters_dropdown();
		
		// get event data
		$data['event'] = $this->events->get($event_id);		
		
		// get video
		$data['video'] = $this->video->get_video($event_id);


		// get seatplans
		$current_seatplan['seatplan_id'] = $data['event']->seatplan_id;
		$current_seatplan['seatplan_name'] = $data['event']->seatplan_name;
		$data['seatplans'] = $this->seatplans->get_seatplans_dropdown($current_seatplan);
		

		if ($this->form_validation->run() == FALSE)
		{		
			// display the page
			$this->load->view('events_edit', $data);
		}
		else
		{


		for($i=1;$i<=20;$i++){
			if($this->input->post('video_id_'.$i)){
			if ($_FILES['video_thumb_'. $i]['name'])
			{
				// upload the photo; params: filename, max width, max height
				$videoThumbnailLink = $this->files->upload_image_1('video_thumb_'. $i, 640, 1000,'vThumb_');
			}else{
			$videoThumbnailLink = false;
			}
				$this->video->update($this->input->post('video_id_'. $i),$this->input->post('video_name_'. $i),$event_id,$this->input->post('video_url_'. $i), $videoThumbnailLink, $this->input->post('video_active_' . $i));
			}
			else if(!$this->input->post('video_id_'.$i) && $this->input->post('video_name_'. $i))
			{
				if ($_FILES['video_thumb_'. $i]['name'])
				{
					// upload the photo; params: filename, max width, max height
					$videoThumbnailLink = $this->files->upload_image_1('video_thumb_'. $i, 640, 1000,'vThumb_');
				}else{
				$videoThumbnailLink = false;
				}
				$this->video->embed($this->input->post('video_name_'. $i),$event_id, $this->input->post('video_url_'. $i), $videoThumbnailLink );
			}
		}
		
		
			//Upload images
			if ($_FILES['event_photo']['name'])
			{
				// upload the photo; params: filename, max width, max height
				$image_path = $this->files->upload_image('event_photo', 640, 1000,'large');
			}
			else 
			{
				$image_path = '';
			}
			if ($_FILES['event_photo_1']['name'])
			{
				// upload the photo; params: filename, max width, max height
				$image_path_1 = $this->files->upload_image_1('event_photo_1', 640, 1000,'large');
			}
			else 
			{
				$image_path_1 = '';
			}
			
	/*		if ($_FILES['event_photo_2']['name'])
			{
				// upload the photo; params: filename, max width, max height
				$image_path_2 = $this->files->upload_image_1('event_photo_2', 640, 1000,'medium');
			}
			else 
			{
				$image_path_2 = '';
			}
			
			if ($_FILES['event_photo_3']['name'])
			{
				// upload the photo; params: filename, max width, max height
				$image_path_3 = $this->files->upload_image_1('event_photo_3', 640, 1000,'thumb');
			}
			else 
			{
				$image_path_2 = '';
			}  */
			$image_path_2 = '';
			$image_path_3 = '';
			
			/**************** event Images *********************/
			if ($_FILES['event_images1']['name'])
			{
				$image_ctr = $this->input->post('image_ctr');
				if($image_ctr>1){
					
					$event_image = "";
					
					for($ctr=1;$ctr<=$image_ctr;$ctr++){
						
					$event_image .= $this->input->post('image_description'. $ctr).'/'.$this->files->upload_image('event_images'.$ctr, 450, 650,'small'). ',';
					$image_description = $this->input->post('image_description'. $ctr).',';
								
					} 
					$event_images = $event_image;
					$image_descriptions = $image_description;
				}else{
					$event_images = $this->files->upload_image('event_images1', 450, 650,'small').',';
					$image_descriptions = $this->input->post('image_description1').',';
				} 
				
			}
			else{
				$event_images = "";
				$image_descriptions ="";
			}
	
			/********** end of event images ********************/
			
			
			// add to db
			$this->events->edit($event_id, $image_path, $image_path_1,$image_path_2,$image_path_3,$event_images,$image_descriptions);
			

			// $edata = $event_id.'/'.$event_images.'/'.$image_descriptions;
			// redirect
			$this->session->set_flashdata('message', assemble_message("Event has been successfully modified"));
			redirect('events/edit/');
		}

	}
 

	
	// --------------------------------------------------------------------
	
	/**
	 * copy
	 *
	 * @access	public
	 */
	
	
	
	
	
	
	function copy($event_id)
	{
		// copy the event
		$new_event_id = $this->events->copy($event_id);
		
		// redirect
		$this->session->set_userdata('cei', $new_event_id);
		$this->session->set_flashdata('message', assemble_message('Event has been successfully copied except the price sections.  You may manually specify them now.'));
		redirect('prices/listing/');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_ticket_types
	 *
	 * @access	public
	 */
	function edit_ticket_types()
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session('Admin','Super Admin');
			
		$config = array(
			array(
				'field'   => 'ticket_types[]',
				'label'   => 'Ticket Types',
				'rules'   => 'trim|required|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 

		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get the event info
		$data['event'] = $this->events->get($event_id);
	
		if ($this->form_validation->run() == FALSE)
		{
			// get ticket types
			$data['ticket_types'] = $this->ticket_types->get_ticket_types_dropdown_sort();
		
			// display the page
			$this->load->view('events_edit_ticket_types', $data);
		}
		else
		{
			$this->events->edit_ticket_types($event_id);
			$this->session->set_flashdata('message', assemble_message('Ticket types has been successfully modified'));
			redirect('events/edit_ticket_types/');
		}
	}	
	// --------------------------------------------------------------------
	
	/**
	 * edit charges
	 *
	 * @access	public
	 */
	function edit_charges()
	{
		if (!$this->session->userdata('cei')) show_404();
		$event_id = $this->session->userdata('cei');
		
		// prepare data for the template
		$data['page_title'] = 'Edit Charges';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session('Admin','Super Admin');
			
		$config = array(
			array(
				'field'   => 'event_venue_amusement_tax',
				'label'   => 'Venue Amusement Tax',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_withholding_tax',
				'label'   => 'Venue Withholding Tax',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_tax',
				'label'   => 'Venue Tax',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_1',
				'label'   => 'Event Charge 1',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_2',
				'label'   => 'Event Charge 2',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_3',
				'label'   => 'Event Charge 3',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_4',
				'label'   => 'Event Charge 4',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_venue_charge_5',
				'label'   => 'Event Charge 5',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),									
			array(
				'field'   => 'event_venue_commission',
				'label'   => 'Venue Commission',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_service_charge',
				'label'   => 'Service Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_ticket_charge',
				'label'   => 'Ticket Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_vat',
				'label'   => 'VAT',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_withholding_tax',
				'label'   => 'WithholdinG Tax',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),	
			array(
				'field'   => 'event_bank_charge_internet',
				'label'   => 'Service Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_bank_charge_outlet',
				'label'   => 'Bank Charge Outlet',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_administrative_fee',
				'label'   => 'Administrative Fee',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_minimum_guarantee',
				'label'   => 'Minimum Guarantee',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_internet_sales_charge',
				'label'   => 'Internet Sales Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_delivery_charge',
				'label'   => 'Delivery Charge',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),		
			array(
				'field'   => 'event_revenue_pullout',
				'label'   => 'Revenue Pull - Out',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_complimentary_pullout',
				'label'   => 'Complimentary Pull - Out',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_interest_fee',
				'label'   => 'Interest Fee',
				'rules'   => 'trim|strip_tags|max_length[10]'

			),
			array(
				'field'   => 'event_reservation_fee',
				'label'   => 'Reservartion Fee',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(

				'field'   => 'event_charge_01',
				'label'   => 'Charge 01',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_02',
				'label'   => 'Charge 02',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_03',
				'label'   => 'Charge 03',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_04',
				'label'   => 'Charge 04',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_05',
				'label'   => 'Charge 05',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_06',
				'label'   => 'Charge 06',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_07',
				'label'   => 'Charge 07',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_08',
				'label'   => 'Charge 08',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_09',
				'label'   => 'Charge 09',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),
			array(
				'field'   => 'event_charge_10',
				'label'   => 'Charge 10',
				'rules'   => 'trim|strip_tags|max_length[10]'
			),										
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		if ($this->form_validation->run() == FALSE)
		{
			// get data
			$data['event'] = $this->events->get($event_id);
			
			// display the page
			$this->load->view('events_charge', $data);
		}
		else
		{
			$this->events->edit_charge($event_id);
			$this->session->set_flashdata('message', assemble_message('Charges has been successfully modified'));
			redirect('events2/edit_charges');
		}
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($event_id = FALSE)
	{
		// log this
		$this->logs->add('Delete Event');
			
		// check user session
		$this->users->check_session('Admin','Super Admin');
		
		$this->events->delete($event_id);
		$this->session->set_flashdata('message', assemble_message('Event has been successfully deleted'));
		redirect('');
	}
	
		function delete_image_gallery($image_id = FALSE)
	{
		// log this
		// $this->logs->add('Delete Event');
			
		// check user session
		$this->users->check_session('Admin','Super Admin');
		
		$this->events->delete_image_gallery($image_id);
		$this->session->set_flashdata('message', assemble_message('Image has been successfully deleted'));
		redirect('events/edit_gallery');
	}
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function recommend($event_id = FALSE)
	{
		// log this
		$this->logs->add('Add To Recommended Event');
			
		// check user session
		$this->users->check_session('Admin','Super Admin');
		
		$this->events->recommend($event_id);
		$this->session->set_flashdata('message', assemble_message('Event has been successfully added to Recommended Events'));


		redirect('events/edit/');
		// redirect('');
	}
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function unrecommend($event_id = FALSE)
	{
		// log this
		$this->logs->add('Remove From Recommended Event');
			
		// check user session
		$this->users->check_session('Admin','Super Admin');
		
		$this->events->unrecommend($event_id);
		$this->session->set_flashdata('message', assemble_message('Event has been successfully removed from Recommended'));


		redirect('events/edit/');
		// redirect('');
	}		
	
	function images() {
		// prepare data for the template
		$data['page_title'] = 'Image Upload Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session('Admin','Super Admin');

		$this->load->view('events_image_upload_links', $data);
	}	
	
	function images_sync_list() {
		// prepare data for the template
		$data['page_title'] = 'Image Synchronized';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		$this->load->view('events_images_sync_list');
	}
	
	function images_sync() {
		// prepare data for the template
		$data['page_title'] = 'Synchronize Website Images';
		// $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$url = $this->config->item("images_sync_url");
		@$this->extension->do_http_post_request($url,array());

		// temp solution
		shell_exec("wget -nH -r -l 2 -p $url");

		$this->session->set_flashdata('message', assemble_message("Image sync done. Please double-check images on $url"));
		redirect('/events/images/');
	}
	
	function data_sync() {
		// prepare data for the template
		$data['page_title'] = 'Synchronize Website Data';
		// $data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		// log this
		$this->logs->add($data['page_title']);
		
		$url = $this->config->item("data_sync_url");
		@$this->extension->do_http_post_request($url,array());

		// temp solution
		shell_exec("wget -nH -r -l 2 -p $url");

		$this->session->set_flashdata('message', assemble_message("Data sync done. Please double-check datas on $url"));
		redirect('');
	}
	
 
	function test()
	{
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		// prepare data for the template
		$data['page_title'] = 'Events';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		if ($this->session->userdata('logged_in')) {
			// log this
			$this->logs->add($data['page_title']);
		}

		$searchkey = array();		
		$searchflds = qw('event_title event_active event_date_time venue_name event_recommended');//array('event_title','event_title','name','ticket_transaction_id');
		foreach ( $searchflds as $fld)
		{
			$searchkey[ $fld ] = $this->input->post($fld);
			$data[$fld]= $this->input->post($fld);
		}
		
		// get all events
		$data['events'] = $this->events->get_current_events($searchkey);
		
			$evs_list = array();
		foreach($data['events'] as $x){
		
			$evs_list[] = $x->event_id;
		
		}
		
		if (!empty($evs_list))
		{
			
		}
		else
		{
			$evs_list[] = 0;
			// $ev_det[][] = 0;
		}
		 
		$data['event_array'] = $this->events->get_event_status($evs_list);

		
		$this->session->set_userdata('breadcrumbs', array());
		$this->benchmark->mark('query_end');		
		$this->load->view('events_listing_current', $data);
		$this->benchmark->mark('page_end');

		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);

	}
	
	
	function _event_code_check($str, $id)
	{	
		$event_code_exists = $this->events->is_event_code_exist($str, $id);
		if ($event_code_exists)
		{
			$this->form_validation->set_message('_event_code_check', "Event Code $str is already taken");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	 
	function edit_gallery_image($image_id)
	{
		// prepare data for the template
		$data['page_title'] = 'Edit Image';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$image_description = $this->input->post('image_title');
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session('Admin','Super Admin');
		$data['image_info'] = $this->events->edit_image_gallery($image_id);	
	 	$config = array(
			array(
				'field'   => 'image_gal',
				'label'   => 'image',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'image_title',
				'label'   => 'description',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
		);
				
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>'); 

		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('edit_gallery_image2', $data);
		}
		else
		{
			// list($filename, $image_path, $filewh, $filesize) = $this->files->upload_ad();

			
			if($filename){
			//Write image info into DB
			$image_path = $this->files->upload_image_1('image_gal', 640, 1000,'large');
			$result_message = "Image has been successfully modified";
			}else{
				$filename = "";
				$image_path = "";
				$filewh = "";
				$filesize ="";
				$result_message = "Image has been successfully modified";
			}
			$image_info = $this->files->upload_image_1('image_gal', 640, 1000,'gallery');
			$this->events->edit_image($image_info, $image_description,$image_id);
			$this->session->set_flashdata('message', assemble_message($result_message));
			redirect('events/edit_gallery');


		}
	}



}

/* End of file events.php */
/* Location: ./application/controllers/events.php */



