<?php

class ETITR extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('etitr_model', 'etitr');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('events_model', 'events');
		$this->load->model('venues_model', 'venue');
		$this->load->model('users_model', 'users');
		$this->load->model('transactions_model', 'transactions');
		//$this->load->model('contacts_model', 'contacts');
		//$this->load->model('logs_model', 'logs');
		$this->load->database('default');

		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('etitr/etitr_form');
	}

	//------------------------------------------------------------------------
	/**
	* _try etitr firm design
	*
	* @access private
	*/
	function etitr_form()
	{
		// prepare data for the template
		$data['page_title'] = 'Promoters Pull Out Form';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
	
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
				
		$data['promoters'] = $this->etitr->get_promoters_dropdown2();
		$data['events'] = $this->etitr->get_events_dropdown2();
		$data['etitr'] = $this->etitr->get_company_dropdown();
		$data['pullout'] = $this->etitr->get_pullout_type_dropdown();

		if($this->input->post('gen_report'))
		{
			$checkbox = $this->input->post('include_printing');
			$insertid = $this->etitr->gen_etitr($checkbox);
			redirect("etitr/gen/$insertid");
		}
		else
		{
			$this->load->view('etitr_form', $data);
		}
		echo "SERBOY";
	}
	
	
	function etitr_form2()
	{
		$data['page_title'] = 'Returns Form';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
	
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));

		$data['promoters'] = $this->etitr->get_promoters_dropdown2();
		$data['events'] = $this->etitr->get_events_dropdown2();
		$data['etitr'] = $this->etitr->get_company_dropdown3();

		if($this->input->post('generate'))
		{
			$checkbox = $this->input->post('include_printing');
			$insertid = $this->etitr->gen_etitr2($checkbox);
			redirect("etitr/gen/$insertid");
		}
		else
		{
			$this->load->view('etitr_form2', $data);
		}
	}
	function etitr_list($page = false)
	{
		$data['page_title'] = 'List';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data['comp_list'] = $this->etitr->get_company_dropdown2();
		$data['prom_list'] = $this->etitr->get_promoters_dropdown();
		$data['eve_list'] = $this->etitr->get_events_dropdown();
		$data['user_list'] = $this->etitr->get_users_dropdown();
	
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		$data['page_list'] = $page;
		
		$this->load->view('etitr_list', $data);
	}
	function etitr_report($page = false)
	{
		$data['page_title'] = 'Report';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data['comp_list'] = $this->etitr->get_company_dropdown2();
		$data['prom_list'] = $this->etitr->get_promoters_dropdown();
		$data['eve_list'] = $this->etitr->get_events_dropdown();
		$data['user_list'] = $this->etitr->get_users_dropdown();
		$data['venue_list'] = $this->etitr->get_venue_dropdown();
		// $data['section_list'] = $this->etitr->get_sections_dropdown();
	
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		$data['page_list'] = $page;
		
		if($this->input->post('etitr_report'))
		{
			$company = $this->input->post('search_comp');
			$promoter = $this->input->post('search_promoters');
			$event = $this->input->post('search_events');
			$user = $this->input->post('search_users');
			$venue = $this->input->post('search_venues');
			$stype = $this->input->post('search_type');
			$sec_type = $this->input->post('search_sectiontype');
			$section = $this->input->post('search_sections');
			$date_start = $this->input->post('date_start');
			$date_end = $this->input->post('date_end');
			
			if ($company)
			{
				$compname = $this->db->query("select company_name,company_id from etitr_companies where company_id = $company");
				if ($compname->num_rows() > 0)
				{
					$data['selected']['company'] = $compname->row()->company_id;
				}
				else
				{
					$data['selected']['company'] = "Anonymous";
				}
			}
			else
			{
				$data['selected']['company'] = "All Companies";
			}
			if ($promoter)
			{
				$promotername = $this->db->query("select promoter_name,promoter_id from promoters where promoter_id = $promoter");
				$data['selected']['promoter'] = $promotername->row()->promoter_id;
			}
			else
			{
				$data['selected']['promoter'] = "All Promoters";
			}
			if ($event)
			{
				$eventname = $this->db->query("select event_title,event_id from events where event_id = $event");
				$data['selected']['event'] = $eventname->row()->event_id;
			}
			else
			{
				$data['selected']['event'] = "All Events";
			}
			if ($user)
			{
				$username = $this->db->query("select user_firstname, user_lastname from users where user_id = $user");
				$data['selected']['user'] = $username->row()->user_firstname . " " . $username->row()->user_lastname;
			}
			else
			{
				$data['selected']['user'] = "All Users";
			}
			if ($venue)
			{
				$venuename = $this->db->query("select venue_name,venue_id from venues where venue_id = $venue");
				$data['selected']['venue'] = $venuename->row()->venue_id;
			}
			else
			{
				$data['selected']['venue'] = "All Venues";
			}
			if ($section)
			{
				$sectionname = $this->db->query("select section_name from sections where section_id = $section");
				$data['selected']['section'] = $sectionname->row()->section_name;
				$data['selected']['section_id'] = $section; 
			}
			else
			{
				$data['selected']['section'] = "All Sections";
				$data['selected']['section_id'] = 0;
			}
			switch ($stype)
			{
				case "0":
				{
					$data['selected']['stype'] = "All Types";
					break;
				}
				case "pullout":
				{
					$data['selected']['stype'] = "Pullout";
					break;
				}
				case "return":
				{
					$data['selected']['stype'] = "Return";
					break;
				}
			}
			if ($sec_type == "0")
			{
				
				$data['selected']['sec_type'] = "All Section Types";
			}
			else
			{
				$data['selected']['sec_type'] = $sec_type;
			}
			if ($date_start == "")
			{
				$data['selected']['start_date'] = "Start";
			}
			else
			{
				$data['selected']['start_date'] = $date_start;
			}
			if ($date_end == "")
			{
				$data['selected']['end_date'] = "End";
			}
			else
			{
				$data['selected']['end_date'] = $date_end;
			}
			
			$data['all_comp'] = $this->etitr->all_comp($data['selected']['company'], $data['selected']['promoter'], $data['selected']['event'], $user, $data['selected']['venue'], $stype, $sec_type, $section, $date_start, $date_end);
			//$this->etitr->test($data['test']);
			//print_r($data['all_comp']);
			$this->load->view('etitr_print', $data);
			//redirect("etitr/etitr_prep/");
		}
		else
		{
			$this->load->view('etitr_report', $data);
		}
	}
	function etitr_recordset($page = false, $what = false, $page2 = false)
	{
		if (!$page) { // empty parameter 
		}
		else {
			// parameter has value
		}
		$data['page_title'] = 'Transaction List';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
	
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		$data['pagenum'] = $page;
		$data['pagewhat'] = $what;
		$data['pagenum2'] = $page2;
		
		$this->load->view('etitr_recordset', $data);
	}
	function etitr_generated_list($page = false, $what = false, $page3 = false)
	{
		if (!$page) { // empty parameter 
		}
		else {
			// parameter has value
		}
		$data['page_title'] = 'Generated List';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
	
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		$data['pagenum'] = $page;
		$data['pagewhat'] = $what;
		$data['pagenum2'] = $page3;
		
		
		$this->load->view('etitr_generated_list', $data);
	}
	function etitr_prep()
	{
		$data['page_title'] = 'PrintOut Report';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
	
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		$this->load->view('etitr_print', $data);
	}
	// /etitr/data/param/type/nume
	function data($param = false, $type = false, $nume = false, $param2 = false)
	{
		if (!$param) { // empty parameter 
		}
		else {
			// parameter has value
		}
		
		$data['page_title'] = 'ETITR';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data['promoters'] = $this->promoters->get_promoters_dropdown();
		$data['events'] = $this->events->get_events_dropdown();
		//$data['etitr'] = $this->etitr->get();
		$data['formdata'] = $param;
		$data['data2'] = $type;
		$data['numero'] = $nume;
		$data['formdata2'] = $param2; 
		
		// log this
		//$this->logs->add($data['page_title']);
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		$this->load->view('etitr_data', $data);
	}
	function data2($event = false, $param = false, $type = false, $nume = false, $param2 = false, $rdate = false)
	{
		if (!$param) { // empty parameter 
		}
		else {
			// parameter has value
		}
		
		$data['page_title'] = 'ETITR';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data['promoters'] = $this->promoters->get_promoters_dropdown();
		$data['events'] = $this->events->get_events_dropdown();

		$data['formdata'] = $param;
		$data['data2'] = $type;
		$data['numero'] = $nume;
		$data['formdata2'] = $param2;
		$data['date_range'] = $rdate;
		$data['event'] = $event;

		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		$this->load->view('etitr_data2', $data);
	}
	function gen($etitr_id = 0)
	{
		$this->db->delete('etitr_temp_data', array('e_userid' => $this->session->userdata('user_id')));
		$data['page_title'] = 'PrintOut Promoters Pull Out Form';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data['prim'] = $this->etitr->get_etitr_prim($etitr_id);
		$data['details'] = $this->etitr->get_etitr_details($etitr_id);
		$data['details2'] = $this->etitr->get_etitr_details2($etitr_id);
		$data['id_id'] = $etitr_id;
		
		
		
		
		

		$sql = "select e.ep_pagetype from etitr_prim e where e.ep_etitr_id = ?";

			$query= $this->db->query($sql, array($etitr_id)); 
			$row = $query->row();
			$page = $row->ep_pagetype;
			if($page == 'return'){
			$this->load->view('etitr_generated_return', $data);	
			}else{
			$this->load->view('etitr_generated', $data);	
		}
		
		
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
			
	}
	
	function chkadd($t_id = false, $val = false, $row = false, $seat = false, $delete = false)
	{
		if (!$t_id) { // empty parameter 
		}
		else {
			// parameter has value
		}
		
		$data['page_title'] = 'ETITR';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];

		$data['trans_id'] = $t_id;
		$data['type'] = $val;
		$data['seat_row'] = $row;
		$data['row_seat'] = $seat;
		$data['del_me'] = $delete;

		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		$this->load->view('etitr_checkbox', $data);
	}
	function utd_section()
	{
		$data['page_title'] = 'PrintOut Report';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
	
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		$this->load->view('etitr_update_ed_section', $data);
	}
	function voided($id,$status)
	 {
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		$this->etitr->change_to_void($id);
		
		// $this->load->view('seniors_listing', $data);
		// echo $status;
		redirect('etitr/gen/'.$id);
	 }
	// --****** ADDED RECENTLY, START OF CHANGES
	function remove_company()
	{
		$val = $this->input->post('Value');
		$text = $this->input->post('Text');
		
		if($val && $text)
		{
			$status = $this->etitr->remove_company($val, $text);
			echo $status;
		}
	}
	function getTicketInfoByTransId()
	{
		$trans_id = $this->input->post('trans_id');
		$event_id = $this->input->post('event_id');

		if( ($trans_id > 0 && $event_id > 0) || (is_int($trans_id) && is_int($event_id)) )
		{
			$result = $this->etitr->getTicketInfoByTransId($trans_id, $event_id);
			$checkIfAlreadyExists = $this->etitr->CheckTransIdIfExistsInPullOut($trans_id); // --****** CALL A FUNCTION TO CHECK IF TRANSACTION ID IS ALREADY
																							//			EXISTS ALTHOUGH IT IS ALREADY CHECKED IN FRONT END
			
			if($checkIfAlreadyExists > 0) {
				echo '<td class="content_data_blank" colspan=5>Your transaction number is already exists... Please try another one.</td>';
			} else if($result > 0 && $checkIfAlreadyExists <= 0) {
				foreach($result as $r)
				{
				
				 
					if(!empty($r->section_name))
					{
						$this->etitr->AddToEtitrTempData($result); // --****** CALL A FUNCTION TO ADD INTO 'etitr_temp_data'
						echo '<td class="content_data section">'.$r->section_name.''.$r->transaction_id.'</td>';
						echo '<td class="content_data type">'.$r->ticket_type_name.'</td>';
						echo '<td class="content_data price">'.$r->amount/$r->qty.'</td>';
						echo '<td class="content_data qty">'.$r->qty.'</td>';
						echo '<td class="content_data amount">'.$r->amount.'</td>';
					}
					else 
					{
						echo '<td class="content_data_blank" colspan=5>Please check your transaction ID.</td>';
					}
				}
			} else {
				echo '<td class="content_data_blank" colspan=5>Please check your transaction ID.</td>';
			}
		}
		else
		{
			echo '<td class="content_data_blank" colspan=5>Please check your transaction ID.</td>';
		}
	}
	function addNewCompany($company = false)
	{
		$company = $this->input->post('company');
		if(($company) || ($company != null))
		{
			$exists = $this->etitr->CheckIfCompanyIsExists($company);
			if($exists <= 0)
			{
				$result = $this->etitr->addNewCompany($company);
			}
			else
			{
				$result = $this->etitr->updateNewCompany($exists, $company);
			}
			echo $result;
		}
		else
		{
			return false;
		}
	}
	function GetVenueNameDateTime($event = false)
	{
		$event = $this->input->post('event');
		if($event > 0)
		{
			$result = $this->etitr->GetVenueNameDateTime($event);
			$format = "F d, Y, g:i A";
			$format2 = "Y-m-d H:i:s";
			$event_date_time = date($format,strtotime($result->event_date_time));
			$event_date_time2 = date($format2,strtotime($result->event_date_time));
			print json_encode(array("venue" => $result->venue_name, "datetime" => $event_date_time, "datetime2" => $event_date_time2, "venue2" => $result->venue_id));
		}
	}
	function ClearTempData()
	{
		$this->etitr->ClearTempData();
	}
	function addNewPulloutType($type = false)
	{
		$type = $this->input->post('pullout');
		if(($type) || ($type != null))
		{
			$exists = $this->etitr->CheckIfPulloutTypeIsExists($type);
			if($exists <= 0)
			{
				$result = $this->etitr->addNewPulloutType($type);
			}
			else
			{
				$result = $this->etitr->updateNewPulloutType($exists, $type);
			}
			echo $result;
		}
		else
		{
			return false;
		}
	}
	function removePulloutType()
	{
		$val = $this->input->post('Value');
		$text = $this->input->post('Text');
		
		if($val && $text)
		{
			$status = $this->etitr->removePulloutType($val, $text);
			echo $status;
		}
	}
	function summary_report()
	{
		// prepare data for the template
		$data['page_title'] = 'Promoters Pull Out Form';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
	
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
				
		$data['report'] = $this->etitr->summaryReport(957);

		$this->load->view('etitr_summary', $data);
	}

	function etitr_form_v2()
	{
		// prepare data for the template
		$data['page_title'] = 'Tickets Pull Out Form';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
	
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
				
		$data['promoters'] = $this->etitr->get_promoters_dropdown2();
		$data['events'] = $this->etitr->get_events_dropdown2();
		$data['etitr'] = $this->etitr->get_company_dropdown();
		$data['pullout'] = $this->etitr->get_pullout_type_dropdown();

		if($this->input->post('gen_report'))
		{
			$checkbox = $this->input->post('include_printing');
			$insertid = $this->etitr->gen_etitr($checkbox);
			redirect("etitr/gen_v2/$insertid");
		}
		else
		{
			$this->load->view('etitr_form_v2', $data);
		}
		echo "SERBOY";
	}
	
	function gen_v2($etitr_id = 0)
	{
		$this->db->delete('etitr_temp_data', array('e_userid' => $this->session->userdata('user_id')));
		$data['page_title'] = 'PrintOut Promoters Pull Out Form';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data['prim'] = $this->etitr->get_etitr_prim($etitr_id);
		$data['details'] = $this->etitr->get_etitr_details($etitr_id);
		$data['details2'] = $this->etitr->get_etitr_details2($etitr_id);
		$data['id_id'] = $etitr_id;
		
		// check users session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		$this->load->view('etitr_generated_v2', $data);		
	}
	
	
	function get_sections_dropdown($event = false){
		
		
		if($event){
			
			$this->db->select('event_seatplan_id');
			$this->db->where('event_id', $event);
			$seatplan = $this->db->get('events')->row()->event_seatplan_id;
		
 		
			 $result = $this->db->where("section_seatplan_id",$seatplan)->get("sections")->result();
			// $result = $this->etitr->get_sections_dropdown($event);
			echo json_encode($result);
		}
		
		
		

	}
	
}

/* End of file promoters.php */
/* Location: ./application/controllers/promoters.php */
