<?php

class Eplus extends CI_Controller {

	/* NOTE: using a model class to handle dbproc causes 
		memory to run out and greatly affects 
		PDF generation based on XML generator
		
		Tested 100-200 ticket nodes for loading using
		initial output design for db storage and PDF generation
	*/
		
	public function __construct()
	{
		parent::__construct();
		$this->load->model('generator_model', 'ticket_generator');
		$this->load->model('events_model', 'events');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('logs_model', 'logs');
		$this->load->model('eplus_model', 'eplus');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('customers_model', 'customers');
		$this->load->model('printer_model', 'printer');
		$this->load->model('logs_model', 'logs');
		$this->load->model('users_model', 'users');
		$this->load->database('default');
	}
  
	function pay($customer_session_id = false, $amount = false){ 
		
		$this->output->set_header("Expires: Tue, 01 Jan 2000 00:00:00 GMT"); 
		$this->output->set_header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); 
		$this->output->set_header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); 
		$this->output->set_header("Cache-Control: post-check=0, pre-check=0", false); 
		$this->output->set_header("Pragma: no-cache");
		
		
		
		$eplus = false;
		// prepare data for the template
		$data['page_title'] = 'EPLUS Payment';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
				
		$user_id = $this->session->userdata('user_id');
		
		$baseurl = $_SERVER["HTTP_HOST"];  		
	 
		$data['customer_session_id'] = $customer_session_id;
		$data['baseurl'] = $baseurl;
		$data['user_id'] = $user_id;
		
	 
	 
		// body onload 
		// $data['onload'] =  "onLoad='window.location=\"ecs://$baseurl/printer/generate_card_details/366089\"'";
		
		
		$eplus = $this->eplus->check_status($customer_session_id, 'Paid');
		
		// $data['eplus'] = $eplus;
		
		if(!$eplus){
			$data['onload'] =  "onLoad='window.location=\"eplus://$baseurl/eplus/generate_payment_info/buy/$amount/$user_id/$customer_session_id\"'";
		}
		

		$data['order_id'] = $customer_session_id;
		$this->load->view('transactions_eplus_payment',$data);
		
	}	
	
	/**
	 * payment
	 *
	 * @access	public
	 */
	function payment()
	{
	 
	  
		// check for customer session
		if (!$this->session->userdata('customer_session_id') or !$this->session->userdata('cei') or !$this->session->userdata('cpi'))
		{
			$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
			redirect('');
		}
				
		$customer_session_id = $this->session->userdata('customer_session_id');
		$cei = $this->session->userdata('cei');
		$cpi = $this->session->userdata('cpi');

		
		//check for eplus sessions
		if($this->session->userdata('postData')){
		
			$_POST = $this->session->userdata('postData');
			 
		}else{
		
			$this->session->set_flashdata('message', assemble_error('Transaction corrupted. Please restart transaction from beginning.<br />'));
			redirect("/events/view/$this->session->userdata('cei')");
		}
		
		 
		// prepare data for the template
		$data['page_title'] = 'Eplus Payment';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		// check ticket status
		$this->transactions->_check_tix_stat($customer_session_id, $cei, array('selected', 'reserved'), $this->session->userdata('tix_qty'));
		 
		$data['event'] = $this->events->get($this->session->userdata('cei'));
		
		// add customer to db
		$customer_id = $this->customers->quick_add();
		
		if ($this->session->userdata('claim') == 'claim')
		{
			// update the transaction
			$transaction_id = $this->session->userdata('tid');

			$this->transactions->update($transaction_id, $data['event']->event_reservation_fee, $customer_id);
		}
		else
		{
			// add transaction
			$transaction_id = $this->transactions->add($customer_id);
		}
		
		if ($transaction_id)
		{
			redirect('transactions/done/'.$transaction_id);
		}
		else
		{
			$this->session->set_flashdata('message', assemble_message('Something went wrong with your transaction.  Please try again.'));
			redirect('transactions/payment/');
		}
	 
	}
 
	function refund($transaction_id = false){ 
	
		$this->output->set_header("Expires: Tue, 01 Jan 2000 00:00:00 GMT"); 
		$this->output->set_header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); 
		$this->output->set_header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0"); 
		$this->output->set_header("Cache-Control: post-check=0, pre-check=0", false); 
		$this->output->set_header("Pragma: no-cache");
 


	// prepare data for the template
		$data['page_title'] = 'EPLUS Payment';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
				
		$user_id = $this->session->userdata('user_id');
		
		$baseurl = $_SERVER["HTTP_HOST"];  		
	 
	 
		$_POST = $this->session->userdata('post_void_data'); 
		$refund_id = $this->session->userdata('refund_id');

		$tickets = $_POST['tickets'];
		
		
		
		$eplus = $this->eplus->get_epayment_details($transaction_id);

		if(!$eplus){
		
			die('Cannot find eplus payment for this transaction');
		}
		
		 
 
		$customer_session_id = $eplus->ticket_session_id;
		$card = $eplus->eplus_payment_internal_card_num;
		
		// $amount = ($eplus->payment_amount/$eplus->tix_id) * count($tickets); 

		$amount = $_POST['payment_36'];
 		
		if($refund_id == ''){
			
 			
			$date = date("YmdHis");
			$refund_id =  $transaction_id . $date; 
			$this->eplus->insert_void_details($refund_id, $user_id,$_POST); 
		}
		
		// echo $refund_id;


		
		$eplus = $this->eplus->check_status($refund_id, 'Refunded');
		if(!$eplus){ 
			$data['onload'] =  "onLoad='window.location=\"eplus://$baseurl/eplus/generate_payment_info/refund/$amount/$user_id/$customer_session_id/$card/$transaction_id/$refund_id\"'";
 		}
	 
		  

		$data['refund_id'] = $refund_id;
		$data['transaction_id'] = $transaction_id;
		$this->load->view('transactions_eplus_refund',$data);
		
	}
	
	function void($transaction_id = false)
	{
 		// prepare data for the template
		$data['page_title'] = 'Void Payment';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		// get details
   		$data['tickets'] = $this->tickets->get_tickets_to_void($transaction_id);
		$data['transaction'] = $this->transactions->get($transaction_id);
	 
				
		// print_r($data['transaction']);
		// die();
		//check for eplus refund sessions
		if($this->session->userdata('post_void_data')){
		
			$_POST = $this->session->userdata('post_void_data');
			 
		}
	 
		
		if (count($data['tickets']) > 0) {
		$data['event'] =  $this->events->get($data['tickets'][0]->ticket_event_id);
		$this->form_validation->set_rules('tickets[]', 'Ticket', 'trim|required|strip_tags');
		}
		
		
		if (count($data['tickets']) > 0) { 
		
		
			// update db
			list($section_id, $ticket_count) = $this->tickets->void($data['transaction'], $data['tickets']);
			$this->transactions->void($transaction_id);
			
			// print_r($_POST);
		// die();
			
			// update available tickets
			if ($section_id != 0)
			{
				$this->sections->update_available($section_id, 'increase', $ticket_count);
			}
			$message = ($ticket_count > 1) ? 'Tickets have' : 'Ticket has';
			$message .= ' been successfully voided.';
			$this->session->set_flashdata('message', assemble_message($message));
			// redirect('transactions/listing/');
		}
		else {
			$this->transactions->void_transaction_only($transaction_id);
			$message = 'Void request has been processed. Please review status of your transaction.';
			$this->session->set_flashdata('message', assemble_message($message));
		}
		redirect("transactions/view/$transaction_id");

		 
	}
	
	function generate_payment_info($type = false, $amount = false, $user_id = false, $session_id = false, $card = false )
	{
		  
		if(!$type || !$amount || !$user_id || !$session_id){
			die();
		}  
		  
		 
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		 
		$result = $this->eplus->get_payment_details($type, $user_id, $session_id);
		
  
		$this->load->dbutil();
		$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
		echo $this->dbutil->xml_from_result($result, $config);
	
	}
	
	function mark_as_paid(){
		
 	
		$this->load->library('simplexml');  

		$xml_data = $this->input->post('xml_data');
		 
	 
		$xml_data = $this->simplexml->xml_parse($xml_data, "&amp");
		// echo '<pre>';
		// print_r($xml_data);
		// echo '</pre>';
		 
		$this->eplus->insert_details($xml_data);
	  
	}
	
	function mark_as_voided(){
		
 	
		$this->load->library('simplexml');  

		$xml_data = $this->input->post('xml_data');
		 
	 
		$xml_data = $this->simplexml->xml_parse($xml_data, "&amp");
		$this->api_void($xml_data);

		$this->eplus->void_payment($xml_data);
	  
	}
	 
 
	function check_payment_status($refund_id = false, $status){
	 
	    $result =  $this->eplus->check_status($refund_id, $status);
		echo $result;
	}

	
	function check_payment_status2($order_id = false, $status){
	 
	    $result =  $this->eplus->check_status2($order_id, $status);
		echo $result;
	}

	
	 
	function calcu(){
	
		$this->load->view('calcu');

	
	}
	
	
	function check_session_status($order_id = false,$user = false, $status = false){
	 
	 
		$session = $this->eplus->check_session($order_id , $user, $status);
	 
	 
		if($session){
		
			 
				$result =  $this->eplus->check_status($order_id, $status);  
			
				if($result){
					echo 0; 
				}else{
					echo 1;
				}
				
		 
		 
		  
		}else{ 
			echo 0;
		}
		 
	}
	
	
	//eplus 1D
	
	function generate_card_details($transID = false, $user_id = false)
	{
		
		if(!$transID || !$user_id){
			die();
		}  
		  
		
		// parse_str($_SERVER['QUERY_STRING'],$_GET);
		
		 //get paramters needed	
		// $transactionID = $this->input->get('transID');
		
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		 
		$result = $this->eplus->get_ticket_details($transID);
		
 
		
		$this->load->dbutil();
		$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
		echo $this->dbutil->xml_from_result($result, $config);
		 
	 
	}
	
	function add_card_number(){
		
 	
		$this->load->library('simplexml');  

		$xml_data = $this->input->post('xml_data');
		 
	 
		$xml_data = $this->simplexml->xml_parse($xml_data, "&amp");
		// echo '<pre>';
		print_r($xml_data);
		// echo '</pre>';
		 
		$this->eplus->insert_card_details($xml_data);
	  
	}
	  
	function check_card($card = false){
	 
	 
	$this->db->where('eplus_card_printed_card_num',$card);
	$query = $this->db->get('eplus_cards');
	
	if($query->num_rows() > 0){
	
	echo 'true';
	
	}else{
	
	echo 'false';
	}
	
	
	
	
	}
	
	function card_details($type = false)
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		// prepare data for the template
		$data['page_title'] = 'Check Card Details';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$this->form_validation->set_rules('card', 'Card Number', 'trim|required|strip_tags');
		$this->form_validation->set_error_delimiters('<div class="errors">', '</div>');

		if ($this->form_validation->run() != FALSE)
		{
			 
			$data['result'] = $this->eplus->get_card_details($this->input->post('card'));
			 // print_r($data['result']);
			 // die();
			 
		}
		
		 
		$this->load->view('card_details', $data);
		 
	}	
	
	
	function void_card($type = false)
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		// prepare data for the template
		$data['page_title'] = 'Void Card Details';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$this->form_validation->set_rules('card', 'Card Number', 'trim|required|strip_tags');
		$this->form_validation->set_rules('username', 'Username', 'trim|required|strip_tags|max_length[20]|callback__check_manager_login');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|strip_tags|max_length[20]');
		
		
		$this->form_validation->set_error_delimiters('<div class="errors">', '</div>');

		if ($this->form_validation->run() != FALSE)
		{
			 
			 
			//add card logs
			$this->eplus->add_card_logs_($this->input->post('card'));
			
			
			//untag card 
 			$this->db->where('eplus_card_printed_card_num', $this->input->post('card'));
			// $this->db->where('eplus_card_date_claimed', '0000-00-00 00:00:00');
			$this->db->delete('eplus_cards'); 
			if($this->db->affected_rows() > 0 ){
			
			$this->session->set_flashdata('message', assemble_message('Card has been voided. Please check the transaction and save ticket details to another card.')); 
			redirect('');
			
			}else{ 
			
				$this->session->set_flashdata('message', assemble_message('Unable to find card number or card is tagged with OneD card.')); 
				redirect('eplus/void_card/'); 
			}
		}
		
		 
		$this->load->view('void_card', $data);
		 
	}	
	 
	 
	function void_one_d_card($type = false)
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		// prepare data for the template
		$data['page_title'] = 'Void Card Details';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$this->form_validation->set_rules('ticket', 'Card Number', 'trim|required|strip_tags');
		$this->form_validation->set_rules('username', 'Username', 'trim|required|strip_tags|max_length[20]|callback__check_manager_login');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|strip_tags|max_length[20]');
		
		
		$this->form_validation->set_error_delimiters('<div class="errors">', '</div>');

		if ($this->form_validation->run() != FALSE)
		{
			 
			//add card logs
			$this->eplus->add_card_logs($this->input->post('ticket'));
			
			
			$this->db->set('eplus_card_printed_card_num_new', NULL);
			$this->db->set('eplus_card_status', 'Done');
			$this->db->set('eplus_card_claim_user_id', 0);
			$this->db->set('eplus_card_date_claimed', '0000-00-00 00:00:00');
			$this->db->where('eplus_card_ticket_id', $this->input->post('ticket'));
			$this->db->update('eplus_cards');
			
			if($this->db->affected_rows() > 0 ){
			
			$this->session->set_flashdata('message', assemble_message('OneD Card has been voided. Please check the transaction and save ticket details to another card.')); 
			redirect('');
			
			}else{ 
			
				$this->session->set_flashdata('message', assemble_message('Unable to find card number associated with this ticket ID.')); 
				redirect('eplus/void_one_d_card/'); 
			}
		}
		
		 
		$this->load->view('void_one_d_card', $data);
		 
	}	
	 
	 
	function _check_manager_login($str)
	{	
		if (!$this->users->manager_login())
		{
			$this->form_validation->set_message('_check_manager_login', "Manager username and password combination is incorrect");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	 //claim 1d card
	
	function get_card_details($card = false)
	{
		
		if(!$card){
			die();
		}  
		  
		
		// parse_str($_SERVER['QUERY_STRING'],$_GET);
		
		 //get paramters needed	
		// $transactionID = $this->input->get('transID');
		
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		 
		$result = $this->eplus->get_card_ticket_details($card);
		
 
		
		$this->load->dbutil();
		$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
		echo $this->dbutil->xml_from_result($result, $config);
		 
	 
	}
	 	
	function mark_as_claimed($card = false,$ticket = false , $user = false){
		
		$this->db->set('eplus_card_printed_card_num_new', $card);
		$this->db->set('eplus_card_status', 'Claimed');
		$this->db->set('eplus_card_date_claimed', date("Y-m-d H:i:s"));
		$this->db->set('eplus_card_claim_user_id', $user);
		$this->db->where('eplus_card_ticket_id', $ticket);
		$this->db->update('eplus_cards');
 	
		echo 1;
	  
	}
	
	function mark_as_done($ticket = false){
		
		
		//add card logs
		$this->eplus->add_card_logs($ticket);
		
		$this->db->set('eplus_card_printed_card_num_new', NULL);
 		$this->db->set('eplus_card_status', 'Done');
		$this->db->set('eplus_card_claim_user_id', 0);
		$this->db->set('eplus_card_date_claimed', '0000-00-00 00:00:00');
		$this->db->where('eplus_card_ticket_id', $ticket);
		$this->db->update('eplus_cards');
 	
		echo 1;
	  
	}
	 
	//iptl
	
	function generate_iptl_details($transID = false, $user_id = false)
	{
		
		if(!$transID || !$user_id){
			die();
		}  
		  
		
		// parse_str($_SERVER['QUERY_STRING'],$_GET);
		
		 //get paramters needed	
		// $transactionID = $this->input->get('transID');
		
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
	

 
		// $result = $this->eplus->get_iptl_ticket_details($transID);
		$data['result'] = $this->eplus->get_iptl_ticket_details($transID);  
		
		foreach($data['result'] as $x){
		
		$event_code =  $x->event_code;
		$ticket_id[] =  $x->ticket_id;
		
		}
		
		
// echo $data['result'][0][$event_code];
	 	
			
		if($event_code == 'MM5-7AUG169AM' || $event_code == 'COLDPLAY4APR17'|| $event_code == 'VAMPS30JAN167P'|| $event_code == '5SOS12MAR168PM'|| $event_code == 'GARDNER04NOV8AM'){
		
		
		$ticket_details = $this->eplus->get_ticket_details_by_id($ticket_id);
		$data['ticket_details']  = $this->array_flatten($ticket_details);
		
		// echo '<pre>';
		 // print_r($data['ticket_details'] );
		 // echo '</pre>';
		 // die();
		$this->load->view('ticket_details_xml',$data);
		
		}else{
		
		
		
		
		
		
		
		$ticketIDs = $this->array_flatten2($data['result'] );
 
 
 
		$ticket_details = $this->eplus->get_ticket_details_by_id($ticketIDs);
		
		
		
		
		$data['ticket_details']  = $this->array_flatten($ticket_details);
	 
		
		 
		 // echo '<pre>';
		 // print_r($data['ticket_details']  );
		 // echo '</pre>';
		 // die();
		$this->load->view('iptl_ticket_details_xml',$data);
		 }
	 
	}
	
	  
	function add_iptl_details(){
		
 	// die('test');
		$this->load->library('simplexml');  

		$xml_data = $this->input->post('xml_data');
		 
	 
		$xml_data = $this->simplexml->xml_parse($xml_data, "&amp");
		// echo '<pre>';
		// print_r($xml_data);
		// echo '</pre>';
		 
		$result = $this->eplus->insert_iptl_details($xml_data);
		echo $result;
	} 
	
  
    function array_flatten($ticket_details) { 
	
		$result = array();
		 
		foreach($ticket_details as $x){
		
			$result[] = $x->eplus_card_ticket_id . $x->eplus_card_event_date; 
		
		}
	
	
	
		return $result; 
	} 

    function array_flatten2($ticket_details) { 
	
		$result = array();
		 
		foreach($ticket_details as $x){
		
			$result[] = $x->ticket_id; 
		
		}
	
	
	
		return $result; 
	} 

  
	function void_iptl_details($card = false,$user_id = false){
		
		if(!$user_id){
		
		die('no user id');
		}
		
		//add card logs
		$this->eplus->add_card_logs2($card, $user_id , 'edited card');
		
		$this->db->where('eplus_card_printed_card_num', $card);
		$this->db->delete('eplus_cards');
 	
		echo 1;
	  
	}
	 
   	function void_iptl_card($type = false)
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager','Reservation','Reservation-Admin'));
		
		// prepare data for the template
		$data['page_title'] = 'Void Card Details';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$this->form_validation->set_rules('ticket', 'Card Number', 'trim|required|strip_tags');
		$this->form_validation->set_rules('username', 'Username', 'trim|required|strip_tags|max_length[20]|callback__check_manager_login');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|strip_tags|max_length[20]');
		$this->form_validation->set_rules('event_date', 'Event Date', 'trim|required|strip_tags|max_length[20]');
 		$this->form_validation->set_rules('or_number', 'OR Number', 'trim|required|strip_tags|max_length[20]');

		
		$this->form_validation->set_error_delimiters('<div class="errors">', '</div>');

		if ($this->form_validation->run() != FALSE)
		{
			 
			
		  
			
			//add card logs
			$card = $this->eplus->add_card_logs3($this->input->post('ticket'), $this->input->post('event_date'), $this->session->userdata('user_id') , 'lost card', $this->input->post('or_number'));		
			
	 
			$this->db->where('eplus_card_printed_card_num', $card);
			$this->db->delete('eplus_cards');
			
			if($this->db->affected_rows() > 0 ){
			
			$this->session->set_flashdata('message', assemble_message('EPLUS Card has been voided. Please check the transaction and save ticket details to another card.')); 
			redirect('');
			
			}else{ 
			
				$this->session->set_flashdata('message', assemble_message('Unexpected error has been encountered. Please contact the developer')); 
				redirect('eplus/void_iptl_card/'); 
			}
		}
		
		 
		$this->load->view('void_iptl_card', $data);
		 
	}	
	 
	 
	function generate_ticket_details($transID = false, $user_id = false)
	{
		
		
		if(!$transID || !$user_id){
			die();
		}  
		  
		
		// parse_str($_SERVER['QUERY_STRING'],$_GET);
		
		 //get paramters needed	
		// $transactionID = $this->input->get('transID');
		
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
	

 
		// $result = $this->eplus->get_iptl_ticket_details($transID);
		$data['result'] = $this->eplus->get_ticket_details2($transID);  
		
		// $ticketIDs = $this->array_flatten2($data['result'] );
 
	 // echo '<pre>';
		 // print_r($ticketIDs);
		 // echo '</pre>';
		 // die();
 
 
		// $ticket_details = $this->eplus->get_ticket_details_by_id($ticketIDs);
		
		
		
		
		// $data['ticket_details']  = $this->array_flatten($ticket_details);
	 
		
		 
		 // echo '<pre>';
		 // print_r($data['ticket_details']  );
		 // echo '</pre>';
		 
		$this->load->view('ticket_details_xml',$data);
		 
	 
	}
	
	function void_madonna_card($type = false)
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		// prepare data for the template
		$data['page_title'] = 'Void Card Details';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$this->form_validation->set_rules('ticket', 'Card Number', 'trim|required|strip_tags');
		$this->form_validation->set_rules('username', 'Username', 'trim|required|strip_tags|max_length[20]|callback__check_manager_login');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|strip_tags|max_length[20]');
		
		
		$this->form_validation->set_error_delimiters('<div class="errors">', '</div>');

		if ($this->form_validation->run() != FALSE)
		{
			 
			//add card logs
			$this->eplus->add_card_logs($this->input->post('ticket'));
			
			 
			$this->db->where('eplus_card_ticket_id', $this->input->post('ticket'));
			$this->db->delete('eplus_cards');
			
			if($this->db->affected_rows() > 0 ){
			
			$this->session->set_flashdata('message', assemble_message('Eplus Card has been voided. Please check the transaction and save ticket details to another card.')); 
			redirect('');
			
			}else{ 
			
				$this->session->set_flashdata('message', assemble_message('Unable to find card number associated with this ticket ID.')); 
				redirect('eplus/void_madonna_card/'); 
			}
		}
		
		 
		$this->load->view('void_madonna_card', $data);
		 
	}	
	 
	 
	
	//dreamplay	
	function generate_dcard_details($transID = false, $user_id = false)
	{
		
		if(!$transID || !$user_id){
			die();
		}  
		  
		
		// parse_str($_SERVER['QUERY_STRING'],$_GET);
		
		 //get paramters needed	
		// $transactionID = $this->input->get('transID');
		
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		 
		$result = $this->eplus->get_dticket_details($transID);
		
 
		
		$this->load->dbutil();
		$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
		echo $this->dbutil->xml_from_result($result, $config);
		 
	 
	}
	
	function add_dcard_number(){
		
 	
		$this->load->library('simplexml');  

		$xml_data = $this->input->post('xml_data');
		 
	 
		$xml_data = $this->simplexml->xml_parse($xml_data, "&amp");
		// echo '<pre>';
		// print_r($xml_data);
		// echo '</pre>';
		 
		$this->eplus->insert_dcard_details($xml_data);
	  
	}
	
	function validate_card(){
		
 	
		$this->load->library('simplexml');  

		$xml_data = $this->input->post('xml_data');
		 
	 
		$xml_data = $this->simplexml->xml_parse($xml_data, "&amp");
		// echo '<pre>';
		// print_r($xml_data);
		// echo '</pre>';
		 
		$this->eplus->validate_card($xml_data);
	  
	}
	 
	function void_dreamplay_pass($type = false)
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		// prepare data for the template
		$data['page_title'] = 'Void Card Details';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$this->form_validation->set_rules('ticket', 'Card Number', 'trim|required|strip_tags');
		$this->form_validation->set_rules('username', 'Username', 'trim|required|strip_tags|max_length[20]|callback__check_manager_login');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|strip_tags|max_length[20]');
		
		
		$this->form_validation->set_error_delimiters('<div class="errors">', '</div>');

		if ($this->form_validation->run() != FALSE)
		{
			 
			//add card logs
			$this->eplus->add_dcard_logs($this->input->post('ticket'),$this->input->post('reason'));
			
			 
			$this->db->where('eplus_card_ticket_id', $this->input->post('ticket'));
			$this->db->delete('eplus_cards_dreamplay');
			
			if($this->db->affected_rows() > 0 ){
			
			$this->session->set_flashdata('message', assemble_message('Dreamplay Annual Card has been voided. Please check the transaction and save ticket details to another card.')); 
			redirect('');
			
			}else{ 
			
				$this->session->set_flashdata('message', assemble_message('Unable to find card number associated with this ticket ID.')); 
				redirect('eplus/void_dreamplay_pass/'); 
			}
		}
		
		 
		$this->load->view('void_dreamplay_card', $data);
		 
	}	
	function update_refund_number(){
		
 	
		$this->load->library('simplexml');  

		$xml_data = $this->input->post('xml_data');
		 
	 
		$xml_data = $this->simplexml->xml_parse($xml_data, "&amp");
		// echo '<pre>';
		// print_r($xml_data);
		// echo '</pre>';
		 
		$this->eplus->update_refund_number($xml_data);
	  
	}
	 
	function api_void($xml_data = false)
	{
	  
	  
		if(!empty($xml_data)){
		 
			foreach($xml_data as $x){ 
		
				 $transaction_id = $x['Trans_Id'];
			  
				// get details
				$data['tickets'] = $this->tickets->get_tickets_to_void($transaction_id);
				$data['transaction'] = $this->transactions->get($transaction_id);
			 
						
				$this->db->where('eplus_payment_refund_session',$x['Refund_Id']); 
				$result = $this->db->get('eplus_payments_refund')->row();
				$_POST = unserialize($result->eplus_payment_refund_post);
				
				/* 
				if (count($data['tickets']) > 0) {
				$data['event'] =  $this->events->get($data['tickets'][0]->ticket_event_id);
				$this->form_validation->set_rules('tickets[]', 'Ticket', 'trim|required|strip_tags');
				}
				 */
				
				if (count($data['tickets']) > 0) { 
				
				
					// update db
					list($section_id, $ticket_count) = $this->tickets->void($data['transaction'], $data['tickets']);
					$this->transactions->void2($transaction_id, $_POST['tickets']);
					$this->transactions->void_payment($_POST,$transaction_id);	 

				 
					
					// update available tickets
					if ($section_id != 0)
					{
						$this->sections->update_available($section_id, 'increase', $ticket_count);
					}
					 
				}
				else {
					$this->transactions->void_transaction_only($transaction_id);
					 
				}
	 
			} 
		}
	}
	
	function redirect($transaction_id = false){
		$message = 'Ticket has been successfully voided.';
		$this->session->set_flashdata('message', assemble_message($message));
		redirect("transactions/view/$transaction_id");
		

	}
	 
		
	//dynamic event access card
	function generate_dynamic_ticket_details($transID = false, $user_id = false)
	{
		
		if(!$transID || !$user_id){
			echo 'No trans id or user id provided';
			die();
		}  
		  
		 
		
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
	
	
		$data['loop']  = 0;
		$data['days']  = 1;
		$data['appcode']  = 190;
	 
	 

		//get ticket info
 		$data['result'] = $this->eplus->get_iptl_ticket_details($transID);   
		
		$ticketIDs = $this->array_flatten2($data['result'] ); 
		
		//get all tagged tickets
		$ticket_details = $this->eplus->get_ticket_details_by_id($ticketIDs); 
		
		$data['ticket_details']  = $this->array_flatten($ticket_details);
	  
		$this->load->view('dynamic_ticket_details_xml',$data);
		  
	 
	}
	
	function add_dynamic_ticket_details(){
		
 	// die('test');
		$this->load->library('simplexml');  

		$xml_data = $this->input->post('xml_data');
		 
	 
		$xml_data = $this->simplexml->xml_parse($xml_data, "&amp");
		// echo '<pre>';
		// print_r($xml_data);
		// echo '</pre>';
		 
		$result = $this->eplus->insert_dynamic_ticket_details($xml_data);
		echo $result;
	} 
	
	function void_dynamic_ticket_details($card = false,$user_id = false){
		
		if(!$user_id){
		
		die('no user id');
		}
		
		//add card logs
		$this->eplus->add_dynamic_card_logs($card, $user_id , 'edited card');
		
		$this->db->where('eplus_card_printed_card_num', $card);
		$this->db->delete('eplus_cards');
 	
		echo 1;
	  
	}
	 
	
	function void_eplus_card($type = false)
	{
		// check user session
		$this->users->check_session(array('Admin', 'Seller', 'Manager'));
		
		// prepare data for the template
		$data['page_title'] = 'Void Card Details';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$this->form_validation->set_rules('ticket', 'Card Number', 'trim|required|strip_tags');
		$this->form_validation->set_rules('username', 'Username', 'trim|required|strip_tags|max_length[20]|callback__check_manager_login');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|strip_tags|max_length[20]');
		
		
		$this->form_validation->set_error_delimiters('<div class="errors">', '</div>');

		if ($this->form_validation->run() != FALSE)
		{
			 
			//add card logs
			$this->eplus->add_card_logs($this->input->post('ticket'));
			
			 
			$this->db->where('eplus_card_ticket_id', $this->input->post('ticket'));
			$this->db->delete('eplus_cards');
			
			if($this->db->affected_rows() > 0 ){
			
			$this->session->set_flashdata('message', assemble_message('Eplus Card has been voided. Please check the transaction and save ticket details to another card.')); 
			redirect('');
			
			}else{ 
			
				$this->session->set_flashdata('message', assemble_message('Unable to find card number associated with this ticket ID.')); 
				redirect('eplus/void_eplus_card/'); 
			}
		}
		
		 
		$this->load->view('void_madonna_card', $data);
		 
	}	
	
 
} 

/* End of file printer.php */
/* Location: ./application/controllers/printer.php */