<?php

class EKTickets extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('customers_model', 'customers');
		$this->load->model('payments_model', 'payments');
		$this->load->model('reservations_model', 'reservations');
		
		$this->load->model('ekbarcode_model', 'ekbarcode');
		$this->load->model('events_model', 'events');
		$this->load->model('logs_model', 'logs');
		$this->load->model('payment_types_model', 'payment_types');
		$this->load->model('prices_model', 'prices');
		$this->load->model('sections_model', 'sections');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('users_model', 'users');
		$this->load->database('default');

		// place authentication check here
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));

	}
	
	function index()
	{
		// $this->load->view('welcome_message');
	}

	
	function listing() {
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		$data['page_title'] = 'Events Listing for EK Tickets';
		// log this
		$this->logs->add($data['page_title']);

		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data["listing"] = $this->ekbarcode->listing_active();
		
		$this->benchmark->mark('query_end');
		$this->load->view('ektickets_listing',$data);
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
	}

	function add_barcode($event_id = 0) {
	
		$data['page_title'] = 'Add EK Barcodes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		$valid = false;
		if ($event_id > 0) {
			$data["event_info"] = $this->events->get($event_id);

			if ($data["event_info"]->events_config_ekbarcode_active == 1) {
				$this->load->view('ekbarcode_add',$data);
				$valid = true;
			}
			
		} 
		if (! $valid) {
			redirect('ekbarcode/listing');
		}
	}

	function view($event_id = 0)
	{
	
		$this->benchmark->mark('page_start');
		$this->benchmark->mark('query_start');
		
		if ($event_id > 0) { } 
		else { redirect("ektickets/listing"); }

		// prepare data for the template
		$data['page_title'] = 'View Event';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);

		// clear previously selected tickets that are due for clearing
		$this->tickets->clear_selected_seats();
		
		// remove current customer session and tickets
		$this->tickets->clear_tickets($this->session->userdata('customer_session_id'));
		$this->session->set_userdata(array('customer_session_id' => '', 'claim' => ''));
		
		
		// add event id to session
		$this->session->set_userdata('cei', $event_id);
	
		// get event
		$data['event'] = $this->events->get($event_id);
		
		// get prices
		$data['prices'] = $this->prices->get_prices($event_id);
		$data['prices_ek'] = $this->ekbarcode->available_barcode_array($event_id);
		
		$this->benchmark->mark('query_end');
		// display the page
		$this->load->view('ektickets_events_view', $data);
		$this->benchmark->mark('page_end');
		
		$querytime = $this->benchmark->elapsed_time('query_start', 'query_end');
		$pagetime = $this->benchmark->elapsed_time('page_start', 'page_end');
		$this->logs->benchmark_add($querytime, $pagetime);
		
	}
	

	function sections($event_id = 0, $transaction_type = false)
	{
		if ($event_id > 0) { } 
		else { redirect("ektickets/listing"); }

		// for the view page - seatplan 
		$this->load->helper('simplejson');

		// prepare data for the template
		$data['page_title'] = 'Select Section';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		// add session id for the current customer
		if (!$this->session->userdata('customer_session_id'))
		{
			$this->session->set_userdata('customer_session_id', $this->users->prep_password(time() . $this->session->userdata('session_id')));
		}
	
		// get event
		$event = $this->events->get($event_id);
		$data['event'] = $event; 
		
		if ($transaction_type == 'reserve')
		{
			// create session for reserve
			$this->session->set_userdata(array('transaction_type' => 'reserve',));
		}
		else
		{
			// create session for reserve
			$this->session->set_userdata(array('transaction_type' => 'sell',));
		}
		
		// get prices
		$data['prices'] = $this->prices->get_prices($event->event_id);
		$data['prices_ek'] = $this->ekbarcode->available_barcode_array($event_id);
		
		// get section names
		$data['section_names'] = $this->sections->get_section_names($event->seatplan_id);
		
		// get all the sections
		$data['sections'] = $this->sections->get_sections($event->event_seatplan_id);
		
		// display the page
		$this->load->view('ektickets_transactions_sections', $data);
	}	
	
	
	function seats($section_id = false)
	{
		if (!$section_id ) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'Select Seats';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data['header'] = "<META HTTP-EQUIV=\"PRAGMA\" CONTENT=\"NO-CACHE\">\n<META HTTP-EQUIV=\"CACHE-CONTROL\" CONTENT=\"NO-CACHE\">\n<META HTTP-EQUIV=\"EXPIRES\" CONTENT=\"0\">\n";
		
		// log this
		$this->logs->add($data['page_title']);
		
		if ($section_id > 0) { } 
		else { redirect("ektickets/listing"); }

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		// add section id to session
		$this->session->set_userdata('csi', $section_id);
		
		// get section info
		$section = $this->sections->get($section_id);
		
		// add price id to session
		$price_id = $this->prices->get_price_id($this->session->userdata('cei'), $section->section_id);
		$this->session->set_userdata('cpi', $price_id);
		
		redirect('ektickets/ticket_quantity/'.$section_id.'/'.$price_id);
		
		
		// redirect if section is not reserved seating
		if ($section->section_type != 'Reserved')
		{
			redirect('ektickets/ticket_quantity/'.$section_id.'/'.$price_id);
		}

		$config = array(
			array(
				'field'   => 'seat[]',
				'label'   => 'Seat',
				'rules'   => 'trim|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		
		if ($this->form_validation->run() != FALSE)
		{
			
			$elem_qty = count($_POST['seat']);
			$seat_qty = count($_POST['seat'], COUNT_RECURSIVE) - $elem_qty;
			
			// add qty of tickets selected to session
			$this->session->set_userdata('tix_qty', $seat_qty);
			
			$get_seat_qty_db = count($this->tickets->get_tickets_by_session($this->session->userdata('customer_session_id'), $this->session->userdata('cpi')));
			
			if ($get_seat_qty_db != $seat_qty)
			{
				$this->session->set_flashdata('message', assemble_error('Error encountered during seats selection. Please try again.<br />'));
				redirect('ektickets/listing');
			}
			else
			{
				redirect('ektickets/ticket_types/');
			}
		}
		else
		{
			// remove previsouly selected tickets
			$this->tickets->clear_tickets($this->session->userdata('customer_session_id'));
			
			// data
			$data['section'] = $section;
			$data['seat_config'] = unserialize($section->section_seat_config);
			$data['event'] = $this->events->get($this->session->userdata('cei'));
			$data['seats_taken'] = $this->tickets->get_taken_seats($this->session->userdata('cei'), $section_id);
			$data['price_id'] = $price_id;
	
			// display the page
			$this->load->view('ektickets_transactions_seats', $data);
		}
	}
	
	function ticket_quantity($section_id = false, $price_id = false)
	{
		if (!$section_id ) show_404();
		
		// prepare data for the template
		$data['page_title'] = 'Enter Ticket Quantity';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		if ($section_id > 0) { } 
		else { redirect("ektickets/listing"); }

		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		// get section info
		$section = $this->sections->get($section_id);
	
		$event_id = $this->session->userdata('cei');
		$maxval = $this->ekbarcode->count_available_barcodes($event_id, $price_id);

		
		$this->form_validation->set_rules('ticket_quantity', 'Ticket Quantity', 'min_value[1]|max_value['.$maxval.']|trim|required|strip_tags|max_length[3]|integer');
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		// data
		$data['section'] = $section;
		$data['section_available'] = $maxval;
		$data['event'] = $this->events->get($this->session->userdata('cei'));
		$data['price_id'] = $price_id;

		if ( $this->form_validation->run() != FALSE )
		{		
			// add to db
			$ticket_count =  $this->ekbarcode->create_tickets($event_id, $section, $price_id);
			
			$ticket_qty = $_POST['ticket_quantity'];
			$ticket_qty_db = count($this->tickets->get_tickets_by_session($this->session->userdata('customer_session_id'), $this->session->userdata('cpi')));
			
			// add qty of tickets selected to session
			$this->session->set_userdata('tix_qty', $ticket_qty);
			
			if (number_format($ticket_qty) != number_format($ticket_qty_db))
			{
				$this->session->set_flashdata('message', assemble_error('Invalid access. Please restart transaction from beginning.<br />'));
				redirect('ektickets/listing');
			}
			else 
			{
				// redirect
				redirect('ektickets/ticket_types/');
			}
		}

		// display the page
		$this->load->view('ektickets_transactions_ticket_quantity', $data);
	}
	
	function ticket_types($claim = false, $transaction_id = false)
	{
		if ($claim == 'claim')
		{
			// get price info
			$restore_session =  $this->reservations->get_customer_id($transaction_id);	
			//printr($restore_session);
			$customer_session_id = $restore_session->ticket_session_id;
			$cei = $restore_session->ticket_event_id;
			$cpi = $restore_session->ticket_price_id;
			$tix_qty = $this->transactions->_get_num_of_reserved_tix($transaction_id);
			
			// set session data
			$this->session->set_userdata('cei', $cei);
			$this->session->set_userdata('cpi', $cpi);
			$this->session->set_userdata('customer_session_id', $customer_session_id);
			$this->session->set_userdata('claim', $claim);
			$this->session->set_userdata('tid', $transaction_id);
			$this->session->set_userdata('tix_qty', $tix_qty);
		}
		else
		{
			if (!$this->session->userdata('customer_session_id') or !$this->session->userdata('cei') or !$this->session->userdata('cpi'))
			{
				$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
				redirect('ektickets/listing');
			}
			
			$customer_session_id = $this->session->userdata('customer_session_id');
			$cei = $this->session->userdata('cei');
			$cpi = $this->session->userdata('cpi');
		}

		
		// prepare data for the template
		$data['page_title'] = 'Select Ticket Types';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		$config = array(
			array(
				'field'   => 'ticket[]',
				'label'   => 'Ticket',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'ticket_type[]',
				'label'   => 'Ticket Type',
				'rules'   => 'required|trim|strip_tags'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($claim == 'claim')
		{
			// get tickets
			$data['tickets'] = $this->tickets->get_reserved_tickets($transaction_id);
		}
		else
		{
			// get tickets
			$data['tickets'] = $this->tickets->get_tickets_by_session($this->session->userdata('customer_session_id'), $this->session->userdata('cpi'));
		}
		
		$ticket_count = count($data['tickets']);
		// get price info
		$data['price'] =  $this->prices->get($cpi);

		$data['event'] = $this->events->get($cei);
		
		/* 		
		// get ticket types - instead of using normal identification of ttypes, we depend on ek_barcode table
		$ticket_types = $this->ekbarcode->ticket_types_with_barcodes($cei, unserialize($data['event']->event_ticket_types),$ticket_count);
		$data['ticket_types'] = $this->ticket_types->array_info($ticket_types);
		*/
		$data['ticket_types'] = $this->ticket_types->array_info(unserialize($data['event']->event_ticket_types));
		if ($this->form_validation->run() != FALSE)
		{
			
			// update db
			$this->tickets->edit_ticket_type();
			if ($this->session->userdata('transaction_type') == 'reserve' && $claim != 'claim')
			{
				// redirect
				redirect('ektickets/customer_info/');
			}
			else
			{			
				// update db
            	// $this->ekbarcode->edit_ticket_type($cei);
			
				// redirect
				redirect('ektickets/payment/'.$claim);
			}	
		}
		else
		{
			$data['uri'] = ($claim == 'claim') ? 'claim/'.$transaction_id : '';
		
			// display the page
			$this->load->view('ektickets_transactions_ticket_types', $data);
		}
	}
	
	function payment()
	{
		// check for customer session
		if (!$this->session->userdata('customer_session_id') or !$this->session->userdata('cei') or !$this->session->userdata('cpi'))
		{
			$this->session->set_flashdata('message', assemble_error('Invalid access. Please try again.'));
			redirect('ektickets/listing');
		}
				
		$customer_session_id = $this->session->userdata('customer_session_id');
		$cei = $this->session->userdata('cei');
		$cpi = $this->session->userdata('cpi');

		// prepare data for the template
		$data['page_title'] = 'Enter Payment';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));
		
		// check ticket status
		if ($this->ekbarcode->_check_tix_stat($customer_session_id, $cei, array('selected', 'reserved'), $this->session->userdata('tix_qty'))) {
		} else {
			$this->session->set_flashdata('message', assemble_error('Transaction corrupted. Please restart transaction from beginning.<br />'));
			redirect("/ektickets/view/$cei");
		}
		
		// get payment types
		//$data['payment_types'] = $this->payment_types->get_payment_types();
		$data['payment_types'] = $this->payment_types->get_payment_type_categories();
		$data['credit_cards'] = $this->payment_types->get_payment_types_dropdown('Credit Card');
		$data['debit_cards'] = $this->payment_types->get_payment_types_dropdown('Debit Card');
		$data['gift_checks'] = $this->payment_types->get_payment_types_dropdown('Gift Check');
		$data['reward_cards'] = $this->payment_types->get_payment_types_dropdown('Reward Card');
		$data['accounts'] = $this->payment_types->get_payment_types_dropdown('Account');
		
		$data['default_cc'] = $this->payment_types->get_payment_type_id_by_categories('Credit Card');
		$data['default_dc'] = $this->payment_types->get_payment_type_id_by_categories('Debit Card');
		$data['default_gc'] = $this->payment_types->get_payment_type_id_by_categories('Gift Check');
		$data['default_rc'] = $this->payment_types->get_payment_type_id_by_categories('Reward Card');
		$data['default_ac'] = $this->payment_types->get_payment_type_id_by_categories('Account');
		
		// validate form
		$this->form_validation->set_rules('customer_mobile', 'Mobile Number', 'trim|required|strip_tags|max_length[15]');
		$this->form_validation->set_rules('customer_firstname', 'First Name', 'trim|strip_tags|max_length[80]');
		$this->form_validation->set_rules('customer_lastname', 'Last Name', 'trim|strip_tags|max_length[20]');
		
		$this->form_validation->set_rules('transaction_payment_cash', 'Cash', 'trim|strip_tags');
		$this->form_validation->set_rules('transaction_payment_credit_card_1', 'Credit Card 1', 'trim|strip_tags|callback__cc1_check');
		$this->form_validation->set_rules('transaction_payment_credit_card_2', 'Credit Card 2', 'trim|strip_tags|callback__cc2_check');
		$this->form_validation->set_rules('transaction_payment_debit_card', 'Debit Card', 'trim|strip_tags|callback__dc_check');
		$this->form_validation->set_rules('transaction_payment_gift_check', 'Gift Check', 'trim|strip_tags|callback__gc_check');
		$this->form_validation->set_rules('transaction_payment_reward_card', 'Reward Card', 'trim|strip_tags|callback__rc_check');
		$this->form_validation->set_rules('transaction_payment_account', 'Account', 'trim|strip_tags|callback__ac_check');
		
		$this->form_validation->set_rules('transaction_credit_card_1', 'Credit Card 1', 'trim|strip_tags');
		$this->form_validation->set_rules('transaction_credit_card_2', 'Credit Card 2', 'trim|strip_tags');
		$this->form_validation->set_rules('transaction_debit_card', 'Debit Card', 'trim|strip_tags');
		$this->form_validation->set_rules('transaction_gift_check', 'Gift Check', 'trim|strip_tags');
		$this->form_validation->set_rules('transaction_reward_card', 'Reward Card', 'trim|strip_tags');
		$this->form_validation->set_rules('transaction_account', 'Account', 'trim|strip_tags');
		
		$this->form_validation->set_rules('total_change', 'Total Change', 'trim|strip_tags|max_length[10]|callback__check_total_change');
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		// get data
		$data['tickets'] = $this->tickets->get_tickets_by_session($customer_session_id);
		$data['price'] =  $this->prices->get($this->session->userdata('cpi'));
		$data['event'] = $this->events->get($this->session->userdata('cei'));

		if ($this->session->userdata('claim') == 'claim')
		{
			// get transaction detail
			$data['transaction'] = $this->transactions->get($this->session->userdata('tid'));

			// get customer detail
			$data['customer'] = $this->customers->get($data['transaction']->transaction_customer_id);
		}
		if ($this->form_validation->run() != FALSE)
		{
			// add customer to db
			$customer_id = $this->customers->quick_add();
			
			if ($this->session->userdata('claim') == 'claim')
			{
				// update the transaction
				$transaction_id = $this->session->userdata('tid');

				$this->transactions->update($transaction_id, $data['event']->event_reservation_fee, $customer_id);
			}
			else
			{
				// add transaction
				$transaction_id = $this->transactions->add($customer_id);
			}
			
			if ($transaction_id)
			{
				redirect('ektickets/done/'.$transaction_id);
			}
			else
			{
				$this->session->set_flashdata('message', assemble_message('Something went wrong with your transaction.  Please try again.'));
				redirect('ektickets/payment/');
			}
		}
		else
		{
			// display the page
			$this->load->view('ektickets_transactions_payment', $data);
		}
	}
	
	function done($transaction_id = false)
	{
		if (!$transaction_id)
		{
			show_404();
		}
		
		//restore session
		$restore_session =  $this->reservations->get_customer_id($transaction_id);
		$customer_session_id = $restore_session->customer_id;

		// unset the manager's override on Other Tender Types
		$this->session->unset_userdata('ott');
		
		// prepare data for the template
		$data['page_title'] = 'Transaction Done';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2', 'Seller', 'Manager'));

		// get data
		$data['tickets'] = $this->tickets->get_paid_tickets($transaction_id);
		$data['price'] =  $this->prices->get($this->session->userdata('cpi'));
		$ticket_types = $this->ticket_types->get_ticket_types($this->session->userdata('cei'));
		$data['transaction'] = $this->transactions->get($transaction_id);
		$data['payments'] = $this->payments->get_payments($transaction_id);
		$data['customer'] = $this->customers->get($data['transaction']->transaction_customer_id);

		$data['event'] = $this->events->get_by_transaction_id($transaction_id);
		
		// check if there are tickets to print
		if (count($data['tickets']) > 0)
		{
			// body onload
			// $data['onload'] =  'onLoad="window.location=\'smtickets:'.$_SERVER["HTTP_HOST"].'/uploads/'.md5($transaction_id).'\'"';
			$data['onload'] =  'onLoad="window.location=\'smtickets:'.$_SERVER["HTTP_HOST"].'/printout/dynamic/'.$this->session->userdata('cei').'/'.$transaction_id.'\'"';
						
			// display the page
			$this->load->view('ektickets_transactions_done', $data);
		}
		else
		{
			// redirect
			$this->session->set_flashdata('message', assemble_message('Something went wrong with your transaction.  Please try again.'));
			redirect('ektickets/listing');
		}
	}	
	

	function _validateTicketType($data) {
		if ($data == 'x')
		{
			$this->form_validation->set_message('_validateTicketType', 'Barcode or ticket type not available. Please contact system administrator.');
			return false;
		}
		else
		{
			return true;
		}
	}
}

