<?php

class EKBarcode extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('ekbarcode_model', 'ekbarcode');
		$this->load->model('events_model', 'events');
		$this->load->model('files_model', 'files');
		$this->load->model('logs_model', 'logs');
		$this->load->model('prices_model', 'prices');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->model('users_model', 'users');
		$this->load->database('default');
		// place authentication check here
		// check user session
		

	}
	
	function index()
	{
		// $this->load->view('welcome_message');
	}

	
	function listing() {
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		$data['page_title'] = 'EK Barcode Listing';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data["listing"] = $this->ekbarcode->listing();
		
		$this->load->view('ekbarcode_listing',$data);
	}

	function add_barcode($event_id = 0) {
	
		$data['page_title'] = 'Add EK Barcodes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		$valid = false;
		if ($event_id > 0) {
			$data["event_info"] = $this->events->get($event_id);

			if ($data["event_info"]->events_config_ekbarcode_active == 1) {
				$this->load->view('ekbarcode_add',$data);
				$valid = true;
			}
			
		} 
		if (! $valid) {
			redirect('ekbarcode/listing');
		}
	}

	function add_barcode_upload($event_id = 0) {
	
		$data['page_title'] = 'Add EK Barcodes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		$valid = false;
		if ($event_id > 0) {
			$config = array(
				array(
					'field'   => 'ticket_type',
					'label'   => 'Ticket Type',
					'rules'   => 'trim|required|strip_tags|max_length[10]'
				),
			);

			$this->form_validation->set_rules($config); 
			$this->form_validation->set_error_delimiters('<small class="error_field" style="margin-left:0%;">', '</small>');
			
			if ($this->form_validation->run() == FALSE) {

				$data["event_info"] = $this->events->get($event_id);

				if ($data["event_info"]->events_config_ekbarcode_active == 1) {
					$this->load->view('ekbarcode_add',$data);
					$valid = true;
				}
			} else {
				$this->upload($event_id);
				$valid = true;
			}
			
		} 
		if (! $valid) {
			redirect('ekbarcode/listing');
		}
	}

	function add_barcode_price($event_id = 0) {
	
		$data['page_title'] = 'Add EK Barcodes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		$valid = false;
		if ($event_id > 0) {
			$config = array(
				array(
					'field'   => 'price_id',
					'label'   => 'Event Price',
					'rules'   => 'trim|required|strip_tags|max_length[10]'
				),
			);

			$this->form_validation->set_rules($config); 
			$this->form_validation->set_error_delimiters('<small class="error_field" style="margin-left:0%;">', '</small>');
			
			if ($this->form_validation->run() == FALSE) {

				$data["event_info"] = $this->events->get($event_id);

				if ($data["event_info"]->events_config_ekbarcode_active == 1) {
					$this->load->view('ekbarcode_add_via_price',$data);
					$valid = true;
				}
			} else {
				$this->upload_via_price($event_id);
				$valid = true;
			}
			
		} 
		if (! $valid) {
			redirect('ekbarcode/listing');
		}
	}

	
	function upload($event_id = 0) {
		
		$data['page_title'] = 'Uploading EK Barcodes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$this->logs->add('CSV File Upload - EK Barcode');
		
		$data['event_id'] = $event_id;
		// $data['eventlongtitle_comp'] = $this->guestlist->compressed_eventname($eventid);

		$skipfirstline = $this->input->post('skipfirstline');
		$valid90days = $this->input->post('valid90days');
		$ticket_type = $this->input->post('ticket_type');
		
		if (is_numeric($valid90days)) {}
		else {$valid90days = 0;}
		
		// $upload_path = './uploads/csv/';
		$upload_path = $this->files->prepare_directory_by_name('csv');

		$success = false;
		if (!empty($upload_path) && ($event_id > 0)) {
			$config['upload_path'] = $upload_path;
			$config['allowed_types'] = "csv|";
			$datetime = date("YmHis");
			$config['file_name']	= "ek_$datetime-$event_id-tt$ticket_type-v$valid90days";

			$this->load->library('upload', $config);
			$this->upload->initialize($config);

			if ($this->upload->do_upload("ekfile"))
			{
				$upload_data = $this->upload->data();
				$success = true;
				// $this->load->view('upload_success', $data);
				
				$data["csvfile"] = $upload_data["full_path"];
				$data["skipfirstline"] = $skipfirstline;
				$data["valid90days"] = $valid90days;
				$data["ticket_type"] = $ticket_type;
				$data["event_info"] = $this->events->get($event_id);
				
				$this->load->view('ekbarcode_uploading',$data);
			}
		}
		
		if (!$success) {
			echo "Not successful. <PRE>";
			print_r($this->upload->data());
			print_r($_FILES);
			echo "</PRE>";
			$data['upload_error'] = $this->upload->display_errors();
		}
	}
	
	function upload_via_price($event_id = 0) {
		
		$data['page_title'] = 'Uploading EK Barcodes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$this->logs->add('CSV File Upload - EK Barcode');
		
		$data['event_id'] = $event_id;
		// $data['eventlongtitle_comp'] = $this->guestlist->compressed_eventname($eventid);

		$skipfirstline = $this->input->post('skipfirstline');
		$valid90days = $this->input->post('valid90days');
		$price_id = $this->input->post('price_id');
		
		if (is_numeric($valid90days)) {}
		else {$valid90days = 0;}
		
		// $upload_path = './uploads/csv/';
		$upload_path = $this->files->prepare_directory_by_name('csv');

		$success = false;
		if (!empty($upload_path) && ($event_id > 0)) {
			$config['upload_path'] = $upload_path;
			$config['allowed_types'] = "csv|";
			$datetime = date("YmHis");
			$config['file_name'] = "ek_$datetime-$event_id-pr$price_id-v$valid90days";

			$this->load->library('upload', $config);
			$this->upload->initialize($config);

			if ($this->upload->do_upload("ekfile"))
			{
				$upload_data = $this->upload->data();
				$success = true;
				// $this->load->view('upload_success', $data);
				
				$data["csvfile"] = $upload_data["full_path"];
				$data["skipfirstline"] = $skipfirstline;
				$data["valid90days"] = $valid90days;
				$data["price_id"] = $price_id;
				$data["event_info"] = $this->events->get($event_id);
				
				$this->load->view('ekbarcode_uploading_via_price',$data);
			}
		}
		
		if (!$success) {
			echo "Not successful. <PRE>";
			print_r($this->upload->data());
			print_r($_FILES);
			echo "</PRE>";
			$data['upload_error'] = $this->upload->display_errors();
		}
	}
	
	function barcodelist($event_id = 0, $show_all = 1, $view_usedbarcode = 0) {
		$data['page_title'] = 'EK List of Barcodes';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		$data["listing"] = $this->ekbarcode->barcodelist($event_id, $show_all, $view_usedbarcode);
		$data["events"] = $this->events->get($event_id);

		
		$this->load->view('ekbarcode_barcodelist',$data);
	}


	function activate($event_id = 0) {
		if ($event_id > 0) {
			$this->ekbarcode->set_eksale_listing_config($event_id,1);
		}
		redirect("ekbarcode/listing");
	}
	
	function deactivate($event_id = 0) {
		if ($event_id > 0) {
			$this->ekbarcode->set_eksale_listing_config($event_id,0);
		}
		redirect("ekbarcode/listing");
	}

}

