<?php

class Contacts extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('promoters_model', 'promoters');
		$this->load->model('contacts_model', 'contacts');
		$this->load->model('branches_model', 'branches');
		$this->load->model('venues_model', 'venues');
		$this->load->model('departments_model', 'departments');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('contacts/listing'); 
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing($type = false, $id = false)
	{
		if (!$type or !$id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Contacts';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// get all contacts
		$data['contacts'] = $this->contacts->get_contacts($type, $id);
		
		switch($type)
		{
			case 'promoters': 
				$promoter = $this->promoters->get($id); 
				$data['name'] = $promoter->promoter_name;
				break;
				
			case 'venues': 
				$venue = $this->venues->get($id);
				$data['name'] = $venue->venue_name;
				break;
				
			case 'branches': 
				$branch = $this->branches->get($id); 
				$data['name'] = $branch->branch_name;
				break;
		}
		
		// check users session
		$this->users->check_session(array('Event','Account','IT','Super Admin'));
		
		$this->load->view('contacts_listing', $data);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add($type = false, $id = false)
	{
		if (!$type or !$id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Add Contact';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Account'));
			
		$config = array(
			array(
				'field'   => 'contact_firstname',
				'label'   => 'First Name',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'contact_lastname',
				'label'   => 'Last Name',
				'rules'   => 'trim|required|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'contact_position',
				'label'   => 'Position',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'contact_phone',
				'label'   => 'Work Phone Number',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'contact_fax',
				'label'   => 'Fax Number',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'contact_mobile',
				'label'   => 'Mobile Number',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'contact_email',
				'label'   => 'Email Address',
				'rules'   => 'trim|valid_email|strip_tags|max_length[80]'
			),
		);
		$data['departments'] = $this->departments->get_departments_dropdown();
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('contacts_add', $data);
		}
		else
		{
			$this->contacts->add($type, $id);
			$this->session->set_flashdata('message', assemble_message('Contact has been successfully added'));
			
			// redirect
			switch($type)
			{
				case 'promoters': redirect('promoters/view/'.$id); break;
				case 'venues': redirect('venues/view/'.$id); break;
				case 'branches': redirect('branches/view/'.$id); break;
				//case 'branches': redirect('contacts/listing/branches/'.$id); break;
			}
		}
	}

	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 * @access	public
	 */
	function edit($contact_id = false, $type = false, $id = false)
	{
		if (!$contact_id or !$type or !$id)
		{
			show_404();
		}
		
		// prepare data for the template
		$data['page_title'] = 'Edit Contact';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Event','Account','IT','Super Admin'));
			
		$config = array(
			array(
				'field'   => 'contact_firstname',
				'label'   => 'First Name',
				'rules'   => 'trim|strip_tags|required|max_length[80]'
			),
			array(
				'field'   => 'contact_lastname',
				'label'   => 'Last Name',
				'rules'   => 'trim|strip_tags|required|max_length[80]'
			),
			array(
				'field'   => 'contact_position',
				'label'   => 'Position',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'contact_phone',
				'label'   => 'Work Phone Number',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'contact_fax',
				'label'   => 'Fax Number',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'contact_mobile',
				'label'   => 'Mobile Number',
				'rules'   => 'trim|strip_tags|max_length[80]'
			),
			array(
				'field'   => 'contact_email',
				'label'   => 'Email Address',
				'rules'   => 'trim|strip_tags|valid_email|max_length[80]'
			),
		);
		$data['departments'] = $this->departments->get_departments_dropdown();
				
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');
		
		if ($this->form_validation->run() == FALSE)
		{
			// get contact's data
			$data['contact'] = $this->contacts->get($contact_id);
			$data['id'] = $id;
			$data['type'] = $type;
			
			// display the page
			$this->load->view('contacts_edit', $data);
		}
		else
		{
			$this->contacts->edit($contact_id, $type, $id);
			$this->session->set_flashdata('message', assemble_message('Contact has been successfully modified'));
			
			// redirect
			switch($type)
			{
				case 'promoters': redirect('contacts/listing/promoters/'.$id); break;
				case 'venues': redirect('contacts/listing/venues/'.$id); break;
				case 'branches': redirect('contacts/listing/branches/'.$id); break;
			}		
		}
	}

	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($contact_id = FALSE, $type = false, $id = false)
	{	
		if (!$contact_id or !$type or !$id)
		{
			show_404();
		}
		
		// log this
		$this->logs->add('Delete Contact');
	
		// check users session
		$this->users->check_session(array('Event','Account','IT','Super Admin'));
		
		$this->contacts->delete($contact_id, $type, $id);
		$this->session->set_flashdata('message', assemble_message('Contact has been successfully deleted'));
		
		// redirect
		switch($type)
		{
			case 'promoters': redirect('contacts/listing/promoters/'.$id); break;
			case 'venues': redirect('contacts/listing/venues/'.$id); break;
			case 'branches': redirect('contacts/listing/branches/'.$id); break;
		}		
	}	

		
	
}

/* End of file contacts.php */
/* Location: ./application/controllers/contacts.php */	