<?php

class Banner extends CI_Controller
 {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('banner_model', 'banner');
		$this->load->model('files_model', 'files');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('banner/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		// prepare data for the template
		$data['page_title'] = 'Event Banner';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['banner'] = $this->banner->get_banner();
		
		$this->load->view('banner_listing', $data);
	}	
	
	function banner_active()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		// prepare data for the template
		$data['page_title'] = 'Event Banner';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['banner'] = $this->banner->get_banner_active();
		
		$this->load->view('banner_listing', $data);
	}
	
	function banner_inactive()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2','Finance'));
		
		// prepare data for the template
		$data['page_title'] = 'Event banner';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['banner'] = $this->banner->get_banner_inactive();
		
		$this->load->view('banner_listing', $data);
	}
	// --------------------------------------------------------------------
	
	/**
	 * upload
	 *
	 * @access	public
	 */
	function upload()
	{
		// prepare data for the template
		$data['page_title'] = 'Upload Banner';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'banner',
				'label'   => 'Banner',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'banner_row',
				'label'   => 'Banner Row',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'event_title',
				'label'   => 'Name of Banner',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
		);
		
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('banner_upload', $data);
		}
		else
		{
			list($filename, $image_path, $filewh, $filesize) = $this->files->upload_banner();
			$this->banner->upload($filename, $image_path, $filewh, $filesize);
			$this->session->set_flashdata('message', assemble_message('Event banner has been successfully added'));
			redirect('banner/banner_active');
		}
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($banner_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Banner');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->banner->delete($banner_id);
		$this->session->set_flashdata('message', assemble_message('Banner has been successfully deleted'));
		redirect('banner/listing/');
	}
	
	/**
	 * active
	 *
	 * @access	public
	 */
	function active($banner_id = FALSE)
	{
		// log this
		$this->logs->add('Banner Active');
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->banner->active($banner_id);
		$this->session->set_flashdata('message', assemble_message('Banner has been successfully activated'));
		redirect('banner/listing/');
	}
	
	/**
	 * inactive
	 *
	 * @access	public
	 */
	function inactive($banner_id = FALSE)
	{
		// log this
		$this->logs->add('Banner Inactive');
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->banner->inactive($banner_id);
		$this->session->set_flashdata('message', assemble_message('Banner has been successfully deactivated'));
		redirect('banner/listing/');
	}
	
}

/* End of file logos.php */
/* Location: ./application/controllers/logos.php */	
