<?php
class Admin extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('logs_model', 'logs');
		$this->load->model('admin_model', 'admin');
		$this->load->model('users_model', 'users');

		// cannot restrict to certain access group since printing is via 3rd party application
		$this->load->database('default');
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
	}
	
	function index()
	{
		// $this->load->view('welcome_message');
	}

    function mark_paid_done($trans_id = 0)
    {
		if ($trans_id > 0) {
			// mark the transaction and tickets as Done
			$this->admin->mark_paid_transaction_done($trans_id);
			$this->logs->add('Marked Done ' . $trans_id);
			
			$message = 'Marked Paid Transaction ID #' . $trans_id . ' as Done. Please review status of your transaction.';
			$this->session->set_flashdata('message', assemble_message($message));
			
		}
		
		$referrer = (isset($_SERVER["HTTP_REFERER"])) ? $_SERVER["HTTP_REFERER"] : '';
		
		if (empty($referrer)) { 
			redirect('');
		}
		else {
			redirect($referrer);
		}
	}


	function ResetPrintWithStatus($status_from = "paid_online" , $trans_id = 0) {
		$this->logs->add('Reset Print Online Ticket ' . $trans_id);
		$status_allowed = array("paid_online","done");
		if (($trans_id > 0) && (in_array($status_from, $status_allowed))) {
			// continue
		} else {
			die("Cannot process your request. Invalid access.");
		}
		
		$status_to = 'paid_online';

		$sql_1 = "
			UPDATE sm_barcode smb
				SET smb.sm_transaction_id = (1000000000 + $trans_id)
				WHERE smb.sm_transaction_id = $trans_id ;
		";
		$sql_2 = "
			UPDATE transactions t
				SET t.transaction_status = '$status_to'
				WHERE t.transaction_id = $trans_id
					AND t.transaction_user_id = 1
					AND t.transaction_branch_id = 90
					AND t.transaction_status = '$status_from'
			;
		";
		$sql_3 = "
			UPDATE tickets tix
				SET tix.ticket_status = '$status_to'
					, tix.ticket_branch_id = 90
					, tix.ticket_user_id = 1
					, tix.ticket_terminal_id = 1
				WHERE tix.ticket_transaction_id = $trans_id
					AND tix.ticket_status = '$status_from'
			;
		";
		
		echo "Processing Request.";
		$boolResetSuccess = $this->db->simple_query($sql_1);
		if ($boolResetSuccess) {
			echo ".";
			$boolResetSuccess &= $this->db->simple_query($sql_2);
		}
		if ($boolResetSuccess) {
			echo ".";
			$boolResetSuccess &= $this->db->simple_query($sql_3);
		}
		echo "<BR>";
		if ($boolResetSuccess) {
			echo "Application of reset to reprint trans ID # $trans_id should be successful. Please check transaction details to verify. ";
		} else {
			echo "Reset was not fully successful. You can double-check transaction details to verify. Please inform MGI. <BR>";
		}

		
	}

	function GenerateBarcode($event_id = 0) {
		$this->load->helper('html');
		$this->db->select("smb.sm_trigger");
		$this->db->where("sm_event_id = '680'");
		$query = $this->db->get("sm_barcode smb");

		$event_id = 693;

		$sql = "
SELECT date(tix.ticket_date_entered) as dt, (hour(tix.ticket_date_entered)%2) hs, smb.sm_transaction_id, smb.sm_trigger, smb.sm_ticket_id, tix.ticket_type_id, tix.ticket_status, smb.sm_deactivated, tix.ticket_event_id
FROM sm_barcode smb
	left join tickets tix
		on tix.ticket_id = smb.sm_ticket_id
	where smb.sm_event_id IN ($event_id)
		and smb.sm_trigger IS NOT NULL

group by dt, hs , smb.sm_deactivated, tix.ticket_status, tix.ticket_type_id
order by smb.sm_transaction_id desc
";
$query = $this->db->query($sql);
		echo "<table cellspacing=5 cellpadding=5 border=0 width=100%>";
		$i = 0;
		$c = 0;
		foreach ($query->result() as $row) {
			$c++;
			if ($i == 2) {
				$i = 0;
			}

			if ($i == 0) {
			echo "<tr>";
			}
			if ($i < 2) {
			echo "<th>";
			echo $c;
			echo "</th>";
			echo "<td>";
			echo img("resources/phpqrcode/on-the-fly.php?data=" . $row->sm_trigger);
			echo img("resources/barcode/ek_barcode.php?text=" . $row->sm_trigger);
			echo "</td>";
			echo "<td>";
			echo $row->sm_ticket_id;
			echo "/";
			echo $row->ticket_status;
			echo "/sc2=";
			echo $row->ticket_type_id;
			echo "/dc-";
			echo $row->sm_deactivated;
			echo "/e-";
			echo $row->ticket_event_id;
			echo "</td>";
			}
			if ($i == 1) {
			echo "</tr>";
			}
			// echo "<BR>";

			$i++;
		}
		echo "</table>";
		
	}

			function paidonlinevoucher($type = false, $transaction_id = false)
	{
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('events_model', 'events');
		$this->load->model('prices_model', 'prices');
		$this->load->model('payments_model', 'payments');
		$this->load->model('ticket_layouts_model', 'ticket_layouts');
		$this->load->model('extension_model', 'extension');

		// check the customer session
		//$this->sessions->session_check(array('tid'));
		// if (!$type) show_404();
		// if (!$transaction_id) show_404();
		if (!$type) { die("error type") ; }
		if (!$transaction_id) { die("error t") ; }
		
		$voucher_type = ($type == 'all') ? 'all' : 'one';
		// $transaction_id = ($transaction_id) ? $transaction_id : $this->session->userdata('tid');

		
  	    // check ownership
		// $this->transactions->check_access($transaction_id);
		// instead of ownership, check if valid ip since this must come from admin
		
		$data['voucher_type'] = $voucher_type;
		$data['transaction'] = $this->transactions->get($transaction_id);
		$data['tickets'] = $this->tickets->get_paid_online_tickets($transaction_id);

		$data['ticket_terms'] = $file = file_get_contents(base_url() . '/resources/terms/ticket_terms.txt', true);
		
		if (count($data['tickets']) > 0)
		{
			$data['price'] = $this->prices->get($data['tickets'][0]->ticket_price_id);
			$data['event'] = $this->events->get($data['tickets'][0]->ticket_event_id);
			$payments = $this->payments->get_payments($transaction_id);

			$data['payment_type'] = (count($payments) > 0) ? $payments[0]->payment_type_name : 'Unknown Payment Type';
			
			$total_payment = 0;
			foreach($payments as $payment)
				$total_payment += $payment->payment_amount;
				
			$data['total_amount'] = $total_payment;
			$data['ticket_layout'] = $this->ticket_layouts->get($data['tickets'][0]->ticket_event_id);
			$data['bcode'] = $this->extension->get_transaction_bcode($transaction_id);
			
			// display the page
			$this->load->view('transaction_tickets', $data);
		}
		else
		{
			echo 'Ticket not found';
		}
	}

function GetBarcode($transID = false){
	
		$this->db->select('transaction_barcode');
		$this->db->where('transaction_id', $transID);
		$result = $this->db->get('transactions')->row();
		
		if($result){
		echo 'Barcode: ' . $result->transaction_barcode;
		
		}else{
		
		echo 'Not Paid Online. Please check transactionstatus';
		}
	
	
	}



}
?>
