<?php

class Ad2 extends CI_Controller
 {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('users_model', 'users');
		$this->load->model('branches_model', 'branches');
		$this->load->model('terminals_model', 'terminals');
		$this->load->model('poster_model', 'poster');
		$this->load->model('ad_model2', 'ad');
		$this->load->model('files_model', 'files');
		$this->load->model('logs_model', 'logs');
		$this->load->database('default');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * index
	 *
	 * @access	public
	 */
	function index()
	{
		redirect('ad/listing');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * listing
	 *
	 * @access	public
	 */
	function listing()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// prepare data for the template
		$data['page_title'] = 'Event Ad';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['ad'] = $this->ad->get_ad();
		
		$this->load->view('ad_listing2', $data);
	}
	
	function ad_active()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// prepare data for the template
		$data['page_title'] = 'Event Ad';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['ad'] = $this->ad->get_ad_active();
		
		$this->load->view('ad_listing2', $data);
	}
	
	function ad_inactive()
	{
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		// prepare data for the template
		$data['page_title'] = 'Ad';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		$data['ad'] = $this->ad->get_ad_inactive();
		
		$this->load->view('ad_listing2', $data);
	}
	// --------------------------------------------------------------------
	
	/**
	 * upload
	 *
	 * @access	public
	 */
	function upload()
	{
		// prepare data for the template
		$data['page_title'] = 'Upload Ad';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		// $this->users->check_session(array('Admin','Super Admin','Admin2'));
			
		$config = array(
			array(
				'field'   => 'ad',
				'label'   => 'Ad',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'ad_type',
				'label'   => 'Ad Type',
				'rules'   => 'trim|required|strip_tags|min_length[1]|max_length[20]'
			),
			array(
				'field'   => 'ad_title',
				'label'   => 'Name of Ad',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'ad_link',
				'label'   => 'Hyperlink',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),

		);
				
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('ad_upload2', $data);
		}
		else
		{
			list($filename, $image_path, $filewh, $filesize) = $this->files->upload_ad();

			
			if($filename){
			//Write image info into DB
			$this->ad->upload($filename, $image_path, $filewh, $filesize);
			$result_message = "Ad uploaded successfully";
			$this->session->set_flashdata('message', assemble_message($result_message));
			redirect('ad2/ad_active');
			
			}else{

			echo $this->upload->display_errors();
			$result_message = "Unable to upload image. Please contact your system administrator.";
			$this->session->set_flashdata('message', assemble_message($result_message));
			redirect('ad2/upload');
			}
			
			


		}
	}
	
	function edit($ad_id)
	{
		// prepare data for the template
		$data['page_title'] = 'Edit Ad';
		$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
		
		// log this
		$this->logs->add($data['page_title']);
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		$data['ad'] = $this->ad->view_ad($ad_id);	
		$config = array(
			array(
				'field'   => 'ad',
				'label'   => 'Ad',
				'rules'   => 'trim|strip_tags'
			),
			array(
				'field'   => 'ad_type',
				'label'   => 'Ad Type',
				'rules'   => 'trim|required|strip_tags|min_length[1]|max_length[10]'
			),
			array(
				'field'   => 'ad_title',
				'label'   => 'Name of Ad',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
			array(
				'field'   => 'ad_link',
				'label'   => 'Hyperlink',
				'rules'   => 'trim|required|strip_tags|max_length[255]'
			),
		);
				
		$this->form_validation->set_rules($config); 
		
		$this->form_validation->set_error_delimiters('<small class="error_field">', '</small>');

		if ($this->form_validation->run() == FALSE)
		{
			// display the page
			$this->load->view('ad_edit2', $data);
		}
		else
		{
			list($filename, $image_path, $filewh, $filesize) = $this->files->upload_ad();

			
			if($filename){
			//Write image info into DB
			
			$result_message = "Ad has been successfully modified";
			}else{
				$filename = "";
				$image_path = "";
				$filewh = "";
				$filesize ="";
				$result_message = "Ad has been successfully modified";
			}
			$this->ad->edit($filename, $image_path, $filewh, $filesize,$ad_id);
			$this->session->set_flashdata('message', assemble_message($result_message));
			redirect('ad/ad_active');


		}
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 * @access	public
	 */
	function delete($ad_id = FALSE)
	{	
		// log this
		$this->logs->add('Delete Ad');
		
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->ad->delete($ad_id);
		$this->session->set_flashdata('message', assemble_message('Ad has been successfully deleted'));
		redirect('ad/listing/');
	}	
	
	function active($ad_id = FALSE)
	{
		// log this
		$this->logs->add('Ad Active');
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->ad->active($ad_id);
		$this->session->set_flashdata('message', assemble_message('Ad has been successfully activated'));
		redirect('ad/listing/');
	}
	
	/**
	 * inactive
	 *
	 * @access	public
	 */
	function inactive($ad_id = FALSE)
	{
		// log this
		$this->logs->add('Ad Inactive');
			
		// check user session
		$this->users->check_session(array('Admin','Super Admin','Admin2'));
		
		$this->ad->inactive($ad_id);
		$this->session->set_flashdata('message', assemble_message('Ad has been successfully deactivated'));
		redirect('ad/listing/');
	}
	
}

/* End of file logos.php */
/* Location: ./application/controllers/logos.php */	

