	<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Video_model extends CI_Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $branches = 'branches o';
	var $poster = 'poster pr';
	var $ad = 'ads';
	var $video = 'videos';
		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_logos
	 *
	 * @access	public
	 */
	function get_video_active()
	{
		$this->db->where('video_active','yes');
		$this->db->join('events', 'events.event_id = videos.video_event_id');
		$query = $this->db->get($this->video);
		
		return $query->result();
	}
		
	function get_video_inactive()
	{
		$this->db->where('video_active','no');
		$this->db->join('events', 'events.event_id = videos.video_event_id');
		$query = $this->db->get($this->video);
		return $query->result();
	}
	
	
	function get_video($event_id = false){
	
		if($event_id){
		$this->db->where('event_id', $event_id);
		}
		
		$this->db->join('events', 'events.event_id = videos.video_event_id');
		$query = $this->db->get($this->video);
		
		return $query->result();
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * get_logos_dropdown
	 *
	 * @access	public
	 */
	
	/* function get_ad_dropdown()
	{
		$query = $this->db->get($this->ad);
			
		$result = $query->result();

		if ($result)
		{
			// transform result into an associative array
			$array[0] = 'None';
			foreach($result as $r)
			{
				$array[$r->ad_id] = $r->event_title;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	} */
	
	// --------------------------------------------------------------------
	
	/**
	 * upload
	 *
	 */
	function embed($video_name = false, $event_id = false, $video_url = false, $video_thumbnail = false, $video_active = false)
	{
	
	if(!$video_name){
		$video_name = $this->input->post('video_name');
		$event_id = $this->input->post('event_id');
		$video_url = $this->input->post('video_url');
		$video_thumbnail = $this->input->post('video_thumbnail');

		}
		else{		
				// add video to db
				$fields = array(
					'video_name'		=> $video_name,
					'video_event_id'	=> $event_id,
					'video_url'			=> $video_url,
					'video_image'		=> $video_thumbnail,
				);
		
		}	
		// insert to db
		$this->db->set($fields);
		$this->db->insert('videos');
		
		return $this->db->insert_id();

		return true;
	}	
	
	// --------------------------------------------------------------------
	
		/**
	 *
	 */
	function update($video_id = false, $video_name = false, $event_id = false, $video_url = false, $video_thumbnail = false, $video_active = false)
	{				
		// add video to db
		$fields = array(
			'video_name'		=> $video_name,
			'video_event_id'	=> $event_id,
			'video_url'			=> $video_url, 
			);
		
		// insert to db
		$this->db->where('video_id', $video_id);
		$this->db->update($this->video,$fields);
		
		return true;
	}	
	

	function batch_update($update_array){
	$this->db->update_batch($this->video, $update_array, 'video_id');
	}	
	
	function batch_insert($insert_array){
	$this->db->insert_batch($this->video, $insert_array);
	}
	
	/**
	 * delete
	 *
	 */
	function delete($video_id)
	{

      	$this->db->where('video_id', $video_id);
		$this->db->delete($this->video, array('video_id' => $video_id));
		return true;
	}	
	
	/**
	 * recommend
	 *
	 */
	function active($video_id)
	{
		$this->db->where('video_id', $video_id);
		$this->db->update($this->video, array('video_active'=>'yes') );
		
		return true;
	}
	
	/**
	 * recommend
	 *
	 */
	function inactive($video_id)
	{
		$this->db->where('video_id', $video_id);
		$this->db->update($this->video, array('video_active'=>'no') );
		
		return true;
	}
	
	function check_existing_video_name($video_name){
		$query = $this->db->where('video_name',$video_name);
		$query = $this->db->get($this->video);
		
		if($query->num_rows() > 0){
		return true;
		}
		else{
		return false;
		}
	}
	





}

// END logos_model.php
/* Location: ./application/models/logos_model.php */	

