<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Users_model extends CI_Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $branches = 'branches o';
		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
		$this->max_idle_time = 60*5; // 30 minutes idle time
		// $this->load->database('default');
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_user
	 *
	 * @access	public
	 */
	function get($user_id)
	{
		$this->db->where('user_id', $user_id);
		$this->db->join($this->branches, 'o.branch_id = u.user_branch_id', 'left');
		$query = $this->db->get($this->users);
	
		return $query->row();		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_users
	 *
	 * @access	public
	 */
	function get_users($offset = false, $limit = false, $searchkey=array())
	{
		$this->db->order_by('user_firstname');
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);

		if (! empty($searchkey) )
		{
			foreach ($searchkey as $skey=>$sval)
			{
				if (!empty($skey) && !empty($sval))
				switch ($skey)
				{
					case 'usertype':
						$this->db->like('user_type', $sval);						
						break;
					case 'username':
						$this->db->like('username', $sval);						
						break;
					case 'branch':
						$this->db->join($this->branches, 'user_branch_id=branch_id', 'left');
						$this->db->like('branch_name', $sval);
						break;					
					case 'terminal':
						$this->db->join('terminals', 'user_terminal_id=terminal_id', 'left');
						$this->db->like('CONCAT(terminal_code,terminal_name,terminal_location)', $sval);						
						break;					
					case 'name':
						$this->db->like('CONCAT(username,user_firstname,user_lastname)', $sval);						
						break;
				}				
			}
		}
		
		$query = $this->db->get($this->users);
		return $query->result();
	}
	
	function get_inactive_users($offset = false, $limit = false, $searchkey=array())
	{
		/* $q_limit = '';
		$q_offset = '';
		if($limit){
			$q_limit = " LIMIT $limit";
		}
		if($offset){
			$q_offset = " OFFSET $offset";
		} */
		
		// $query = $this->db->query("SELECT `user_id`, `user_firstname`, `user_lastname`, `username`, `user_type`, `user_email`, `user_last_login`, DATEDIFF(CURDATE(), `user_last_login`) AS days FROM (`users` u) where DATEDIFF(CURDATE(), `user_last_login`) > 30  ORDER BY `user_firstname`".$q_limit.$q_offset."");
		
		
		
		
		
		$this->db->order_by('user_firstname');
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		
		
		
		if (! empty($searchkey) )
		{
			foreach ($searchkey as $skey=>$sval)
			{
				if (!empty($skey) && !empty($sval))
				switch ($skey)
				{
					case 'usertype':
						$this->db->like('user_type', $sval);						
						break;
					case 'branch':
						$this->db->join($this->branches, 'user_branch_id=branch_id', 'left');
						$this->db->like('branch_name', $sval);
						break;					
					case 'terminal':
						$this->db->join('terminals', 'user_terminal_id=terminal_id', 'left');
						$this->db->like('CONCAT(terminal_code,terminal_name,terminal_location)', $sval);						
						break;					
					case 'name':
						$this->db->like('CONCAT(username,user_firstname,user_lastname)', $sval);						
						break;
				}				
			}
		}
		$this->db->where("DATEDIFF(CURDATE(), `user_last_login`) > 30");
		// if($searchkey){
		$query = $this->db->get($this->users);
		// }
		// echo $this->db->last_query();
		// die();
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * login
	 *
	 * @access	public
	 *
	 */
	function login()
	{			
		$this->db->where('username', $this->input->post('username')); 
		$this->db->where('password', $this->prep_password($this->input->post('password'))); 
		$this->db->where('user_active !=', 10); 
		$this->db->where_in('user_type', array('Super Admin', 'Admin', 'Admin2', 'Seller','Account','Event', 'Manager', 'Finance','Reservation-Admin','Reservation','Treasury','IT'));

		$query = $this->db->get($this->users);
		
		if ($query->num_rows() > 0) 
		{
			$user = $query->row();						
			$this->update_last_login($user->user_id);
			return $user;
		}
		else
		{
			return false;
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * manager login
	 *
	 * @access	public
	 *
	 */
	function manager_login($username=false, $password=false)
	{
		$username = $username ? $username : $this->input->post('username');
		$password = $password ? $password : $this->input->post('password');
		
		$this->db->where('username', $username ); 
		$this->db->where('password', $this->prep_password($password)); 
		$this->db->where('user_active !=', 10);
		$this->db->where_in('user_type', array('Manager', 'Admin','Super Admin','Admin2')); 
		
		$query = $this->db->get($this->users);
	
		if ($query->num_rows() > 0) 
		{
			$user = $query->row();
			return $user;
		}
		else
		{
			return false;
		}
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * update_last_login
	 *
	 * @access	public
	 *
	 */
	function update_last_login($user_id)
	{
		// update db
		$this->db->where('user_id', $user_id);
		$this->db->update($this->users, array('user_last_login' => date("Y-m-d H:i:s")));
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * check_session
	 *
	 * @access	public
	 */
	function check_session($user_type = false)
	{
		// check for terminal id
		/*if (!$this->session->userdata('tid'))
		{
			redirect('users/users_session');
		}*/
		// echo '<pre>';
		// print_r($this->session->userdata); 
		// echo '</pre>';
		
		// die();
		
		$this->check_user_session();		
		// die('test');
		if ($this->session->userdata('logged_in')) 
		{
			
			/* 
			$delta = strtotime('now') - $this->session->userdata['last_activity'];
			// echo strtotime('now');
			// die();
			if ($delta > $this->max_idle_time)
			{
				// the user is logged out, or session expired
				redirect('users/session_expired');
				exit();
			}
			
			
			
			 */
			
			/*$CI =& get_instance(); 
			$CI->load->model('usersessions_model','usersess');		
			if ( $CI->usersess->is_active( $this->session->userdata('user_id') ) )
			{			
			  $CI->usersess->update( $this->session->userdata('user_id') );
			}
			else
			{
				redirect('users/logout');
			}*/

			$hash = $this->prep_password($this->session->userdata('user_id') . $this->session->userdata('username') .  $this->session->userdata('user_type'));
			
			if ($hash == $this->session->userdata('hash'))
			{
				if ($user_type)
				{
					$user = $this->get($this->session->userdata('user_id'));
					
					if (is_array($user_type))
					{
						// check user type (array)
					 
						if (in_array($user->user_type, $user_type)) 
						{
							return true;
						}
						else 
						{
							$this->session->set_flashdata('message', assemble_message('You are not allowed to access that page'));
							redirect('');
						}
					}
					else
					{
						// check levels (variable)
						if ($user->user_type == $user_type)
						{ 
							return true;
						}
						else 
						{
							$this->session->set_flashdata('message', assemble_message('You are not allowed to access that page'));
							redirect('');
						}
					}
				}
				else
				{
					return true;
				}
			}
			else
			{
				redirect('users/login');
			}
		} 
		else 
		{
			redirect('users/login');
		}
	}
	
	
	
	// --------------------------------------------------------------------
	
	/**
	 * is_username_exist
	 *
	 * @access	public
	 */
	function is_username_exist($username = FALSE)
	{
		// check if username exists
		$this->db->where('lower(username)', strtolower($username));
		$query = $this->db->get($this->users);
		
		return ($query->num_rows() > 0) ? true : false;
	}
	
		// --------------------------------------------------------------------
	
	/**
	 * is_username_exist
	 *
	 * @access	public
	 */
	function is_email_exist($email = FALSE)
	{
		// check if username exists
		$this->db->where('user_email', $email);
		$query = $this->db->get($this->users);
		
		return ($query->num_rows() > 0) ? true : false;
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * is_password_exist
	 *
	 * @access	public
	 */
	function is_password_exist($password = FALSE)
	{
		// check if password exists
		$this->db->where('lower(password)', strtolower($this->prep_password($password)));
		$query = $this->db->get($this->users);
		
		return ($query->num_rows() > 0) ? true : false;
	}	
	// --------------------------------------------------------------------
	
	/**
	 * is_newpassword_exist
	 *
	 * @access	public
	 */
	function is_newpassword_exist($newpassword = FALSE)
	{
		// check if password exists
		$this->db->where('lower(password)', strtolower($this->prep_password($password)));
		$query = $this->db->get($this->users);
		
		return ($query->num_rows() > 0) ? true : false;
	}	
	// --------------------------------------------------------------------
	
	/**
	 * prep_password
	 *
	 * @access	public
	 */
	function prep_password($password)
	{
		return sha1($this->config->item('encryption_key').$password);
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add()
	{
		$fields = array(
			'user_date_created'		=> date("Y-m-d H:i:s"),
			'username'				=> $this->input->post('username'),
			'password'				=> $this->prep_password($this->input->post('password')),
			'user_email'			=> $this->input->post('email'),
			'user_firstname'		=> $this->input->post('firstname'),
			'user_lastname'			=> $this->input->post('lastname'),
			'user_type'				=> $this->input->post('user_type'),	
			'user_branch_id'		=> $this->input->post('branch_id'),
			'user_terminal_id'		=> $this->input->post('terminal_id'),
			'user_change_password'	=> 1,		
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('users');
		
		return true;
	}
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add_session()
	{
		$fields = array(
			'session_user_id'			=> $this->session->userdata('user_id'),
			'session_branch_id'			=> $this->input->post('branch_id'),	
			'session_type'				=> 'Login',
			'session_date_time'			=> date("Y-m-d H:i:s"),
			'session_loose_change'		=> $this->input->post('session_loose_change'),
			'session_beginning_serial'	=> $this->input->post('session_beginning_serial'),
			'session_ending_serial'		=> $this->input->post('session_ending_serial'),	
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('sessions');
		
		// get session id
		$session_id = $this->db->insert_id();
		return   $this->db->insert_id();
	}	
	// --------------------------------------------------------------------
	
	/**
	 * log_out session
	 *
	 */
	function session_logout()
	{
		$fields = array(
			'session_user_id'			=> $this->session->userdata('user_id'),
			'session_branch_id'			=> $this->input->post('branch_id'),	
			'session_type'				=> 'Logout',
			'session_date_time'			=> date("Y-m-d H:i:s"),
			'session_ending_serial'		=> $this->input->post('session_ending_serial'),				
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('sessions');
		
		return true;
	}	
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($user_id)
	{
		$fields = array(
			'user_email'		=> $this->input->post('email'),
			'user_firstname'	=> $this->input->post('firstname'),
			'user_lastname'		=> $this->input->post('lastname'),
			'user_type'			=> $this->input->post('user_type'),
			'user_branch_id'	=> $this->input->post('branch_id'),	
			'user_terminal_id'	=> $this->input->post('terminal_id'),					
			'user_notes'	=> $this->input->post('notes'),					
			'user_active'	=> $this->input->post('user_active'),				
			'user_finance_type'	=> $this->input->post('finance_type'),				
		);
		
		// optional fields
		if ($this->input->post('password'))
		{
			$fields['password'] = $this->prep_password($this->input->post('password'));
		}
		
		// update db
		$this->db->where('user_id', $user_id);
		$this->db->update($this->users, $fields);
		
		return true;
	}
	// --------------------------------------------------------------------
	
	/**
	 * change password
	 *
	 */
	function change_password($user_id)
	{
		$fields = array(
			'password'				=> $this->prep_password($this->input->post('new_password')),
			'user_change_password'	=> 0,
		);
	
		// update db
		$this->db->where('user_id', $user_id);
		$this->db->update($this->users, $fields);
		
		return true;
	}	
	// --------------------------------------------------------------------
	
	/**
	 * reset password by username
	 *
	 */
	function reset_password_by_username($username, $new_password=false)
	{
		$new_password = $new_password ? $new_password : $this->input->post('new_password');
		
		$fields = array(
			'password'				=> $this->prep_password($new_password),
			'user_change_password'	=> 1,
		);
	
		// update db
		$this->db->where('username', $username);
		$this->db->update($this->users, $fields);
		
		$affected = $this->db->affected_rows();
		
		return !!$affected;
	}	
	// --------------------------------------------------------------------
	
	
	
	
	/**
	 * delete
	 *
	 */
	function delete($user_id)
	{
		$this->db->delete('users', array('user_id' => $user_id));
		
		return true;
	}
	
	function inactive_users($date){
		$this->db->select('user_id');
		$this->db->where('last_activity <', $date);
		$query = $this->db->get('user_sessions'); 
		
		// echo $this->db->last_query();
		// die();
		return $query->result();
	}
	
	function deactivate_users($date){
		$this->db->where('user_last_login <', $date);
		$this->db->update($this->users, array('user_active' => 1));
	}

	function check_user_session(){
		
		$this->db->where('username',  $this->session->userdata('username'));  
		$this->db->join('user_sessions us', 'us.user_id = u.user_id', 'left');
		// $this->db->where('user_active !=', 10);  
		$query = $this->db->get('users u');
		$x = $query->row();
		
		
		if ($query->num_rows() > 0 && $x->ip_address == get_ip_address()) 
		{
			// echo $x->ip_address . ' ' . $this->input->ip_address();
			 return true;
			 
		}
		else
		{
			// echo 'test';
			// die();
			redirect('users/logout');
			exit();
		} 
			
	} 
	
	function check_finance_type($user_id){
		$this->db->where('user_id', $user_id);
		$query = $this->db->get($this->users);
		return $query->row('user_finance_type');
	}
	
	
}

// END users_model.php
/* Location: ./application/models/users_model.php */