<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class tourgroup_model extends CI_Model
{

	// var $etitr = 'etitr tr';
	// var $etitr_details = 'etitr_details ed';
	// var $etitr_prim = 'etitr_prim ep';
	var $tickets = 'tickets ti';
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('sections_model', 'sections_model');
		$this->load->model('payment_types_model', 'payment_types_model');
		// $this->load->model('tickets_model', 'tickets_model');
	}
	
	function get_tourgroup($offset = false, $limit = false)
	{
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$this->db->join('tourgroup_operator', 'tourgroup_operator.tourgroup_operator_id = tourgroup.tourgroup_operator_id', 'left');
		$this->db->join('users', 'users.user_id = tourgroup.tourgroup_user_id', 'left');
		// $this->db->join('tourgroup_events', 'tourgroup_events.tourgroup_events_id = tourgroup.tourgroup_event_id', 'left');
		$this->db->join('events', 'events.event_id = tourgroup.tourgroup_event_id', 'left');
		$query = $this->db->get('tourgroup');
		return $query->result();
	}
	function get_tourgroup_row()
	{
		$this->db->join('tourgroup_operator', 'tourgroup_operator.tourgroup_operator_id = tourgroup.tourgroup_operator_id', 'left');
		$this->db->join('users', 'users.user_id = tourgroup.tourgroup_user_id', 'left');
		// $this->db->join('tourgroup_events', 'tourgroup_events.tourgroup_events_id = tourgroup.tourgroup_event_id', 'left');
		$this->db->join('events', 'events.event_id = tourgroup.tourgroup_event_id', 'left');
		$query = $this->db->get('tourgroup');
		return $query->num_rows();
	}
	function tourgroup_view($key)
	{
		$this->db->where('tourgroup_id', $key);
		$this->db->join('tourgroup_operator', 'tourgroup_operator.tourgroup_operator_id = tourgroup.tourgroup_operator_id', 'left');
		$this->db->join('users', 'users.user_id = tourgroup.tourgroup_user_id', 'left');
		$this->db->join('events', 'events.event_id = tourgroup.tourgroup_event_id', 'left');
		$this->db->join('venues', 'venues.venue_id = events.event_venue_id', 'left');
		// $this->db->join('tourgroup_events', 'tourgroup_events.tourgroup_events_id = tourgroup.tourgroup_event_id', 'left');
		$this->db->join('tourgroup_payment', 'tourgroup_payment.tourgroup_payment_tourgroup_id = tourgroup.tourgroup_id', 'left');
		$query = $this->db->get('tourgroup');
		return $query->row();
	}
	function tourgroup_view2($key)
	{
		$this->db->where('tourgroup_id', $key);
		$this->db->join('tourgroup_operator', 'tourgroup_operator.tourgroup_operator_id = tourgroup.tourgroup_operator_id', 'left');
		$this->db->join('users', 'users.user_id = tourgroup.tourgroup_user_id', 'left');
		// $this->db->join('tourgroup_events', 'tourgroup_events.tourgroup_events_id = tourgroup.tourgroup_event_id', 'left');
		$this->db->join('tourgroup_payment', 'tourgroup_payment.tourgroup_payment_tourgroup_id = tourgroup.tourgroup_id', 'left');
		$query = $this->db->get('tourgroup');
		return $query->result();
	}
	function ticket_details($key)
	{
		$this->db->where('tourgroup_id', $key);
		$this->db->join('prices', 'prices.price_id = tourgroup.tourgroup_price_id', 'left');
		$this->db->join('sections', 'sections.section_id = tourgroup.tourgroup_section_id', 'left');
		$this->db->join('ticket_types', 'ticket_types.ticket_type_id = tourgroup.tourgroup_ticket_type_id', 'left');
		$query = $this->db->get('tourgroup');
		return $query->row();
	}
	function get_tourgroup_event($offset = false, $limit = false)
	{
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$this->db->where('events_config_tourgroup_active', '1');
		$this->db->join('events', 'events.event_id = events_config.events_config_eventid', 'left');
		$this->db->join('venues', 'venues.venue_id = events.event_venue_id', 'left');
		$query = $this->db->get('events_config');
		return $query->result();
	}
	function get_tourgroup_event_row()
	{
		$this->db->where('events_config_tourgroup_active', '1');
		$this->db->join('events', 'events.event_id = events_config.events_config_eventid', 'left');
		$this->db->join('venues', 'venues.venue_id = events.event_venue_id', 'left');
		$query = $this->db->get('events_config');
		return $query->num_rows();
	}
	function get_operator()
	{
		$this->db->order_by("tourgroup_operator_id");
		$query = $this->db->get("tourgroup_operator");
			
		$result = $query->result();
		$array[0] = "";
		if ($result)
		{
			foreach($result as $r)
			{
				$array[$r->tourgroup_operator_id] = $r->tourgroup_operator_firstname." ".$r->tourgroup_operator_lastname;
			}
		}
		$last = $query->num_rows() + 1;
		$array[$last] = "--Add Operator--";
		return $array;
	}
	function get_event($key)
	{
		// $this->db->where('tourgroup_events_id', $key);
		// $query = $this->db->get("tourgroup_events");
		
		$this->db->where('events_config_eventid', $key);
		$this->db->join('events', 'events.event_id = events_config.events_config_eventid', 'left');
		$this->db->join('venues', 'venues.venue_id = events.event_venue_id', 'left');
		$query = $this->db->get("events_config");

		return $query->row();
	}
	function add_reserve()
	{
		$date_time = date("Y-m-d h:i:s",strtotime($this->input->post('book_datetime')));
		$fields = array(
			'tourgroup_event_id'			=> $this->input->post('event_id'),
			'tourgroup_operator_id'			=> $this->input->post('operator_name'),
			'tourgroup_description'			=> $this->input->post('event_desc'),
			'tourgroup_datetime'			=> $date_time,
			'tourgroup_num_persons'			=> $this->input->post('person_num'),
			'tourgroup_amount_fee'			=> $this->input->post('amount_fee'),
			'tourgroup_reserve_fee'			=> $this->input->post('reserve_fee'),
			'tourgroup_down_fee'			=> $this->input->post('down_fee'),
			'tourgroup_user_id'				=> $this->session->userdata('user_id'),
			'tourgroup_remarks'				=> $this->input->post('remarks'),
			'tourgroup_balance'				=> $this->input->post('amount_fee'),
			'tourgroup_price_id'			=> $this->input->post('prices'),
			'tourgroup_section_id'			=> $this->input->post('sections'),
			'tourgroup_ticket_type_id'		=> $this->input->post('ticket_types'),
		);
		$this->db->set($fields);
		$this->db->insert('tourgroup');
		
		return $this->db->insert_id();
	}
	function add_payment($tourgroup_payment_transaction_id, $tourgroup_payment_event_id, $tourgroup_payment_operator_id, $tourgroup_payment_tourgroup_id, $payment_type, $amount_paid)
	{
		$fields = array(
			'tourgroup_payment_transaction_id'			=> $tourgroup_payment_transaction_id,
			'tourgroup_payment_event_id'				=> $tourgroup_payment_event_id,
			'tourgroup_payment_operator_id'				=> $tourgroup_payment_operator_id,
			'tourgroup_payment_tourgroup_id'			=> $tourgroup_payment_tourgroup_id,
			'tourgroup_payment_type'					=> $payment_type,
			'tourgroup_payment_amount'					=> $amount_paid,
			'tourgroup_payment_user_id'					=> $this->session->userdata('user_id'),
		);
		$this->db->set($fields);
		$this->db->insert('tourgroup_payment');
		
		$this->db->where('tourgroup_id', $tourgroup_payment_tourgroup_id);
		$query = $this->db->get('tourgroup');
		$result = $query->row();
		
		$check_balance = $result->tourgroup_balance - $amount_paid;
		// echo $check_balance;
		if($check_balance == 0)
		{
			$status = "PAID";
		}
		else
		{
			$status = "NOT PAID";
		}
		$fields2 = array(
			'tourgroup_balance'		=> $check_balance,
			'tourgroup_status'		=> $status,
		);
		$this->db->where('tourgroup_id', $tourgroup_payment_tourgroup_id);
		$this->db->set($fields2);
		$this->db->update('tourgroup');
		
		return $tourgroup_payment_tourgroup_id;
	}
	function update_payment_status($transaction_id)
	{
		$fields = array(
			'tourgroup_payment_status' => 'Paid',
		);
		$this->db->where('tourgroup_payment_transaction_id', $transaction_id);
		$this->db->set($fields);
		$this->db->update('tourgroup_payment');
	}
	function get_operator_comp($company)
	{
		$this->db->where('tourgroup_operator_id', $company);
		$query = $this->db->get('tourgroup_operator');
		// $company_name = $query-
		if($query->num_rows() < 1)
		{
			$eto_return = "No Company";
		}
		else
		{
			$eto_return = $query->row()->tourgroup_operator_company;
		}
		
		return $eto_return;
	}
	function add_price($amount_paid,$payment_type,$event_id)
	{
		// echo $amount_paid."-".$payment_type."-".$event_id;
		$array = array();
		// echo print_r(serialize($array));
		$fields = array(
			// 'price_event_id'		=> $event_id,
			'price_name'			=> $payment_type,
			'price_price'			=> $amount_paid,
			'price_sections'		=> serialize($array),
		);
		$this->db->set($fields);
		$this->db->insert('prices');
		
		return $this->db->insert_id();
	}
	function is_price_exist($amount_paid,$payment_type,$tevent_id)
	{
	
		$this->db->where('price_price', $amount_paid);
		$this->db->where('price_name', $payment_type);
		// $this->db->where('price_event_id', $tevent_id);
		$query = $this->db->get('prices');
		$result = $query->num_rows();
		if($result > 0)
		{
			// return true;
			return $query->row()->price_id;
		}
		else
		{
			return false;
		}
	
	}
	
	function get($key)
	{
		$this->db->where('tourgroup_event_id', $key);
		$this->db->join('events', 'events.event_id = tourgroup.tourgroup_event_id', 'left');
		$this->db->join('tourgroup_operator', 'tourgroup_operator.tourgroup_operator_id = tourgroup.tourgroup_operator_id', 'left');
		$query = $this->db->get('tourgroup');
		return $query->row();
	}
	function add_tickets($transaction_id,$ticket_session_id,$ticket_event_id,$ticket_price_id,$ticket_section_id)
	{
		$fields = array(
			'ticket_transaction_id'		=> $transaction_id,
			'ticket_session_id'			=> $ticket_session_id,
			'ticket_event_id'			=> $ticket_event_id,
			'ticket_price_id'			=> $ticket_price_id,
			'ticket_section_id'			=> $ticket_section_id,
			'ticket_type_id'			=> 1,
			'ticket_seat'				=> 'Free Seating',
			'ticket_status'				=> 'paid',
			'ticket_user_id'			=> $this->session->userdata('user_id'),
			);
		$this->db->set($fields);
		$insert_id = $this->db->insert('tickets');
		
		$eto_id = $this->db->insert_id($insert_id);
		
		$fields2 = array(
			'module_type_name'				=> 'SDCT',
			'module_type_transaction_id'	=> $transaction_id,
			'module_type_ticket_id'			=> $eto_id,
		);
		$this->db->set($fields2);
		$this->db->insert('module_types');
	}
	function add_tickets2($transaction_id,$ticket_session_id,$ticket_event_id,$ticket_price_id,$ticket_section_id,$ticket_type_id,$num_of_persons)
	{
		$ticket_count = 0;
		foreach (range(1, $num_of_persons) as $count)
		{
			$fields = array(
				'ticket_transaction_id'		=> $transaction_id,
				'ticket_session_id'			=> $ticket_session_id,
				'ticket_event_id'			=> $ticket_event_id,
				'ticket_price_id'			=> $ticket_price_id,
				'ticket_section_id'			=> $ticket_section_id,
				'ticket_type_id'			=> $ticket_type_id,
				'ticket_seat'				=> 'Free Seating',
				'ticket_status'				=> 'paid',
				'ticket_user_id'			=> $this->session->userdata('user_id'),
				);
			$this->db->set($fields);
			$this->db->insert('tickets');
			
			$ticket_count++;
		}
		// if ($ticket_count > 1) {
			// $this->sections_model->update_available($section, 'decrease', $ticket_count);
		// }
		return $ticket_count;
	}
	function add_operator($firstname, $middlename, $lastname, $company)
	{
		$fields = array(
			'tourgroup_operator_firstname'	=> $firstname,
			'tourgroup_operator_middlename'	=> $middlename,
			'tourgroup_operator_lastname'	=> $lastname,
			'tourgroup_operator_company'	=> $company,
		);
		$this->db->set($fields);
		$this->db->insert('tourgroup_operator');
	}
	
	function get_section_id(){
	
			$section_id_ko = $this->session->userdata('payment_type');
			$this->db->select('section_id');
			$this->db->where('section_code',$section_id_ko);
			$this->db->where('section_name',$section_id_ko);
			$query = $this->db->get('sections');
			$result = $query->row();
			return $result->section_id;
	}
	function get_ticket($transaction_id)
	{
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->join('sections', 'sections.section_id = tickets.ticket_section_id', 'left');
		$this->db->join('ticket_types', 'ticket_types.ticket_type_id = tickets.ticket_type_id', 'left');
		$this->db->join('prices', 'prices.price_id = tickets.ticket_price_id', 'left');
		$query = $this->db->get('tickets');
		
		return $query->row();
	}
	function void($transaction_id)
	{
		$this->db->where('module_type_transaction_id', $transaction_id);
		$this->db->where('module_type_name', 'SDCT');
		$this->db->join('tourgroup_payment','tourgroup_payment.tourgroup_payment_transaction_id = module_types.module_type_transaction_id', 'left');
		$this->db->join('tourgroup','tourgroup.tourgroup_id = tourgroup_payment.tourgroup_payment_tourgroup_id', 'left');
		$this->db->join('transactions', 'transactions.transaction_id = tourgroup_payment.tourgroup_payment_transaction_id', 'left');
		$tourgroup = $this->db->get('module_types');
		$tg = $tourgroup->row();
		
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->join('prices', 'prices.price_id = tickets.ticket_price_id', 'left');
		$price_me = $this->db->get('tickets');
		$price = $price_me->row();
		// print_r($this->db->last_query());
		// echo $price->price_price + $tg->tourgroup_balance;

		if($tourgroup->num_rows() != 0)
		{
			// $new_bal = $tg->price_price + $tg->tourgroup_balance;
			if($tg->tourgroup_status == "PAID")
			{
				$fields = array(
					'tourgroup_balance'		=> $price->price_price + $tg->tourgroup_balance,
					'tourgroup_status'		=> 'NOT PAID',
				);
			}
			else
			{
				$fields = array(
					'tourgroup_balance'		=> $price->price_price + $tg->tourgroup_balance,
				);
			}
			$this->db->where('tourgroup_id', $tg->tourgroup_id);
			$this->db->set($fields);
			$this->db->update('tourgroup');
			
			$fields = array(
				'tourgroup_payment_status'		=> 'Voided',
			);
			$this->db->where('tourgroup_payment_id', $tg->tourgroup_payment_id);
			$this->db->set($fields);
			$this->db->update('tourgroup_payment');
		}
	}
	function get_prices($event_id = false)
	{
		$this->db->where("price_event_id", $event_id);
		$this->db->order_by("price_name");
		$query = $this->db->get("prices");
			
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			// $array[0] = "select one";
			foreach($result as $r)
			{
				$array[$r->price_id] = $r->price_name." (".$r->price_price.")";
			}
		}
		return $array;
	}
	function get_sections($section_id = false)
	{
		// echo $section_id;
		if($section_id > 0)
		{
			$this->db->where("price_id", $section_id);
		}
		else
		{
			return array();
		}
		$query = $this->db->get("prices");
		$result = $query->row();
		
		// print_r(unserialize($result->price_sections));
		$eto_section = unserialize($result->price_sections);
		
		if(empty($eto_section))
		{
			return array();
		}
		$this->db->order_by("section_name");
		$this->db->where_in("section_id", $eto_section);
		$query = $this->db->get("sections");
			
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				if($r->section_type == "Free Seating")
				{
					$type = "F";
				}
				elseif($r->section_type == "Reserved")
				{
					$type = "R";
				}
				elseif($r->section_type == "Standing")
				{
					$type = "S";
				}
				$array[$r->section_id] = $r->section_name." (".$type.")";
			}
		}
		return $array;
	}
	function get_ticket_types($event_id = false)
	{
		if($event_id > 0)
		{
			$this->db->where("event_id", $event_id);
		}
		else
		{
			return array();
		}
		$query = $this->db->get("events");
		$result = $query->row();
		
		// print_r(unserialize($result->price_sections));
		$eto_ticket = unserialize($result->event_ticket_types);
		
		if(empty($eto_ticket))
		{
			return array();
		}
		
		$this->db->order_by("ticket_type_name");
		$this->db->where_in("ticket_type_id", $eto_ticket);
		$query = $this->db->get("ticket_types");
			
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
		}
		return $array;
	}
	function get_tour_inf($id)
	{
		$this->db->where('tourgroup_payment_transaction_id', $id);
		$this->db->join('tourgroup', 'tourgroup.tourgroup_id = tourgroup_payment.tourgroup_payment_tourgroup_id', 'left');
		$this->db->join('tourgroup_operator', 'tourgroup_operator.tourgroup_operator_id = tourgroup.tourgroup_operator_id', 'left');
		$query = $this->db->get('tourgroup_payment');
		
		return $query->row();
	}
	function add_trans($customer_id)
	{
		$fields = array(
			'transaction_date'					=> date("Y-m-d H:i:s"),
			'transaction_user_id'				=> $this->session->userdata('user_id'),
			'transaction_customer_id'			=> 0,
			'transaction_branch_id'				=> $this->session->userdata('user_branch_id'),
			'transaction_terminal_id'			=> $this->session->userdata('user_terminal_id'),
			'transaction_cash_change'			=> $this->_prep_amount($this->input->post('total_change')),
			'transaction_status'				=> 'paid',
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('transactions');
		
		// get transaction id
		// $transaction_id = $this->db->insert_id(); << this function sometimes returns 0.  do not use this anymore
		// got this solution from http://codeigniter.com/forums/viewthread/60170/
		$query = $this->db->query('SELECT LAST_INSERT_ID()');
		$row = $query->row_array();
		$transaction_id = $row['LAST_INSERT_ID()'];
		if($transaction_id > 0)
		{
			
		}
		else
		{
			return false;
		}
		
		// update tickets table, include the transaction id
		// $this->db->where('ticket_status', 'selected');
		// $this->db->where('ticket_session_id', $this->session->userdata('customer_session_id'));
		// $this->db->update($this->tickets, array('ticket_transaction_id' => $transaction_id, 'ticket_status' => 'paid'));
		
		// print_r($this->db->last_query());
		// $this->db->where('ticket_transaction_id', $transaction_id);
		// $ticket_id = $this->db->get('tickets');
		// $ticket_id_eto = $ticket_id->row();

			// $fields2 = array(
				// 'module_type_name'				=> 'SDCT',
				// 'module_type_transaction_id'	=> $transaction_id,
				// 'module_type_ticket_id'			=> $ticket_id_eto->ticket_id,
			// );
			// $this->db->set($fields2);
			// $this->db->insert('module_types');
		
		// get payment types
		$payment_types = $this->payment_types_model->get_payment_types();
		$payment_types = array('cash', 'credit_card_1', 'credit_card_2', 'debit_card', 'gift_check', 'reward_card', 'account');
		
		// add the payment
		foreach ($payment_types as $payment_type)
		{
			if ($this->input->post('transaction_payment_'.$payment_type))
			{
				$fields = array(
					'payment_transaction_id'	=> $transaction_id,
					'payment_payment_type_id'	=> ($payment_type == 'cash' ) ? 1 : $this->input->post('transaction_'.$payment_type),
					'payment_amount'			=> $this->_prep_amount($this->input->post('transaction_payment_'.$payment_type)),
				);

				// insert to db
				$this->db->set($fields);
				$this->db->insert('payments');
			}
		}
		
		return $transaction_id;
	}
	function _prep_amount($str)
	{	
		return str_replace(',', '', $str);
	}	
}
// END promoters_model.php
/* Location: ./application/models/promoters_model.php */