<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Ticket_Types_Model extends CI_Model
{
	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $prices = 'prices pc';	
	var $ticket_types = 'ticket_types tt';	
	var $events = 'events e';		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();

	}
	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_type
	 *
	 * @access	public
	 */
	function get($ticket_type_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('ticket_type_id', $ticket_type_id);
		$query = $this->db->get($this->ticket_types);
	
		return $query->row();
		
	}	
	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_types
	 *
	 * @access	public
	 */
 	function get_ticket_types()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->order_by('ticket_type_group, ticket_type_id');
		$query = $this->db->get($this->ticket_types);
		return $query->result();
	}
	
	function get_ticket_types_b()
	{
		$this->db->order_by('ticket_type_group, ticket_type_id');
		$this->db->where('ticket_type_active', 1);
		$query = $this->db->get($this->ticket_types);
		return $query->result();
	}


	
	function get_ticket_type_list()
	{
		$this->db->order_by('ticket_type_name, ticket_type_group, ticket_type_id');
		$this->db->where('ticket_type_active', 1);
		$query = $this->db->get($this->ticket_types);
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_types_dropdown
	 *
	 * @access	public
	 */
	function get_ticket_types_dropdown()
	{
		// $this->db->order_by('ticket_type_group');
		$this->db->order_by('ticket_type_id');
		$this->db->where('ticket_type_active', 1); 
		$query = $this->db->get($this->ticket_types);
		
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_ticket_types_details($event_ticket_types )
	{
		
		$this->db->order_by('ticket_type_id');
		$this->db->where_in('ticket_type_id', $event_ticket_types);
		$query = $this->db->get($this->ticket_types);
		
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_ticket_types_discount($id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->order_by('ticket_type_id');
		$this->db->where('ticket_type_id', $id);
		$query = $this->db->get($this->ticket_types);
		$result = $query->row();
		return array($result->ticket_type_discount,$result->ticket_type_discount_type);

	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 */
	function add()
	{
		$fields = array(
			'ticket_type_code'			=> $this->input->post('ticket_type_code'),
			'ticket_type_name'			=> $this->input->post('ticket_type_name'),
			'ticket_type_discount_type'	=> $this->input->post('ticket_type_discount_type'),
			'ticket_type_discount'		=> $this->input->post('ticket_type_discount'),
			// 'ticket_type_group'			=> $this->input->post('ticket_type_group'),
			'ticket_type_active'		=> $this->input->post('ticket_type_active'),
		);
		
		// insert to db
		$this->db->set($fields);
		$this->db->insert('ticket_types');
		
		return true;
	}		
	// --------------------------------------------------------------------
	
	/**
	 * edit
	 *
	 */
	function edit($ticket_type_id)
	{
		$fields = array(
			'ticket_type_code'			=> $this->input->post('ticket_type_code'),
			'ticket_type_name'			=> $this->input->post('ticket_type_name'),
			'ticket_type_discount_type'	=> $this->input->post('ticket_type_discount_type'),		
			'ticket_type_discount'		=> $this->input->post('ticket_type_discount'),
			'ticket_type_group'			=> $this->input->post('ticket_type_group'),					
			'ticket_type_active'		=> $this->input->post('ticket_type_active'),					
			'ticket_type_promo'			=> $this->input->post('ticket_type_promo'),					
			'ticket_type_color'			=> $this->input->post('ticket_type_color'),					
			'ticket_type_expiration'	=> $this->input->post('expiration'),					
		);
		
		// update db
		$this->db->where('ticket_type_id', $ticket_type_id);
		$this->db->update($this->ticket_types, $fields);
		
		return true;
	}		
	// --------------------------------------------------------------------
	
	/**
	 * delete
	 *
	 */
	function delete($ticket_type_id)
	{
		$this->db->delete('ticket_types', array('ticket_type_id' => $ticket_type_id));
		
		return true;
	}	
	
	function array_info($ticket_types) {
		$result = array();
		if (count($ticket_types) > 0) {
			$this->db->where_in('ticket_type_id', $ticket_types);
			$query = $this->db->get($this->ticket_types);
			foreach($query->result() as $row) {
				$result[$row->ticket_type_id] = $row->ticket_type_name . " (". $row->ticket_type_code . ")" ;
			}
		}
		/*
		if (count($result) > 0) {}
		else {$result["x"] = "--not available--";}
		*/
		return $result;
	}
	
	function get_ticket_types_dropdown_promo($ticket_types = false)
	{
		// $this->db->order_by('ticket_type_group');
		$this->db->order_by('ticket_type_id');
		$this->db->where('ticket_type_active', 1); 
		
		if($ticket_types)
		$this->db->where_in('ticket_type_id', unserialize($ticket_types));
		
		$query = $this->db->get($this->ticket_types);
		
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
	
	function get_ticket_types_dropdown_sort()
	{
		// $this->db->order_by('ticket_type_group');
		$this->db->order_by('ticket_type_name');
		$this->db->where('ticket_type_active', 1); 
		$query = $this->db->get($this->ticket_types);
		
		$result = $query->result();
		if ($result)
		{
			// transform result into an associative array
			foreach($result as $r)
			{
				$array[$r->ticket_type_id] = $r->ticket_type_name;
			}
			return $array;
		}
		else
		{
			return $result;
		}
	}
		function get_prices($price_id=false)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('price_id', $price_id);
		$query = $this->db->get('prices');
		
		return $query->row();
	}
	function get_ticket_types_seller()
	{
		$price= $this->session->userdata('cpi');
		$price_ticket_type = $this->get_prices($price);
		$this->db->query('set transaction isolation level read uncommitted');
		$today =  date("Y/m/d");
		$where_au = "(ticket_type_expiration >= '$today' OR ticket_type_expiration = '0000-00-00')";

	
		if (!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
			$this->db->where('ticket_type_group', 0);
		}
		
		// limit for disney
		$this->db->where($where_au);
		
		//$this->session->userdata('user_branch_id') 
		$cebu = array(32,104,137);
		$davao = array(31,106);
 	    $user_branch = $this->session->userdata('user_branch_id');
		
		 
		if (!in_array($user_branch, $cebu) && $this->session->userdata('user_type') != 'Admin') {
			
			$this->db->where('ticket_type_id !=', 1017);
		}
		
		if (!in_array($user_branch, $davao) && !in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))) {
			
			$this->db->where('ticket_type_id !=', 1018);
		}
		
		
		
		 
 		

		if(!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
			
			
			$this->db->where('ticket_type_id !=', 1578); //hide otc GLOBEHITC
			$this->db->where('ticket_type_id !=', 1582); //hide otc GLOBEHITC
			$this->db->where('ticket_type_id !=', 1606); //hide otc GLOBEHITC
			$this->db->where('ticket_type_id !=', 1610); //hide otc GLOBEHITC
			$this->db->where('ticket_type_id !=', 1611); //hide otc GLOBEHITC
			$this->db->where('ticket_type_id !=', 1614); //hide otc GLOBEHITC
			$this->db->where('ticket_type_id !=', 1618); //hide otc GLOBEHITC
			
			//
			
			if ($price_ticket_type->price_ticket_types){ 
				$this->db->where_in('ticket_type_id', unserialize($price_ticket_type->price_ticket_types)); //eto lang kita nya	
			}
			// 60116,60117,60118,60119,60120,60121,60122,60123,60124    1337  
			if (in_array($price, array(60116,60117,60118,60119,60120,60121,60122,60123,6012))){ 
				$this->db->where('ticket_type_id', 1337); //eto lang kita nya
				
				
			}else{
				
				//d kita sa iba
				$this->db->where('ticket_type_id !=', 1337);
			}
			
			
			// hitc 1575 hide sa 57782,57783
			if (in_array($price, array(57782,57783))){ 
				$this->db->where('ticket_type_id !=', 1575);
			} 
			
			
			// hitc 1616 hide sa 57681,57782
			if (in_array($price, array(57782))){ 
				$this->db->where('ticket_type_id !=', 1616);
			} 
			
			
			
			//57682
			if (in_array($price, array(57682))){ 
				$this->db->where_in('ticket_type_id', [1575,1616]);
				$this->db->where('ticket_type_id !=', 1617);

			} 
			
			// ticekt type 1617 not visible sa 57681,57682
			//57681
			if (in_array($price, array(57681))){ 
				$this->db->where('ticket_type_id', 1575);
				$this->db->where('ticket_type_id !=', 1617);
			}
			
			
			
			
			// 57681,57682 
			
			 
			
			//59267,59268,59269,59270,59271,59272  
			//59189,59188,59187,59190,59191,59192   dpaat kita lang 1572 
			//58657,58662,58987,58658,58664,58659,58660

			
			// if (in_array($price, array(58987,58658,58663,58655,58664,58659,58988,58668,58672,58665,58673,58669,59141,58683,58687,58680,58688,58684))){
				
			// }
			$this->db->where('ticket_type_id !=', 1581);
			
			if (in_array($price, array(58657,58662,58987,58658,58664,58659,58660 ,58667,58671,58988,58668,58673,58669,58670))){
				$this->db->where('ticket_type_id !=', 1579);
			}
			
			
			// if (in_array($price, array(59189,59188,59187,59190,59191,59192))){
				// $this->db->where('ticket_type_id', 1572);
			// }
			
			
			if (in_array($price, array(59267,59268,59269,59270,59271,59272))){
				$this->db->where('ticket_type_id !=', 1572);
			}
			
			 
			//58657,58662,58667,58671  = 1568
			//58987,58658,58663,58655,58664,58659,58660,58988,58668,58672,58665,58673,58669,58670 = 1569
			//ONEFC CODE OF HONOR regular only
			
			
			// if (in_array($price, array(58657,58662,58987,58658,58663,58655,58664,58659,58667,58671,58988,58668,58672,58665,58673,58669,58682,58686,59141,58683,58687,58680,58688,58684))){
				// $this->db->where('ticket_type_id !=', 1);
			// }
			
			 
			
			// if (!in_array($price, array(58657,58662,58667,58671))){
				    	  
				// $this->db->where('ticket_type_id !=', 1568);  
			// }
			// if (!in_array($price, array(58987,58658,58663,58655,58664,58659,58988,58668,58672,58665,58673,58669))){
				    	  
				// $this->db->where('ticket_type_id !=', 1569);  
			// }
			
			
				
			// if (in_array($price, array(58660,58670,58685))){
				// $this->db->where('ticket_type_id', 1);
			// }
			
			
			 
			//winner promo CD
			if (in_array($price, array(49929))){
				    	  
				$this->db->where('ticket_type_id', 1485);  
			}else{
				
				$this->db->where('ticket_type_id !=', 1485);  
				
				
			}
			
			
			//THE ART SHOW REFRAMED
			if (in_array($price, array(49739))){
				    	  
			}else{
				
				$this->db->where('ticket_type_id !=', 1471);  
				
				
			}
			
			
			//ONEFC cat 49895 BOODLE onefc
			if (in_array($price, array(49895))){
				    	
				$this->db->where('ticket_type_id', 1);  
			}
			
			
			//ONEFC cat 5-10
			if (in_array($price, array(49704,49706,49736,49707,49717,49735))){
				    	
				// $this->db->where_in('ticket_type_id', array(1,2));  
			}else{
				
				$this->db->where_not_in('ticket_type_id', array(1489,1488,1233,1462,1486,1487,1472, 1473, 1428,1476,1445,1446,1446,1447,1477,1478,1479,1480,1481,1400));  
				
				
			}
			
			//FORMER WESTLIFE BRIAN MCFADDEN ROMANTIC INTIMATE CONCERT LIVE IN CEBU
			if (in_array($price, array(48038,48041))){
				    	
				$this->db->where_in('ticket_type_id', array(1,2));  
			}
			
			
			if (in_array($price, array(48039,48040))){
				    	
				$this->db->where_in('ticket_type_id', array(1460));  
			}
			
			
			
			//DOI PLDT
			if (in_array($price, array(48133,48137,48167,48178,48182,48238,48242,48302,48362,48403,48407,48433,48437,48463,48467,48493,48497))){
				    	
			}else{
				$this->db->where('ticket_type_id !=', 1205);  
				
			}
			
			
			//DOI employee
			if (in_array($price, array(48406,48511,48271,48496,48436,48403,48508,48268,48493,48433,48512,48272,48497,48437,48407,48398,48503,48263,48488,48428))){
				    	
			}else{
				$this->db->where('ticket_type_id !=', 1308);  
				
			}
			
			
			//DOI flash sale ec 7 & 8
			if (in_array($price, array(48099,48103,48104,48107,48127,48128,48132,48133,48136,48137,48143,48147,48148,48151,48152,48158,48162,48163,48166,48167,48173,48177,48178,48181,48182,48188,48192,48193,48196,48197,48203,48207,48208,48211,48212,48218,48222,48223,48226,48227,48233,48237,48238,48241,48242,48248,48252,48253,48256,48257,48263,48267,48268,48271,48272,48278,48282,48283,48286,48287,48293,48297,48298,48301,48302,48308,48312,48313,48316,48317,48323,48327,48328,48331,48332,48338,48342,48343,48346,48347,48353,48357,48358,48361,48362,48368,48372,48373,48376,48377,48383,48387,48388,48391,48392,48398,48402,48403,48406,48407,48413,48417,48418,48421,48422,48428,48432,48433,48436,48437,48443,48447,48448,48451,48452,48458,48462,48463,48466,48467,48473,48477,48478,48481,48482,48488,48492,48493,48496,48497,48503,48507,48508,48511,48512,48518,48522,48523,48526,48527))){
			
				// $this->db->where('ticket_type_id !=', 1);  
			}else{
				$this->db->where('ticket_type_id !=', 1215);  
				$this->db->where('ticket_type_id !=', 1470);  
				
			}
			
			
			//DOI 
			if (in_array($price, array(48099,48104,48127,48128,48133,48137,48143,48148,48152,48158,48163,48167,48173,48178,48182,48188,48193,48197,48203,48208,48212,48218,48223,48227,48233,48238,48242,48248,48253,48257,48263,48268,48272,48278,48283,48287,48293,48298,48302,48308,48313,48317,48323,48328,48332,48338,48343,48347,48353,48358,48362,48368,48373,48377,48383,48388,48392,48398,48403,48407,48413,48418,48422,48428,48433,48437,48443,48448,48452,48458,48463,48467,48473,48478,48482,48488,48493,48497,48503,48508,48512,48518,48523,48527))){
				    	
			}else{
				$this->db->where('ticket_type_id !=', 1455);  
				
			}
			
			
			//alaska 
			if (in_array($price, array(44683))){
				    	
				$this->db->where('ticket_type_id !=', 1423);  
			}
			
			
			//brave 
			if (in_array($price, array(43192, 43193, 43194))){
				    	
			}else{
				
				$this->db->where('ticket_type_id !=', 1363); 
				$this->db->where('ticket_type_id !=', 1364); 
				
			} 
			
			//brave 
			if (in_array($price, array(43193, 43194))){
				    	
			}else{
				
				$this->db->where('ticket_type_id !=', 1365);  
				
			} 
			
			
			//brave new
			if (in_array($price, array(43202, 43192, 43193,43194))){
				    	
			}else{
				
				$this->db->where('ticket_type_id !=', 1374);  
				$this->db->where('ticket_type_id !=', 1375);  
				
			} 
			
			
			
			//SMART/M5 discount
			if (in_array($price, array(40747, 40748))){
				    	
			}else{
				
				$this->db->where('ticket_type_id !=', 1367); 
				
			} 
		 
		 
			// 	"01/06/2018","01/13/2018","01/20/2018","01/27/2018","02/03/2018","02/10/2018","02/17/2018","02/24/2018","01/07/2018","01/14/2018","01/21/2018","01/28/2018","02/04/2018","02/11/2018","02/18/2018","02/25/2018"
			
			
			//Kidzania
			$kidzania = array("01/06/2018","01/13/2018","01/20/2018","01/27/2018","02/03/2018","02/10/2018","02/17/2018","02/24/2018","01/07/2018","01/14/2018","01/21/2018","01/28/2018","02/04/2018","02/11/2018","02/18/2018","02/25/2018");
			$valid_date = $this->session->userdata('valid_date');
			$valid_date = strtotime($valid_date); 
			$valid_date = date('m/d/Y',$valid_date);
 
			// echo $valid_date;
			
			if (!in_array($valid_date, $kidzania)){
				 
				$this->db->where('ticket_type_id !=', 1218 ); 
				
			}
			
		
	    }
	 
		// $this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		
		$this->db->order_by('ticket_type_group, ticket_type_id');
		$query = $this->db->get($this->ticket_types);
		// echo $this->db->last_query();
		// die();
		return $query->result();
	}
		

	
	function getTicketTypeByEvent($event_id )
	{
		$this->db->distinct();
		$this->db->select('tt.ticket_type_name, tt.ticket_type_id');
		$this->db->where('t.ticket_event_id', $event_id);
		$this->db->join('tickets t', 't.ticket_type_id = tt.ticket_type_id');
		$query = $this->db->get('ticket_types tt');
		return $query->result();
		
		
	}
	
	function getTicketTypeByEventLongTitle($event_long )
	{
		
		$this->db->select('event_id');
		$this->db->where('event_long_title', $event_long);
		$query_id = $this->db->get('events')->result_array();
		// echo $this->db->last_query();
		// return $query_id->result();
		// echo '<pre>';
		// print_r($query_id);
		// die();
		foreach($query_id as $k=>$v) {
		$event_ids[$k] = $v["event_id"];
		
		}
		$this->db->distinct();
		$this->db->select('tt.ticket_type_name, tt.ticket_type_id');
		$this->db->where_in('t.ticket_event_id', $event_ids);
		$this->db->where('tt.ticket_type_group', 0);
		$this->db->join('tickets t', 't.ticket_type_id = tt.ticket_type_id');
		$this->db->order_by('tt.ticket_type_id', 'ASC');
		$query = $this->db->get('ticket_types tt');
		return $query->result();
		// echo $this->db->last_query();
		// die();
		
		
	}

	
	function get_ticket_types_doi()
	{
		$this->db->query('set transaction isolation level read uncommitted');
		 
		$cei = $this->session->userdata('cei');
 		$price = $this->prices_model->get($this->session->userdata('cpi')); 
		$price_name = $price->price_name;
		
		
		$today =  date("Y/m/d");
		$where_au = "(ticket_type_expiration >= '$today' OR ticket_type_expiration = '0000-00-00')";

	
		if($this->session->userdata('user_type') != 'Admin'){
			$this->db->where('ticket_type_group', 0);
		}
		
		// limit for disney
		$this->db->where($where_au);
		
		//$this->session->userdata('user_branch_id') 
		$cebu = array(32,104,137);
		$davao = array(31,106);
 	    $user_branch = $this->session->userdata('user_branch_id');
		
		
		if (!in_array($user_branch, $cebu) && $this->session->userdata('user_type') != 'Admin') {
			
			$this->db->where('ticket_type_id !=', 1017);
		}
		
		if (!in_array($user_branch, $davao) && $this->session->userdata('user_type') != 'Admin') {
			
			$this->db->where('ticket_type_id !=', 1018);
		}
		

		
	 
		if($this->session->userdata('user_type') != 'Admin'){
			 
		    $doi_all = array(6162,6164,6165,6166,6167,6168,6169,6170,6171,6172,6173,6174,6175,6176,6177,6178,6179,6180);
		    $doi_sm_emp = array(6168,6169,6170,6171);
		    $doi_bulk = array(6162,6164,6165,6168,6169,6170,6175,6177,6178,6179,6180);
		    $doi_hotel = array(6162,6165,6168,6169,6170,6175,6177,6178,6179,6180);
		 
			if(in_array($cei,$doi_all)){
				if (strpos($price_name, 'BOX') !== false) {
					// echo 'true';
					
					
				}else{
					
					$this->db->where('ticket_type_id !=', 1021);
					$this->db->where('ticket_type_id !=', 1022);
					$this->db->where('ticket_type_id !=', 1205);
					$this->db->where('ticket_type_id !=', 1206);
					$this->db->where('ticket_type_id !=', 1214);
					$this->db->where('ticket_type_id !=', 1213);
					$this->db->where('ticket_type_id !=', 1215);
					$this->db->where('ticket_type_id !=', 1216);
					$this->db->where('ticket_type_id !=', 1031);
				 
  				}
				
			
			}
			
			if(in_array($cei,$doi_sm_emp)){
				if (strpos($price_name, 'BOX') !== false) {
					// echo 'true';
					
					
				}else{
					
					$this->db->where('ticket_type_id !=', 1019); 
				}
				
			
			}
			
			if(in_array($cei,$doi_bulk)){
				if (strpos($price_name, 'BOX') !== false) {
					// echo 'true';
					
					
				}else{
					
					$this->db->where('ticket_type_id !=', 1031); 
				}
				
			
			}
			
			if(in_array($cei,$doi_hotel)){
				if (strpos($price_name, 'BOX') !== false) {
					// echo 'true';
					
					
				}else{
					
					$this->db->where('ticket_type_id !=', 1204); 
				}
				
			
			}
			
			 
	    }
	 
		// $this->db->where('t.transaction_date >=', $reports_date.' 00:00:01');
		
		$this->db->order_by('ticket_type_group, ticket_type_id');
		$query = $this->db->get($this->ticket_types);
		return $query->result();
	}
 
	function getEventTicketTypes($event_id=false){
		$query = $this->db->where('event_id', $event_id)->get('events')->row();
		$this->db->where_in('ticket_type_id',unserialize($query->event_ticket_types));
		$queue=$this->db->get('ticket_types');
		return $queue->result(); 
	}
}
// END Ticket_Types_Model.php
/* Location: ./application/models/Ticket_Types_Model.php */		
